﻿package com {
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.SimpleButton;
	
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.events.Event;
	
	import flash.text.TextFieldAutoSize;
	import flash.text.StyleSheet;
	
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	import com.lionelUtils.*;
	
	public class LecteurRss extends MovieClip {
				
		private var listeFlux		:XML;
		private var fluxEnCours		:XML;
		private var monStyle		:StyleSheet;
		private var donneesCSS		:URLLoader;
		private var adresseCSS		:URLRequest;
		
		private var navigation		:Sprite;
		private var xmlImp			:XmlImport;
		
		public function LecteurRss() {
			// importation du XML listant les flux
			xmlImp 							= new XmlImport(this,"xml/flux.xml","chargementListeFlux");
			// charge style
			var lCss	:URLLoader			= new URLLoader();
			lCss.load(new URLRequest("style/styles.css"));
			lCss.addEventListener(Event.COMPLETE, parseCss);
		}
		public function chargementListeFlux(_data:XML):void
		{
			xmlImp							= null;
			listeFlux 						= _data;
			initNavigation();
		}
		private function parseCss(e:Event):void
		{
			monStyle 						= new StyleSheet();
			monStyle.parseCSS(e.target.data);		
		}
		// creation de la navigatin et des boutons
		private function initNavigation():void
		{
			navigation 								= new Sprite();
			navigation.addEventListener(MouseEvent.CLICK, onClick);
			this.addChild(navigation);
			for each(var flux:XML in listeFlux..flux){
				var monBoutton			:SimpleButton 		= createBouton(flux.nom.@data);
				monBoutton.name								= flux.url.@data;
				monBoutton.x 								= navigation.width > 0 ? navigation.width + 5 : 0;
				navigation.addChild(monBoutton);
			}
			// charge par defaut
			onClick();
			
			function onClick(e:MouseEvent = null):void{
				var _tempBouton			:SimpleButton		= e ? e.target as SimpleButton : navigation.getChildAt(0) as SimpleButton;
				activeAllBt(_tempBouton);
				chargeFlux(_tempBouton.name);
			}
			
			navigation.x 							= (stage.stageWidth - navigation.width) /2;
			navigation.y 							= stage.stageHeight - navigation.height - 10;
		}
		// chargement du flux selectionné
		private function chargeFlux(s:String):void
		{
			xmlImp							= new XmlImport(this,s,"afficheFlux");
		}
		// chargement du flux
		public function afficheFlux(_data:XML):void
		{
			var i			:uint			= 0;
			xmlImp							= null;
			fluxEnCours						= _data;
			// affichage du titre sous titre et date
			titreFlux.text 					= fluxEnCours..title[0];
			description.text 				= fluxEnCours..description[0];
			date.text 						= fluxEnCours..lastBuildDate[0] ? fluxEnCours..lastBuildDate[0] : "";
			lesTitres.styleSheet			= monStyle;
			lesTitres.text					= "";
			for each(var tp:XML in fluxEnCours..item){
				lesTitres.htmlText += "<a href='event:" + i + "'>" + tp..title + "</a><br/>";
				i++;
			}
			lesTitres.autoSize				= TextFieldAutoSize.LEFT;
			// positionnement verticale des champs titreEnCours et resume
			titreEnCours.y 					= lesTitres.y + lesTitres.height + 10;
			resume.y						= titreEnCours.y +titreEnCours.height + 10;
			// affichage de liens
			lesTitres.addEventListener(TextEvent.LINK, detectLien);
			detectLien();
		}
		// detection du lien cliqué
		private function detectLien(e:TextEvent = null):void
		{
			var num			:int 			= e ? Number(e.text) : 0;
			var monXml		:XML			= fluxEnCours..item[num];
			// test link ou <feedburner:origLink>
			var link		:String			= monXml.link ? monXml.link : monXml.toString().split("<feedburner:origLink>")[1].split("</feedburner:origLink>")[0] ;
			resume.htmlText					= monXml.description + "<br/><br/><i><a href='"+link+"'>Aller à l'article original</a></i>";
			titreEnCours.text				= monXml.title;
		}
		// activation de tous les boutons
		private function activeAllBt(bec:SimpleButton):void
		{
			for (var i:uint = 0 ; i < navigation.numChildren ; i++){
				var b:SimpleButton 	= navigation.getChildAt(i) as SimpleButton;
				b.mouseEnabled		= true;
				b.alpha				= 1;
			}
			bec.mouseEnabled		= false;
			bec.alpha				= .5;
		}
		// creation des boutons
		private function createBouton(monLabel:String = "Mon Bouton"):SimpleButton {
			var simpleButton	:SimpleButton 		= new SimpleButton();
			simpleButton.upState					= new DessineRectangle(0xFF0000,monLabel);
			simpleButton.overState					= new DessineRectangle(0x00FF00,monLabel);
			simpleButton.downState					= new DessineRectangle(0x00FF00,monLabel);
			simpleButton.hitTestState				= new DessineRectangle(0xFF0000,monLabel);
			simpleButton.useHandCursor				= true;
			return simpleButton;
		}
	}
	
}