﻿package com{

	import flash.display.MovieClip;
	import flash.display.DisplayObject;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.display.Sprite;
	import flash.utils.Timer;
	import flash.events.TimerEvent;

	public class DocumentClass extends MovieClip {

		private var monXml											:XMLImport;
		private var plateau											:Sprite;
		private var totalNiveau,niveauEnCours,nbrPoint				:int;
		private var objectif										:uint;
		private var time,titreDelay									:Timer;
		private var txtPt,txtTitre									:TextField;
		private var fmt												:TextFormat;
		
		public function DocumentClass() {
			monXml 				= new XMLImport("ressources/ressources.xml",this);
			plateau 			= new Sprite();
			stage.addChild(plateau);
			niveauEnCours 		= 1;
		}
		
		public function xmlCallBack(){
			totalNiveau = monXml.xmlData.niveaux.niveau.length();
			// les champs de texte
			fmt 				= new TextFormat();
			fmt.font 			= monXml.xmlData.parametres.titre.@font;
			fmt.align 			= TextFormatAlign.CENTER
			
			txtPt						= new TextField();
			txtTitre 					= new TextField();
			txtPt.width 				= txtTitre.width = stage.stageWidth;
			txtPt.height 				= txtTitre.height = 50;
			txtPt.y 					= stage.stageHeight - 30;
			txtTitre.y 				= stage.stageHeight/2 - 30;
			txtTitre.selectable 	= txtPt.selectable = false;
			txtTitre.defaultTextFormat = fmt;
			txtPt.defaultTextFormat = fmt;
			txtTitre.htmlText 	= "<font size='"+monXml.xmlData.parametres.titre.@size+"'>"+monXml.xmlData.parametres.titre+"</font>";
			
			
			
			stage.addChildAt(txtPt,0);
			stage.addChild(txtTitre);
			
			titreDelay = new Timer(5000);
			titreDelay.start();
			titreDelay.addEventListener(TimerEvent.TIMER, onDelay);
			
		}
		private function onDelay(e:TimerEvent){
			txtTitre.x 		= stage.stageWidth;
			titreDelay.removeEventListener(TimerEvent.TIMER, onDelay);
			titreDelay = null;
			lanceNiveau(niveauEnCours);
		}
		
		private function lanceNiveau(qn:uint){
			nbrPoint 			= 0;
			objectif 				= Number(monXml.xmlData.niveaux.niveau[niveauEnCours-1].pointsMax);
			
			txtPt.text 			= "0 points";
			time 					= new Timer(Number(monXml.xmlData.niveaux.niveau[niveauEnCours-1].vitesseCreationCible));
			time.start();
			time.addEventListener(TimerEvent.TIMER, creerCible);
			
			creerCible();
		}
		
		public function creerCible(e:TimerEvent = null){
			
			var vitesse:uint 		= Math.floor(Math.random()*10 + 1);
			var point:uint			= Math.ceil(vitesse/2);
			var _mc:Cible 			= new Cible(plateau,this,vitesse,point);
			_mc.scaleX				= _mc.scaleY		= 0.2 + (vitesse/10);
			_mc.y 					= -_mc.height/2;
			_mc.x 					= Math.floor(Math.random()*(stage.stageWidth - _mc.width) + _mc.width/2);
			
			plateau.addChild(_mc);
		}
		public function addPoint(p:int){
			nbrPoint 	+= p;
			txtPt.text 	= nbrPoint + " points";
			if (nbrPoint >= objectif){
				time.stop();
				time.removeEventListener(TimerEvent.TIMER, creerCible);
				time = null;
				purgeMc(plateau);
				if (niveauEnCours + 1 <= totalNiveau){
					
					niveauEnCours ++;
					titreDelay = new Timer(2500);
					titreDelay.start();
					titreDelay.addEventListener(TimerEvent.TIMER, onDelay);
					txtTitre.x = 0;
					txtTitre.htmlText 	= "<font size='"+monXml.xmlData.parametres.titre.@size+"'>Niveau "+niveauEnCours+"</font>";
				}else{
					txtTitre.x = 0;
					txtTitre.htmlText 	= "<font size='"+monXml.xmlData.parametres.titre.@size+"'>Partie Terminée </font>";
				}
			}
		}
		private function purgeMc(mc:Sprite){
			var nbrChild = mc.numChildren;
			while(nbrChild--){
				var temp:Cible = mc.getChildAt(0) as Cible;
				temp.kill();
			}
		}
	}
}