﻿package com.niklas {
	
	import flash.display.Sprite;
	import flash.display.Shape;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.Font;
	
	import flash.utils.getTimer;
	
	public class Montre extends Sprite{

		private var rayonMontre		:uint;
		private var cadran			:Sprite;
		private var h				:Shape;
		private var m				:Shape;
		private var s				:Shape;
		private var t				:TextField;
		private var tf				:TextFormat; 
		private var mf				:Font			= new MaFont();
		
		// chrono
		private var c				:Shape;
		private var startPauseSp	:Sprite;
		private var resetSp			:Sprite;
		private var inAction		:Boolean;
		private var rotationVisible	:Boolean;
		private var tOrigine		:uint;
		private var tc				:TextField;
		
		// fonction constructeur
		public function Montre(rayon:uint) {
			rayonMontre			= rayon;
			this.addEventListener(Event.ADDED_TO_STAGE, onAddToStage);
			this.addEventListener(Event.REMOVED_FROM_STAGE, onRemoveFromStage);
		}
		// quand la montre est ajouté à l'ecran creation, affichage et écoute des elements graphiques
		private function onAddToStage(e:Event):void
		{
			// le format pour l'affichage du texte faisant reference à la police incorporée dans le .fla
			tf		 			= new TextFormat(mf.fontName,rayonMontre/5,Math.random()*0xffffff);
			// ******** sprite pour le cadran avec les graduations
			cadran				= new Sprite();
			// dessine les traits
			cadran.graphics.lineStyle(1,Math.random()*0xffffff);
			for (var i:uint = 0 ; i < 360 ; i+=6){
				var _coordonnee:Array	= cp(i,rayonMontre-5,rayonMontre);
				cadran.graphics.moveTo(_coordonnee[0],_coordonnee[1]);
				cadran.graphics.lineTo(_coordonnee[2],_coordonnee[3]);
				cadran.graphics.endFill();
			}
			// cadran
			cadran.graphics.lineStyle(2,Math.random()*0xffffff);
			cadran.graphics.drawCircle(0,0,rayonMontre);
			cadran.graphics.endFill();
			//********************
			// aiguilles
			h					=	dessineAiguille(-Math.floor(rayonMontre*.5));
			m					=	dessineAiguille(-Math.floor(rayonMontre*.7));
			s					=	dessineAiguille(-Math.floor(rayonMontre*.8));
			c					= 	dessineAiguille(-Math.floor(rayonMontre*.9));
			// boutons et prosition des boutons
			startPauseSp		= 	dessineRectangle(20,10);
			resetSp				=	dessineRectangle(20,10);
			startPauseSp.rotation	= 45;
			resetSp.rotation		= -45;
			positionneBt(startPauseSp);
			positionneBt(resetSp);
			// texte
			t					= new TextField();
			t.y					= rayonMontre + 10;
			t.embedFonts		= true;
			t.selectable		= false;
			t.autoSize			= TextFieldAutoSize.LEFT;
			t.defaultTextFormat = tf;
			// ajout
			this.addChild(t);
			this.addChild(h);
			this.addChild(m);
			this.addChild(s);
			this.addChild(c);
			this.addChild(startPauseSp);
			this.addChild(resetSp);
			this.addChild(cadran);
			
			startPauseSp.addEventListener(MouseEvent.CLICK,onStartChrono);
			resetSp.addEventListener(MouseEvent.CLICK,onResetChrono);
			this.addEventListener(Event.ENTER_FRAME, onMontre);
		}
		// fonction loop
		private function onMontre(e:Event):void{
			// fonction loop cacul la position des aiguilles et du chrono
			var _d	:Date 	= new Date();
			var _vh	:* 		= _d.hours;
			var _vm	:* 		= _d.minutes;
			var _vs	:* 		= _d.seconds;
			 
			h.rotation 	  	= _vh*30 + _vm/2 ;
			m.rotation 	  	= _vm*6  + _vs/10;
			s.rotation 	  	= _vs*6  + _d.milliseconds/ 166 ;
			
			// calcul les donnée pour l'heur digitale
			if (_vh < 10) _vh = "0" + _vh;
			if (_vm < 10) {_vm = "0" + _vm;}
			_vs 			= _vs < 10 ? "0" + _vs : _vs ;
			
			// positionne le texte de l'heure digitale
			t.text			= _vh + ":" + _vm+":" + _vs;
			t.x				= -t.width / 2;
			
			// fait tourner l'aiguille du chrono et controle l'affichage du temps du chrono
			if (rotationVisible){
				var _difSeconde:Number	= (getTimer() - tOrigine)/1000
				c.rotation 				= _difSeconde * 6;
				if (!tc){
					tc					= new TextField();
					tc.y				= - 20;
					tc.embedFonts		= true;
					tc.selectable		= false;
					tc.autoSize			= TextFieldAutoSize.LEFT;
					tc.defaultTextFormat = new TextFormat(mf.fontName,rayonMontre/7,Math.random()*0xffffff);;
					this.addChild(tc);
				}
				var _ch:*				= Math.floor(_difSeconde / 3600) < 10 ? "0" +  Math.floor(_difSeconde / 3600) : Math.floor(_difSeconde / 3600) ;
				var _cm:*				= Math.floor((_difSeconde % 3600) / 60) < 10 ? "0" + Math.floor((_difSeconde % 3600) / 60) : Math.floor((_difSeconde % 3600) / 60);
				var _cs:*				= (_difSeconde % 3600) % 60 < 10 ? "0" + (_difSeconde % 3600) % 60 : (_difSeconde % 3600) % 60;
				tc.text					= _ch + ":" + _cm + ":" + _cs;
				tc.x					= -tc.width / 2;
			}else if (tc && !inAction){
				this.removeChild(tc);
				tc = null;
			}
		}
		// action sur le boutons du chrono
		private function onStartChrono(e:MouseEvent):void
		{
			!inAction ? tOrigine = getTimer() : null;
			!inAction ? inAction = rotationVisible = true : rotationVisible = !rotationVisible;
		}
		private function onResetChrono(e:MouseEvent):void
		{
			inAction 	= rotationVisible = false;
			c.rotation 	= 0;
		}
		//********** Dessin et Positionnement
		private function dessineAiguille(l:int):Shape
		{
			var _ligne:Shape 	= new Shape();
			_ligne.graphics.lineStyle(1,Math.random()*0xffffff);
			_ligne.graphics.moveTo(0,0);
			_ligne.graphics.lineTo(0,l)
			_ligne.graphics.endFill();
			return _ligne;
		}
		private function dessineRectangle(l:uint,h:uint):Sprite
		{
			var _rect:Sprite 	= new Sprite();
			_rect.graphics.beginFill(Math.random()*0xffffff);
			_rect.graphics.lineStyle(1,Math.random()*0xffffff);
			_rect.graphics.drawRect(-l/2,-h/2,l,h)
			_rect.graphics.endFill();
			return _rect;
		}
		private function positionneBt(sp:Sprite):void
		{
			sp.x = Math.sin((sp.rotation*Math.PI)/180) * (rayonMontre +(sp.height/2) - 2);
			sp.y = -Math.cos((sp.rotation*Math.PI)/180) * (rayonMontre);
		}
		// renvois depuis l'angle un tableau de coordonnée x,y pour positionner les graduations 
		private function cp(angle:uint,dO:uint,dF:uint):Array
		{
			var _a:Array = new Array();
			_a.push(Math.sin(Math.PI*angle/180) * dO);
			_a.push(Math.cos(Math.PI*angle/180) * dO);
			_a.push(Math.sin(Math.PI*angle/180) * dF);
			_a.push(Math.cos(Math.PI*angle/180) * dF);
			return _a;
		}
		// lancer au retrait de la liste d'affichage
		private function onRemoveFromStage(e:Event):void
		{
			startPauseSp.removeEventListener(MouseEvent.CLICK,onStartChrono);
			resetSp.removeEventListener(MouseEvent.CLICK,onResetChrono);
			this.removeEventListener(Event.ENTER_FRAME, onMontre);
		}
	}
}