## Redis Commands Supported

### Keys Command

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |        DEL        |    Yes     | DEL key [key …]                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       DUMP        |    Yes     | DUMP key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      EXISTS       |    Yes     | EXISTS key                                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      EXPIRE       |    Yes     | EXPIRE key seconds                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     EXPIREAT      |    Yes     | EXPIREAT key timestamp                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       KEYS        |    Yes*     | KEYS pattern                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MIGRATE      |    No      | MIGRATE host port key destination-db timeout                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MOVE        |    No      | MOVE key db                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      OBJECT       |    No      | OBJECT subcommand [arguments [arguments …]]                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PERSIST      |    Yes     | PERSIST key                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PEXPIRE      |    Yes     | PEXPIRE key milliseconds                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PEXPIREAT     |    Yes     | PEXPIREAT key milliseconds-timestamp                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PTTL         |    Yes     | PTTL key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RANDOMKEY     |    No      | RANDOMKEY                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RENAME       |    No      | RENAME key newkey                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RENAMENX      |    No      | RENAMENX key newkey                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RESTORE      |    Yes     | RESTORE key ttl serialized-value                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SORT         |    No      | SORT key [BY pattern] [LIMIT offset count] [GET pattern [GET pattern ...]] [ASC|DESC] [ALPHA] [STORE destination]   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       TTL         |    Yes     | TTL key                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      TYPE         |    Yes     | TYPE key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SCAN         |    Yes*    | SCAN cursor [MATCH pattern] [COUNT count]                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* SCAN, KEYS read only the local node.

### Strings Command

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       APPEND      |    Yes     | APPEND key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      BITCOUNT     |    Yes     | BITCOUNT key [start] [end]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BITOP       |    No      | BITOP operation destkey key [key ...]                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       DECR        |    Yes     | DECR key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      DECRBY       |    Yes     | DECRBY key decrement                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       GET         |    Yes     | GET key                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GETBIT       |    Yes     | GETBIT key offset                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     GETRANGE      |    Yes     | GETRANGE key start end                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      GETSET       |    Yes     | GETSET key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      INCR         |    Yes     | INCR key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      INCRBY       |    Yes     | INCRBY key increment                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     INCRBYFLOAT   |    Yes     | INCRBYFLOAT key increment                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MGET         |    Yes     | MGET key [key ...]                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MSET         |    No      | MSET key value [key value ...]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      MSETNX       |    No      | MSETNX key value [key value ...]                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      PSETEX       |    Yes     | PSETEX key milliseconds value                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SET          |    Yes     | SET key value [EX seconds] [PX milliseconds] [NX|XX]                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SETBIT       |    Yes     | SETBIT key offset value                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SETEX        |    Yes     | SETEX key seconds value                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SETNX        |    Yes     | SETNX key value                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SETRANGE     |    Yes     | SETRANGE key offset value                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      STRLEN       |    Yes     | STRLEN key                                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Hashes

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       HDEL        |    Yes     | HDEL key field [field ...]                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HEXISTS      |    Yes     | HEXISTS key field                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       HGET        |    Yes     | HGET key field                                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HGETALL      |    Yes     | HGETALL key                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HINCRBY      |    Yes     | HINCRBY key field increment                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    HINCRBYFLOAT   |    Yes     | HINCRBYFLOAT key field increment                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HKEYS        |    Yes     | HKEYS key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HLEN         |    Yes     | HLEN key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HMGET        |    Yes     | HMGET key field [field ...]                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HMSET        |    Yes     | HMSET key field value [field value ...]                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HSET         |    Yes     | HSET key field value                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HSETNX       |    Yes     | HSETNX key field value                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      HVALS        |    Yes     | HVALS key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Lists

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BLPOP       |    No      | BLPOP key [key ...] timeout                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       BRPOP       |    No      | BRPOP key [key ...] timeout                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     BRPOPLPUSH    |    No      | BRPOPLPUSH source destination timeout                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LINDEX       |    Yes     | LINDEX key index                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LINSERT      |    Yes     | LINSERT key BEFORE|AFTER pivot value                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LLEN         |    Yes     | LLEN key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LPOP         |    Yes     | LPOP key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LPUSH        |    Yes     | LPUSH key value [value ...]                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LPUSHX       |    Yes     | LPUSHX key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LRANGE       |    Yes     | LRANGE key start stop                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LREM         |    Yes     | LREM key count value                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LSET         |    Yes     | LSET key index value                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      LTRIM        |    Yes     | LTRIM key start stop                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RPOP         |    Yes     | RPOP key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     RPOPLPUSH     |    Yes*    | RPOPLPUSH source destination                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RPUSH        |    Yes     | RPUSH key value [value ...]                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      RPUSHX       |    Yes     | RPUSHX key value                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* RPOPLPUSH support requires that source and destination keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for source and destination key. Dynomite does no checking on its end to verify that source and destination key hash to the same server, and the RPOPLPUSH command is forwarded to the server that the source key hashes to

### Sets

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SADD         |    Yes     | SADD key member [member ...]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SCARD        |    Yes     | SCARD key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SDIFF        |    Yes*    | SDIFF key [key ...]                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SDIFFSTORE    |    Yes*    | SDIFFSTORE destination key [key ...]                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SINTER       |    Yes*    | SINTER key [key ...]                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SINTERSTORE    |    Yes*    | SINTERSTORE destination key [key ...]                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SISMEMBER     |    Yes     | SISMEMBER key member                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SMEMBERS      |    Yes     | SMEMBERS key                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SMOVE        |    Yes*    | SMOVE source destination member                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SPOP         |    Yes     | SPOP key                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SRANDMEMBER    |    Yes     | SRANDMEMBER key                                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SREM         |    Yes     | SREM key member [member ...]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SUNION        |    Yes*    | SUNION key [key ...]                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   SUNIONSTORE     |    Yes*    | SUNIONSTORE destination key [key ...]                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SSCAN        |    Yes**   | SSCAN key cursor [MATCH pattern] [COUNT count]                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* SIDFF, SDIFFSTORE, SINTER, SINTERSTORE, SMOVE, SUNION and SUNIONSTORE support requires that the supplied keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys in the command. Dynomite does no checking on its end to verify that all the keys hash to the same server, and the given command is forwarded to the server that the first key hashes to.

** SSCAN scans only sets in the local node.

### Sorted Sets

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZADD         |    Yes     | ZADD key score member [score] [member]                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZCARD        |    Yes     | ZCARD key                                                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZCOUNT       |    Yes     | ZCOUNT key min max                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZINCRBY      |    Yes     | ZINCRBY key increment member                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZINTERSTORE   |    Yes*    | ZINTERSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZLEXCOUNT     |    Yes     | ZLEXCOUNT key min max                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZRANGE       |    Yes     | ZRANGE key start stop [WITHSCORES]                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZRANGEBYLEX    |    Yes     | ZRANGEBYLEX key min max [LIMIT offset count]                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZRANGEBYSCORE  |    Yes     | ZRANGEBYSCORE key min max [WITHSCORES] [LIMIT offset count]                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZRANK        |    Yes     | ZRANK key member                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ZREM        |    Yes     | ZREM key member [member ...]                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   ZREMRANGEBYLEX  |    Yes     | ZREMRANGEBYLEX key min max                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   ZREMRANGEBYRANK |    Yes     | ZREMRANGEBYRANK key start stop                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  ZREMRANGEBYSCORE |    Yes     | ZREMRANGEBYSCORE key min max                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZREVRANGE      |    Yes     | ZREVRANGE key start stop [WITHSCORES]                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |   ZREVRANGEBYLEX  |    Yes     | ZREVRANGEBYLEX key max min [LIMIT offset count]                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  ZREVRANGEBYSCORE |    Yes     | ZREVRANGEBYSCORE key max min [WITHSCORES] [LIMIT offset count]                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZREVRANK      |    Yes     | ZREVRANK key member                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     ZSCORE        |    Yes     | ZSCORE key member                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    ZUNIONSTORE    |    Yes*    | ZUNIONSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      ZSCAN        |    Yes**   | ZSCAN key cursor [MATCH pattern] [COUNT count]                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* ZINTERSTORE and ZUNIONSTORE support requires that the supplied keys hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys in the command. Dynomite does no checking on its end to verify that all the keys hash to the same server, and the given command is forwarded to the server that the first key hashes to.

** SSCAN scans only sorted sets in the local node.

## HyperLogLog
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PFADD         |    Yes     | PFADD key element [element...]                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PFCOUNT       |    Yes     | PFCOUNT key [key...]                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PFMERGE       |    No      | PFMERGE destkey sourcekey [sourcekey ...]                                                                           |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+


### Pub/Sub

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PSUBSCRIBE    |    No      | PSUBSCRIBE pattern [pattern ...]                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     PUBLISH       |    No      | PUBLISH channel message                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    PUNSUBSCRIBE   |    No      | PUNSUBSCRIBE [pattern [pattern ...]]                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SUBSCRIBE     |    No      | SUBSCRIBE channel [channel ...]                                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     UNSUBSCRIBE   |    No      | UNSUBSCRIBE [channel [channel ...]]                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Transactions

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      DISCARD      |    No      | DISCARD                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       EXEC        |    No      | EXEC                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       MULTI       |    No      | MULTI                                                                                                               |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      UNWATCH      |    No      | UNWATCH                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       WATCH       |    No      | WATCH key [key ...]                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

### Scripting

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       EVAL        |    Yes*    | EVAL script numkeys key [key ...] arg [arg ...]                                                                     |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     EVALSHA       |    Yes*    | EVALSHA sha1 numkeys key [key ...] arg [arg ...]                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT EXISTS  |    Yes     | SCRIPT EXISTS script [script ...]                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT FLUSH   |    Yes**   | SCRIPT FLUSH                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT KILL    |    Yes**   | SCRIPT KILL                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    SCRIPT LOAD    |    Yes     | SCRIPT LOAD script                                                                                                  |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

 * EVAL and EVALSHA support is limited to scripts that take at least 1 key. If multiple keys are used, all keys must hash to the same server. You can ensure this by using the same [hashtag](recommendation.md#hash-tags) for all keys. If you use more than 1 key, the proxy does no checking to verify that all keys hash to the same server, and the entire command is forwarded to the server that the first key hashes to

 ** SCRIPT KILL and SCRIPT FLUSH will kill and flush on ALL Dynomite nodes.

### Connection

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       AUTH        |    No      | AUTH password                                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       ECHO        |    No      | ECHO message                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       PING        |    YES*    | PING                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |       QUIT        |    YES     | QUIT                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SELECT       |    No      | SELECT index                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* inline PING is also supported and runs locally only.

### Server

    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      Command      | Supported? | Format                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    BGREWRITEAOF   |    No      | BGREWRITEAOF                                                                                                        |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      BGSAVE       |    No      | BGSAVE                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CLIENT KILL    |    No      | CLIENT KILL ip:port                                                                                                 |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CLIENT LIST    |    No      | CLIENT LIST                                                                                                         |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CONFIG GET     |    YES     | CONFIG GET parameter                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    CONFIG SET     |    No      | CONFIG SET parameter value                                                                                          |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |  CONFIG RESETSTAT |    No     | CONFIG RESETSTAT                                                                                                    |
    +-------------------+-------------+--------------------------------------------------------------------------------------------------------------------+
    |  CONFIG REWRITE   |    No      | CONFIG REWRITE                                                                                                      |
    +-------------------+-------------+--------------------------------------------------------------------------------------------------------------------+
    |     DBSIZE        |    No      | DBSIZE                                                                                                              |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    DEBUG OBJECT   |    No      | DEBUG OBJECT key                                                                                                    |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |    DEBUG SEGFAULT |    No      | DEBUG SEGFAULT                                                                                                      |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     FLUSHALL      |    No      | FLUSHALL                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     FLUSHDB       |    No      | FLUSHDB                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      INFO         |    YES*      | INFO                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     LASTSAVE      |    No      | LASTSAVE                                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     MONITOR       |    No      | MONITOR                                                                                                             |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SAVE         |    No      | SAVE                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SHUTDOWN      |    No      | SHUTDOWN [NOSAVE] [SAVE]                                                                                            |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SLAVEOF       |    No      | SLAVEOF host port                                                                                                   |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |     SLOWLOG       |    No      | SLOWLOG subcommand [argument]                                                                                       |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      SYNC         |    No      | SYNC                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+
    |      TIME         |    No      | TIME                                                                                                                |
    +-------------------+------------+---------------------------------------------------------------------------------------------------------------------+

* INFO reads only the local node.


## Note

- redis commands are not case sensitive
- only vectored commands 'MGET key [key ...]' and 'DEL key [key ...]' needs to be fragmented

## Performance

### Setup

+ redis-server running on machine A.
+ dynomite running on machine A as a local proxy to redis-server.
+ redis-benchmark running on machine B.
+ machine A != machine B.
+ dynomite built with --enable-debug=no
+ dynomite running with mbuf-size of 512 (-m 512)
+ redis-server built from redis 2.6 branch

### redis-benchmark against redis-server

    $ redis-benchmark -h <machine-A> -q -t set,get,incr,lpush,lpop,sadd,spop,lpush,lrange -c 100 -p 6379
    SET: 89285.71 requests per second
    GET: 92592.59 requests per second
    INCR: 89285.71 requests per second
    LPUSH: 90090.09 requests per second
    LPOP: 90090.09 requests per second
    SADD: 90090.09 requests per second
    SPOP: 93457.95 requests per second
    LPUSH (needed to benchmark LRANGE): 89285.71 requests per second
    LRANGE_100 (first 100 elements): 36496.35 requests per second
    LRANGE_300 (first 300 elements): 15748.03 requests per second
    LRANGE_500 (first 450 elements): 11135.86 requests per second
    LRANGE_600 (first 600 elements): 8650.52 requests per second

### redis-benchmark against dynomite proxing redis-server

    $ redis-benchmark -h <machine-A> -q -t set,get,incr,lpush,lpop,sadd,spop,lpush,lrange -c 100 -p 22121
    SET: 85470.09 requests per second
    GET: 86956.52 requests per second
    INCR: 85470.09 requests per second
    LPUSH: 84745.77 requests per second
    LPOP: 86206.90 requests per second
    SADD: 84745.77 requests per second
    SPOP: 86956.52 requests per second
    LPUSH (needed to benchmark LRANGE): 84745.77 requests per second
    LRANGE_100 (first 100 elements): 29761.90 requests per second
    LRANGE_300 (first 300 elements): 12376.24 requests per second
    LRANGE_500 (first 450 elements): 8605.85 requests per second
    LRANGE_600 (first 600 elements): 6587.62 requests per second

