﻿-- Languages
INSERT [Localization].[Language] ([CultureName], [DisplayName], [Country], [Region], [IsDefaultLanguage]) VALUES (N'en-US', N'English - United States', N'English - United States', N'United States', 1)
INSERT [Localization].[Language] ([CultureName], [DisplayName], [Country], [Region], [IsDefaultLanguage]) VALUES (N'tr-TR', N'Turkish - Turkey', N'Turkish - Turkey', N'Turkey', 0)
INSERT [Localization].[Language] ([CultureName], [DisplayName], [Country], [Region], [IsDefaultLanguage]) VALUES (N'fr-FR', N'French - France', N'French - France', N'France', 0)


-- .Net Core Default Validation Message Localization Resources
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The value ''{0}'' is not valid for {1}.'                 , N'The value ''{0}'' is not valid for {1}.'                 , N'AttemptedValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'A value for the ''{0}'' property was not provided.'      , N'A value for the ''{0}'' property was not provided.'      , N'MissingBindRequiredValueAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'A value is required.'                                  , N'A value is required.'                                  , N'MissingKeyOrValueAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The supplied value is invalid for {0}.'                , N'The supplied value is invalid for {0}.'                , N'UnknownValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The value ''{0}'' is invalid.'                           , N'The value ''{0}'' is invalid.'                           , N'ValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The field {0} must be a number.'                       , N'The field {0} must be a number.'                       , N'ValueMustBeANumberAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Null value is invalid.'                                , N'Null value is invalid.'                                , N'ValueMustNotBeNullAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The {0} field is not a valid e-mail address.'          , N'The {0} field is not a valid e-mail address.'          , N'InvalidEmail')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The field {0} must match the regular expression ''{1}''.', N'The field {0} must match the regular expression ''{1}''.', N'MustMatchRegex')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'The password and confirmation password do not match.'  , N'The password and confirmation password do not match.'  , N'PasswordNoMatch')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'{0} must be less than {2} and greater then {1}.'       , N'{0} must be less than {2} and greater then {1}.'       , N'Range')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'{0} cannot be empty.'                                  , N'{0} cannot be empty.'                                  , N'Required')

-- .Net Core Default Validation Localization Turkish Resources
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The value ''{0}'' is not valid for {1}.'                 , N'''{0}'' değeri ''{1}'' için geçerli değil.', N'AttemptedValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'A value for the ''{0}'' property was not provided.'      , N'''{0}'' için bir değer sağlanmadı.', N'MissingBindRequiredValueAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'A value is required.'                                  , N'Bu değer zorunludur.', N'MissingKeyOrValueAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The supplied value is invalid for {0}.'                , N'Sağlanan değer, ''{0}'' için geçersiz.', N'UnknownValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The value ''{0}'' is invalid.'                           , N'''{0}'' değeri geçersiz.', N'ValueIsInvalidAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The field {0} must be a number.'                       , N'''{0}'' alanı bir sayı olmalıdır.', N'ValueMustBeANumberAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Null value is invalid.'                                , N'Null değer geçersiz.', N'ValueMustNotBeNullAccessor')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The {0} field is not a valid e-mail address.'          , N'''{0}'' alanı geçerli bir e-posta adresi değil.', N'InvalidEmail')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The field {0} must match the regular expression ''{1}''.', N'''{0}'' alanı, ''{1}'' ifadesinin normal ifadesiyle eşleşmelidir.', N'MustMatchRegex')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'The password and confirmation password do not match.'  , N'Şifre ve doğrulama şifresi uyuşmuyor.', N'PasswordNoMatch')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'{0} must be less than {2} and greater then {1}.'       , N'''{0}'', ''{2}'' den düşük ve ''{1}'' den daha büyük olmalıdır.', N'Range')
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'{0} cannot be empty.'                                  , N'''{0}'' boş olamaz.', N'Required')



--Test Project English Resources
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'HasNoEquivalentInOtherLanguages'				, N'- This key value has no equivalent in other languages.<br/>- If you mark <b>"LocalizationSettings.UseDefaultLanguageWhenValueIsNull"</b> property as true in <b>appsettings.json</b>, the value for the default language is shown.', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Hello'		, N'Hello!', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Sample Pages'									, N'Sample Pages!', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Exception Handler'								, N'Exception Handler!', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Client Side Localization Sample Message'		, N'This message was generated by javascript with client side localization.', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'AboutMe'		, N'About Me', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Address'		, N'Address', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'City'			, N'City', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Company'		, N'Company', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ConfirmPassword', N'Confirm Password', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Country'		, N'Country', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'EMailAddress'	, N'E-Mail Address', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'FirstName'		, N'First Name', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'LastName'		, N'Last Name', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Password'		, N'Password', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'PostalCode'		, N'Postal Code', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Username'		, N'Username', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'BirthDate'		, N'Birth Date', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Time'			, N'Time', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Currency'		, N'Currency', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'PhoneNumber'	, N'Phone Number', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'CreditCard'		, N'Credit Card', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'IpAddress'		, N'Ip Address', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ItemNotFoundExceptionKey', N'Item not found', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'CustomExceptionKey', N'Custom Exception Localization Test Message', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Click and show client side localization sample'	, N'Click and show client side localization sample', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Logo_Description'								, N'Logo Description NetCoreStack Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_Home'										, N'Home', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_Forms'										, N'Forms', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_About'										, N'About', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_Contact'									, N'Contact', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_Component_Api'								, N'Component Api', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_ClientSideLocalization'					, N'Client Side Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_ExceptionLocalization'						, N'Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Menu_AjaxExceptionLocalization'					, N'Ajax Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'AboutPageDescription'							, N'About page description', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'HowToUse'										, N'How to use', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ApiPage_AllLanguage'							, N'All Languages', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ApiPage_AllResources'							, N'All Resources', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ApiPage_AllResourcesByLanguageId'				, N'All Resources By LanguageId', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ApiPage_CreateLanguage'							, N'Create Language', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'ApiPage_CreateResource'							, N'Create Resource', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (1, N'Copyright'										, N'© Copyright {0} {1} All Rights Reserved', NULL)




--Test Project Turkish Resources
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Hello'			, N'Merhaba!', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Sample Pages'	, N'Örnek Sayfalar', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Exception Handler'		, N'Hata Yakalama', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Client Side Localization Sample Message'		, N'Bu mesaj JavaScript ile Client-Side Localization aracılığı ile üretildi.', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'AboutMe'		, N'Hakkımda', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Address'		, N'Adres', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'City'			, N'Şehir', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Company'		, N'Firma', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ConfirmPassword', N'Şifre Onayı', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Country'		, N'Ülke', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'EMailAddress'	, N'E-Posta Adresi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'FirstName'		, N'Ad', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'LastName'		, N'Soyad', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Password'		, N'Şifre', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'PostalCode'		, N'Posta Kodu', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Username'		, N'Kullanıcı Adı', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'BirthDate'		, N'Doğum Tarihi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Time'			, N'Zaman', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Currency'		, N'Para Birimi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'PhoneNumber'	, N'Telefon Numarası', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'CreditCard'		, N'Kredi Kartı', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'IpAddress'		, N'İp Adresi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ItemNotFoundExceptionKey', N'Öğe bulunamadı', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'CustomExceptionKey', N'Özel Hata Sayfası Localization Test Mesajı', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Click and show client side localization sample'	, N'Tıkla ve client-side localization örneğini görüntüle', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Logo_Description'								, N'Logo Açıklaması - NetCoreStack Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_Home'										, N'Ana Sayfa', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_Forms'										, N'Form Öğeleri', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_About'										, N'Hakkında', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_Contact'									, N'İletişim', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_Component_Api'								, N'Component Api', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_ClientSideLocalization'					, N'Client Side Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_ExceptionLocalization'						, N'Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Menu_AjaxExceptionLocalization'					, N'Ajax Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'AboutPageDescription'							, N'Hakkında sayfası açıklaması', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'HowToUse'										, N'Nasıl kullanılır?', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ApiPage_AllLanguage'							, N'Tüm Diller', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ApiPage_AllResources'							, N'Tüm Kaynaklar', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ApiPage_AllResourcesByLanguageId'				, N'LanguageId parametresine göre kaynaklar', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ApiPage_CreateLanguage'							, N'Yeni Dil Oluşturma', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'ApiPage_CreateResource'							, N'Yeni Kaynak Oluşturma', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (2, N'Copyright'										, N'© {0} {1} Her hakkı saklıdır', NULL)



--Test Project French Resources
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Hello'		, N'Bonjour!', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Sample Pages'	, N'Exemples de pages', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Exception Handler'		, N'Gestionnaire d`exception', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Client Side Localization Sample Message'		, N'Ce message a été généré par javascript avec la localisation côté client.', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'AboutMe'		, N'À propos de moi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Address'		, N'Adresse', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'City'			, N'Ville', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Company'		, N'Entreprise', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ConfirmPassword', N'Confirmez le mot de passe', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Country'		, N'Pays', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'EMailAddress'	, N'Adresse électronique', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'FirstName'		, N'Prénom', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'LastName'		, N'Nom de famille', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Password'		, N'Mot de passe', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'PostalCode'		, N'Code Postal', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Username'		, N'Nom d`utilisateur', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'BirthDate'		, N'Date de naissance', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Time'			, N'Temps', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Currency'		, N'Devise', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'PhoneNumber'	, N'Numéro de téléphone', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'CreditCard'		, N'Carte de crédit', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'IpAddress'		, N'Adresse IP', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ItemNotFoundExceptionKey', N'Objet non-trouvé', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'CustomExceptionKey', N'Message de test de localisation d`exception personnalisée', NULL)

INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Click and show client side localization sample'	, N'Cliquez et montrez un exemple de localisation côté client', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Logo_Description'								, N'Description du logo - NetCoreStack Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_Home'										, N'Page d`accueil', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_Forms'										, N'Éléments de forme', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_About'										, N'À propos de moi', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_Contact'									, N'Sur', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_Component_Api'								, N'Component Api', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_ClientSideLocalization'					, N'Client Side Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_ExceptionLocalization'						, N'Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Menu_AjaxExceptionLocalization'					, N'Ajax Exception Localization', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'AboutPageDescription'							, N'A propos de la description de la page', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'HowToUse'										, N'Comment utiliser', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ApiPage_AllLanguage'							, N'Toutes les langues', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ApiPage_AllResources'							, N'Toutes les ressources', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ApiPage_AllResourcesByLanguageId'				, N'Paramètre Resources by LanguageId', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ApiPage_CreateLanguage'							, N'Créer une nouvelle langue', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'ApiPage_CreateResource'							, N'Yeni Kaynak Oluşturma', NULL)
INSERT [Localization].[Resource] ([LanguageId], [Key], [Value], [Comment]) VALUES (3, N'Copyright'										, N'© Copyright {0} {1} Tous droits réservés.', NULL)



