# Braindler: Personal AI Assistant with Internet Access for Real-World Tasks, Goal Achievement and Communications

[![Official Website](https://img.shields.io/badge/Official%20Website-braindler.com-blue?style=flat&logo=world&logoColor=white)](https://braindler.com)
[![Twitter Follow](https://img.shields.io/twitter/follow/braindler?style=social)](https://twitter.com/Braindler)

![Braindler](/assets/braindler.png)
<br/>Braindler, when given a goal in natural language, attempts to achieve it by decomposing it into sub-tasks and using the internet and other tools while applying recursion, depth-first search, and breadth-first search. Within the recursion process, separate roles can be created, resulting in a team of specialized virtual professionals working together. Braindler can utilize not only OpenAI's GPT-4 or GPT-3.5 API but also TrueGPT, which is trained to produce output in RoboScript format, enabling interactive capabilities beyond conventional text responses.


Braindler is the next-generation upgrade to the GPT series, harnessing the power of the internet for improved interactions, problem-solving, and communication with people. This user-friendly AI can access websites, gather information, complete tasks, and seamlessly engage with users in a chat interface.
Active Internet Engagement capabilities go beyond traditional chat interfaces by enabling proactive interaction with online resources and services. For instance, Braindler can autonomously send a message to a person or group, fill out a web form, or conduct API interactions to streamline tasks and enhance the user experience.
Experience the future of AI with Braindler, designed to help users efficiently tackle tasks, achieve their goals, and enhance human communication through active online engagement.

## 🚀 Features
- ⚡ **Internet-based Actions:** Execute tasks and interact with online resources.
- 🌐 **Web-Based Search:** Utilize web-based resources to gather information and identify solutions.
- 👥 **Multi-User Mode:** Support multi-user mode for group collaboration and management. Users can assign tasks, communicate with each other, and monitor progress together.
- 💬 **Communicate with Individuals and Groups:** Seamlessly engage with people and organizations
free interaction and makes the AI assistant more versatile and convenient to use.
- 📚 **Supported Models:**
  - Supports API for GPT3 and GPT4
  - Support local-based models(CPU or [GPU](https://github.com/nativemindnet/Braindler-GPU-LM-Endpoint)): [TrueGPT](https://github.com/nativemindnet/TrueGPT) (with RoboScript support), ALPACA, DOLLY, VICUNA, STABLELM
- 🔊 **Text-to-Speech:** Extend Braindler's capabilities with text-to-speech functionality for voice output, providing a more immersive user experience.
- 🎤 **Speech-to-Text:** Integrate speech recognition technology to allow users to communicate with Braindler using their voice. This feature enables hands-
- 🔌 **Customizable Plugin System:** Create and integrate your own plugins to expand Braindler's capabilities and tailor its functionality to your specific needs.
- 🌍 Multilingual Support: Braindler can support multiple languages, allowing users to communicate with it in their preferred language. 

## 🧠 Cognitive Mechanisms of Braindler

### Memory and Adaptability
- 💾 **Efficient Memory Management:** Handles short-term and long-term memory effectively.
- 🧠 **Memory Registers:** Storage for sensitive information such as login credentials, passwords, and API keys.
- 🎯 **Dynamic Goal and Task Registers:** Adapt to changing objectives and assignments in real-time.
- 💬 **Seamless Goal and Task Modification:** AI and operators can update goals and tasks through natural conversation.

### Search and Problem Solving
- 🕸️ **Recursion:** Breaking down complex tasks into simpler sub-tasks for efficient execution.
- 🔄 **Looping Mechanisms:** Braindler can perform repetitive tasks through looping mechanisms, allowing it to complete tasks efficiently and accurately.
- 🔍 **Depth-First Search:** Explore deeper branches in the search tree for more comprehensive solutions.
- 🌐 **Breadth-First Search:** Investigate a wide range of possibilities to identify the best solution.
- 🌟 **Multivariate Approach:** Explore multiple paths and options for versatile problem-solving.
- 👥 **Virtual AI-Team Management:** Braindler create and manage virtual AI-team members of Braindler, each with their own set of goals and tasks.
- 🎭 **Personality Types:** Customize AI behavior through prompts for various personality styles and skills assets.

### Customization and Interaction
- 📩 **Incoming Events:** Respond to time-based triggers, incoming messages from different platforms, and other external inputs.
- 🤖 **Autonomy:** Braindler autonomously breaks down complex tasks and achieves goals without requiring constant human input or manual commands for every task.
- 📣 **Queue Prompts:** Prompt operator when action is required instead of waiting indefinitely.


## Supported Actions for Platforms

Braindler offers seamless integration with a wide range of platforms and services, including:
- Local(sandbox) / Remote(SSH) computer management
- 📱 Telegram
- 💬 WhatsApp
- 🌐 LINE
- 🇨🇳 WeChat
- 📧 Email
- 👥 Facebook
- 🐦 Twitter
- 🐙 GitHub
- ...Additionally, you can create custom integrations using our plugin system to connect Braindler with your preferred platforms and tools.

## How to try
- 🌐 Browser Integration: Use the Braindler web browser version, designed to make it easy for non-programmers to create and use their own AI agents.
- 📱 Messaging Platforms: Braindler is available on popular messaging platforms, including:
  - Telegram Bot [@Braindler_bot](https://t.me/Braindler_bot)
  - Line Bot [@127mydng](https://line.me/R/ti/p/@127mydng)
  - WhatsApp Bot
  - WeChat Bot

<details>
<summary><h3>Braindler vs ChatGPT</h3></summary>
Braindler builds upon the foundations of ChatGPT while offering several key enhancements:
* Passive Information Gathering: Braindler effectively extracts relevant information from websites and databases, providing users with the most up-to-date and accurate data for their needs, without requiring manual initiation or step-by-step instructions.
* Active Internet Engagement: Braindler proactively interacts with online resources and services, enabling seamless coordination with individuals and organizations to simplify tasks and enhance user experience. For instance, Braindler can autonomously order a pizza from a local pizzeria or arrange a taxi pickup without requiring the user to manually initiate contact.
* Enhanced Problem Solving: By leveraging its internet connectivity, Braindler can perform more complex tasks and provide more accurate information to users, leading to better problem-solving capabilities.
* Goal Achievement: Braindler is designed to help users achieve their goals by not only providing relevant information but also by actively assisting in task execution.
These differences make Braindler a more versatile and powerful AI assistant compared to ChatGPT, enhancing the user experience and expanding the range of tasks it can help users accomplish.
</details>

<details>
<summary><h3>🛠️ Applications and Use Cases</h3></summary>
  
Braindler offers a wide range of applications and use cases tailored for different target audiences:

#### 📚 Students and Educators
- 📖 Homework Assistance: Braindler can provide guidance, explanations, and step-by-step solutions for various academic subjects.
- 📝 Essay Writing and Editing: Get help with brainstorming, writing, and editing essays or academic papers.
- 🗂️ Research Assistance: Braindler can search the internet for scholarly articles, journals, and other resources to support academic research.

#### 👩‍💼 Professionals and Entrepreneurs
- 💼 Project Management: Use Braindler to manage projects, assign tasks, set deadlines, and monitor progress.
- 📈 Data Analysis: Leverage Braindler's capabilities to analyze data, generate insights, and create visualizations.
- 🤝 Networking: Braindler can search for potential collaborators, partners, or clients and help initiate contact.

#### 🛠️ Developers and Engineers
- 📝 Code Writing, Debugging, and Editing: Braindler can assist in software development tasks, including writing, debugging, testing, and editing code.
- 📚 API Documentation: Get help with understanding and utilizing various APIs in your projects.
- 🚀 Optimization: Receive suggestions and guidance for optimizing code and system performance.

#### 🎨 Creatives and Designers
- 💡 Idea Generation: Generate creative ideas for projects, designs, or campaigns.
- 🖼️ Visual Design Assistance: Receive guidance on visual design elements, color palettes, and layout choices.
- ✍️ Copywriting: Get help with crafting compelling copy for advertisements, social media, and other marketing materials.

#### 💼 Businesses and Organizations
- 📣 Social Media Management: Automate and optimize social media content creation, scheduling, and engagement.
- 📈 Market Research: Conduct competitive analysis, customer surveys, and other market research tasks.
- 🛍️ E-commerce Support: Braindler can assist with product recommendations, order processing, and customer support.

#### 🤖 Marketing and Sales
- 📈 Traffic Generation: Use Braindler to generate traffic to your website or social media accounts through automated posting and engagement.
- 📊 Lead Generation: Automate lead generation processes and capture leads through chatbots, web forms, and other methods.
- 💼 Sales Support: Use Braindler to assist sales teams with lead nurturing, customer engagement, and follow-up.

#### 📞 Customer Support
- 📞 Customer Service: Braindler can handle routine customer inquiries and support requests, freeing up support staff to focus on more complex issues.
- 🤖 Chatbots: Use Braindler to build and deploy chatbots for customer support and engagement on websites and social media platforms.
- 🧩 Troubleshooting: Braindler can assist customers with basic troubleshooting and technical support issues.

#### 🤵 Human Resources
- 📝 Resume Screening: Use Braindler to automatically screen resumes and identify qualified candidates for job openings.
- 🎓 Employee Training: Braindler can assist with employee training and development by providing personalized guidance and support.
- 🗂️ HR Management: Use Braindler to manage HR tasks such as onboarding, benefits enrollment, and performance management.

#### 🤖 Automation
- 🤖 Robotic Process Automation (RPA): Use Braindler to automate repetitive and routine tasks, such as data entry, report generation, and document processing.
- 🌐 Web Scraping: Use Braindler to extract data from websites and other online sources for analysis and reporting.
- 📂 File Management: Braindler can assist with file organization, storage, and retrieval tasks.

#### 🎮 Gaming
- 🎮 Game Design: Braindler can assist game designers with concept development, storyboarding, and character creation.
- 🤖 Non-Player Characters (NPCs): Use Braindler to create intelligent NPCs that can interact with players and adapt to changing game conditions.
- 🌱 Game Simulation: Use Braindler to simulate game scenarios and test different game mechanics and strategies.
</details>

## Request for Help
We are actively seeking contributors from diverse backgrounds and skill sets to help us create a powerful and user-friendly AI assistant. If you are passionate about AI and want to make a positive impact, consider joining our team!
We need assistance in the following areas:

- 🚀 **Command Expansion:** Help us develop new commands and functionalities for Braindler, enhancing its capabilities and making it more versatile.
- 🎨 **Frontend Development:** Join our frontend team to improve the user interface, user experience, and overall design of Braindler.
- 🤖 **Backend Development:** Collaborate with our backend team to optimize the performance, stability, and scalability of Braindler.
- 🧠 **AI & NLP Research:** Assist in refining and expanding our AI models, integrating new language models, and researching cutting-edge NLP techniques.
- 🌐 **API & Platform Integration:** Help us integrate Braindler with various APIs, platforms, and services to improve its functionality and compatibility.
- 📝 **Documentation & Tutorials:** Contribute to the creation and maintenance of comprehensive documentation, guides, and tutorials for users and developers.
- 📢 **Marketing & Community Outreach:** Support our marketing efforts to promote Braindler and engage with the community through social media, content creation, and events.
- 🌍 **Localization & Internationalization:** Help us make Braindler accessible to users worldwide by contributing to the translation and localization of the user interface, documentation, and other resources.
- 🔧 **Quality Assurance & Testing:** Work with us to identify and fix bugs, perform testing, and ensure the overall quality and stability of Braindler.

We welcome newcomers, enthusiasts, and experienced professionals alike, as everyone can bring fresh ideas and valuable perspectives to the project. We are committed to providing support and guidance along the way.

If you have any ideas or suggestions, or if you are interested in contributing to the project, please don't hesitate to reach out to us on our [Discord server](https://discord.gg/UcZra8Ay)!

