<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('crm_products', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->default('');
            $table->decimal('cost');
            $table->decimal('price');
            $table->string('unit')->default('');
            $table->integer('state');
            $table->string('desc')->nullable()->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('crm_products');
    }
}
