# License and Citation

## Citation

If you find the NVIDIA Kaolin Wisp library useful for your research, please cite:
```
@misc{KaolinWispLibrary,
      author = {Towaki Takikawa and Or Perel and Clement Fuji Tsang and Charles Loop and Joey Litalien and Jonathan Tremblay and Sanja Fidler and Maria Shugrina},
      title = {Kaolin Wisp: A PyTorch Library and Engine for Neural Fields Research},
      year = {2022},
      howpublished={\url{https://github.com/NVIDIAGameWorks/kaolin-wisp}}
}
```

## License
This codebase is licensed under the NVIDIA Source Code License. 
Commercial licenses are also available, free of charge. 
Please apply using this link (use "Other" and specify Kaolin Wisp): [https://www.nvidia.com/en-us/research/inquiries/](https://www.nvidia.com/en-us/research/inquiries/)


## Wisp in research

A non-exhaustive list of example projects includes:
* 3D Generative Models: ["Magic3D: High-Resolution Text-to-3D Content Creation"](https://arxiv.org/abs/2211.10440) (Lin et al. 2023)
* Robotics: ["Neural Fields for Robotic Object Manipulation from a Single Image"](https://arxiv.org/abs/2210.12126) (Blukis et al. 2022)
* Interactive Editing: ["SKED: Sketch-guided Text-based 3D Editing"](https://arxiv.org/abs/2303.10735) (Mikaeili et al. 2023)
* Differentiable Rendering: ["Pointersect: Neural Rendering with Cloud-Ray Intersection"](https://arxiv.org/abs/2304.12390) (Chang et al. 2023)


### External Contributions

We welcome & encourage external contributions to the codebase!
Special thanks for community members:
* [lightfield botanist](https://github.com/3a1b2c3)
* [Soumik Rakshit](https://github.com/soumik12345)


## Special Thanks

We thank James Lucas, Jonathan Tremblay, Valts Blukis, Anita Hu, and Nishkrit Desai for giving us early feedback
and testing out the code at various stages throughout development. 
We thank Rogelio Olguin and Jonathan Tremblay for the Wisp reference data. 
