[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
[![LinkedIn][linkedin-shield]][linkedin-url]



<!-- PROJECT LOGO -->
<br />
<div align="center">
  <a href="https://github.com/NDJSec/Android-Reverse-Engineering">
    <img src="images/logo.jpeg" alt="Logo" width="500" height="500">
  </a>

<h3 align="center">Android-Reverse-Engineering</h3>

  <p align="center">
    A FREE comprehensive guide to learning Android Reverse Engineering. From Java, to Dalvik, to ART, to the JNI come learn along.
    <br />
    <a href="https://github.com/NDJSec/Android-Reverse-Engineering"><strong>Explore the PDF »</strong></a>
    <br />
    <a href="https://android.nicolasjanis.dev/"><strong>Explore the EBook »</strong></a>
    <br />
  </p>
<h3 align="center">IN DEVELOPMENT</h3>
</div>

## Who Should Read This
The following guide, is for anyone and everyone who is looking for a FREE comprehensive guide for learning Android Reverse Engineering (RE). In this series, we will start with what is Reverse Engineering and its importance. Then, we will look at Java and the JVM. In the end, we will look into Dalvik bytecode and the Android Runtime (ART), and we will finish with the Java Native Interface (JNI) and ARM RE. 

So come along with me in this journey, as we work to learn the inner workings of Android and become the next generation of Cyber Professionals. 

## Table of Contents
<details>
    <summary>Chapters</summary>
    <ol>
        <li>Preface</li>
        <li>Introduction to Reverse Engineering</li>
            <ul>
                <li>Goals</li>
                <li>Techniques</li>
                <li>Tools: Overview</li>
                <li>Tools: Linux</li>
                <li>Tools: VIM</li>
                <li>Tools: APKTool</li>
                <li>Tools: Jadx</li>
                <li>Tools: Android Debug Bridge</li>
                <li>Tools: Ghidra</li>
            </ul>
        <li>Android Basics</li>
            <ul>
                <li>Android Overview</li>
                <li>Component Model</li>
                <li>Android Permissions</li>
                <li>Manifest File</li>
            </ul>
        <li>Java COMMING SOON</li>
    </ol>
</details>

## Further Reading 
- Kevin Thomas ([@mytechnotalent][Kevin_GitHub]) Free Reverse Engineering Self-Study Course [HERE][RE_Tutorial_Url]

## Android RE Analysis Tools [HERE](https://github.com/NDJSec/DroidAnalysis)

## Acknowledgements 
- Kevin Thomas ([@mytechnotalent][Kevin_GitHub])
- Dr. Adwait Nadkarni ([@adwaitnadkarni][Nadkarni_Site])
- SPL Lab ([@spl_wm][SPL_Site])

## License
[Apache License, Version 2.0][License_Url]


<!-- -->
[RE_Tutorial_Url]: https://github.com/mytechnotalent/Reverse-Engineering-Tutorial
[License_Url]: https://www.apache.org/licenses/LICENSE-2.0
[Kevin_GitHub]: https://github.com/mytechnotalent
[Nadkarni_Site]: https://www.adwaitnadkarni.com/
[SPL_Site]: https://spl-wm.github.io/

[contributors-shield]: https://img.shields.io/github/contributors/NDJSec/Android-Reverse-Engineering.svg?style=for-the-badge
[contributors-url]: https://github.com/NDJSec/Android-Reverse-Engineering/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/NDJSec/Android-Reverse-Engineering.svg?style=for-the-badge
[forks-url]: https://github.com/NDJSec/Android-Reverse-Engineering/network/members
[stars-shield]: https://img.shields.io/github/stars/NDJSec/Android-Reverse-Engineering.svg?style=for-the-badge
[stars-url]: https://github.com/NDJSec/Android-Reverse-Engineering/stargazers
[issues-shield]: https://img.shields.io/github/issues/NDJSec/Android-Reverse-Engineering.svg?style=for-the-badge
[issues-url]: https://github.com/NDJSec/Android-Reverse-Engineering/issues
[license-shield]: https://img.shields.io/github/license/NDJSec/Android-Reverse-Engineering.svg?style=for-the-badge
[license-url]: https://github.com/NDJSec/Android-Reverse-Engineering/blob/master/LICENSE.txt
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://www.linkedin.com/in/nicolas-janis/
[product-screenshot]: images/screenshot.png
