---
layout: post
title: MvvmCross 9.0.0
date: 2022-09-10 14:00:00 +0200
categories: mvvmcross
---

It has been a little while since the last MvvmCross release, but here is a bit one.

Today we announce MvvmCross 9.0.0!

This version of MvvmCross is now only targeting .NET 6.0 all old target frameworks have been removed. This improves quality of life significantly when working on MvvmCross, and lessens the amount of targets we have.

Since we are now exclusively targeting .NET6.0, we needed to remove Windows Universal App support and Xamarin.Forms support, as these don't have .NET6.0 compatibility.

If you are still on an old target framework, you will have to stay on an older version of MvvmCross.

There are also a couple of breaking changes to MvvmCross, removing the broken backwards navigation where you would provide return parameters for the awaiter of the Close method. This wasn't lifecycle aware and caused many headaches, hence why it was removed.

# Changelog

## [9.0.0](https://github.com/MvvmCross/MvvmCross/tree/9.0.0) (2022-09-10)

[Full Changelog](https://github.com/MvvmCross/MvvmCross/compare/8.0.2...9.0.0)

**Breaking changes:**

- Remove broken Navigate methods that pass back data when calling Close [\#4262](https://github.com/MvvmCross/MvvmCross/issues/4262)
- Add .NET 6.0 Support [\#4319](https://github.com/MvvmCross/MvvmCross/pull/4319) ([Cheesebaron](https://github.com/Cheesebaron))
- Remove broken TResult ViewModel and in navigation service [\#4312](https://github.com/MvvmCross/MvvmCross/pull/4312) ([Cheesebaron](https://github.com/Cheesebaron))

**Implemented enhancements:**

- Added support for floating point values in Android Margin bindings [\#4387](https://github.com/MvvmCross/MvvmCross/pull/4387) ([entdark](https://github.com/entdark))
- Sticky Messages [\#4207](https://github.com/MvvmCross/MvvmCross/pull/4207) ([Hackmodford](https://github.com/Hackmodford))

**Fixed bugs:**

- An application crash due to duplicates in 'ViewAssemblies' collection [\#4295](https://github.com/MvvmCross/MvvmCross/issues/4295)
- Crash on iOS when utilizing Custom modal presentation [\#4294](https://github.com/MvvmCross/MvvmCross/issues/4294)
- Throw ThreadCanceledException when using IMvxNavigationService.Navigate in IMvxNavigationService.Navigate\<..., TResult\>\(\) [\#4261](https://github.com/MvvmCross/MvvmCross/issues/4261)
- wpf AppStart - first view not shown [\#4221](https://github.com/MvvmCross/MvvmCross/issues/4221)
- Inconsistent 'TResult' type parameter constraints [\#4206](https://github.com/MvvmCross/MvvmCross/issues/4206)
- Fixed never re laying out the view when Margin bound value changes on Android [\#4388](https://github.com/MvvmCross/MvvmCross/pull/4388) ([entdark](https://github.com/entdark))
- Use string key in dictionary instead on not uniquie hash code [\#4341](https://github.com/MvvmCross/MvvmCross/pull/4341) ([ivmazurenko](https://github.com/ivmazurenko))
- Remove constraints on IMvxViewModel TParameter and TResult [\#4299](https://github.com/MvvmCross/MvvmCross/pull/4299) ([Cheesebaron](https://github.com/Cheesebaron))
- Bugfix - iOS - Crash on Custom Modal's [\#4293](https://github.com/MvvmCross/MvvmCross/pull/4293) ([justinwojo](https://github.com/justinwojo))
- Only warn about lollipop Shared element transition if using Interface [\#4292](https://github.com/MvvmCross/MvvmCross/pull/4292) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix wpf default presentation [\#4291](https://github.com/MvvmCross/MvvmCross/pull/4291) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix Android Top Activity [\#4290](https://github.com/MvvmCross/MvvmCross/pull/4290) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix appcompat searchview query targetbinding not registered [\#4231](https://github.com/MvvmCross/MvvmCross/pull/4231) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix navigate with TParameter and TResult resulting in crash [\#4230](https://github.com/MvvmCross/MvvmCross/pull/4230) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix potential null ref in MvxColorValueConverter [\#4229](https://github.com/MvvmCross/MvvmCross/pull/4229) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix resolving of IMvxTextProvider [\#4209](https://github.com/MvvmCross/MvvmCross/pull/4209) ([2urbo](https://github.com/2urbo))

**Closed issues:**

- Update to iOS 15 Preventing Table Cells from Being Reused [\#4330](https://github.com/MvvmCross/MvvmCross/issues/4330)

**Merged pull requests:**

- Bump Microsoft.NET.Test.Sdk from 17.1.0 to 17.3.1 [\#4465](https://github.com/MvvmCross/MvvmCross/pull/4465) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.Build.Download from 0.11.2 to 0.11.3 [\#4463](https://github.com/MvvmCross/MvvmCross/pull/4463) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Moq from 4.18.1 to 4.18.2 [\#4461](https://github.com/MvvmCross/MvvmCross/pull/4461) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.36.0.43782 to 8.44.0.52574 [\#4460](https://github.com/MvvmCross/MvvmCross/pull/4460) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Lifecycle.LiveData from 2.3.1.3 to 2.5.0 [\#4448](https://github.com/MvvmCross/MvvmCross/pull/4448) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update Directory.Packages.props [\#4429](https://github.com/MvvmCross/MvvmCross/pull/4429) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump AppCompat packages together [\#4428](https://github.com/MvvmCross/MvvmCross/pull/4428) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.5.2 to 1.3.0.1 [\#4427](https://github.com/MvvmCross/MvvmCross/pull/4427) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.Build.Download from 0.11.0 to 0.11.2 [\#4425](https://github.com/MvvmCross/MvvmCross/pull/4425) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump AsyncFixer from 1.5.1 to 1.6.0 [\#4424](https://github.com/MvvmCross/MvvmCross/pull/4424) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Moq from 4.16.1 to 4.18.1 [\#4423](https://github.com/MvvmCross/MvvmCross/pull/4423) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Serilog from 2.10.0 to 2.11.0 [\#4422](https://github.com/MvvmCross/MvvmCross/pull/4422) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump xunit.runner.visualstudio from 2.4.3 to 2.4.5 [\#4421](https://github.com/MvvmCross/MvvmCross/pull/4421) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.CodeAnalysis from 4.1.0 to 4.2.0 [\#4420](https://github.com/MvvmCross/MvvmCross/pull/4420) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Roslynator.Analyzers from 4.0.2 to 4.1.1 [\#4417](https://github.com/MvvmCross/MvvmCross/pull/4417) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.GooglePlayServices.Location from 118.0.0.1 to 119.0.1.1 [\#4416](https://github.com/MvvmCross/MvvmCross/pull/4416) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.ViewPager from 1.0.0.10 to 1.0.0.14 [\#4413](https://github.com/MvvmCross/MvvmCross/pull/4413) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.CardView from 1.0.0.11 to 1.0.0.16 [\#4412](https://github.com/MvvmCross/MvvmCross/pull/4412) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.Extensions.Logging.Abstractions from 5.0.0 to 6.0.1 [\#4390](https://github.com/MvvmCross/MvvmCross/pull/4390) ([dependabot[bot]](https://github.com/apps/dependabot))
- Switch base type of TargetType property of generic MvxAndroidTargetBinding [\#4386](https://github.com/MvvmCross/MvvmCross/pull/4386) ([ivmazurenko](https://github.com/ivmazurenko))
- Bump Microsoft.NET.Test.Sdk from 17.0.0 to 17.1.0 [\#4377](https://github.com/MvvmCross/MvvmCross/pull/4377) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.34.0.42011 to 8.36.0.43782 [\#4375](https://github.com/MvvmCross/MvvmCross/pull/4375) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Roslynator.Analyzers from 3.2.2 to 4.0.2 [\#4366](https://github.com/MvvmCross/MvvmCross/pull/4366) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.CodeAnalysis from 3.11.0 to 4.1.0 [\#4365](https://github.com/MvvmCross/MvvmCross/pull/4365) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump MSBuild.Sdk.Extras from 3.0.38 to 3.0.44 [\#4363](https://github.com/MvvmCross/MvvmCross/pull/4363) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.Build.Download from 0.10.0 to 0.11.0 [\#4362](https://github.com/MvvmCross/MvvmCross/pull/4362) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.30.0.37606 to 8.34.0.42011 [\#4357](https://github.com/MvvmCross/MvvmCross/pull/4357) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable the Visual Studio fast up-to-date check [\#4346](https://github.com/MvvmCross/MvvmCross/pull/4346) ([drewnoakes](https://github.com/drewnoakes))
- Fix broken Playground.Mac build [\#4333](https://github.com/MvvmCross/MvvmCross/pull/4333) ([yannleprovost](https://github.com/yannleprovost))
- Bump Microsoft.SourceLink.GitHub from 1.0.0 to 1.1.1 [\#4323](https://github.com/MvvmCross/MvvmCross/pull/4323) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.CodeAnalysis.NetAnalyzers from 5.0.3 to 6.0.0 [\#4318](https://github.com/MvvmCross/MvvmCross/pull/4318) ([dependabot[bot]](https://github.com/apps/dependabot))
- Added Win UI 3 support [\#4316](https://github.com/MvvmCross/MvvmCross/pull/4316) ([dahovey](https://github.com/dahovey))
- Bump XunitXml.TestLogger from 3.0.66 to 3.0.70 [\#4314](https://github.com/MvvmCross/MvvmCross/pull/4314) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.NET.Test.Sdk from 16.10.0 to 17.0.0 [\#4309](https://github.com/MvvmCross/MvvmCross/pull/4309) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Lifecycle.LiveData from 2.3.1 to 2.3.1.3 [\#4307](https://github.com/MvvmCross/MvvmCross/pull/4307) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.CodeAnalysis from 3.10.0 to 3.11.0 [\#4306](https://github.com/MvvmCross/MvvmCross/pull/4306) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.NETCore.UniversalWindowsPlatform from 6.2.12 to 6.2.13 [\#4305](https://github.com/MvvmCross/MvvmCross/pull/4305) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.26.0.34506 to 8.30.0.37606 [\#4304](https://github.com/MvvmCross/MvvmCross/pull/4304) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Leanback from 1.0.0.9 to 1.0.0.12 [\#4303](https://github.com/MvvmCross/MvvmCross/pull/4303) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump MSBuild.Sdk.Extras from 3.0.23 to 3.0.38 [\#4301](https://github.com/MvvmCross/MvvmCross/pull/4301) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Roslynator.Analyzers from 3.2.0 to 3.2.2 [\#4300](https://github.com/MvvmCross/MvvmCross/pull/4300) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update AndroidX packages [\#4298](https://github.com/MvvmCross/MvvmCross/pull/4298) ([Cheesebaron](https://github.com/Cheesebaron))
- Android can call RegisterSetupType twice, add guard [\#4297](https://github.com/MvvmCross/MvvmCross/pull/4297) ([Cheesebaron](https://github.com/Cheesebaron))
- Update Tabbar.axml and Toolbar.axml classes [\#4287](https://github.com/MvvmCross/MvvmCross/pull/4287) ([ChristosMylonas](https://github.com/ChristosMylonas))
- Bump SonarAnalyzer.CSharp from 8.25.0.33663 to 8.26.0.34506 [\#4224](https://github.com/MvvmCross/MvvmCross/pull/4224) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.Google.Android.Material from 1.3.0.1 to 1.4.0 [\#4222](https://github.com/MvvmCross/MvvmCross/pull/4222) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Leanback from 1.0.0.8 to 1.0.0.9 [\#4219](https://github.com/MvvmCross/MvvmCross/pull/4219) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.GooglePlayServices.Basement from 117.6.0 to 117.6.0.1 [\#4218](https://github.com/MvvmCross/MvvmCross/pull/4218) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Fragment from 1.3.4 to 1.3.5 [\#4213](https://github.com/MvvmCross/MvvmCross/pull/4213) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.24.0.32949 to 8.25.0.33663 [\#4212](https://github.com/MvvmCross/MvvmCross/pull/4212) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.3 to 1.2.4 [\#4211](https://github.com/MvvmCross/MvvmCross/pull/4211) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Roslynator.Analyzers from 3.1.0 to 3.2.0 [\#4198](https://github.com/MvvmCross/MvvmCross/pull/4198) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.CodeAnalysis from 3.9.0 to 3.10.0 [\#4197](https://github.com/MvvmCross/MvvmCross/pull/4197) ([dependabot[bot]](https://github.com/apps/dependabot))
