---
layout: post
title: MvvmCross 8.0.0
date: 2021-06-11 18:00:00 +0200
categories: mvvmcross
---

A new MvvmCross version is available on [NuGet](https://www.nuget.org/packages/MvvmCross/8.0.0)! You can always find the latest [changelog in the root of the repository](https://github.com/MvvmCross/MvvmCross/blob/develop/CHANGELOG.md) to see what has changed between versions.

This time we have some breaking changes, which is why the major version has been bumped.

This version of MvvmCross brings the following new changes:

- A lot of the API has been covered with Nullable Attributes (potentially breaking)
- Switch to Microsoft.Extensions.Logging (breaking). See the [doc here on new usage for logging][new-doc]
- Fixed many warnings when building MvvmCross

New features include:

- MvxModalPresentationAttribute for Xamarin.Forms (Community contribution by [patrick11994](https://github.com/patrick11994))
- Xamarin.Forms 5 support (Community contribution by [epsmae](https://github.com/epsmae))

We have also had a lot of documentation updates by [Hackmodford](https://github.com/Hackmodford), many thanks for all the contributions here.

## Thanks

A big, thank you, to all contributors. We always appreciate discussion and contributions. If you want to contribute to MvvmCross, please join us on the [DotNet Evolution Discord][8] in the #MvvmCross channel.

Another way to contribute is to open issues on GitHub, to help us discover and fix any pain points you may have with MvvmCross.

## Changelog

### [8.0.0](https://github.com/MvvmCross/MvvmCross/tree/8.0.0) (2021-06-11)

[Full Changelog](https://github.com/MvvmCross/MvvmCross/compare/7.1.0...8.0.0)

**Breaking changes:**

- Switch to Microsoft.Logging.Abstractions [\#4141](https://github.com/MvvmCross/MvvmCross/pull/4141) ([Cheesebaron](https://github.com/Cheesebaron))
- Add more nullable attributes [\#4078](https://github.com/MvvmCross/MvvmCross/pull/4078) ([Cheesebaron](https://github.com/Cheesebaron))
- Warnings cleanup \(+semver: breaking\) [\#3967](https://github.com/MvvmCross/MvvmCross/pull/3967) ([Cheesebaron](https://github.com/Cheesebaron))

**Implemented enhancements:**

- PresentationStyle for MvxModalPresentationAttribute for iOS devices on Xamarin Forms [\#3973](https://github.com/MvvmCross/MvvmCross/pull/3973) ([patrick11994](https://github.com/patrick11994))

**Fixed bugs:**

- PreferenceFragment target bindings missing after migration to AndroidX [\#4094](https://github.com/MvvmCross/MvvmCross/issues/4094)
- Fragment with Tag-Property of MvxFragmentPresentation-Attribute not found using FindFragmentByTag [\#3999](https://github.com/MvvmCross/MvvmCross/issues/3999)
- Respect Tag in attribute when set [\#4187](https://github.com/MvvmCross/MvvmCross/pull/4187) ([Cheesebaron](https://github.com/Cheesebaron))
- Add back preferences related bindings and helpers [\#4186](https://github.com/MvvmCross/MvvmCross/pull/4186) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix null ref in mvxmessenger using logger [\#4074](https://github.com/MvvmCross/MvvmCross/pull/4074) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix exception disposing weakevent on disposed source [\#4073](https://github.com/MvvmCross/MvvmCross/pull/4073) ([Cheesebaron](https://github.com/Cheesebaron))
- Correct ios freezing when take photo. [\#4033](https://github.com/MvvmCross/MvvmCross/pull/4033) ([PierreYvesBl](https://github.com/PierreYvesBl))
- Fix crash when trying to close plain iOS popover [\#4001](https://github.com/MvvmCross/MvvmCross/pull/4001) ([Hackmodford](https://github.com/Hackmodford))
- Fix numberOfItemsInSection not implemented warning in MvxBaseCollectionViewSource [\#3981](https://github.com/MvvmCross/MvvmCross/pull/3981) ([Cheesebaron](https://github.com/Cheesebaron))
- Fix for Forms Modal Back Navigation \#3914 [\#3976](https://github.com/MvvmCross/MvvmCross/pull/3976) ([patrick11994](https://github.com/patrick11994))
- Change ViewModel Parameters and Result constraints from class to notnull [\#3970](https://github.com/MvvmCross/MvvmCross/pull/3970) ([Cheesebaron](https://github.com/Cheesebaron))

**Closed issues:**

- ViewModel Constructor Dependency Injection with a base ViewModel when upgrading from 6.3.1 to 7.1.2 [\#4183](https://github.com/MvvmCross/MvvmCross/issues/4183)
- Warning GC27A339F: method 'collectionView:numberOfItemsInSection:' in protocol 'UICollectionViewDataSource' [\#3979](https://github.com/MvvmCross/MvvmCross/issues/3979)

**Merged pull requests:**

- Bump Xamarin.AndroidX.Leanback from 1.0.0.7 to 1.0.0.8 [\#4191](https://github.com/MvvmCross/MvvmCross/pull/4191) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.RecyclerView from 1.2.0 to 1.2.1 [\#4190](https://github.com/MvvmCross/MvvmCross/pull/4190) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump nokogiri from 1.10.10 to 1.11.7 in /docs [\#4189](https://github.com/MvvmCross/MvvmCross/pull/4189) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rexml from 3.2.4 to 3.2.5 in /docs [\#4188](https://github.com/MvvmCross/MvvmCross/pull/4188) ([dependabot[bot]](https://github.com/apps/dependabot))
- Logging cleanup [\#4185](https://github.com/MvvmCross/MvvmCross/pull/4185) ([Cheesebaron](https://github.com/Cheesebaron))
- Initialize logging as early as possible [\#4184](https://github.com/MvvmCross/MvvmCross/pull/4184) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump SonarAnalyzer.CSharp from 8.23.0.32424 to 8.24.0.32949 [\#4182](https://github.com/MvvmCross/MvvmCross/pull/4182) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Fragment from 1.3.3 to 1.3.4 [\#4181](https://github.com/MvvmCross/MvvmCross/pull/4181) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.AppCompat.AppCompatResources from 1.2.0.7 to 1.3.0 [\#4180](https://github.com/MvvmCross/MvvmCross/pull/4180) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.AppCompat from 1.2.0.7 to 1.3.0 [\#4179](https://github.com/MvvmCross/MvvmCross/pull/4179) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Microsoft.NET.Test.Sdk from 16.9.4 to 16.10.0 [\#4178](https://github.com/MvvmCross/MvvmCross/pull/4178) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.2.1 to 1.2.3 [\#4177](https://github.com/MvvmCross/MvvmCross/pull/4177) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.22.0.31243 to 8.23.0.32424 [\#4176](https://github.com/MvvmCross/MvvmCross/pull/4176) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Lifecycle.LiveData from 2.3.0.1 to 2.3.1 [\#4170](https://github.com/MvvmCross/MvvmCross/pull/4170) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Leanback from 1.0.0.6 to 1.0.0.7 [\#4168](https://github.com/MvvmCross/MvvmCross/pull/4168) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump SonarAnalyzer.CSharp from 8.20.0.28934 to 8.22.0.31243 [\#4167](https://github.com/MvvmCross/MvvmCross/pull/4167) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.GooglePlayServices.Location from 117.1.0 to 118.0.0 [\#4166](https://github.com/MvvmCross/MvvmCross/pull/4166) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump Xamarin.AndroidX.Fragment from 1.3.0.1 to 1.3.3 [\#4165](https://github.com/MvvmCross/MvvmCross/pull/4165) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.CodeAnalysis from 3.8.0 to 3.9.0 [\#4164](https://github.com/MvvmCross/MvvmCross/pull/4164) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Upgrade to GitHub-native Dependabot [\#4163](https://github.com/MvvmCross/MvvmCross/pull/4163) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump XunitXml.TestLogger from 3.0.62 to 3.0.66 [\#4159](https://github.com/MvvmCross/MvvmCross/pull/4159) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.ExifInterface from 1.3.2.1 to 1.3.2.2 [\#4158](https://github.com/MvvmCross/MvvmCross/pull/4158) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Moq from 4.16.0 to 4.16.1 [\#4157](https://github.com/MvvmCross/MvvmCross/pull/4157) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.NET.Test.Sdk from 16.8.3 to 16.9.4 [\#4155](https://github.com/MvvmCross/MvvmCross/pull/4155) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump SonarAnalyzer.CSharp from 8.18.0.27296 to 8.20.0.28934 [\#4153](https://github.com/MvvmCross/MvvmCross/pull/4153) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.RecyclerView from 1.1.0.8 to 1.2.0 [\#4152](https://github.com/MvvmCross/MvvmCross/pull/4152) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Fix misunderstanding sentence in Value Combiners documentation [\#4121](https://github.com/MvvmCross/MvvmCross/pull/4121) ([hieuwu](https://github.com/hieuwu))
- Bump packages [\#4120](https://github.com/MvvmCross/MvvmCross/pull/4120) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump Xamarin.GooglePlayServices.Basement from 117.5.0 to 117.6.0 [\#4106](https://github.com/MvvmCross/MvvmCross/pull/4106) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Add caching to pipeline [\#4098](https://github.com/MvvmCross/MvvmCross/pull/4098) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump Microsoft.NETCore.UniversalWindowsPlatform from 6.2.11 to 6.2.12 [\#4086](https://github.com/MvvmCross/MvvmCross/pull/4086) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.Fragment from 1.2.5.4 to 1.2.5.5 [\#4085](https://github.com/MvvmCross/MvvmCross/pull/4085) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump SonarAnalyzer.CSharp from 8.17.0.26580 to 8.18.0.27296 [\#4084](https://github.com/MvvmCross/MvvmCross/pull/4084) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump XunitXml.TestLogger from 2.1.45 to 3.0.62 [\#4082](https://github.com/MvvmCross/MvvmCross/pull/4082) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Test improvement [\#4081](https://github.com/MvvmCross/MvvmCross/pull/4081) ([epsmae](https://github.com/epsmae))
- Bump Roslynator.Analyzers from 3.0.0 to 3.1.0 [\#4079](https://github.com/MvvmCross/MvvmCross/pull/4079) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.0.1 to 1.2.1 [\#4076](https://github.com/MvvmCross/MvvmCross/pull/4076) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Add More Nullable Attributes [\#4075](https://github.com/MvvmCross/MvvmCross/pull/4075) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.0.1 to 1.2.1 [\#4072](https://github.com/MvvmCross/MvvmCross/pull/4072) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump XunitXml.TestLogger from 2.1.26 to 2.1.45 [\#4070](https://github.com/MvvmCross/MvvmCross/pull/4070) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump AsyncFixer from 1.4.1 to 1.5.1 [\#4069](https://github.com/MvvmCross/MvvmCross/pull/4069) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Update Getting Started Doc [\#4068](https://github.com/MvvmCross/MvvmCross/pull/4068) ([Hackmodford](https://github.com/Hackmodford))
- Update Custom Data Binding documentation [\#4067](https://github.com/MvvmCross/MvvmCross/pull/4067) ([Hackmodford](https://github.com/Hackmodford))
- Update upgrade-to-mvvmcross-60.md [\#4064](https://github.com/MvvmCross/MvvmCross/pull/4064) ([igormoiseev](https://github.com/igormoiseev))
- Bump SonarAnalyzer.CSharp from 8.16.0.25740 to 8.17.0.26580 [\#4061](https://github.com/MvvmCross/MvvmCross/pull/4061) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump AsyncFixer from 1.4.0 to 1.4.1 [\#4060](https://github.com/MvvmCross/MvvmCross/pull/4060) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump AsyncFixer from 1.3.0 to 1.4.0 [\#4059](https://github.com/MvvmCross/MvvmCross/pull/4059) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Moq from 4.15.2 to 4.16.0 [\#4058](https://github.com/MvvmCross/MvvmCross/pull/4058) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Update Package List Documentation [\#4055](https://github.com/MvvmCross/MvvmCross/pull/4055) ([Hackmodford](https://github.com/Hackmodford))
- Feature/visual studio build improvement [\#4054](https://github.com/MvvmCross/MvvmCross/pull/4054) ([epsmae](https://github.com/epsmae))
- Improve MethodBinding Documentation [\#4052](https://github.com/MvvmCross/MvvmCross/pull/4052) ([Hackmodford](https://github.com/Hackmodford))
- fix MvxValueConverter example code in docs [\#4050](https://github.com/MvvmCross/MvvmCross/pull/4050) ([Hackmodford](https://github.com/Hackmodford))
- fix for contributors not appearing in docs [\#4049](https://github.com/MvvmCross/MvvmCross/pull/4049) ([Hackmodford](https://github.com/Hackmodford))
- Update MvxPresentationHint Documentation [\#4047](https://github.com/MvvmCross/MvvmCross/pull/4047) ([Hackmodford](https://github.com/Hackmodford))
- Bump MSBuild.Sdk.Extras from 3.0.22 to 3.0.23 [\#4044](https://github.com/MvvmCross/MvvmCross/pull/4044) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.CodeAnalysis.NetAnalyzers from 5.0.1 to 5.0.3 [\#4042](https://github.com/MvvmCross/MvvmCross/pull/4042) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Add docs for MvxPopoverPresentationAttribute [\#4039](https://github.com/MvvmCross/MvvmCross/pull/4039) ([Hackmodford](https://github.com/Hackmodford))
- Bump Xamarin.GooglePlayServices.Basement from 117.4.0 to 117.5.0 [\#4038](https://github.com/MvvmCross/MvvmCross/pull/4038) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.Google.Android.Material from 1.2.1 to 1.2.1.1 [\#4037](https://github.com/MvvmCross/MvvmCross/pull/4037) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump deps [\#4036](https://github.com/MvvmCross/MvvmCross/pull/4036) ([Cheesebaron](https://github.com/Cheesebaron))
- Nuget manage packages centrally [\#4035](https://github.com/MvvmCross/MvvmCross/pull/4035) ([Cheesebaron](https://github.com/Cheesebaron))
- Bump Xamarin.AndroidX.MediaRouter from 1.2.0 to 1.2.0.1 [\#4030](https://github.com/MvvmCross/MvvmCross/pull/4030) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.Legacy.Support.V4 from 1.0.0.5 to 1.0.0.6 [\#4025](https://github.com/MvvmCross/MvvmCross/pull/4025) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.Lifecycle.LiveData from 2.2.0.3 to 2.2.0.4 [\#4024](https://github.com/MvvmCross/MvvmCross/pull/4024) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.GooglePlayServices.Basement from 117.2.1 to 117.4.0 [\#4015](https://github.com/MvvmCross/MvvmCross/pull/4015) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.Google.Android.Material from 1.1.0.5 to 1.2.1 [\#4013](https://github.com/MvvmCross/MvvmCross/pull/4013) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.ExifInterface from 1.3.1 to 1.3.2 [\#4012](https://github.com/MvvmCross/MvvmCross/pull/4012) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump MSBuild.Sdk.Extras from 2.1.2 to 3.0.22 [\#4008](https://github.com/MvvmCross/MvvmCross/pull/4008) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.CodeAnalysis.FxCopAnalyzers from 3.3.1 to 3.3.2 [\#4006](https://github.com/MvvmCross/MvvmCross/pull/4006) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.NET.Test.Sdk from 16.8.0 to 16.8.3 [\#4002](https://github.com/MvvmCross/MvvmCross/pull/4002) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Moq from 4.15.1 to 4.15.2 [\#4000](https://github.com/MvvmCross/MvvmCross/pull/4000) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump SonarAnalyzer.CSharp from 8.14.0.22654 to 8.15.0.24505 [\#3998](https://github.com/MvvmCross/MvvmCross/pull/3998) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.NETCore.UniversalWindowsPlatform from 6.2.10 to 6.2.11 [\#3996](https://github.com/MvvmCross/MvvmCross/pull/3996) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.CodeAnalysis from 3.7.0 to 3.8.0 [\#3994](https://github.com/MvvmCross/MvvmCross/pull/3994) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Moq from 4.14.7 to 4.15.1 [\#3992](https://github.com/MvvmCross/MvvmCross/pull/3992) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.Google.Android.Material from 1.0.0.1 to 1.1.0.5 [\#3991](https://github.com/MvvmCross/MvvmCross/pull/3991) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.NET.Test.Sdk from 16.7.1 to 16.8.0 [\#3990](https://github.com/MvvmCross/MvvmCross/pull/3990) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Fix memory leak in MvxMacViewPresenter [\#3989](https://github.com/MvvmCross/MvvmCross/pull/3989) ([ivmirx](https://github.com/ivmirx))
- Bump Xamarin.AndroidX.AppCompat from 1.2.0.4 to 1.2.0.5 [\#3987](https://github.com/MvvmCross/MvvmCross/pull/3987) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.SwipeRefreshLayout from 1.0.0.5 to 1.1.0 [\#3986](https://github.com/MvvmCross/MvvmCross/pull/3986) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.ExifInterface from 1.1.0.5 to 1.3.1 [\#3985](https://github.com/MvvmCross/MvvmCross/pull/3985) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Xamarin.AndroidX.MediaRouter from 1.1.0.5 to 1.2.0 [\#3984](https://github.com/MvvmCross/MvvmCross/pull/3984) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump Microsoft.CodeAnalysis.FxCopAnalyzers from 3.3.0 to 3.3.1 [\#3977](https://github.com/MvvmCross/MvvmCross/pull/3977) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Xamarin Forms 5.0 Support [\#3972](https://github.com/MvvmCross/MvvmCross/pull/3972) ([epsmae](https://github.com/epsmae))
- Bump Xamarin.GooglePlayServices.Basement from 117.1.1 to 117.2.1 [\#3971](https://github.com/MvvmCross/MvvmCross/pull/3971) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))

[new-doc]: {{ site.baseurl }}{% link _documentation/fundamentals/logging-new.md %}