---
layout: post
title: Joining the .NET Foundation
date:   2017-11-15 22:00:00 +0200
categories: 
 - mvvmcross
 - community
---

As part of the [.NET Summer Hackfest][hackfest] we announced that we were working on joining the [.NET Foundation][netfoundation]. We have just received confirmation that we were accepted! So we are very happy to announce that we are joining the .NET Foundation, which governs a lot of great open source projects which impact you daily.

## What is MvvmCross?
For newcomers, MvvmCross is a opinionated MVVM Framework, which you can use to write native Apps without compromising on performance or look and feel. We support a very large number of platforms, among them Xamarin.Android, Xamarin.iOS, Xamarin.Forms, Windows UWP and WPF and more.

We are currently looking into migrating all our projects to the new SDK project styles and moving away from using Portable Class Libraries and instead use .NET Standard 2.0. One of the recent bigger additions to MvvmCross was to get proper Xamarin.Forms support, with the ability to navigate between Forms pages and native ViewControllers and Activities.

## What does this mean for MvvmCross?
The .NET Foundation was founded as an independent organization to foster open source development and collaboration. The MvvmCross teams is all for that and we want to participate in not only making MvvmCross better, but strengthening the .NET ecosystem.

Joining the .NET Foundation gives us a lot of benefits ranging from legal help, project guidance and monitoring, marketing, monetary support and a bunch of great technical support services that we would otherwise have to spend a lot of money on.

MvvmCross will mostly continue the same way as it has always been. We will continue developing MvvmCross on GitHub, we will continue pushing new releases to NuGet.

## What is in it for me?
For you as a contributor there will be some minor changes. In the near future we will set up a GitHub bot to ask you to sign a Contributor License Agreement and check whenever you submit a Pull Request that it is signed.

For you as a user of MvvmCross, joining the .NET Foundation means that MvvmCross will remain a open source project. It will ensure that MvvmCross is guided and mentored into a welcoming community where we can share knowledge and best practices.

There will in the coming time be some improvements on some technical aspects of the project, as we will get access to code signing certificates. Then we can start signing our NuGet packages, so you can verify the origins of each package.

We are very excited to join the .NET Foundation and are very honored to be standing besides so many great open source projects.

## Supporting MvvmCross
Please consider supporting MvvmCross by commiting to one of the [support tiers on OpenCollective][oc]. We have recently updated the OpenCollective page with better goals and new tiers.

As always you can follow us on [Twitter @MvvmCross][twitter], you can talk to us on [Slack in the #MvvmCross channel][slack], ask questions on [StackOverflow using the MvvmCross tag][so] and file issues on [GitHub in the issues section][github].

[hackfest]: https://dotnetfoundation.org/blog/2017/08/23/net-summer-hackfest-update-session-3-underway
[netfoundation]: https://dotnetfoundation.org
[twitter]: https://twitter.com/MvvmCross
[slack]: http://xamarinchat.herokuapp.com/
[so]: https://stackoverflow.com/questions/tagged/mvvmcross
[oc]: https://opencollective.com/mvvmcross
[github]: https://github.com/MvvmCross/MvvmCross/issues
