---
layout: post
title: MvvmCross 4.2.3
date:   2016-08-22 11:37:35 +0100
categories: mvvmcross
---

We've just released MvvmCross 4.2.3 after a short holliday break.

Here is the list of changes between 4.2.2 and 4.2.3, the list is a bit short this time around; many of them are simple quality of life changes to the code in the repositories, such as fixing line endings on files.

To make sure you have your git client correctly set up please do the following to avoid crazy diffs.

**On Windows**

```
git config --global core.autocrlf true
```

**On Mac** 
```
git config --global core.autocrlf input
```
If you are pulling changes on an already cloned repo, it might be necessary to do the following for your git client to recognize the changes to the files.
```
git rm --cached -r .
git reset --hard
```

The list of changes is as follows

**MvvmCross main repo** 

- Normalized line endings
- Added `IMvxViewModelInitializer` interface; describes async initialization of `MvxViewModel`
- ResourceHelpers now looks up correct stylables for `MvxExpandableListView`

**MvvmCross-AndroidSupport** 

- Updated to latest Xamarin.Android Support packages
- Removed unused json plugin dependency from AppCompat library
- Added missing dependency on MvvmCross.Binding in AppCompat library
- `MvxRecyclerViewHolder` methods made virtual, for easier inheritance
- Normalized line endings

**MvvmCross-Plugins**

- Better error handling for Location plugins. New `MvxLocationErrorCode`s added.
- Added missing methods in `IMvxRestClient` and `IMvxJsonRestClient` in Network plugin
- Normalized line endings
- Updated README for ResxLocalization plugin
- Added `NC<string>` to handle NotifyPropertyChanged for string types 
- Changed SQLite connection factory to Generic for WPF to support OS X

**MvvmCross-iOSSupport** 

No changes