---
layout: post
title: MvvmCross 4.2
date:   2016-06-15 11:37:35 +0100
categories: mvvmcross
---
It’s that time again - a brand new MvvmCross release!

With over more than 40 contributions this turns out to be a very nice release.

Changes across the board; both functionality, several bug fixes and performance improvements has made it in.

One of the more prominent changes is `MvxTaskBasedBindingContext` datacontext bindings now occur on a worker thread, this should resulting in a smoother scrolling experience, especially when having several bindings on a row.
 
If you want the old behavior you can do so by overriding the Setup.cs as follows.

```
protected override void InitializeLastChance()
{
    base.InitializeLastChance();
    Mvx.RegisterType<IMvxBindingContext, MvxBindingContext>();
}
```

To take full advantage of the `MvxTaskBasedBindingContext`, 
you should also call `ShouldAlwaysRaiseInpcOnUserInterfaceThread(false);` in the `ViewModel` constructor.

# Changes
Here is the list with changes for grouped by repository

## MvvmCross

- Null­propagation for event handlers
- Move away from MvxAndroidTargetBinding and use MvxConvertingTargetBinding as `Context` is not needed everywhere
- Dispose of the base after cleaning up the derived instance
- Add binding for TextView.Hint
- Use drawable instead of resource, which is not UI thread bound
- Don't resubscribe in Dispose
- Fix failing ViewModel unit tests
- Unsubscribe events in bindings
- Remove LINQ from ReflectionExtensions (micro optimization)
- MultiRegionViewPresenter ­ Support frame search failure
- Add UI refresh control bindings
- Allows binding to EditTextPreference.Text and TwoStatePreference.Checked
- Cache Java.Lang.Boolean.True since in Xamarin it results in a JNI call
- Raise AttachCalled with the passed in activity, not this.Activity
- Animate UICollectionView changes
- Generic MvxAdapter implementation
- Ignore transparent proxies on Mono
- Added Code of Conduct
- UWP ­ Fixed 'ViewModel.Close(this)'
- Use Reflection instead of Expression.Compile() to speed up bindings

## Plugins

- Don't reset the UIImagePickerController Delegate after successfully picking an image

## AndroidSupport

- Move displaying fragment out of request from OnCreate to OnNewIntent
- Make bindings MvxConvertingTargetBinding
- Register classes with java namespaces
- Remove unneeded MvxAppCompatListView, which fixes casting exceptions
- Cleanup recyclerview
- Unsubscribe from all events in bindings
- Bind to `Android.Support.V7.Preferences.Preference`
- Raise AttachCalled with the passed in `Activity`, not `this.Activity`
- Add binding for Toolbar's `Subtitle`
- Look for `MvxTemplateSelector` instead of `MvxItemTemplateSelector`
- Simplify event invocation
- Call `MvxAppCompatSetupHelper.FillDefaultBindingNames`

## iOSSupport

- Handle default behaviour for SidePanel presenter

## Breaking changes
One breaking change is `MvxAndroidTask` which had duplicate implementations before and lived in both `MvvmCross.Droid.Platform` and `MvvmCross.Platform.Droid.Platform`. There is now only one implementation of it living in `MvvmCross.Platform.Droid.Platform`.

As mentioned in the beginning we have introduced `MvxTaskBasedBindings`, this is a potentially breaking change. Especially when using `ShouldAlwaysRaiseInpcOnUserInterfaceThread(false);` in your ViewModel, where you might get exceptions saying that UI must be updated on the UI thread. In such cases please open a [GitHub Issue](github.com/mvvmcross/mvvmcross/issues/new).


It's very nice to see that again the number of contributions outside the team of "usual suspects" is growing.
A huge thanks to everyone that participated and made this release happening. Now go out and make some cool apps!