---
layout: post
title: 3.0.13 - pushed to nuget
date:   2013-10-13 11:37:35 +0100
categories: mvvmcross
---

I've now pushed 3.0.13 to nuget :)


Thanks to everyone who's contributed code, ideas and assistance - I'm well behind on badges now - so many of you are awesome! I will catch up on badges soon!



Note that there are some potentially breaking changes in 3.0.13 - marked in bold in the change list below.

The most obvious of these will be in:
- the changes across MvvmCross to consistently use the US spelling "Initialize" rather than UK spelling "Initialise". 
- the optimisations to custom bindings (see http://slodge.blogspot.co.uk/2013/10/changes-to-custom-bindings-in-v3013.html)
- Other more subtle breaking changes may come out of some of the binding optimizations - if any bugs appear, please do report them (with reproduction examples if possible). 


-----


The main changes from 3.0.12 are:


- added UnsetValue and DoNothing binding constants to allow richer ValueConverter implementation (note that these constants are not fully supported across all Windows platforms)
- changed binding implementation so that many more binders will now block feedback loops
- changed binding implementation so that many more binders will now attempt value coercion when setting values on a target
- optimised text binding in Droid and Touch - 'label' controls will be set directly using non-reflection and using one-way binding as default
- optimisations for one-way binding - event subscription is not removed
- added an IMvxInteraction helper interface to assist with 'dialog' user interactions
- cleared up 'mixed spellings' of Initialisation/Initialization - the US spelling 'Initialization' is now used everywhere (this may break some overrides in people's Setup code)
- event `Raise` extension methods now moved into shared code - into CrossCore
- fragment inflation no longer causes an error message in trace
- fixed two missing event hook calls in Android dialog code
- Binding DataContext's now have a DataContextChanged event
- By default, views can now be named with postfix 'View' or 'ViewController' on iOS, 'View' or 'Activity' on Android, 'View' or 'Page' on WindowsPhone/Store, 'View' or 'Control' on WPF
- Small optimisation in internationalisation converter
- Improved access to MasterNavigationController in Touch presenters - as requested via @deapsquatter's blog
- Improved override capabilities for AndroidLifetime monitoring object
- Improved error message for users using viewmodels from mutliple assemblies
- Weak referencing is now used in Rio field binding
- Added a new location interface into the location plugin - the old one still works but is now marked obsolete
- Added a simple Reachability implementation for Android in the Network plugin
- Fixed a "To" regression in the Android email plugin
- Added simple UIView/View/Control boolean "Hidden" bindings for all platforms
- FluentBindings can now use `FullyDescribed` and `SourceDescribed` methods to describe contents - e.g. Bind(textField).FullyDescribed("Text MyConverter(Property1)") and Bind(textField).For(t => t.Text).SourceDescribed("MyConverter(Property1)") - the previous Described method (which is SourceDescribed) is now marked as Obsolete
- Integrated lots of Android Dialog changes from @csteeg - many improvements in usability and stability (if you have overridden GetViewImpl the signature has now changed)
- Included improved Bitmap resource drawable binding from @Cheesebaron and @scatria
- Fixed misaligned ViewDidAppear/Disappear calls in event source UIViewController
- Added MvxRadioGroup from @BenGladman for Android (it's fab!)
- Added SimplePickerElement from @BenPage for Android Dialog
- Fixed ambiguous construction issue with MvxColor - and unit tests for the default RGB color value converters
- Added named MvxColors class based on Mono standard name set
- Merged Mac binding and Mvvm code from @loqu8 and @deapsquatter - Mac has separate solution currently (more on this soon hopefully)
- Improved TeamCity buildability via @loqu8 
- INotifyCollectionChanged event is LinkerPleaseInclude included within MvvmCross core library
- Android Download image loader can use "res:" prefix for images
- Android MvxImageView exposes DefaultImagePath and ErrorImagePath properties (matches iOS API now)
- Android MvxImageView no longer has a IntPtr constructor
- ToString error messages improved for binding debugging
- Android MvxSpinner now uses radio elements by default 
- Android MvxBaseListItem now supports ICheckable
- Github projects have moved into /MvvmCross organisation
