// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MS-PL license.
// See the LICENSE file in the project root for more information.

#nullable enable
using MvvmCross.Binding.Extensions;
using UIKit;

namespace MvvmCross.Platforms.Ios.Binding.Target;

public class MvxUIViewHiddenTargetBinding(UIView target)
    : MvxBaseUIViewVisibleTargetBinding(target)
{
    protected override void SetValueImpl(object target, object? value)
    {
        var view = View;
        if (view == null) return;

        var hidden = value.ConvertToBoolean();
        view.Hidden = hidden;
    }
}
