# -*- coding: utf-8 -*-

# Copyright (c) 2023 Morwenn
# SPDX-License-Identifier: MIT

import argparse
import pathlib
import sys

from matplotlib import pyplot


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Plot a distribution with a varying parameter.")
    parser.add_argument('path', help="path to the file to plot")
    args = parser.parse_args()

    path = pathlib.Path(args.path)
    if not path.exists():
        print(f"File {path} does not exist")
        sys.exit(1)

    with path.open() as fd:
        # Read metadata from the first line
        mop_name, _, max_disorder, _ = fd.readline().strip().split(',')

        # Read the rest of the file
        percentages = []
        disorders = []
        for line in fd:
            pct, disorder = line.strip().split(',')
            percentages.append(int(pct))
            disorders.append(int(disorder))

    fix, axes = pyplot.subplots()
    axes2 = axes.twinx()

    # Plot the results
    axes.plot(percentages, disorders, linestyle='dashed')
    axes.ticklabel_format(style='plain')
    # Add a tick for the maximum disorder possible
    axes2.axhline(int(max_disorder), linestyle=':', color='gray')
    axes2.set_yticks([int(max_disorder)], [f"$max({mop_name.capitalize()}(X))$"])

    pyplot.title(f"${mop_name.capitalize()}(X)$ generated by dist::{mop_name}")
    axes.set_ylabel(mop_name.capitalize())

    pyplot.tight_layout()
    pyplot.xlim(left=0, right=100)
    axes.set_ylim(bottom=0)
    axes2.set_ylim(bottom=0)
    pyplot.show()
