/*
    Copyright (c) 2024 Yann M. Vidamment (MorganKryze)
    Licensed under GNU GPL v2.0. See full license at: https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/LICENSE.md
*/
namespace ConsoleAppVisuals.Enums;

/// <summary>
/// The <see cref="TextAlignment"/> enum defines the alignment of a string in the space.
/// </summary>
/// <remarks>
/// For more information, consider visiting the documentation available <a href="https://morgankryze.github.io/ConsoleAppVisuals/">here</a>.
/// </remarks>
public enum TextAlignment
{
    /// <summary>
    /// The string is placed in the center of the space.
    /// </summary>
    Center,

    /// <summary>
    /// The string is placed on the left of the space.
    /// </summary>
    Left,

    /// <summary>
    /// The string is placed on the right of the space.
    /// </summary>
    Right
}
