/*
    Copyright (c) 2024 Yann M. Vidamment (MorganKryze)
    Licensed under GNU GPL v2.0. See full license at: https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/LICENSE.md
*/
namespace ConsoleAppVisuals.Enums;

/// <summary>
/// The <see cref="DialogOption"/> enum defines the outputs of a dialog.
/// </summary>
/// <remarks>
/// For more information, consider visiting the documentation available <a href="https://morgankryze.github.io/ConsoleAppVisuals/">here</a>.
/// </remarks>
public enum DialogOption
{
    /// <summary>
    /// No options are set or escape pressed.
    /// </summary>
    None,

    /// <summary>
    /// Left option selected.
    /// </summary>
    Left,

    /// <summary>
    /// Right option selected.
    /// </summary>
    Right,
}
