# Example projects

## Introduction

This directory contains example projects that demonstrate how to use the `ConsoleAppVisuals` library. Each example is a self-contained project that can be run _independently_. Here is a list of the examples and their descriptions:

- **Presentation**: A complete example that demonstrates how to use the `ConsoleAppVisuals` library. It tackles all the major features of the library. It is a good starting point for learning how to use the library. (Used to generate the presentation video in the docs)
- **PasswordManager**: A simple example using the `Prompt`, `ScrollingMenu`, `TableView` and `TableSelector` classes to create a decent password manager (non-secure project).
- **CustomElement**: A minimalist example showing how to create and use user-defined elements.
- **CustomFont**: A minimalist example showing how to create and use a custom fonts.

## How to run an example

To run an example, you need to have the `ConsoleAppVisuals` library installed. You can install it by **downloading the zip file** or by **using the following command**:

```bash
git clone https://github.com/MorganKryze/ConsoleAppVisuals.git
```

Then, navigate to the example directory you want to run (replace `[example_name]` with the name of the example from the list above):

```bash
cd ConsoleAppVisuals/examples/[example_name]
```

Finally, run the example:

```bash
dotnet run
```

---

Have a question, give a feedback or found a bug? Feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [start a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on the GitHub repository.
