---
title: Welcome to the docs
author: Yann M. Vidamment (MorganKryze)
description: Welcome to the documentation of the ConsoleAppVisuals library. This is a simple and easy-to-use library that allows you to create visual elements in the console. Here are all the resources available.
keywords: c#, documentation, welcome, introduction, index
ms.author: Yann M. Vidamment (MorganKryze)
ms.date: 03/28/2024
ms.topic: quickstart
ms.service: ConsoleAppVisuals
---

# Welcome to the docs

[![version](https://img.shields.io/nuget/v/ConsoleAppVisuals.svg?label=version)](https://www.nuget.org/packages/ConsoleAppVisuals/) [![downloads](https://img.shields.io/nuget/dt/ConsoleAppVisuals.svg)](https://www.nuget.org/packages/ConsoleAppVisuals/) [![stars](https://img.shields.io/github/stars/MorganKryze/consoleappvisuals.svg?style=flat&logo=github&colorB=yellow&label=stars)](https://github.com/MorganKryze/ConsoleAppVisuals) [![coverage](https://coveralls.io/repos/github/MorganKryze/ConsoleAppVisuals/badge.svg?)](https://coveralls.io/github/MorganKryze/ConsoleAppVisuals?branch=main) [![license](https://img.shields.io/badge/License-GPL_v2.0-orange.svg)](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/LICENSE.md)

![presentation](assets/vid/gif/presentation.gif)

## Table of contents

Welcome to the documentation of the `ConsoleAppVisuals` library. This is a simple and easy-to-use library that allows you to create visual elements in the console. Here are all the resources available:

- [Introduction](/ConsoleAppVisuals/1-introduction/basic_concepts.html): find the basic concepts and the first steps into the library to learn how to use it.
- [Elements](/ConsoleAppVisuals/2-elements/index.html): find all the visual elements available in the library with their description.
- [References](/ConsoleAppVisuals/3-references/index.html): find all methods, properties and classes with their description and all arguments available.
- [Examples](/ConsoleAppVisuals/4-examples/index.html): find some examples to learn how to use the library in concrete use cases.
- [Articles](/ConsoleAppVisuals/5-articles/index.html): find some additional library-related articles.
- [Legacy](/ConsoleAppVisuals/6-legacy/index.html): find the outdated documentation of the library for the versions 2.x.x and below.

## Roadmap

The library is still in active development. The next feature and bug resolutions are listed in the [Project](https://github.com/users/MorganKryze/projects/3/views/2) section of the GitHub repository.

## Supported .NET versions

| Version                                         | Supported          |
| ----------------------------------------------- | ------------------ |
| [net8.x](https://dotnet.microsoft.com/download) | :white_check_mark: |
| net7.x                                          | :white_check_mark: |
| net6.x                                          | :white_check_mark: |
| < net6.x                                        | :x:                |

## Security Policy

Consider reading our [SECURITY](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/SECURITY.md) policy to know more about how we handle security issues and how to report them. You will also find the stable versions of the project.

## Acknowledgments

Consider reading the [ACKNOWLEDGMENTS](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/ACKNOWLEDGMENTS.md) file. It's a testament to the collaborative effort that has gone into improving and refining our library. We're deeply grateful to all our contributors for their invaluable input and the significant difference they've made to the project.

It also lists the open source projects that have been used to build this library until now.

## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**. To do so, follow the steps described in the [CONTRIBUTING](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/CONTRIBUTING.md) file.

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

Do not hesitate to **star** and **share** the project if you like it!
