---
title: Passive
author: Yann M. Vidamment (MorganKryze)
description: This section describes all passive elements available in the library. They will be accompanied by a brief description and a link to their respective documentation page.
keywords: c#, documentation, passive, elements
ms.author: Yann M. Vidamment (MorganKryze)
ms.date: 03/28/2024
ms.topic: tutorial
ms.service: ConsoleAppVisuals
---

# Passive

## Classic elements

| Visual                                                        | Description                                                                                                            | Documentation                                                                                                                |
| ------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- |
| ![Text](../assets/img/jpg/elements/text.jpg)                  | The `Text` is a simple text element that can be used to display information to the user.                               | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Text.html)         |
| ![EmbedText](../assets/img/jpg/elements/embed_text.jpg)       | The `EmbedText` is a text element that has been embed. Nothing more.                                                   | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.EmbedText.html)    |
| ![Title](../assets/img/jpg/elements/title.jpg)                | The `Title` is a text element that can be used to display a title at the top of the console. (You may change the font) | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Title.html)        |
| ![Banner](../assets/img/jpg/elements/banner.jpg)              | The `Banner` is a text element that can be used to display a banner.                                                   | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Banner.html)       |
| ![Header](../assets/img/jpg/elements/banner.jpg)              | The `Header` is a banner placed at the top of the console.                                                             | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Header.html)       |
| ![Footer](../assets/img/jpg/elements/banner.jpg)              | The `Footer` is a banner placed at the bottom of the console                                                           | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Footer.html)       |
| ![HeightSpacer](../assets/img/jpg/elements/height_spacer.jpg) | The `HeightSpacer` is a passive element that can be used to add a vertical space.                                      | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.HeightSpacer.html) |
| ![TableView](../assets/img/jpg/elements/table_view.jpg)       | The `TableView` is a passive element that can be used to display a table. (You may change the style fo the borders)    | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.TableView.html)    |
| ![Matrix](../assets/img/jpg/elements/matrix.jpg)              | The `Matrix` is a passive element that can be used to display a matrix. (You may also change its style)                | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.Matrix.html)       |

## "Inspectors" elements

These are debugging elements and should not be used in a production environment. They are not very customizable and are intended to be used for debugging purposes only.

| Visual                                                         | Description                                                                                                                                                                                                                         | Documentation                                                                                                                     |
| -------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| ![ElementsDashboard](../assets/img/jpg/elements/dashboard.jpg) | The `ElementsDashboard` is a passive element that can be used to display the list of elements currently stored in the `Window`.                                                                                                     | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.ElementsDashboard.html) |
| ![ElementsList](../assets/img/jpg/elements/elements_list.jpg)  | The `ElementsList` is a passive element that can be used to display the list of elements currently available (from the library or the local project). You may select the type expected (Default, Passive, Interactive or Animated). | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.PassiveElements.ElementsList.html)      |

Have a question, give a feedback or found a bug? Feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [start a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on the GitHub repository.
