---
title: Interactive
author: Yann M. Vidamment (MorganKryze)
description: This section describes all interactive elements available in the library. They will be accompanied by a brief description and a link to their respective documentation page.
keywords: c#, documentation, interactive, elements
ms.author: Yann M. Vidamment (MorganKryze)
ms.date: 03/28/2024
ms.topic: tutorial
ms.service: ConsoleAppVisuals
---

# Interactive

| Visual                                                           | Description                                                                                                                          | Documentation                                                                                                                     |
| ---------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
| ![Dialog](../assets/img/jpg/elements/dialog.jpg)                 | The `Dialog` is interaction box providing 0, 1 or 2 options to the user.                                                             | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.Dialog.html)        |
| ![FloatSelector](../assets/img/jpg/elements/number_selector.jpg) | The `FloatSelector` display a roulette letting you choose a number given a range and a step.                                         | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.FloatSelector.html) |
| ![IntSelector](../assets/img/jpg/elements/number_selector.jpg)   | Very similar to the `FloatSelector`, the `IntSelector` is used to select an integer.                                                 | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.IntSelector.html)   |
| ![Prompt](../assets/img/jpg/elements/prompt.jpg)                 | The `Prompt` is a simple input box that allows the user to enter a string (Different input types available for secrecy for example). | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.Prompt.html)        |
| ![ScrollingMenu](../assets/img/jpg/elements/scrolling_menu.jpg)  | The `ScrollingMenu` is a menu that allows the user to scroll through a list of choices.                                              | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.ScrollingMenu.html) |
| ![TableSelector](../assets/img/jpg/elements/table_selector.jpg)  | The `TableSelector` is a table that allows the user to select a row.                                                                 | [Read more](https://morgankryze.github.io/ConsoleAppVisuals/3-references/ConsoleAppVisuals.InteractiveElements.TableSelector.html) |

---

Have a question, give a feedback or found a bug? Feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [start a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on the GitHub repository.
