# ConsoleAppVisuals

> User-friendly .NET visuals library designed for console apps.

[![version](https://img.shields.io/nuget/v/ConsoleAppVisuals.svg?label=version)](https://www.nuget.org/packages/ConsoleAppVisuals/) [![downloads](https://img.shields.io/nuget/dt/ConsoleAppVisuals.svg)](https://www.nuget.org/packages/ConsoleAppVisuals/) [![stars](https://img.shields.io/github/stars/MorganKryze/consoleappvisuals.svg?style=flat&logo=github&colorB=yellow&label=stars)](https://github.com/MorganKryze/ConsoleAppVisuals) [![coverage](https://coveralls.io/repos/github/MorganKryze/ConsoleAppVisuals/badge.svg?)](https://coveralls.io/github/MorganKryze/ConsoleAppVisuals?branch=main) [![license](https://img.shields.io/badge/License-GPL_v2.0-orange.svg)](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/LICENSE.md)

[![title](https://raw.githubusercontent.com/MorganKryze/ConsoleAppVisuals/main/docs/assets/vid/gif/presentation.gif)](https://morgankryze.github.io/ConsoleAppVisuals/)

## Documentation

We **highly recommend** you to read the [documentation](https://morgankryze.github.io/ConsoleAppVisuals/) to get started with the library. It contains a detailed guide on how to use the library, its features, and additional articles for the curious ones.

## Supported .NET versions

| Version                                         | Supported          |
| ----------------------------------------------- | ------------------ |
| [net8.x](https://dotnet.microsoft.com/download) | :white_check_mark: |
| net7.x                                          | :white_check_mark: |
| net6.x                                          | :white_check_mark: |
| < net6.x                                        | :x:                |

## Roadmap

The library is still in active development. The next feature and bug resolutions are listed in the [Project](https://github.com/users/MorganKryze/projects/3/views/2) section of the GitHub repository.

## Security Policy

Consider reading our [SECURITY](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/SECURITY.md) policy to know more about how we handle security issues and how to report them. You will also find the stable versions of the project.

## Acknowledgments

Consider reading the [ACKNOWLEDGMENTS](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/ACKNOWLEDGMENTS.md) file. It's a testament to the collaborative effort that has gone into improving and refining our library. We're deeply grateful to all our contributors for their invaluable input and the significant difference they've made to the project.

It also lists the open source projects that have been used to build this library until now.

## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**. To do so, follow the steps described in the [CONTRIBUTING](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/.github/CONTRIBUTING.md) file.

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

Do not hesitate to **star** and **share** the project if you like it!

## License

Distributed under the GNU GPL v2.0 License. See [LICENSE](https://github.com/MorganKryze/ConsoleAppVisuals/blob/main/LICENSE.md) for more information.

## Star History

<a href="https://star-history.com/#MorganKryze/ConsoleAppVisuals&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=MorganKryze/ConsoleAppVisuals&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=MorganKryze/ConsoleAppVisuals&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=MorganKryze/ConsoleAppVisuals&type=Date" />
 </picture>
</a>
