# Security Policy

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 3.5.x   | :white_check_mark: |
| 3.4.x   | :white_check_mark: |
| 3.3.x   | :white_check_mark: |
| 3.2.x   | :white_check_mark: |
| 3.1.x   | :warning:          |
| 3.0.x   | :warning:          |
| 2.x.x   | :white_check_mark: |
| < 2.1.0 | :x:                |

3.0.x and 3.1.x were the pre-versions of the v3 update. They were not fully tested yet and may contain some bugs (some fixed since 3.2.0). We recommend to use the latest version of the library.

1.0.x and 2.0.x are not supported anymore. Please update to the latest version to benefit from the latest security updates.

## Reporting a Vulnerability

To report a minor vulnerability, please open an issue on this repository. To report a major vulnerability, please send an email to this address: <morgan@kodelab.fr>.

We will be reactive to fix the issue and we will keep you informed of the progress.

## Handling of security issues

We are committed to providing a secure library. We will do our best to fix any security issue as soon as possible. We will also provide a stable version of the library to ensure that you can use a secure version of the library. So stay tuned and check the [releases](https://github.com/MorganKryze/ConsoleAppVisuals/releases?page=1) as the [discussions](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) of the project.
