# New elements, new examples, docs rewrite

## TL; DR 🎯

Introduction of `Text` and `Dialog` elements, add `AnimatedElement` namespace, new docs sections: Elements and Examples, rewrite of all docs and metadata to stay up to date with new features and improvements, minor bug fixes.

## NEW ✨

- `Text` passive element: display multiple lines on the console (can choose alignment and placement)
- `Dialog` interactive element: similar to the former `EmbedText` that can display 0, 1, or 2 options
- `DialogOption` enum: None (if escape or 0 option), Left and Right (as 2 options maximum)
- The example project is now part of an "examples" folder. The former "example" project is now the "Presentation" one. The font and custom element feature are described in the "CustomElement" and "CustomFont" projects
- "PasswordManager" is a demonstration project to explore basic `Prompt`, `ScrollingMenu` and `Dialog` features
- `AnimatedElement` namespace that will host non passive nor interactive elements like the `FakeLoadingBar` (more to come...)
- Refactor all source code files to remove most of magic values and replace them with constants
- Structure all source code files using precise regions
- New `UpdateProcessDuration` function for `FakeLoadingBar`
- Remove `Status.None` value for `Status` enum (not used)
- Rename testing namespace to "tests"
- Tested all `Dialog` and `Text` features
- Inverted arguments in `InsertLine` function for consistency
- Elements docs section to present all available elements with their description and links to docs.
- Examples docs section to display use cases and good practices.

## IMPROVED 📈

- `EmbedText`: has lost its button and Freeze to become passive element (faithful `Text` with embed borders) > Reduce ambiguity
- Publish docs for CI only from main branch to prevent displaying work in progress in production documentation
- Refactor `TextStyler` properties
- Add a `Font` property to `Title` element
- Rename "testing" folder to "tests"
- Encourage use of "!." instead of "?." for safety
- Rename several functions for convenience and consistency
- Adopted /// comments conventions for clear instructions
- Update typical `remarks` comment section to a more concise one
- Update License information (slightly)
- Update License mention in source code
- Update Docfx metadata for articles (title, author, ms.date...)
- Update report generator to 5.2.4
- Add missing `VisualAttribute` on functions
- Add local ChangeLog to keep track of releases notes.
- Simplified ReadMe files and access data through links instead of direct content.
- Remove dead links due to file system changes.
- Add two new supporters to the project (A13S).
- Fully implement PasswordManager project.
- Implemented `AnimatedElement` into `ElementsList`.
- Rewrite all tutorials from Introduction section to make them more readable and understandable. Also add diagrams and update photos and video.
- Update Contributing guidelines to cover submission of new elements and example projects.
- Update `InteractiveElement` metadata to include return type value.
- Add `Examples` section to Debugging article.
- Make Create Element article more readable.

## FIXED 🐛

- Rendering bug with first occurrence with TableSelector
- License mention leading to dead link
- Some builds paths not using Borders in `TableSelector`
- Tools json file formatting
- `LoadingBar` added to the `AnimatedElement` namespace.
- Replace use of `EmbedText` with `Dialog`.
- Remove margin feature in `Footer` element causing rendering issues.
- `EmbedText` was still in `InteractiveElements` namespace.

## DOCS 📜

- [x] ✅ Docs added

## TESTS 🔍

- [x] ✅ Features totally covered

## FEEDBACK 📃

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

---

**Full Changelog**: <https://github.com/MorganKryze/ConsoleAppVisuals/compare/v3.4.0...v3.5.0>
