# Docs rewrite

## TL; DR 🎯

Added new sections, rewrite the rest to stay up to date with new features and improvements, minor bug fixes.

## NEW ✨

- Elements docs section to present all available elements with their description and links to docs.
- Examples docs section to display use cases and good practices.

## IMPROVED 📈

- Add local ChangeLog to keep track of releases notes.
- Simplified ReadMe files and access data through links instead of direct content.
- Remove dead links due to file system changes.
- Add two new supporters to the project (A13S).
- Fully implement PasswordManager project.
- Implemented `AnimatedElement` into `ElementsList`.
- Rewrite all tutorials from Introduction section to make them more readable and understandable. Also add diagrams and update photos and video.
- Update Contributing guidelines to cover submission of new elements and example projects.
- Update `InteractiveElement`metadata to include return type value.
- Add `Examples` section to Debugging article.
- Make Create Element article more readable.

## FIXED 🐛

- `LoadingBar` added to the `AnimatedElement` namespace.
- Replace use of `EmbedText` with `Dialog`.
- Remove margin feature in `Footer` element causing rendering issues.
- `EmbedText` was still in `InteractiveElements` namespace.

## DOCS 📜

- [x] ✅ Docs added

## TESTS 🔍

- [x] ✅ Features totally covered

## FEEDBACK 📃

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

---

**Full Changelog**: <https://github.com/MorganKryze/ConsoleAppVisuals/compare/v3.5.0-beta.1...v3.5.0-rc>
