# Metadata update and `AnimatedElement`

## TL; DR 🎯

Complete metadata rework, introduction of the `AnimatedElement`.

## NEW ✨

- `AnimatedElement` namespace that will host non passive nor interactive elements like the `FakeLoadingBar` (more to come...)
- Refactor all source code files to remove most of magic values and replace them with constants
- Structure all source code files using precise regions
- New `UpdateProcessDuration` function for `FakeLoadingBar`
- Remove `Status.None` value for `Status` enum (not used)

## IMPROVED 📈

- Rename several functions for convenience and consistency
- Adopted /// comments conventions for clear instructions
- Update typical `remarks` comment section to a more concise one
- Update License information (slightly)
- Update License mention in source code
- Update Docfx metadata for articles (title, author, ms.date...)

## FIXED 🐛

- License mention leading to dead link
- Some builds paths not using Borders in `TableSelector`

## DOCS 📜

- [x] 🚧 Writing docs

## TESTS 🔍

- [x] ✅ Features totally covered

## FEEDBACK 📃

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

---

**Full Changelog**: https://github.com/MorganKryze/ConsoleAppVisuals/compare/v3.5.0-beta...v3.5.0-beta.1
