# Dialog and Text elements

## TL; DR 🎯

Introduction to 2 new elements that will replace the ambiguous use of EmbedText.

## NEW ✨

- `Text` passive element: display multiple lines on the console (can choose alignement and placement)
- `Dialog` interactive element: similar to the former `EmbedText` that can display 0, 1, or 2 options 
- `DialogOption` enum: None (if escape or 0 option), Left and Right (as 2 options maximum)
- The example project is now part of an "examples" folder. The former "example" project is now the "Presentation" one. The font and custom element feature are described in the "CustomElement" and "CustomFont" projects
- "PasswordManager" is a demonstration project to explore basic `Prompt`, `ScrollingMenu` and `Dialog` features

## IMPROVED 📈

- `EmbedText`: has lost its button and Freeze to become passive element (faithful `Text` with embed borders) > Reduce ambiguity
- Publish docs for CI only from main branch to prevent displaying work in progress in production documentation
- Refactor `TextStyler`properties
- Add a `Font` property to `Title` element
- Rename "testing" folder  to "tests"
- Encourage use of "!." instead of "?." for safety

## FIXED 🐛

- Rendering bug with first occurence with TableSelector

## DOCS 📜

- [x] ❌ No docs added

## TESTS 🔍

- [x] ❌ No tests added

## FEEDBACK 📃

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

---

**Full Changelog**: https://github.com/MorganKryze/ConsoleAppVisuals/compare/v3.4.0...v3.5.0-alpha