# New Borders management

## TL; DR 🎯

Instead of roundedCorners boolean, we use BordersType enum. Interaction response history.

## NEW ✨

- `BordersType` enum: enumeration of all borders available (SingleStraight, SingleBold, SingleRounded, DoubleStraight, ASCII)
- `Borders` class: Manages elements borders giving characters depending on the borders type
- Replace rounded corners to Borders feature for: Matrix, TableView, TableSelector, Int and FloatSelector, Prompt, EmbedText, ElementsList, ElementsDashboard
- The interactions are now stored in a list (accessible through `GetResponseHistory()`
-  Thus, `GetResponse()`  now takes the most recent response saved. 

## IMPROVED 📈

- Made '▶' default char when calling `UpdateSelector()` for elements using it
- CD: remove main blocking step
- CD: remove release notes useless extraction
- Minor updates on PR and release notes templates

## FIXED 🐛

None.

## Documentation 📜

- [x] ✅ Docs added

## Tests 🔍

- [x] ✅ Features totally covered

## FEEDBACK 📃

We are always open for feedback and discussions. If you are using our library and want to share your use case, or if you have any suggestions for improvement, please feel free to [open an issue](https://github.com/MorganKryze/ConsoleAppVisuals/issues) or [open a discussion](https://github.com/MorganKryze/ConsoleAppVisuals/discussions) on our GitHub repository. Your input helps us understand possible use cases and make necessary improvements.

---

**Full Changelog**: https://github.com/MorganKryze/ConsoleAppVisuals/compare/v3.3.1...v3.4.0