# Planned Folder Structure

- src
  - components
    - widgets
    - comments
      - comments.jsx
      - button.jsx
    - article
    - reactions
    - table
  - screens
    - article
      - index.jsx
      - mobile.jsx
      - desktop.jsx
  - hooks
  - store
    - types.js
    - actions
      - article.action.js
    - reducers
      - article.reducer.js
  - utils
    - constants.jsx
    - theme
      - dark.jsx
      - light.jsx
    - firebase.js
    - apollo.js
    - apis
      - article.api.js
      - comment.api.js
  - assets
    - img
    - placeholders

# Development Process

1. Select a page to develop.
2. Determine and develop the components necessary for that particular page.
3. Develop the desktop site.
4. Develop the mobile site.
5. Write tests for the new page/component

# Planning for development

1. Develop the material-ui theme structure.
2. Develop the onboarding flow.
3. Develop the most common components used.

- Header, Footer, Navbar, Post (small, medium, large),

4. Develop the Home Page, Article Page.
