/*
 Source Server         : localhost_3306
 Source Server Type    : MySQL
 Source Server Version : 50562
 Source Host           : localhost:3306
 Source Schema         : xiaoxiang_blog

 Target Server Type    : MySQL
 Target Server Version : 50562
 File Encoding         : 65001

 Date: 12/03/2023 21:47:40
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for t_blog
-- ----------------------------
DROP TABLE IF EXISTS `t_blog`;
CREATE TABLE `t_blog`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键，唯一标识',
  `active` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否有效，1有效，0无效',
  `author_id` int(10) UNSIGNED NOT NULL COMMENT '外键，发布者ID',
  `title` varchar(210) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '博客标题',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '博客内容',
  `read_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '访问量',
  `like_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞量',
  `comment_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论数',
  `like_msg_send_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞消息下发计数，防止重复发点赞消息',
  `create_timestamp` bigint(20) UNSIGNED NOT NULL COMMENT '发布时间',
  `update_timestamp` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 90 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of t_blog
-- ----------------------------
INSERT INTO `t_blog` VALUES (6, 1, 20, '沁园春 · 雪', '<p style=\"padding: 0px; text-indent: 2em;\"><span style=\"text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>北国风光，千里冰封，万里雪飘。</b></font></span></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>望长城内外，惟余莽莽；大河上下，顿失滔滔。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>山舞银蛇，原驰蜡象，欲与天公试比高。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>须晴日，看红装素裹，分外妖娆。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>江山如此多娇，引无数英雄竞折腰。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>惜秦皇汉武，略输文采；唐宗宋祖，稍逊风骚。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>一代天骄，成吉思汗，只识弯弓射大雕。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><b>俱往矣，数风流人物，还看今朝。</b></font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><br></font></p><p style=\"padding: 0px; text-indent: 2em;\"><span style=\"font-family: Arial, Helvetica; font-size: 16px; font-weight: 700; text-indent: 0px;\"><font color=\"#000000\" style=\"\">译文</font></span></p><p style=\"padding: 0px; text-indent: 2em;\"><span style=\"text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">北方的风光，千里冰封冻，万里雪花飘。</font></span></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">望长城内外，只剩下无边无际白茫茫一片。整条黄河，立刻失去了波涛滚滚的水势。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">被白雪覆盖的群山好像银蛇在舞动，高原好像白象在奔跑，它们都想试着和老天爷比一下谁更高。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">等到晴天的时候，看红日和白雪交相辉映，格外娇艳美好。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">江山是如此的媚娇，引得无数英雄竞相倾倒。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">可惜秦始皇、汉武帝，略差文治功劳；唐太宗、宋太祖，稍逊文学才华。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">称雄一世的英雄人物，成吉思汗，只知道拉弓射大雕。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">这些人物都已经过去了，称得上能建功立业的英雄人物，还要看今天的人们。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><br></font></p><p style=\"padding: 0px; text-indent: 2em;\"><span style=\"color: rgb(0, 0, 0); font-family: Arial, Helvetica; font-size: 16px; font-weight: 700; text-indent: 0px;\">注释</span></p><p style=\"padding: 0px; text-indent: 2em;\"><span style=\"text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">北国：该词源于中国古代的分裂时期，如宋称辽、金为北国，东晋称十六国等为北国，南北朝时代南方的各朝代称在北方与之对抗的各朝代为北国等。毛泽东诗中的“北国”使人在不觉中产生出一种我国疆土广大的民族自豪感。</font></span></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">雪：这首词作于红一方面军一九三六年二月由陕北准备东渡黄河进入山西省西部的时候。作者在一九四五年十月七日给柳亚子信中说，这首词作于“初到陕北看见大雪时”。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">惟：只。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">馀：剩下。此字一作“余”，但目前刊出的书法作品中写作“馀”，以此为准。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">莽莽：无边无际。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">大河上下：大河，指黄河。大河上下，犹言整条黄河。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">顿失滔滔：（黄河）立刻失去了波涛滚滚的气势。描写黄河水结冰的景象。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">山舞银蛇，原驰蜡象：群山好像（一条条）银蛇在舞动。高原（上的丘陵）好像（许多）白象在奔跑。“原”指高原，即秦晋高原。蜡象，白色的象。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">天公：指天，即命运。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">须：等到；需要。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">红装素裹：形容雪后天晴，红日和白雪交相辉映的壮丽景色。红装，原指妇女的艳装，这里指红日为大地披上了红装。素裹，原指妇女的淡装，这里指皑皑白雪覆盖着大地。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">分外妖娆：格外婀娜多姿。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">竞折腰：折腰，倾倒，躬着腰侍候。这里是说争着为江山奔走操劳。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">秦皇：秦始皇嬴政（前259~前210），秦朝的创业皇帝。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">汉武：汉武帝刘彻（前156~前87），汉朝功业最盛的皇帝。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">略输文采：文采本指辞藻、才华。“略输文采”，是说秦皇汉武，武功甚盛，对比之下，文治方面的成就略有逊色。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">唐宗：唐太宗李世民（599~649），唐朝的建立、统一大业的皇帝。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">宋祖：宋太祖赵匡胤（927~976），宋朝的创业皇帝。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">稍逊风骚：意近“略输文采”。风骚，本指《诗经》里的《国风》和《楚辞》里的《离骚》，后来泛指文章辞藻。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">一代天骄：指可以称雄一世的英雄人物，泛指非常著名，有才能的人物。天骄，“天之骄子”的省略语。意思是上天所骄纵宠爱的人，成吉思汗即是。汉时匈奴自称。后来也泛称强盛的少数名族或其首领。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">成吉思汗（hán）：元太祖铁木真（1162~1227）在1206年统一蒙古后的尊称，意为“强者之汗”（汗是可汗的省称，即王）。后蒙古于1271年改国号为元，成吉思汗被尊为建立元朝的始祖。成吉思汗除占领中国黄河以北地区外，还曾向西远征，占领中亚和南俄，建立了庞大的蒙古帝国。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">只识弯弓射大雕：雕，一种属于鹰类的大型猛禽，善飞难射，古代因用“射雕手”比喻高强的射手。“只识弯弓射大雕”，是说只以武功见长。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">俱往矣：都已经过去了。 俱，都。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\">数风流人物：称得上能建功立业的英雄人物。数，数得着、称得上的意思。</font></p><p style=\"padding: 0px; text-indent: 2em;\"><font color=\"#000000\" face=\"黑体\"><br></font></p><p style=\"text-indent: 0px; padding: 0px;\"><font face=\" Arial, Helvetica\"><span style=\"font-size: 16px;\"><b><span style=\"color: rgb(0, 0, 0); text-indent: 0px;\"></span><font color=\"#000000\">&nbsp; &nbsp; &nbsp; 赏析</font></b></span></font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">　词上片描写北国壮丽的雪景，纵横千万里，展示了大气磅礴、旷达豪迈的意境，抒发了词人对祖国壮丽河山的热爱。下片议论抒情，重点评论历史人物，歌颂当代英雄，抒发无产阶级要做世界的真正主人的豪情壮志。全词熔写景、议论和抒情于一炉，意境壮美，气势恢宏，感情奔放，胸襟豪迈，颇能代表毛泽东诗词的豪放风格。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">上片描写乍暖还寒的北国雪景，展现伟大祖国的壮丽山河。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“北国风光，千里冰封，万里雪飘”这三句总写北国雪景，把读者引入了一个冰天雪地、广袤无垠的银色世界。“北国风光”是上片内容的总领句。“千里”“万里”两句是交错说的，即千万里都是冰封，千万里都是雪飘。诗人登高远望，眼界极为广阔，但是“千里”“万里”都远非目力所及，这是诗人的视野在想像之中延伸扩展，意境更加开阔，气魄非常宏大。天地茫茫，纯然一色，包容一切。“冰封”凝然安静，“雪飘”舞姿轻盈，静动相衬，静穆之中又有飘舞的动态。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“望长城内外，惟余莽莽；大河上下，顿失滔滔。”“望”字统领下文，直至“欲与天公试比高”句。这里的“望”，有登高远眺的意思并有很大的想像成分，它显示了诗人自身的形象，使人感受到他那豪迈的意兴。“望”字之下，展现了长城、黄河、山脉、高原这些最能反映北国风貌的雄伟景观，这些景观也正是我们伟大祖国的形象。“长城内外”，这是从南到北，“大河上下”，这是自西向东，地域如此广袤，正与前面“千里”“万里”两句相照应。意境的大气磅礴，显示了诗人博大的胸怀，雄伟的气魄。“惟余莽莽”“顿失滔滔”分别照应“雪飘”“冰封”。“惟余”二字，强化了白茫茫的壮阔景象。“顿失”二字，则写出变化之速，寒威之烈，又使人联想到未冰封时大河滚滚滔滔的雄壮气势。这四句用视觉形象，赋予冰封雪飘的风光以更为具体更为丰富的直觉，更显气象的奇伟雄浑。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“山舞银蛇，原驰蜡象，欲与天公试比高。”“山舞银蛇，原驰蜡象”的动态描写，都有活泼奔放的气势。加上“欲与天公试比高”一句，表现“山”“原”与天相连，更有一种奋发的态势和竞争的活力。“山”“原”都是静物，写它们“舞”“驰”，这化静为动的浪漫想像，固然因在大雪飘飞中远望山势和丘陵绵延起伏，确有山舞原驰的动感，更因诗人情感的跃动，使他眼前的大自然也显得生气勃勃，生动活跃。。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“须晴日，看红装素裹，分外妖娆”写的是虚景，与前十句写眼前的实景形成对比，想像雪后晴日当空的景象，翻出一派新的气象。雪中的景象在苍茫中显得雄伟，雪后的景象则显得娇艳。“看”字与“望”字照应；“红装素裹”，把江山美景比做少女的衣装，形容红日与白雪交相辉映的艳丽景象。“分外妖娆”，赞美的激情溢于言表。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">下片由毛泽东主席对祖国山河的壮丽而感叹，并引出秦皇汉武等英雄人物，纵论历代英雄人物，抒发作者伟大的抱负及胸怀。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“江山如此多娇，引无数英雄竞折腰”，可谓承上启下，将全词连接得天衣无缝。“江山如此多娇”承上，总括上片的写景，对“北国风光”作总评；“引无数英雄竞折腰”启下，展开对历代英雄的评论，抒发诗人的抱负。这一过渡使全词浑然一体，给人严丝合缝、完整无隙的感受。祖国的山河如此美好，难怪引得古今许多英雄人物为之倾倒，争着为统一天下而奋斗。一个“竞”字，写出英雄之间激烈的争斗，写出一代代英雄的相继崛起和衰落的经历。“折腰”的形象，展示了每位英雄人物为之倾倒的姿态，并揭示了为之奋斗的动机。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“惜秦皇汉武，略输文采；唐宗宋祖，稍逊风骚。一代天骄，成吉思汗，只识弯弓射大雕”，以“惜”字总领七个句子，展开对历代英雄人物的评论。诗人于历代帝王中举出五位很有代表性的人物，展开一幅幅历史画卷，使评论得以具体形象地展开，如同翻阅一部千秋史册，一一加以评说。一个“惜”字，定下对历代英雄人物的评论基调，饱含惋惜之情而又有批判。然而措词极有分寸，“略输文采”“稍逊风骚”，并不是一概否定。至于成吉思汗，欲抑先扬，在起伏的文势中不但有惋惜之极的意味，而且用了“只识”二字而带有嘲讽之意。“弯弓射大雕”，非常传神地表现了成吉思汗只恃武功而不知文治的形象。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">“俱往矣，数风流人物，还看今朝”，“俱往矣”三字，言有尽而意无穷，有画龙点睛之妙。将中国封建社会的历史一笔带过，转向诗人所处的当今时代，点出全词“数风流人物，还看今朝”的主题。“今朝”是一个新的时代，新的时代需要新的风流人物来带领。“今朝”的风流人物不负历史的使命，超越于历史上的英雄人物，具有更卓越的才能，并且必将创造空前伟大的业绩，是诗人坚定的自信和伟大的抱负。这震撼千古的结语，发出了超越历史的宣言，道出了改造世界的壮志。那一刻思接千载，那一刻洞悉未来，那一刻豪情万丈，那一刻傲视古今。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">《沁园春·雪》突出体现了毛泽东词风的雄健、大气。作为领袖毛泽东的博大的胸襟和抱负，与广阔雄奇的北国雪景发生同构，作者目接“千里”“万里”，“欲与天公试比高”；视通几千年，指点江山主沉浮。充分展示了雄阔豪放、气势磅礴的风格。</font></p><p style=\"padding: 0px;\"></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">全词用字遣词，设喻用典，明快有力，挥洒自如，辞义畅达，一泻千里。全词合律入韵，似无意而为之。虽属旧体却给读者以面貌一新之感。不单是从词境中表达出的新的精神世界，而首先是意象表达系统的词语，鲜活生动，凝练通俗，易诵易唱易记。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\"><br></font></p><p style=\"text-indent: 0px; padding: 0px;\"><b style=\"font-family: Arial, Helvetica; font-size: 16px;\"><font color=\"#000000\">&nbsp; &nbsp; &nbsp; 创作背景</font></b></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">该词的创作有2种说法：</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">一说是，1936年2月，毛泽东等率领红军东征抗日先锋军东渡黄河、突破阎军防线后，踏雪沿官道山行进，顺利到达山西省石楼县留村，并在此写下了著名诗篇《沁园春·雪》；</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">另一说是1936年2月，毛泽东率红军抗日，来到西北高原。在陕西省清涧县高杰村附近的袁家沟，写下壮丽的《沁园春·雪》。</font></p><p style=\"text-indent: 28px; padding: 0px;\"><font color=\"#000000\" face=\"黑体\">《沁园春·雪》最早发表于1945年11月14日重庆《新民报晚刊》，后正式发表于《诗刊》1957年1月号。</font></p><p style=\"text-indent: 0px; padding: 0px;\"><b style=\"font-family: Arial, Helvetica; font-size: 16px;\"><font color=\"#000000\"></font></b><font face=\" Arial, Helvetica\"><span style=\"font-size: 16px;\"><b><font color=\"#000000\"><br></font></b></span></font></p>\n			', 15, 6, 0, 1, 1676474126071, 1677827061683);
INSERT INTO `t_blog` VALUES (7, 1, 20, '香菱学诗', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">香菱见过众人之后，吃过晚饭，宝钗等都往贾母处去了，自己便往潇湘馆中来。此时黛玉已好了大半，见香菱也进园来住，自是欢喜。香菱因笑道：“我这一进来了，也得了空儿，好歹教给我作诗，就是我的造化了！”黛玉笑道：“既要作诗，你就拜我作师。我虽不通，大略也还教得起你。”香菱笑道：“果然这样，我就拜你作师。你可不许腻烦的。”黛玉道：“什么难事，也值得去学！不过是起承转合，当中承转是两副对子，平声对仄声，虚的对实的，实的对虚的，若是果有了奇句，连平仄虚实不对都使得的。”香菱笑道：“怪道我常弄一本旧诗偷空儿看一两首，又有对的极工的，又有不对的，又听见说‘一三五不论，二四六分明’。看古人的诗上亦有顺的，亦有二四六上错了的，所以天天疑惑。如今听你一说，原来这些格调规矩竟是末事，只要词句新奇为上。”黛玉道：“正是这个道理，词句究竟还是末事，第一立意要紧。若意趣真了，连词句不用修饰，自是好的，这叫做‘不以词害意’。”香菱笑道：“我只爱陆放翁的诗‘重帘不卷留香久，古砚微凹聚墨多’，说的真有趣！”黛玉道：“断不可学这样的诗。你们因不知诗，所以见了这浅近的就爱，一入了这个格局，再学不出来的。你只听我说，你若真心要学，我这里有《王摩诘全集</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">诗人助兴常思玩，野客添愁不忍观。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">翡翠楼边悬玉镜，珍珠帘外挂冰盘。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">良宵何用烧银烛，晴彩辉煌映画栏。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">黛玉笑道：“意思却有，只是措词不雅。皆因你看的诗少，被他缚住了。把这首丢开，再作一首，只管放开胆子去作。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">香菱听了，默默的回来，越性连房也不入，只在池边树下，或坐在山石上出神，或蹲在地下抠土，来往的人都诧异。李纨、宝钗、探春、宝玉等听得此信，都远远的站在山坡上瞧看他。只见他皱一回眉，又自己含笑一回。宝钗笑道：“这个人定要疯了！昨夜嘟嘟哝哝直闹到五更天才睡下，没一顿饭的工夫天就亮了。我就听见他起来了，忙忙碌碌梳了头就找颦儿去。一回来了，呆了一日，作了一首又不好，这会子自然另作呢。”宝玉笑道：“这正是‘地灵人杰’，老天生人再不虚赋情性的。我们成日叹说可惜他这么个人竟俗了，谁知到底有今日。可见天地至公。”宝钗笑道：“你能够像他这苦心就好了，学什么有个不成的。”宝玉不答。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">只见香菱兴兴头头的又往黛玉那边去了。探春笑道：“咱们跟了去，看他有些意思没有。”说着，一齐都往潇湘馆来。只见黛玉正拿着诗和他讲究。众人因问黛玉作的如何。黛玉道：“自然算难为他了，只是还不好。这一首过于穿凿了，还得另作。”众人因要诗看时，只见作道：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">非银非水映窗寒，拭看晴空护玉盘。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">淡淡梅花香欲染，丝丝柳带露初干。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">只疑残粉涂金砌，恍若轻霜抹玉栏。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">梦醒西楼人迹绝，余容犹可隔帘看。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">宝钗笑道：“不像吟月了，月字底下添一个‘色’字倒还使得，你看句句倒是月色。这也罢了，原来诗从胡说来，再迟几天就好了。”香菱自为这首妙绝，听如此说，自己扫了兴，不肯丢开手，便要思索起来。因见他姊妹们说笑，便自己走至阶前竹下闲步，挖心搜胆，耳不旁听，目不别视。一时探春隔窗笑说道：“菱姑娘，你闲闲罢。”香菱怔怔答道：“‘闲’字是十五删的，你错了韵了。”众人听了，不觉大笑起来。宝钗道：“可真是诗魔了。都是颦儿引的他！”黛玉道：“圣人说，‘诲人不倦’，他又来问我，我岂有不说之理。”李纨笑道：“咱们拉了他往四姑娘房里去，引他瞧瞧画儿，叫他醒一醒才好。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">说着，真个出来拉了他过藕香榭，至暖香坞中。惜春正乏倦，在床上歪着睡午觉，画缯立在壁间，用纱罩着。众人唤醒了惜春，揭纱看时，十停方有了三停。香菱见画上有几个美人，因指着笑道：“这一个是我们姑娘，那一个是林姑娘。”探春笑道：“凡会作诗的都画在上头，快学罢。”说着，顽笑了一回。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">各自散后，香菱满心中还是想诗。至晚间对灯出了一回神，至三更以后上床卧下，两眼鳏鳏，直到五更方才朦胧睡去了。一时天亮，宝钗醒了，听了一听，他安稳睡了，心下想：“他翻腾了一夜，不知可作成了？这会子乏了，且别叫他。”正想着，只听香菱从梦中笑道：“可是有了，难道这一首还不好？”宝钗听了，又是可叹，又是可笑，连忙唤醒了他，问他：“得了什么？你这诚心都通了仙了。学不成诗，还弄出病来呢。”一面说，一面梳洗了，会同姊妹往贾母处来。原来香菱苦志学诗，精血诚聚，日间做不出，忽于梦中得了八句。梳洗已毕，便忙录出来，自己并不知好歹，便拿来又找黛玉。刚到沁芳亭，只见李纨与众姊妹方从王夫人处回来，宝钗正告诉他们说他梦中作诗说梦话。众人正笑，抬头见他来了，便都争着要诗看。</p>', 4, 0, 0, 0, 1676474278146, 0);
INSERT INTO `t_blog` VALUES (8, 1, 20, '祖国啊，我亲爱的祖国', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你河边上破旧的老水车，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">数百年来纺着疲惫的歌；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你额上熏黑的矿灯，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">照你在历史的隧洞里蜗行摸索；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是干瘪的稻穗；是失修的路基；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">是淤滩上的驳船，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">把纤绳深深勒进你的肩膊；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">——祖国啊！</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是贫困，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是悲哀。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你祖祖辈辈</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">痛苦的希望啊，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">是“飞天”袖间<span style=\"text-indent: 2em;\">千百年未落到地面的花朵，</span></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">——祖国啊</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你簇新的理想，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">刚从神话的蛛网里挣脱；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你雪被下古莲的胚芽;</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你挂着眼泪的笑涡；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是新刷出的雪白的起跑线；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">是绯红的黎明</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">正在喷薄：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">——祖国啊！</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我是你的十亿分之一，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">是你九百六十万平方的总和；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">你以伤痕累累的乳房</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">喂养了</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">迷惘的我、深思的我、沸腾的我。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">那就从我的血肉之躯上</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">去取得</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">你的富饶、你的荣光、你的自由；</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">——祖国啊，</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我亲爱的祖国！</p>', 1, 1, 0, 1, 1676474845168, 0);
INSERT INTO `t_blog` VALUES (9, 1, 20, '范进中举', '\n				\n				<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">范进进学回家，母亲，妻子俱各欢喜。正待烧锅做饭，只见他丈人胡屠户，手里拿着一副大肠和一瓶酒，走了进来。范进向他作揖，坐下。胡屠户道：\"我自倒运，把个女儿嫁与你这现世宝，历年以来，不知累了我多少。如今不知因我积了甚么德，带挈你中了个相公，我所以带个酒来贺你。\"范进唯唯连声，叫浑家把肠子煮了，烫起酒来，在茅草棚下坐着。母亲自和媳妇在厨下造饭。胡屠户又吩咐女婿道：\"你如今既中了相公，凡事要立起个体统来。比如我这行事里，都是些正经有脸面的人，又是你的长亲，你怎敢在我们跟前装大？若是家门口这些做田的，扒粪的，不过是平头百姓，你若同他拱手作揖，平起平坐，这就是坏了学校规矩，连我脸上都无光了。你是个烂忠厚没用的人，所以这些话我不得不教导你，免得惹人笑话。\"范进道：\"岳父见教的是。\"胡屠户又道：\"亲家母也来这里坐着吃饭。老人家每日小菜饭，想也难过。我女孩儿也吃些。自从进了你家门，这十几年，不知猪油可曾吃过两三回哩！可怜！可怜！\"说罢，婆媳两个都来坐着吃了饭。吃到日西时分，胡屠户吃的醺醺的。这里母子两个，千恩万谢。屠户横披了衣服，腆着肚子去了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">次日，范进少不得拜拜乡邻。魏好古又约了一班同案的朋友，彼此来往。因是乡试年，做了几个文会。不觉到了六月尽间，这些同案的人约范进去乡试。范进因没有盘费，走去同丈人商议，被胡屠户一口啐在脸上，骂了一个狗血喷头，道：\"不要失了你的时了！你自己只觉得中了一个相公，就\'癞虾蟆想吃起天鹅肉\'来！我听见人说，就是中相公时，也不是你的文章，还是宗师看见你老，不过意，舍与你的。如今痴心就想中起老爷来！这些中老爷的都是天上的\'文曲星\'！你不看见城里张府上那些老爷，都有万贯家私，一个个方面大耳？像你这尖嘴猴腮，也该撒抛尿自己照照！不三不四，就想天鹅屁吃！趁早收了这心，明年在我们行里替你寻一个馆，每年寻几两银子，养活你那老不死的老娘和你老婆是正经！你问我借盘缠，我一天杀一个猪还赚不得钱把银子，都把与你去丢在水里，叫我一家老小嗑西北风！\"一顿夹七夹八，骂的范进摸门不着。辞了丈人回来，自心里想：\"宗师说我火候已到，自古无场外的举人，如不进去考他一考，如何甘心？\"因向几个同案商议，瞒着丈人，到城里乡试。出了场，即使回家。家里已是饿了两三天。被胡屠户知道，又骂了一顿。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">到出榜那日，家里没有早饭米，母亲吩咐范进道：\"我有一只生蛋的母鸡，你快拿到集上去卖了，买几升米来煮餐粥吃，我已是饿的两眼都看不见了。\"范进慌忙抱了鸡，走出门去。才去不到两个时候，只听得一片声的锣响，三匹马闯将来。那三个人下了马，把马拴在茅草棚上，一片声叫道：\"快请范老爷出来，恭喜高中了！\"母亲不知是甚事，吓得躲在屋里；听见了，方敢伸出头来，说道：\"诸位请坐，小儿方才出去了。\"那些报录人道：\"原来是老太太。\"大家簇拥着要喜钱。正在吵闹，又是几匹马，二报、三报到了，挤了一屋的人，茅草棚地下都坐满了。邻居都来了，挤着看，老太太没奈何，只得央及一个邻居去寻他儿子。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">那邻居飞奔到集上，一地里寻不见；直寻到集东头，见范进抱着鸡，手里插个草标，一步一踱的，东张西望，在那里寻人买。邻居道：\"范相公，快些回去！你恭喜中了举人，报喜人挤了一屋里。\"范进道是哄他，只装不听见，低着头往前走。邻居见他不理，走上来，就要夺他手里的鸡。范进道：\"你夺我的鸡怎的？你又不买。\"邻居道：\"你中了举了，叫你家去打发报子哩。\"范进道：\"高邻，你晓得我今日没有米，要买这鸡去救命，为甚么拿这话来混我？我又不同你顽，你自回去罢，莫误了我卖鸡。\"邻居见他不信，劈手把鸡夺下，掼在地下，一把拉了回来。报录人见了道\"好了，新贵人回来了。\"正要拥着他说话，范进三两步走进屋里来，见中间报帖已经升挂起来，上写道：\"捷报贵府老爷范讳进高中广东乡试第七名亚元。京报连登黄甲。\"</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">范进不看便罢，看了一遍，又念一启蒙，自己把两手拍了一下，笑了一声，道：\"噫！好了！我中了！\"说着，往后一交跌倒，牙关咬紧，不省人事。老太太慌了，慌将几口开水灌了过来。他爬将起来，又拍着手大笑道：\"噫！好！我中了！\"笑着，不由分说，就往门外飞跑，把报录人和邻居吓了一跳。走出大门不多路，一脚踹在塘里，挣起来，头发都跌散了，两手黄泥，淋淋漓漓一身的水。众人拉他不住，拍着笑着，一直走到集上去了。众人大眼望小眼，一齐道：\"原来新贵人欢喜疯了。\"老太太哭道：\"怎生这样苦命的事！中了一个甚么举人，就得了这拙病！这一疯了，几时才得好？\"娘子胡氏道：\"早上好好出去，怎的就得了这样的病！却是如何是好？\"众邻居劝道：\"老太太不要心慌。我们而今且派两个人跟定了范老爷。这里众人家里拿些鸡蛋酒米，且管待了报子上的老爹们，再为商酌。\"</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">当下众邻居有拿鸡蛋来的，有拿白酒来的，也有背了斗米来的，也有捉两只鸡来的。娘子哭哭啼啼，在厨下收拾齐了，拿在草棚下。邻居又搬些桌凳，请报录的坐着吃酒，商议他这疯了，如何是好。报录的内中有一个人道：\"在下倒有一个主意，不知可以行得行不得？\"众人问：\"如何主意？\"那人道：\"范老爷平日可有怕的人？他只因欢喜狠了，痰涌上来，迷了心窍。如今只消他怕的这个人来打他一个嘴巴，说\'这报录的话都是哄你的，你并不曾中。\'他这一吓，把痰吐了出来，就明白了。\"众邻都拍手道：\"这个主意好得紧，妙得紧！范老爷怕的，莫过于肉案上的胡老爹。好了！快寻胡老爹来。他想还不知道，在集上卖肉哩。\"又一个人道；\"在集上卖肉，他倒好知道了；他从五更鼓就往东头集上迎猪，还不曾回来。快些迎着去寻他。\"</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">一个人飞奔去迎，走到半路，遇着胡屠户来，后面跟着一个烧汤的二汉，提着七八斤肉，四五千钱，正来贺喜。进门见了老太太，老太太大哭着告诉了一番。胡屠户诧异道：\"难道这等没福？\"外边人一片声请胡老爹说话。胡屠户把肉和钱交与女儿，走了出来。众人如此这般，同他商议。胡屠户作难道：\"虽然是我女婿，如今却做了老爷，就是天上的星宿。天上的星宿是打不得的！我听得斋公们说：打了天上的星宿，阎王就要拿去打一百铁棍，发在十八层地狱，永不得翻身。我却是不敢做这样的事！\"邻居内一个尖酸的人说道：\"罢么！胡老爹，你每日杀猪的营生，白刀子进去，红刀子出来，阎王也不知叫判官的簿子上记了你几千铁棍；就是添上这一百棍，也打甚么要紧？只恐铁棍打完了，也算不到这笔帐上来。或者你教好了女婿的病，阎王叙功，从地狱里把你提上第十七层来，也不可知。\"报录的人道：\"不要只管讲笑话。胡老爹，这个事须是这般，你没奈何，权变一权变。\"屠户被众人局不过，只得连斟两碗酒喝了，壮一壮胆，把方才这些小心收起，将平日的凶恶样子拿出来，卷一卷那油晃晃的衣袖，走上集去。众邻居五六个都跟着走。老太太赶出来叫道：\"亲家，你只可吓他一吓，却不要把他打伤了！\"众邻居道：\"这自然，何消吩咐。\"说着，一直去了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">来到集上，只见范进正在一个庙门口站着，散着头发，满脸污泥，鞋都跑掉了一只，兀自拍着掌，口里叫道：\"中了！中了！\"胡屠户凶神似的走到跟前，说道：\"该死的畜生！你中了甚么？\"一个嘴巴打将去。众人和邻居见这模样，忍不住的笑。不想胡屠户虽然大着胆子打了一下，心里到底还是怕的，那手早颤起来，不敢打到第二下。范进因这一嘴巴，却也打晕了，昏倒在地。众邻居一齐上前，替他抹胸口，捶背心，舞了半日，渐渐喘息过来，眼睛明亮，不疯了。众人扶起，借庙门口一个外科郎中的板凳上坐着。胡屠户站在一边，不觉那只手隐隐的疼将起来；自己看时，把个巴掌仰着，再也弯不过来。自己心里懊恼道：\"果然天上\'文曲星\'是打不得的，而今菩萨计较起来了。\"想一想，更疼的狠了，连忙向郎中讨了个膏药帖着。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">范进看了众人，说道：\"我怎么坐在这里？\"又道：\"我这半日，昏昏沉沉，如在梦里一般。\"众邻居道：\"老爷，恭喜高中了。适才欢喜的有些引动了痰，方才吐出几口痰来了，好了。快请回家去打发报录人。\"范进说道：\"是了。我也记得是中的第七名。\"范进一面自绾了头发，一面问郎中借了一盆水洗洗脸。一个邻居早把那一只鞋寻了来，替他穿上。见丈人在跟前，恐怕又要来骂。胡屠户上前道：\"贤婿老爷，方才不是我敢大胆，是你老太太的主意，央我来劝你的。\"邻居内一个人道：\"胡老爹方才这个嘴巴打的亲切，少顷范老爷洗脸，还要洗下半盆猪油来！\"又一个道：\"老爹，你这手明日杀不得猪了。\"胡屠户道：\"我那里还杀猪！有我这贤婿，还怕后半世靠不着也怎的？我每常说，我的这个贤婿，才学又高，品貌又好，就是城里头那张府、周府的这些老爷，也没有我女婿这样一个体面的相貌。你们不知道，得罪你们说，我小老这一双眼睛，却是认得人的。想着先年，我小女在家里长到三十多岁，多少有钱的富户要和我结亲，我自己觉得女儿像有些福气的，毕竟要嫁与个老爷，今日果然不错！\"说罢，哈哈大笑。众人都笑起来。看着范进洗了脸，郎中又拿茶来吃了，一同回家。范举人先走，屠户和邻居跟在后面。屠户见女婿衣裳后襟滚皱了许多，一路低着头替他扯了几十回。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">到了家门，屠户高声叫道：\"老爷回府了！\"老太太迎着出来，见儿子不疯，喜从天降。众人问报录的，已是家里把屠户送来的几千钱打发他们去了。范进拜了母亲，也拜了丈人。胡屠户再三不安道：\"些须几个钱，不够你赏人。\"范进又谢了邻居。正待坐下，早看见一个体面的管家，手里拿着一个大红全帖，飞跑了进来：\"张老爷来拜新中的范老爷。\"说毕，轿子已是到了门口。胡屠户忙躲进女儿房里，不敢出来。邻居各自散了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">范进迎了出去，只见那张乡绅下了轿进来，头戴纱帽，身穿葵花色圆领、金带、皂靴。他是举人出身，做过一任知县的，别号静斋，同范进让了进来，到堂屋内平磕了头，分宾主坐下。张乡绅攀谈道：\"世先生同在桑梓，一向有失亲近。\"范进道：\"晚生久仰老先生，只是无缘，不曾拜会。\"张乡绅道：\"适才看见题名录，贵房师高要县汤公，就是先祖的门生，我和你是亲切的世弟兄。\"范进道：\"晚生侥幸，实是有愧。却幸得出老先生门下，可为欣喜。\"张乡绅四面将眼睛望了一望，说道：\"世先生果是清贫。\"随在跟的家人手里拿过一封银子来，说道：\"弟却也无以为敬，谨具贺仪五十两，世先生权且收着。这华居其实住不得，将来当事拜往，俱不甚便，弟有空房一所，就在东门大街上，三进三间，虽不轩敞，也还干净，就送与世先生；搬到那里去住，早晚也好请教些。\"范进再三推辞，张乡绅急了，道：\"你我年谊世好，就如至亲骨肉一般；若要如此，就是见外了。\"范进方才把银子收下，作辑谢了。又说了一会，打躬作别。胡屠户直等他上了轿，才敢走出堂屋来。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">范进即将这银子交与浑家打开看，一封一封雪白的细丝锭子，即便包了两锭，叫胡屠户进来，递与他道：\"方才费老爹的心，拿了五千钱来。这六两多银子，老爹拿了去。\"屠户把银子攥在手里紧紧的，把拳头舒过来，道：\"这个，你且收着。我原是贺你的，怎好又拿了回去？\"范进道：\"眼见得我这里还有几两银子，若用完了，再来问老爹讨来用。\"屠户连忙把拳头缩了回去，往腰里揣，口里说道：\"也罢，你而今相与了这个张老爷，何愁没有银子用？他家里的银子，说起来比皇帝家还多些哩！他家就是我卖肉的主顾，一年就是无事，肉也要四五千斤，银子何足为奇！\"又转回头来望着女儿，说道：\"我早上拿了钱来，你那该死行瘟的兄弟还不肯，我说：\'姑老爷今非昔比，少不得有人把银子送上门来给，只怕姑老爷还不希罕。\'今日果不其然！如今拿了银子家去，骂死这砍头短命的奴才！\"说了一会，千恩万谢，低着头，笑迷迷的去了。</p>\n			\n			', 45, 1, 1, 1, 1676474914358, 1677846467302);
INSERT INTO `t_blog` VALUES (10, 1, 20, '从百草园到三味书屋', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我家的后面有一个很大的园，相传叫作百草园。现在是早已并屋子一起卖给朱文公的子孙了，连那最末次的相见也已经隔了七八年，其中似乎确凿只有一些野草；但那时却是我的乐园。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">不必说碧绿的菜畦，光滑的石井栏，高大的皂荚树，紫红的桑葚；也不必说鸣蝉在树叶里长吟，肥胖的黄蜂伏在菜花上，轻捷的叫天子(云雀)忽然从草间直窜向云霄里去了。单是周围的短短的泥墙根一带，就有无限趣味。油蛉在这里低唱，蟋蟀们在这里弹琴。翻开断砖来，有时会遇见蜈蚣；还有斑蝥，倘若用手指按住它的脊梁，便会啪的一声，从后窍喷出一阵烟雾。何首乌藤和木莲藤缠络着，木莲有莲房一般的果实，何首乌有臃肿的根。有人说，何首乌根是有像人形的，吃了便可以成仙，我于是常常拔它起来，牵连不断地拔起来，也曾因此弄坏了泥墙，却从来没有见过有一块根像人样。如果不怕刺，还可以摘到覆盆子，像小珊瑚珠攒成的小球，又酸又甜，色味都比桑葚要好得远。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">长的草里是不去的，因为相传这园里有一条很大的赤练蛇。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">长妈妈曾经讲给我一个故事听：先前，有一个读书人住在古庙里用功，晚间，在院子里纳凉的时候，突然听到有人在叫他。答应着，四面看时，却见一个美女的脸露在墙头上，向他一笑，隐去了。他很高兴；但竟给那走来夜谈的老和尚识破了机关。说他脸上有些妖气，一定遇见“美女蛇”了；这是人首蛇身的怪物，能唤人名，倘一答应，夜间便要来吃这人的肉的。他自然吓得要死，而那老和尚却道无妨，给他一个小盒子，说只要放在枕边，便可高枕而卧。他虽然照样办，却总是睡不着，当然睡不着的。到半夜，果然来了，沙沙沙!门外像是风雨声，他正抖作一团时，却听得豁的一声，一道金光从枕边飞出，外面便什么声音也没有了，那金光也就飞回来，敛在盒子里。后来呢?后来，老和尚说，这是飞蜈蚣，它能吸蛇的脑髓，美女蛇就被它治死了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">结末的教训是：所以倘有陌生的声音叫你的名字，你万不可答应他。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这故事很使我觉得做人之险，夏夜乘凉，往往有些担心，不敢去看墙上，而且极想得到一盒老和尚那样的飞蜈蚣。走到百草园的草丛旁边时，也常常这样想。但直到现在，总还没有得到，但也没有遇见过赤练蛇和美女蛇。叫我名字的陌生声音自然是常有的，然而都不是美女蛇。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">冬天的百草园比较的无味；雪一下，可就两样了。拍雪人(将自己的全形印在雪上)和塑雪罗汉。需要人们鉴赏，这是荒园，人迹罕至，所以不相宜，只好来捕鸟。薄薄的雪，是不行的；总须积雪盖了地面一两天，鸟雀们久已无处觅食的时候才好。扫开一块雪，露出地面，用一枝短棒支起一面大的竹筛来，下面撒些秕谷，棒上系一条长绳，人远远地牵着，看鸟雀下来啄食，走到竹筛底下的时候，将绳子一拉，便罩住了。但所得的是麻雀居多，也有白颊的“张飞鸟”，性子很躁，养不过夜的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这是闰土的父亲所传授的方法，我却不大能用。明明见它们进去了，拉了绳，跑去一看，却什么都没有，费了半天力，捉住的不过三四只。闰土的父亲是小半天便能捕获几十只，装在叉袋里叫着撞着的。我曾经问他得失的缘由，他只静静地笑道：你太性急，来不及等它走到中间去。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我不知道为什么家里的人要将我送进书塾〔书塾〕就是私塾，旧时家庭、宗族或教师自己设立的教学处所。里去了，而且还是全城中称为最严厉的书塾。也许是因为拔何首乌毁了泥墙吧，也许是因为将砖头抛到间壁的梁家去了吧，也许是因为站在石井栏上跳了下来吧……都无从知道。总而言之：我将不能常到百草园了。Ade,我的蟋蟀们!Ade，我的覆盆子们和木莲们!</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">出门向东，不上半里，走过一道石桥，便是我的先生的家了。从一扇黑油的竹门进去，第三间是书房。中间挂着一块匾道：三味书屋；匾下面是一幅画，画着一只很肥大的梅花鹿伏在古树下。没有孔子牌位，我们便对着那匾和鹿行礼。第一次算是拜孔子，第二次算是拜先生。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">第二次行礼时，先生便和蔼地在一旁答礼。他是一个高而瘦的老人，须发都花白了，还戴着大眼镜。我对他很恭敬，因为我早听到，他是本城中极方正，质朴，博学的人。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">不知从那里听来的，东方朔也很渊博，他认识一种虫，名曰“怪哉”，冤气所化，用酒一浇，就消释了。我很想详细地知道这故事，但阿长是不知道的，因为她毕竟不渊博。现在得到机会了，可以问先生。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“先生，‘怪哉’这虫，是怎么一回事?……”我上了生书，将要退下来的时候，赶忙问。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“不知道!”他似乎很不高兴，脸上还有怒色了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我才知道做学生是不应该问这些事的，只要读书，因为他是渊博的宿儒，决不至于不知道，所谓不知道者，乃是不愿意说。年纪比我大的人，往往如此，我遇见过好几回了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我就只读书，正午习字，晚上对课。先生最初这几天对我很严厉，后来却好起来了，不过给我读的书渐渐加多，对课也渐渐地加上字去，从三言到五言，终于到七言。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">三味书屋后面也有一个园，虽然小，但在那里也可以爬上花坛去折蜡梅花，在地上或桂花树上寻蝉蜕。最好的工作是捉了苍蝇喂蚂蚁，静悄悄地没有声音。然而同窗们到园里的太多，太久，可就不行了，先生在书房里便大叫起来：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“人都到那里去了!”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">人们便一个一个陆续走回去；一同回去，也不行的。他有一条戒尺，但是不常用，也有罚跪的规则，但也不常用，普通总不过瞪几眼，大声道：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“读书!”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">于是大家放开喉咙读一阵书，真是人声鼎沸。有念“仁远乎哉我欲仁斯仁至矣”的，有念“笑人齿缺曰狗窦大开”的，有念“上九潜龙勿用”的，有念“厥土下上上错厥贡苞茅橘柚”的……先生自己也念书。后来，我们的声音便低下去，静下去了，只有他还大声朗读着：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“铁如意，指挥倜傥，一坐皆惊呢；金叵罗，颠倒淋漓噫，千杯未醉嗬……”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我疑心这是极好的文章，因为读到这里，他总是微笑起来，而且将头仰起，摇着，向后拗过去，拗过去。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">先生读书入神的时候，于我们是很相宜的。有几个便用纸糊的盔甲套在指甲上做戏。我是画画儿，用一种叫作“荆川纸”的，蒙在小说的绣像上一个个描下来，像习字时候的影写一样。读的书多起来，画的画也多起来；书没有读成，画的成绩却不少了，最成片段的是《荡寇志》和《<a href=\"https://www.thn21.com/wen/famous/13542.html\" target=\"_blank\" class=\"infotextkey\" style=\"color: rgb(45, 100, 179);\">西游记</a>》的绣像，都有一大本。后来，为要钱用，卖给一个有钱的同窗了。他的父亲是开锡箔店的；听说现在自己已经做了店主，而且快要升到绅士的地位了。这东西早已没有了吧。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">九月十八日</p>', 3, 2, 0, 1, 1676475020818, 0);
INSERT INTO `t_blog` VALUES (11, 1, 20, '苏州园林', '\n				\n				<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">苏州园林据说有一百多处，我到过的不过十多处。其他地方的园林我也到过一些。倘若要我说说总的印象，我觉得苏州园林是我国各地园林的标本，各地园林或多或少都受到苏州园林的影响。因此，谁如果要鉴赏我国的园林，苏州园林就不该错过。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">设计者和匠师们因地制宜，自出心裁，修建成功的园林当然各各不同。可是苏州各个园林在不同之中有个共同点，似乎设计者和匠师们一致追求的是：务必使游览者无论站在哪个点上，眼前总是一幅完美的图画。为了达到这个目的，他们讲究亭台轩榭的布局，讲究假山池沼的配合，讲究花草树木的映衬，讲究近景远景的层次。总之，一切都要为构成完美的图画而存在，决不容许有欠美伤美的败笔。他们惟愿游览者得到“如在画图中”的美感，而他们的成绩实现了他们的愿望，游览者来到园里，没有一个不心里想着口头说着“如在画图中”的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我国的建筑，从古代的宫殿到近代的一般住房，绝大部分是对称的，左边怎么样，右边也怎么样。苏州园林可绝不讲究对称，好像故意避免似的。东边有了一个亭子或者一道回廊，西边决不会来一个同样的亭子或者一道同样的回廊。这是为什么?我想，用图画来比方，对称的建筑是图案画，不是美术画，而园林是美术画，美术画要求自然之趣，是不讲究对称的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">苏州园林里都有假山和池沼。假山的堆叠，可以说是一项艺术而不仅是技术。或者是重峦叠嶂，或者是几座小山配合着竹子花木，全在乎设计者和匠师们生平多阅历，胸中有邱壑，才能使游览者攀登的时候忘却苏州城市，只觉得身在山间。至于池沼，大多引用活水。有些园林池沼宽敞，就把池沼作为全园的中心，其他景物配合着布置。水面假如成河道模样，往往安排桥梁。假如安排两座以上的桥梁，那就一座一个样，决不雷同。池沼或河道的边沿很少砌齐整的石岸，总是高低屈曲任其自然。还在那儿布置几块玲珑的石头，或者种些花草：这也是为了取得从各个角度看都成一幅画的效果。池沼里养着金鱼或各色鲤鱼，夏秋季节荷花或睡莲开放，游览者看“鱼戏莲叶间”，又是入画的一景。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">苏州园林栽种和修剪树木也着眼在画意。高树与低树俯仰生姿。落叶树与常绿树相间，花时不同的多种花树相间，这就一年四季不感到寂寞。没有修剪得像宝塔那样的松柏，没有阅兵式似的道旁树：因为依据中国画的审美观点看，这是不足取的。有几个园里有古老的藤萝，盘曲嶙峋的枝干就是一幅好画。开花的时候满眼的珠光宝气，使游览者感到无限的繁华和欢悦，可是没法说出来。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">游览苏州园林必然会注意到花墙和廊子。有墙壁隔着，有廊子界着，层次多了，景致就见得深了。可是墙壁上有砖砌的各式镂空图案，廊子大多是两边无所依傍的，实际是隔而不隔，界而未界，因而更增加了景致的深度。有几个园林还在适当的位置装上一面大镜子，层次就更多了，几乎可以说把整个园林翻了一番。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">游览者必然也不会忽略另外一点，就是苏州园林在每一个角落都注意图画美。阶砌旁边栽几丛书带草。墙上蔓延着爬山虎或者蔷薇木香。如果开窗正对着白色墙壁，太单调了，给补上几竿竹子或几棵芭蕉。诸如此类，无非要游览者即使就极小范围的局部看，也能得到美的享受。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">苏州园林里的门和窗，图案设计和雕镂琢磨功夫都是工艺美术的上品。大致说来，那些门和窗尽量工细而决不庸俗，即使简朴而别具匠心。四扇，八扇，十二扇，综合起来看，谁都要赞叹这是高度的图案美。摄影家挺喜欢这些门和窗，他们斟酌着光和影，摄成称心满意的照片。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">苏州园林与北京的园林不同，极少使用彩绘。梁和柱子以及门窗栏杆大多漆广漆，那是不刺眼的颜色。墙壁白色。有些室内墙壁下半截铺水磨方砖，淡灰色和白色对衬。屋瓦和檐漏一律淡灰色。这些颜色与草木的绿色配合，引起人们安静闲适的感觉。花开时节，更显得各种花明艳照眼。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">可以说的当然不止以上这些，这里不再多写了。</p>\n			\n			', 7, 2, 0, 1, 1676475072646, 1677258105767);
INSERT INTO `t_blog` VALUES (12, 1, 20, '出师表', '\n				<p style=\"padding: 0px; line-height: 28px;\">　&nbsp; &nbsp; 先帝创业未半而中道崩殂，今天下三分，益州疲弊，此诚危急存亡之秋也。然侍卫之臣不懈于内，忠志之士忘身于外者，盖追先帝之殊遇，欲报之于陛下也。诚宜开张圣听，以光先帝遗德，恢弘志士之气，不宜妄自菲薄，引喻失义，以塞忠谏之路也。</p><p style=\"padding: 0px; line-height: 28px;\">　　宫中府中，俱为一体；陟罚臧否，不宜异同。若有作奸犯科及为忠善者，宜付有司论其刑赏，以昭陛下平明之理，不宜偏私，使内外异法也。</p><p style=\"padding: 0px; line-height: 28px;\">　　侍中、侍郎郭攸之、费祎、董允等，此皆良实，志虑忠纯，是以先帝简拔以遗陛下。愚以为宫中之事，事无大小，悉以咨之，然后施行，必能裨补阙漏，有所广益。</p><p style=\"padding: 0px; line-height: 28px;\">　　将军向宠，性行淑均，晓畅军事，试用于昔日，先帝称之曰能，是以众议举宠为督。愚以为营中之事，悉以咨之，必能使行阵和睦，优劣得所。</p><p style=\"padding: 0px; line-height: 28px;\">　　亲贤臣，远小人，此先汉所以兴隆也；亲小人，远贤臣，此后汉所以倾颓也。先帝在时，每与臣论此事，未尝不叹息痛恨于桓、灵也。侍中、尚书、长史、参军，此悉贞良死节之臣，愿陛下亲之信之，则汉室之隆，可计日而待也。</p><p style=\"padding: 0px; line-height: 28px;\">　　臣本布衣，躬耕于南阳，苟全性命于乱世，不求闻达于诸侯。先帝不以臣卑鄙，猥自枉屈，三顾臣于草庐之中，咨臣以当世之事，由是感激，遂许先帝以驱驰。后值倾覆，受任于败军之际，奉命于危难之间，尔来二十有一年矣。</p><p style=\"padding: 0px; line-height: 28px;\">　　先帝知臣谨慎，故临崩寄臣以大事也。受命以来，夙夜忧叹，恐托付不效，以伤先帝之明；故五月渡泸，深入不毛。今南方已定，兵甲已足，当奖率三军，北定中原，庶竭驽钝，攘除奸凶，兴复汉室，还于旧都。此臣所以报先帝而忠陛下之职分也。至于斟酌损益，进尽忠言，则攸之、祎、允之任也。</p><p style=\"padding: 0px; line-height: 28px;\">　　愿陛下托臣以讨贼兴复之效，不效，则治臣之罪，以告先帝之灵。若无兴德之言，则责攸之、祎、允等之慢，以彰其咎；陛下亦宜自谋，以咨诹善道，察纳雅言，深追先帝遗诏。臣不胜受恩感激。今当远离，临表涕零，不知所言。</p>\n			', 11, 2, 1, 1, 1676475128851, 1677846725934);
INSERT INTO `t_blog` VALUES (13, 1, 20, '老人与海', '<p>　　他们在海里走得很顺当，老头儿把手泡在咸咸的海水里，想让脑子清醒，头上有高高的积云，还有很多的卷云，因此老头儿知道还要刮一整夜的小风。老头儿不断地望着鱼，想弄明白是不是真有这回事。这是第一条鲨鱼朝它扑来的前一个钟头。</p><p>　　鲨鱼的出现不是偶然的。当一大股暗黑色的血沉在一英里深的海里然后又散开的时候，它就从下面水深的地方窜上来。它游得那么快，什么也不放在眼里，一冲出蓝色的水面就涌现在太阳光下。然后它又钻进水里去，嗅出了臭迹，开始顺着船和鱼所走的航线游来。</p><p>　　有时候鲨鱼也迷失了臭迹，但很快就嗅出来，或者嗅出一点儿影子，于是紧紧顺着这条航线游。这是一条巨大的鲭鲨，生来就跟海里游速最快的鱼一般快。它周身的一切都美，只除了上下颚。它的脊背蓝蓝的象是旗鱼的脊背。肚子是银白色，皮是光滑的，漂亮的。它生得跟旗鱼一样，不同的是它那巨大的两颚，游得快的时候两颚紧闭起来。它在水面下游，高耸的脊鳍象刀子似的一动也不动地插在水里。在它紧闭的双嘴唇里，八排牙齿全部向内倾斜着。跟寻常大多数鲨鱼不同，它的牙齿不是角锥形的，象爪子一样缩在一起的时候，形状就如同人的手指头。那些牙齿几乎跟老头儿的手指头一般长，两边都有剃刀似的锋利的刃子。这种鱼天生要吃海里一切的鱼，尽管那些鱼游得那么快，身子那么强，战斗的武器那么好，除掉它没有任何的鱼敌得过。现在，它嗅出了新的臭迹，加快游起来，它的蓝色的脊鳍划开了水面。</p><p>　　老头儿看见它来到，知道这是一条毫无畏惧而且为所欲为的鲨鱼。他把鱼叉准备好，用绳子系住，眼也不眨地望着鲨鱼向前游来。绳子短了，少去割掉用来绑鱼的那一段。</p><p>　　老头儿现在头脑清醒，正常，有坚强的决心，但是希望不大。他想：能够撑下去就太好啦。看见鲨鱼越来越近的时候，他向那条死了的大鱼望了一眼。他想：这也许是一场梦。我不能够阻止它来害我，但是也许我可以捉住它。“Dentuso\"，他想。</p><p>　　鲨鱼飞快地逼近船后边。它去咬那条死鱼的时候，老头儿看见它的嘴大张着，看见它在猛力朝鱼尾巴上面的肉里咬进去的当儿，那双使人惊奇的眼睛和咬得格崩格崩的牙齿。鲨鱼的头伸出水面，脊背也正在露出来，老头儿用鱼叉攮到鲨鱼头上的时候，他听得出那条大鱼身上皮开肉绽的声音。他攮进的地方，是两只眼睛之间的那条线和从鼻子一直往上伸的那条线交叉的一点。事实上并没有这两条线。有的只是那又粗大又尖长的蓝色的头，两只大眼，和那咬得格崩崩的、伸得长长的、吞噬一切的两颚。但那儿正是脑子的所在，老头儿就朝那一个地方扎进去了。他鼓起全身的气力，用他染了血的手把一杆锋利无比的鱼叉扎了进去。他向它扎去的时候并没有抱着什么希望，但他抱有坚决的意志和狠毒无比的心肠。</p><p>　　鲨鱼在海里翻滚过来。老头儿看见它的眼珠已经没有生气了，但是它又翻滚了一下，滚得自己给绳子缠了两道。老头儿知道它是死定了，鲨鱼却不肯承认。接着，肚皮朝上，尾巴猛烈地扑打着水面，两颚格崩格地响着，象一只快艇一样在水面上破浪而去。海水给它的尾巴扑得白浪滔天，绳一拉紧，它的身子四分之三就脱出了水面，那绳不住地抖动，然后突然扎断了。老头儿望着鲨鱼在水面上静静地躺了一会儿，后来它就慢慢地沉了下去。</p><p>　　“它咬去了大约四十磅，”老头儿高声说。他想：他把我的鱼叉连绳子都带去啦，现在我的鱼又淌了血，恐怕还有别的鲨鱼会窜来呢。</p><p>　　他不忍朝死鱼多看一眼，因为它已经给咬得残缺不全了。鱼给咬住的时候，他真觉得跟自己身受的一样。</p><p>　　他想：能够撑下去就太好啦 。这要是一场梦多好，但愿我没有钓到这条鱼，独自躺在床上的报纸上面。</p><p>　　“可是人不是生来要给人家打败的，”他说，“人尽可被毁灭，可是不会肯吃败仗的。”他想：不过这条鱼给我弄死了，我倒是过意不去。现在倒霉的时刻就要来到，我连鱼叉也经丢啦。“Dentuso”这个东西，既残忍，又能干，既强壮，又聪明。可我比它更聪明。也许不吧，他想。也许我只是比它多了个武器吧。</p><p>　　“别想啦，老家伙，”他又放开嗓子说。“还是把船朝这条航线上开去，有了事儿就担当。”</p><p>　　他想，可是我一定要想。因为我剩下的只有想想了。除了那个，我还要想想垒球。我不晓得，老狄马吉奥乐意不乐意我把鱼叉扎在它脑子上的那个办法呢?这不是一桩了不起的事儿。什么人都能办得到。但是，你是不是认为我的手给我招来的麻烦就跟鸡眼一样呢?我可没法知道。我的脚后跟从来没有出过毛病，只有一次，我在游泳的时候一脚踩在一条海鳐鱼上面，脚后跟给它刺了一下，当时我的小腿就麻木了，痛得简直忍不住。</p><p>　　“想点开心的事吧，老家伙，”他说。“每过一分钟就离家更近一步。丢掉了四十磅鱼肉，船走起来更轻快些。”</p><p>　　他很清楚，把船开到海流中间的时候会出现什么花样。可是现在一点办法也没有。</p><p>　　“得，有主意啦，”他大声说。“我可以把我的刀子绑在一只桨的把上。”</p><p>　　他把舵柄夹在胳肢窝里，用脚踩住帆脚绳，把刀子绑在桨把上了。</p><p>　　“啊，”他说。“我虽照旧是个老头儿。不过我不是赤手空拳罢了。”</p><p>　　这时风大了些，他的船顺利地往前驶着。他只看了看鱼的前面一部分，他又有点希望了。</p><p>　　他想：不抱着希望真蠢。此外我还觉得这样做是一桩罪过，他想：别想罪过了吧。不想罪过，事情已经够多啦，何况我也不懂得这种事。</p><p>　　我不懂得这种事，我也不怎么相信。把一条鱼弄死也许是一桩罪过。我猜想一定是罪过，虽然我把鱼弄死是为了养活自己也为了养活许多人。不过，那样一来什么都是罪过了。不想罪过了吧。现在想它也太迟啦，有些人是专门来考虑犯罪事儿的。让那些人去想吧。你生来是个打鱼的，正如鱼生来是条鱼。桑彼得罗是打鱼的，跟老狄马吉奥的爸爸一样。</p><p>　　他总喜欢去想一切跟他有关联的事情，同时因为没有书报看，也没有收音机，他就想得很多，尤其是不住地在想到罪过。他想，你把鱼弄死不仅仅是为了养活自己，卖去换东西吃。你弄死它是为了光荣，因为你是个打鱼的。它活着的时候你爱它，它死了你还是爱它。你既然爱它，把它弄死了就不是罪过。不然别的还有什么呢?</p><p>　　“你想得太多啦，老头儿，”他高声说。</p><p>　　他想：你倒得乐意把那条鲨鱼给弄死的。可是它跟你一样靠着吃活鱼过日子。它不是一个吃腐烂东西的动物，也不像有些鲨鱼似的，只是一个活的胃口。它是美丽的，崇高的，什么也不害怕。</p><p>　　“我弄死它为了自卫，”老头儿又高声说。“我把它顺顺当当地给弄死啦。”</p><p>　　他想：况且，说到究竟，这一个总要杀死那一个。鱼一方面养活我，一方面要弄死我。孩子是要养活我的。我不能过分欺骗自己了。</p><p>　　他靠在船边上，从那条死鱼身上给鲨鱼咬过的地方撕下了一块肉。他嚼了一嚼，觉得肉很好，味道也香，象牲口的肉，又紧凑又有水分，可就是颜色红。肉里面筋不多，他知道可以在市场上卖大 价钱。可是他没法叫肉的气味不散到水里去，他知道倒霉透顶的事儿快要发生了。</p><p>　　风在不住地吹，稍 微转到东北方去，他知道，这就是说风不会减退了。老头儿朝前面望了一望，但是他看不见船上冒出来的烟。只有飞鱼从船头那边飞出来，向两边仓皇地飞走，还有的就是一簇簇黄色的马尾藻。他连一只鸟儿也看不见。</p><p>　　他已经在海里走了两上钟头，在船梢歇着，有时候嚼嚼从马林鱼身上撕下来的肉，尽量使自己好好休息一下，攒些儿力气，这时他又看见了两条鲨鱼中间的第一条。</p><p>　　“呀，”他嚷了一声。这一声音是没法可以表达出来的，或许这就像是一个人在觉得一根钉子穿过他的\'手钉进木头里的时候不自主地发出的喊声吧。</p><p>　　“星鲨，”他高声说。他看见第二条鱼的鳍随着第一条鱼的鳍冒上来，根据那褐色的三角形的鳍和那摆来摆去的尾巴，他认出这是两条犁头鲨。它们嗅出了臭迹以后就兴奋起来，因为饿得发呆了，它们在兴奋中一会儿迷失了臭迹，一会儿又把臭迹找出来。但是它们却始终不停地向前逼近。</p><p>　　老头儿系上帆脚绳，把舵柄夹紧。然后拿起上面绑着刀子的桨。他轻轻地把桨举起来，尽量轻轻，因为他的手痛得不听使唤了。然后，他又把手张开，再轻轻地把桨攥住，让手轻松一些。这一次他攥得很紧，让手忍住了疼痛不缩回来，一面注意着鲨鱼的来到。他看得见它们的阔大的、扁平的铲尖儿似的头，以及那带白尖儿的宽宽的胸鳍。这是两条气味难闻的讨厌的鲨鱼，是吃腐烂东西的，又是凶残嗜杀的。饥饿的时候，它们会去咬一把桨或者船的舵。这些鲨鱼会趁海龟在水面上睡觉的时候就把它们的腿和四肢咬掉。它们饥饿的时候会咬在水里游泳的人，即使人身上没有鱼血的气味或者鱼的粘液。</p><p>　　“呀，”老头儿说。“星鲨，来吧，星鲨。”</p><p>　　它们来了。但是它们没有象鲭鲨那样的游来。一条鲨鱼转了一个身，就钻到船底下看不见的地方，它把那条死鱼一拉又一扯，老头儿感觉到船在晃动。另一条鲨鱼用它一条缝似的黄眼睛望着老头儿，然后飞快地游到船跟前，张着半圆形的大嘴朝死鱼身上被咬过的部分咬去。在它那褐色的头顶和后颈上，在脑子和脊髓相连的地方，清清楚楚地现出了一条纹路，老头儿就用绑在桨上的刀子朝那交切点攮进去，又抽出来，再攮进它的猫似的黄眼睛里。鲨鱼放开了它咬的死鱼，从鱼身上滑下去，死去的时候还吞着它咬下的鱼肉。</p><p>　　由于另一条鲨鱼正在蹂躏死鱼的缘故，船身还在晃荡，老头儿松开了帆脚绳，让船向一边摆动，使鲨鱼从船底下出来。一看见鲨鱼，他就从船边弯着身子把刀子朝它身上扎去。他要扎的只是肉，可是鲨鱼的皮很结实，好不容易才把刀子戳进去。这一下不仅震痛了他的手，也震痛了他的肩膀。鲨鱼又很快地露出头来，当它的鼻子伸出水面来靠在死鱼身上的时候，老头儿对准它的扁平的脑顶中央扎去，然后把刀子拔出，又朝同一个地方扎了一下。它依旧闭紧了嘴咬住鱼，于是老头儿再从它的左眼上戳进去，但它还是缠住死鱼不放。</p><p>　　“怎么啦 ?”老头儿说着又把刀子扎进它的脊骨和脑子中间去。这一次戳进去很容易，他觉得鲨鱼的软骨断了。老头儿又把桨翻了一个身，把刀放在鲨鱼的两颚中间，想把它的嘴撬开。他把刀子绞了又绞，当鲨鱼一松滑下去的时候，他说：“去，去，星鲨。滑到一英里的深的水里去。去找你的朋友吧，也许那是你的妈妈呢。”</p><p>　　老头儿擦了擦他的刀片，把桨放下，然后系上了帆脚索，张开了帆，把船顺着原来的航线开去。</p><p>　　“它们准是把它吃掉四分之一了，而且吃的净是好肉，”他大声说，“我真盼望这是一场梦，但愿我根本没有把它钓上来。鱼啊，这件事可真教我不好受。从头错到底啦”。他不再说下去，也不愿朝鱼看一眼。它的血已经淌尽了，还在受着波浪的冲刷，看上去好象镜子底的银白色，它身上的条纹依然看得出来。</p><p>　　“鱼啊，我不应该把船划到这么远的地方去，”他说。“既不是为了你，也不是为了我。我很不好受，鱼啊。”</p><p>　　好吧，他又自言自语地说。望一望绑刀的绳子，看看断了没有。然后把你的手弄好，因为还有麻烦的事儿没有来到呢。</p><p>　　“有一块石头磨磨刀子该多好，”老头儿检查了一下绑在桨把上的绳子以后说。“我应该带一块石头来。”他想：好多东西都是应该带来的，但是你没有带来，老家伙。现在不是想你没有的东西的时候。想一想用他现有的东西的时候。想一想用你现有的东西可以做的事儿吧。</p><p>　　“你给我想出了很巧妙的主意，”他敞开了喉咙说。“可是我懒得听下去啦。”</p><p>　　他把舵柄夹在胳肢窝里，双手泡在水里，随着船往前飘去。</p><p>　　“天晓得，最后那一条鲨鱼撕去了我好多鱼肉，”他说。“可是船现在轻松些了。”他不愿去想给撕得残缺不全的鱼肚子。他知道，鲨鱼每次冲上去猛扯一下，就给扯去了好多的死鱼肉，现在死鱼已经成为一切鲨鱼追踪的途径，宽阔得象海面上一条大路一样了。</p><p>　　他想：这是把一个人养活一整个冬天的鱼啊。别那样想吧。歇一歇，把你的手弄好，守住剩下来的鱼肉。水里有了那么多的气味，我手上的血腥味也算不得什么，何况手上的血淌得也不多了。给割破的地方算不了什么。淌血会叫我的左手不抽筋。</p><p>　　他想：我现在还有什么事儿可想呢?没有。什么也别去想它，只等着以后的鲨鱼来到吧。我希望这真是一场梦，他想。但是谁晓得呢?也许结果会很好的。</p><p>　　下一个来到鲨鱼是一条犁头鲨。;它来到的时候就活象一只奔向猪槽的猪，如果一只猪的嘴有它的那么大，大得连你的头也可以伸到它嘴里去的话。老头儿先让它去咬那条死鱼，然后才把绑在桨上的刀扎进它的脑子里去。但是鲨鱼一打滚就往后猛的一挣，那把刀子喀嚓一声折断了。</p><p>　　老头儿只管去掌他的舵，连看也不看那条大鲨鱼，它慢慢地沉到水里去，最初还是原来那么大，然后渐渐小下去，末了只有一丁点儿了。这种情景老头儿一向是要看得入迷的，可是现在他望也不望一眼。</p><p>　　“我还有鱼钩呢，”他说。“但是那没用处。我有两把桨，一个舵把，还有一根短棍。”</p><p>　　他想：这一回它们可把我打败了。我已经上了年纪，不能拿棍子把鲨鱼给打死。但是，只要我有桨，有短棍，有舵把，我一定要想法去揍死它们。</p><p>　　他又把手泡在水里。这时天色渐渐地向晚。除了海和天，什么也看不出来。天上的风刮得比先前大了些，马上他就希望能够看到陆地。</p><p>　　“你累乏啦，老头儿，”他说。“里里外外都累乏啦。”</p><p>　　直到太阳快落下去的时候，鲨鱼才又向他扑来。</p><p>　　老头儿看见两个褐色的鳍顺着死鱼的水里所不得不造成的那条宽阔的路线游着。它们甚至不去紧跟着鱼的气味，就肩并肩地直朝着小船扑来。</p><p>　　他扭紧了舵，把帆脚绳系好，从船梢下面去拿那根短棍。这是把一个断了桨锯成二英尺半长左右的一个桨把子。因为那个桨把子有个把手，他用一手攥起来才觉得方便，他说稳稳地把它攥在右手里，用手掌弯弯地握着，一面望着鲨鱼的来到。两条都是“星鲨”。</p><p>　　他想：我要先让第一条鲨鱼把死鱼咬紧了，然后再朝它的鼻尖儿揍，或者照着朝它的头顶上劈去。</p><p>　　两条鲨鱼一道儿来到跟前，他看见离得最近的一条张开大嘴插进死鱼的银白色的肚皮时，他把短棍高高地举起，使劲捶下，朝鲨鱼的宽大的头顶狠狠地劈去。短棍落下的当儿，他觉得好象碰到了一块坚韧的橡皮，同时他也感觉到打在铁硬的骨头上。鲨鱼从死鱼身上滑下去的时候，他又朝它的鼻尖上狠狠地揍了一棍。</p><p>　　另一条鲨鱼原是忽隐忽现的，这时又张开了大嘴扑上来。当它咬住了死鱼、闭紧了嘴的时候，老头儿看得见从它嘴角上漏出的一块块白花花的鱼肉。他用棍子对准了它打去，只是打中了它的头，鲨鱼朝他望了一望，然后把它咬住的那块肉撕去。当它衔着鱼肉逃走的时候，老头儿又揍了它一棍，但是打中的只是橡皮似的又粗又结实的地方。</p><p>　　“来吧，星鲨，”老头儿说。“再来吧。”</p><p>　　鲨鱼一冲又冲上来，一闭住嘴就给老头儿揍了一棍。他把那根棍子举到不能再高的地方，结结实实地揍了它一下。这一回他觉得他已经打中了脑盖骨，于是又朝同一个部位打去，鲨鱼慢慢吞吞地把一块鱼肉撕掉，然后从死鱼身上滑下去了。</p><p>　　老头儿留意望着那条鲨鱼会不会再回来，可是看不见一条鲨鱼。一会儿他看见一条在水面上打着转儿游来游去。他却没有看到另一条鳍。</p><p>　　他想：我没指望再把它们弄死了。当年轻力壮的时候，我会把它们弄死的。可是我已经叫它们受到重伤，两条鲨鱼没有一条会觉得好过。要是我能用一根垒球棒，两只手抱住去打它们，保险会把第一条鲨鱼打死。甚至现在也还是可以的。</p><p>　　他不愿再朝那条死鱼看一眼。他知道它的半个身子都给咬烂了。在他跟鲨鱼格斗的时候，太阳已经落下去。</p><p>　　“马上就要天黑，”他说。“一会儿我要看见哈瓦那的灯火了。如果我往东走得更远，我会看见从新海滩上射出来的灯光。”</p><p>　　他想：现在离港口不会太远了。我希望没有人替我担心。只有那孩子，当然，他一定会替我担心的。可是我相信他有信心。好多打鱼的老头儿也会替我担心的。还有好多别的人。我真是住在一个好地方呀。</p><p>　　他不能再跟那条大鱼讲话，因为它给毁坏得太惨啦。这时他脑子里突然想起了一件事。</p><p>　　“你这半条鱼啊，”他说。“你原来是条整鱼。我过意不去的是我走得太远，这把你和我都给毁啦。可是我们已经弄死了许多鲨鱼，你和我，还打伤好多条。老鱼，你究竟弄死过多少鱼啊?你嘴上不是白白地生了那个长吻的。”</p><p>　　他总喜欢想到这条死去的鱼，想到要是它能够随意地游来游去，它会怎么样去对付一条鲨鱼。他想：我应该把它的长吻砍掉，用它去跟鲨鱼斗。可是船上没有斧头，后来又丢掉了刀子。</p><p>　　话又说回来，当时要是我能够把它的长吻儿砍掉，绑在桨把上的话，那该是多好的武器呀。那样一来，我俩就会一同跟它斗啦。要是它们在夜里窜来，你该怎么办呢?你有什么办法呢?</p><p>　　“跟它们斗，”他说。“我要跟它们斗到死。”</p><p>　　现在已经天黑，可是天边还没有红光，也看不见灯火，有的只是风，只是扯得紧紧的帆，他觉得大概自己已经死了。他合上两只手，摸一摸手掌心。两只手没有死，只要把两只手一张一合，他还觉得活活地痛 哩。他把 脊背靠在船梢上，才知道自己没有死。这是他的肩膀告诉他的。</p><p>　　他想：我许过愿，要是我捉到了这条鱼，我一定把所有的那些祷告都说一遍。但是我现在累得说不出了。倒不如把麻袋拿过来盖在我的肩膀上。</p><p>　　他躺在船梢,一面掌舵，一面留意天边红光的出现。他想：我还有半条鱼。也许我有运气把前面半条鱼带回去。我应该有点儿运气的。可是没有呀，他说。你走得太远，把运气给败坏啦。</p><p>　　“别胡说八道啦，”他又嚷起来。“醒着，掌好舵。也许你的运气还不小呢。”</p><p>　　“我倒想买点儿运气，要是有地方买的说。”他说。</p><p>　　我拿什么去买运气呢?他自己问自己。我买运气，能够用一把丢掉的鱼叉，一把折断的刀子，一双受了伤的手去买吗?</p><p>　　“可以的，”他说。“你曾经想用海上的八十 四天去买它。它们也几乎把它卖给了你。”</p><p>　　他想：别再胡思乱吧。运气是各式各样的，谁认得出呢?可是不管什么样的运气我都要点儿，要什么报酬我给什么。他想：我希望我能见到灯光。我想要的事儿太多，但灯光正是我现在想要的。他想靠得舒服些，好好地去掌舵;因为觉得疼痛，他知道他并没有死。</p><p>　　大约在夜里十点钟的时候，他看见了城里的灯火映在天上的红光。最初只是辨认得出，如同月亮初升以前天上的光亮。然后，当渐渐猛烈的海风掀得波涛汹涌的时候，才能从海上把灯光看得清楚。他已经驶进红光里面，他想，现在他马上就要撞到海流的边上了。</p><p>　　他想：现在一切都过去了。不过,也许它们还要向我扑来吧。可是，在黑夜里，没有一件武器，一个人怎么去对付它们呢?</p><p>　　他现在身体又痛又发僵，他的伤口和身上一切用力过度的部分都由于夜里的寒冷而痛得厉害。他想：我希望我不必再去跟它们斗啦。我多么希望我不必再跟它们斗啦。我多么希望我不必跟它们斗呀。</p><p>　　可是到了半夜的时候，他又跟它们斗起来，这一回他知道斗也不会嬴了。它们是成群结队来的，他只看到它们的鳍在水里划出的纹路，看到它们扑到死鱼身上去时所放出的磷光。他用棍棒朝它们的头上打去，听到上下颚裂开和它们钻到船下面去咬鱼时把船晃动的声音。凡是他能够感觉到的，听见的，他就不顾一切地用棍棒劈去。他觉得有什么东西抓住了他的那根棍，随着棍就丢掉了。</p><p>　　他把舵从舵上曳掉，用它去打，去砍，两只手抱住它，一次又一次地劈下去，但是它们已经窜到船头跟前去咬那条死鱼，一忽儿一个接着一个地扑上来的时候，它们把水面下发亮的鱼肉一块一块地撕去了。</p><p>　　最后，一条鲨鱼朝死鱼的头上扑来，他知道一切都完了。于是他用舵把对准鲨鱼的头打去，鲨鱼的两颚正卡在又粗又重的死鱼头上，不能把它咬碎。他又迎面劈去，一次，两次，又一次。他听到舵把折断的声音，再用那裂开了的桨把往鲨鱼身上戳去。他觉得桨把已经戳进去，他知道把子很尖，因此他再把它往里面戳。鲨鱼放开鱼头就翻滚着沉下去。那是来到的一大群里最后的一条鲨鱼。它们再也没有什么东西可吃了。</p><p>　　老头儿现在简直喘不过气来，同时他觉得嘴里有一股奇怪的味道。这种味道带铜味，又甜。他担心了一会儿。不过那种味道并不多。</p><p>　　他往海里啐了一口唾沫，说：“吃吧，星鲨。作你们的梦去，梦见你们弄死了一个人吧。”</p><p>　　他知道他终于给打败了，而且一点补救的办法也没有，于是他走回船梢，发现舵把的断成有缺口的一头还可以安在舵的榫头上，让他凑合着掌舵。他又把麻袋围在肩膀上，然后按照原来的路线把船驶回去。现在他在轻松地驶着船了，他的脑子里不再去想什么，也没有感觉到什么。什么事都已过去，现在只要把船尽可能好好地、灵巧地开往他自己的港口去。夜里，鲨鱼又来咬死鱼的残骸，象一个人从饭桌子上捡面包屑似的。老头儿睬也不睬它们，除了掌舵，什么事儿都不睬。他只注意屋他的船走得多么轻快，多么顺当，没有其重无比的东西在旁边拖累它了</p><p>　　船还是好好的，他想。完完整整，没有半点儿损伤，只除了那个舵把。那是容易配上的。</p><p>　　他感觉到他已经驶进海流里面，看得出海滨居住区的灯光。他知道他现在走到什么地方，到家不算一回事儿。</p><p>　　风总算是我们的朋友，他想。然后他又加上一句：不过也只是有时候。还有大海，那儿有我们的朋友，也有我们的敌人。床呢，他又想。床是我的朋友。正是床啊，他想床真要变成一件了不起的东西。一旦给打败，事情也就容易办了，他想。我决不知道原来有这么容易。可是，是什么把你打败的呢?他又想。</p><p>　　“什么也不是，”他提嗓子说。“是我走得太远啦。”</p><p>　　当他驶进小港的时候，海滨酒店的灯火已经熄灭，他知道人们都已上床睡去。海风越刮越大，现在更是猖狂了。然而港口是静悄悄的。于是他把船向岩石下面的一小块沙滩跟前划去。没有人来帮助他，他只好一个人尽力把船划到岸边。然后他从船里走出,把船系在岩石旁边。</p><p>　　他放下桅杆，卷起了帆，把它捆上，然后把桅杆在肩上, 顺着堤坡往岸上走去。这时他才知道他已经疲乏到什么程度。他在半坡上歇了一会儿，回头望了一望，借着水面映出的街灯的反光，看见那条死鱼的大尾巴挺立在船梢后面。他看见鱼脊骨的赤条条的白线，黑压压一团的头，伸得很长的吻和身上一切光溜溜的部分。</p><p>　　他再往上爬去，一到堤顶上他就跌倒，把桅杆横在肩上躺了一会儿。他试一试想站起来，可是非常困难，于是他就扛着桅杆坐在那儿，一面望着路上。一只猫从远处跑过去，不知在那儿干什么。老头儿直望着它，过一会他才转过来专望着大路。</p><p>　　最后，他放下了桅杆站起来，再把桅杆提起，放在肩上，然后走他的路。在他走到他的茅棚以前，他不得不坐在地上歇了五次。</p><p>　　走进茅棚以后，他把桅杆靠在墙上。他摸黑找到了一个水瓶，喝了一口水就躺到床上去。他把毯子盖到肩上，又裹住脊背和两腿，就脸朝下躺在报纸上，手心朝上，两只胳膊伸得挺直的。</p>', 0, 0, 0, 0, 1676475304879, 0);
INSERT INTO `t_blog` VALUES (14, 1, 20, '奇妙的克隆', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">克隆是什么</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">一个细菌经过20分钟左右就可一分为二；一根葡萄枝切成十段就可能变成十株葡萄；仙人掌切成几块，每块落地就生根；一株草莓依靠它沿地“爬走”的匍匐茎，一年内就能长出数百株草莓苗……凡此种种，都是生物靠自身的一分为二或自身的一小部分的扩大来繁衍后代，这就是无性繁殖。无性繁殖的英文名称叫“Clone”，音译为“克隆”。实际上，英文的“Clone”起源于希腊文“Klone”，原意是用“嫩枝”或“插条”繁殖。时至今日，“克隆”的含义已不仅仅是“无性繁殖”，凡来自一个祖先，无性繁殖出的一群个体，也叫“克隆”。这种来自一个祖先的无性繁殖的后代群体也叫“无性繁殖系”，简称无性系。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">自然界的许多动物，在正常情况下都是依靠父方产生的雄性细胞(精子)与母方产生的雌性细胞(卵子)融合(受精)成受精卵(合子)，再由受精卵经过一系列细胞分裂长成胚胎，最终形成新的个体。这种依靠父母双方提供性细胞、并经两性细胞融合产生后代的繁殖方法就叫有性繁殖。但是，如果我们用外科手术将一个胚胎分割成两块、四块、八块……最后通过特殊的方法使一个胚胎长成两个、四个、八个……生物体，这些生物体就是克隆个体。而这两个、四个、八个……个体就叫做无性繁殖系(也叫克隆)。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">可以这样说，关于克隆的设想，我国明代的大作家吴承恩已有精彩的描述孙悟空经常在紧要关头拔一把猴毛变出一大群猴子，猴毛变猴就是克隆猴。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">克隆鲫鱼出世前后</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">1979年春，中国科学院武汉水生生物研究所的科学家，用鲫鱼囊胚期的细胞进行人工培养，经过385天59代连续传代培养后，用直径10微米左右的玻璃管在显微镜下从培养细胞中吸出细胞核。与此同时，除去鲫鱼卵细胞的核，让卵细胞留出空间做好接纳囊胚细胞核的准备。一切准备就绪后，把玻璃管吸出的核移放到空出位置的鲫鱼卵细胞内。得到了囊胚细胞核的卵细胞在人工培养下大部分夭亡了。在189个这种换核卵细胞中，只有两个孵化出了鱼苗，而最终只有一条幼鱼渡过难关，经过80多天培养后长成8厘米长的鲫鱼。这种鲫鱼并没有经过雌、雄细胞的结合，仅仅是给卵细胞换了个囊胚细胞的核，实际上是由换核卵产生的，因此也是克隆鱼。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">在克隆鲫鱼出现之前，英国牛津大学的科学家已经在1960年和1962年，先后用非洲一种有爪的蟾蜍(非洲爪蟾)进行过克隆试验。试验方式是先用紫外线照射爪蟾卵细胞，破坏其中的核，然后依靠高超的外科手术从爪蟾蝌蚪的肠上皮细胞、肝细胞、肾细胞中取出核，并把这些细胞的核精确地放进已被紫外线破坏了细胞核的卵细胞内。经过精心照料，这些换核卵中终于有一部分长出了活蹦乱跳的爪蟾。这种爪蟾也不是经过精细胞和卵细胞相结合产生的，所以也是克隆爪蟾。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我国著名学者童第周在1978年成功地进行了黑斑蛙的克隆试验。他将黑斑蛙的红细胞的核移入事先除去了核的黑斑蛙卵中，这种换核卵最后长成能在水中自由游泳的蝌蚪。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">鱼类换核技术的成熟和两栖类换核的成功，使一批从事良种培育工作的科学家激动不已。既然鲫鱼的囊胚细胞核取代鲫鱼卵细胞核后能得到克隆鱼，那么异种鱼换核能否得到新的杂种鱼呢?我国科学家首先提出了这个问题，也首先解决了这个问题。就是培养克隆鲫鱼成功的那个研究所，设法把鲤鱼胚胎细胞的核取代了鲫鱼卵细胞的核。鲤鱼细胞核和鲫鱼卵细胞质居然能相安无事，并开始了类似受精卵分裂发育的过程，最后长出有“胡须”的“鲤鲫鱼”。这种鱼有“胡须”，生长快，完全像鲤鱼，但它的侧线鳞片数和脊椎骨的数目与鲫鱼相同，而且鱼味鲜美不亚于鲫鱼。这种人工克隆新鱼种的出现，为鱼类育种开辟了新途径。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">对科学的追求是永无止境的。鱼类、两栖类克隆的成功自然而然地使科学家把目光投向了哺乳类。美国和瑞士的科学家率先从灰色小鼠的胚胎细胞中取出细胞核，用这个核取代黑色小鼠受精卵细胞核。实际上，这个黑色小鼠的受精卵在精细胞核刚进入卵细胞后，就把精细胞核连同卵细胞的核一起除去。灰鼠胚胎细胞的核移入黑色小鼠的去核受精卵后，在试管里人工培养了四天，然后再把它植入白色小鼠的子宫内。经几百次灰、黑、白这样的操作以后，白色小鼠终于生下了三只小灰鼠。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">克隆绵羊“多利”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">1997年英国《自然》杂志公布了爱丁堡罗斯林研究所威尔莫特等人的研究成果：经过247次失败之后，他们在1996年得到了一只名为“多利”的克隆雌性小绵羊。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“多利”绵羊是如何“创造”出来的呢?威尔莫特等学者先给“苏格兰黑面羊”注射促性腺素，促使它排卵。得到卵之后，立即用极细的吸管从卵细胞中取出核。与此同时，从怀孕三个月的“芬多席特”六龄母羊的乳腺细胞中取出核，立即送入取走核的“苏格兰黑面羊”的卵细胞中。手术完成之后，用相同频率的电脉冲刺激换核卵，让“苏格兰黑面羊”的卵细胞质与“芬多席特”母羊乳腺细胞的核相互协调，使这个“组装”细胞在试管里经历受精卵那样的分裂、发育而形成胚胎的过程。然后，将胚胎巧妙地植入另一只母羊的子宫里。到去年7月，这只“护理”体外形成胚胎的母羊终于产下了小绵羊“多利”。“多利”不是由母羊的卵细胞和公羊的精细胞受精的产物，而是“换核卵”一步一步发展的结果，因此是“克隆羊”。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“克隆羊”的诞生，在全世界引起了轰动。它的难能可贵之处在于换进去的是体细胞的核，而不是胚胎细胞核。这个结果证明：动物体中执行特殊功能、具有特定形态的所谓高度分化的细胞与受精卵一样具有发育成完整个体的潜在能力。也就是说，动物细胞与植物细胞一样，也具有全能性。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">克隆技术造福人类</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">克隆技术会给人类带来极大的好处。例如，英国PPL公司已培育出羊奶中含有治疗肺气肿的α-I抗胰蛋白酶的母羊。这种羊奶的售价是6000美元一升。一只母羊就好比一座制药厂。用什么办法能最有效、最方便地使这种羊扩大繁殖呢?最好的办法就是“克隆”。同样，荷兰PHP公司培育出能分泌人乳铁蛋白的牛，以色列LAS公司育成了能生产血清白蛋白的羊。这些高附加值的牲畜如何有效地繁殖?答案当然还是“克隆”。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">母马配公驴可以得到杂种优势特别强的动物骡，然而骡不能繁殖后代，那么，优良的骡如何扩大繁殖?最好的办法也是“克隆”。我国的大熊猫是国宝，但自然交配成功率低，因此已濒临绝种。如何挽救这类珍稀动物?“克隆”为人类提供了切实可行的途径。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">除此之外，克隆动物对于研究癌生物学、研究免疫学、研究人的寿命等都有不可低估的作用。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">不可否认，“克隆绵羊”的问世也引起了许多人对“克隆人”的兴趣。例如，有人在考虑，是否可用自己的细胞克隆成一个胚胎，在其成形前就冰冻起来。在将来的某一天，自身的某个器官出了问题时，就可从胚胎中取出这个器官进行培养，然后替换自己病变的器官。这也就是用克隆法为人类自身提供“配件”。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">有关“克隆人”的讨论提醒人们，科技进步是一首悲喜交集的进行曲。科技越发展，对社会的渗透越广泛深入，就越有可能引起许多有关的伦理、道德和法律等问题。我想用诺贝尔奖获得者、著名分子生物学家J.D.沃森的话来结束本文：“可以期待，许多生物学家，特别是那些从事无性繁殖研究的科学家，将会严肃地考虑它的含意，并展开科学讨论，用以教育世界人民。”</p>', 9, 0, 0, 0, 1676475387395, 0);
INSERT INTO `t_blog` VALUES (15, 1, 20, '藤野先生', '\n				<p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">东京也无非是这样。上野的樱花烂熳的时节，望去确也象绯红的轻云，但花下也缺不了成群结队的“清国留学生”的速成班，头顶上盘着大辫子，顶得学生制帽的顶上高高耸起，形成一座富士山。也有解散辫子，盘得平的，除下帽来，油光可鉴，宛如小姑娘的发髻一般，还要将脖子扭几扭。实在标致极了。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">中国留学生会馆的门房里有几本书买，有时还值得去一转；倘在上午，里面的几间洋房里倒也还可以坐坐的。但到傍晚，有一间的地板便常不免要咚咚咚地响得震天，兼以满房烟尘斗乱；问问精通时事的人，答道，“那是在学跳舞。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">到别的地方去看看，如何呢？</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">我就往仙台的医学专门学校去。从东京出发，不久便到一处驿站，写道：日暮里。不知怎地，我到现在还记得这名目。其次却只记得水户了，这是明的遗民朱舜水先生客死的地方。仙台是一个市镇，并不大；冬天冷得利害；还没有中国的学生。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">大概是物以希为贵罢。北京的白菜运往浙江，便用红头绳系住菜根，倒挂在水果店头，尊为“胶菜”；福建野生着的芦荟，一到北京就请进温室，且美其名曰“龙舌兰”。我到仙台也颇受了这样的优待，不但学校不收学费，几个职员还为我的食宿操心。我先是住在监狱旁边一个客店里的，初冬已经颇冷，蚊子却还多，后来用被盖了全身，用衣服包了头脸，只留两个鼻孔出气。在这呼吸不息的地方，蚊子竟无从插嘴，居然睡安稳了。饭食也不坏。但一位先生却以为这客店也包办囚人的饭食，我住在那里不相宜，几次三番，几次三番地说。我虽然觉得客店兼办囚人的饭食和我不相干，然而好意难却，也只得别寻相宜的住处了。于是搬到别一家，离监狱也很远，可惜每天总要喝难以下咽的芋梗汤。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">从此就看见许多陌生的先生，听到许多新鲜的讲义。解剖学是两个教授分任的。最初是骨学。其时进来的是一个黑瘦的先生，八字须，戴着眼镜，挟着一迭大大小小的书。一将书放在讲台上，便用了缓慢而很有顿挫的声调，向学生介绍自己道：——</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“我就是叫作藤野严九郎的……。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\"><img src=\"http://5b0988e595225.cdn.sohucs.com/images/20180902/eee15c0872e04c04a51919bfae215402.jpeg\" style=\"margin: 10px auto 0px; padding: 0px; display: block; max-width: 100%; width: 25%; float: right;\" class=\"note-float-right\"></p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">后面有几个人笑起来了。他接着便讲述解剖学在日本发达的历史，那些大大小小的书，便是从最初到现今关于这一门学问的著作。起初有几本是线装的；还有翻刻中国译本的，他们的翻译和研究新的医学，并不比中国早。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">那坐在后面发笑的是上学年不及格的留级学生，在校已经一年，掌故<span style=\"border: 0px; margin: 0px; padding: 0px;\">15</span>颇为熟悉的了。他们便给新生讲演每个教授的历史。这藤野先生，据说是穿衣服太模胡了，有时竟会忘记带领结；冬天是一件旧外套，寒颤颤的，有一回上火车去，致使管车的疑心他是扒手，叫车里的客人大家小心些。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">他们的话大概是真的，我就亲见他有一次上讲堂没有带领结。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">过了一星期，大约是星期六，他使助手来叫我了。到得研究室，见他坐在人骨和许多单独的头骨中间，——他其时正在研究着头骨，后来有一篇论文在本校的杂志上发表出来。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“我的讲义，你能抄下来么？”他问。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“可以抄一点。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“拿来我看！”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">我交出所抄的讲义去，他收下了，第二三天便还我，并且说，此后每一星期要送给他看一回。我拿下来打开看时，很吃了一惊，同时也感到一种不安和感激。原来我的讲义已经从头到末，都用红笔添改过了，不但增加了许多脱漏的地方，连文法的错误，也都一一订正。这样一直继续到教完了他所担任的功课：骨学、血管学、神经学。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">可惜我那时太不用功，有时也很任性。还记得有一回藤野先生将我叫到他的研究室里去，翻出我那讲义上的一个图来，是下臂的血管，指着，向我和蔼的说道：——</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“你看，你将这条血管移了一点位置了。——自然，这样一移，的确比较的好看些，然而解剖图不是美术，实物是那么样的，我们没法改换它。现在我给你改好了，以后你要全照着黑板上那样的画。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">但是我还不服气，口头答应着，心里却想道：——</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“图还是我画的不错；至于实在的情形，我心里自然记得的。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">学年试验完毕之后，我便到东京玩了一夏天，秋初再回学校，成绩早已发表了，同学一百余人之中，我在中间，不过是没有落第<span style=\"border: 0px; margin: 0px; padding: 0px;\">16</span>。这回藤野先生所担任的功课，是解剖实习和局部解剖学。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">解剖实习了大概一星期，他又叫我去了，很高兴地，仍用了极有抑扬的声调对我说道：——</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“我因为听说中国人是很敬重鬼的，所以很担心，怕你不肯解剖尸体。现在总算放心了，没有这回事。”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">但他也偶有使我很为难的时候。他听说中国的女人是裹脚的，但不知道详细，所以要问我怎么裹法，足骨变成怎样的畸形，还叹息道，“总要看一看才知道。究竟是怎么一回事呢？”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">有一天，本级的学生会干事到我寓里来了，要借我的讲义看。我检出来交给他们，却只翻检了一通，并没有带走。但他们一走，邮差就送到一封很厚的信，拆开看时，第一句是：——</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“你改悔罢！”</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">这是《新约》上的句子罢，但经托尔斯泰新近引用过的。其时正值日俄战争，托老先生便写了一封给俄国和日本的皇帝的信，开首便是这一句。日本报纸上很斥责他的不逊，爱国青年也愤然，然而暗地里却早受了他的影响了。其次的话，大略是说上年解剖学试验的题目，是藤野先生讲义上做了记号，我预先知道的，所以能有这样的成绩。末尾是匿名。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">我这才回忆到前几天的一件事。因为要开同级会，干事便在黑板上写广告，末一句是“请全数到会勿漏为要”，而且在“漏”字旁边加了一个圈。我当时虽然觉到圈得可笑，但是毫不介意，这回才悟出那字也在讥刺我了，犹言我得了教员漏泄出来的题目。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">我便将这事告知了藤野先生；有几个和我熟识的同学也很不平，一同去诘责<span style=\"border: 0px; margin: 0px; padding: 0px;\">22</span>干事托辞检查的无礼，并且要求他们将检查的结果，发表出来。终于这流言消灭了，干事却又竭力运动，要收回那一封匿名信去。结末是我便将这托尔斯泰式的信退还了他们。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">中国是弱国，所以中国人当然是低能儿，分数在六十分以上，便不是自己的能力了：也无怪他们疑惑。但我接着便有参观枪毙中国人的命运了。第二年添教霉菌学，细菌的形状是全用电影来显示的，一段落已完而还没有到下课的时候，便影几片时事的片子，自然都是日本战胜俄国的情形。但偏有中国人夹在里边：给俄国人做侦探，被日本军捕获，要枪毙了，围着看的也是一群中国人；在讲堂里的还有一个我。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“万岁！”他们都拍掌欢呼起来。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">这种欢呼，是每看一片都有的，但在我，这一声却特别听得刺耳。此后回到中国来，我看见那些闲看枪毙犯人的人们，他们也何尝不酒醉似的喝彩，——呜呼，无法可想！但在那时那地，我的意见却变化了。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">到第二学年的终结，我便去寻藤野先生，告诉他我将不学医学，并且离开这仙台。他的脸色仿佛有些悲哀，似乎想说话，但竟没有说。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“我想去学生物学，先生教给我的学问，也还有用的。”其实我并没有决意要学生物学，因为看得他有些凄然，便说了一个慰安他的谎话。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">“为医学而教的解剖学之类，怕于生物学也没有什么大帮助。”他叹息说。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">将走的前几天，他叫我到他家里去，交给我一张照相，后面写着两个字道：“惜别”，还说希望将我的也送他。但我这时适值没有照相了；他便叮嘱我将来照了寄给他，并且时时通信告诉他此后的状况。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">我离开仙台之后，就多年没有照过相，又因为状况也无聊，说起来无非使他失望，便连信也怕敢写了。经过的年月一多，话更无从说起，所以虽然有时想写信，却又难以下笔，这样的一直到现在，竟没有寄过一封信和一张照片。从他那一面看起来，是一去之后，杳无消息了。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">但不知怎地，我总还时时记起他，在我所认为我师的之中，他是最使我感激，给我鼓励的一个。有时我常常想：他的对于我的热心的希望，不倦的教诲，小而言之，是为中国，就是希望中国有新的医学；大而言之，是为学术，就是希望新的医学传到中国去。他的性格，在我的眼里和心里是伟大的，虽然他的姓名并不为许多人所知道。</p><p style=\"border: 0px; margin-top: 0.63em; margin-bottom: 1.8em; padding: 0px; font-size: 16px; counter-reset: list-1 0 list-2 0 list-3 0 list-4 0 list-5 0 list-6 0 list-7 0 list-8 0 list-9 0; color: rgb(25, 25, 25); font-family: ‘PingFang SC‘, Arial, 微软雅黑, 宋体, simsun, sans-serif;\">他所改正的讲义，我曾经订成三厚本，收藏着的，将作为永久的纪念。不幸七年前迁居的时候，中途毁坏了一口书箱，失去半箱书，恰巧这讲义也遗失在内了。责成运送局去找寻，寂无回信。只有他的照相至今还挂在我北京寓居的东墙上，书桌对面。每当夜间疲倦，正想偷懒时，仰面在灯光中瞥见他黑瘦的面貌，似乎正要说出抑扬顿挫的话来，便使我忽又良心发现，而且增加勇气了，于是点上一枝烟，再继续写些为“正人君子”之流所深恶痛疾的文字。</p>\n			', 2, 0, 0, 0, 1676475488315, 1677847059105);
INSERT INTO `t_blog` VALUES (16, 1, 20, '繁星', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我爱月夜，但我也爱星天。从前在家乡七、八月的夜晚在庭院里纳凉的时候，我最爱看天上密密麻麻的繁星。望着星天，我就会忘记一切，仿佛回到了母亲的怀里似的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">三年前在南京我住的地方有一道后门，每晚我打开后门，便看见一个静寂的夜。下面是一片菜园，上面是星群密布的蓝天。星光在我们的肉眼里虽然微小，然而它使我们觉得光明无处不在。那时候我正在读一些关于天文学的书，也认得一些星星，好像它们就是我的朋友，它们常常在和我谈话一样。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">如今在海上，每晚和繁星相对，我把它们认得很熟了。我躺在舱面上，仰望天空。深蓝色的天空里悬着无数半明半昧的星。船在动，星也在动，它们是这样低，真是摇摇欲坠呢！渐渐地我的眼睛模糊了，我好像看见无数萤火虫在我的周围飞舞。海上的夜是柔和的，是静寂的，是梦幻的。我望着那许多认识的星，我仿佛看见它们在对我霎眼，我仿佛听见它们在小声说话。这时我忘记了一切。在星的怀抱中我微笑着，我沉睡着。我觉得自己是一个小孩子，现在睡在母亲的怀里了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">有一夜，那个在哥伦波上船的英国人指给我看天上的巨人。他用手指着：那四颗明亮的星是头，下面的几颗是身子，这几颗是手，那几颗是腿和脚，还有三颗星算是腰带。经他这一番指点，我果然看清楚了那个天上的巨人。看，那个巨人还在跑呢！</p>', 30, 11, 7, 10, 1676475657843, 0);
INSERT INTO `t_blog` VALUES (17, 1, 20, '故乡', '\n				\n				<p style=\"text-indent:2em;\">我冒了严寒，回到相隔2000余里，别了20余年的故乡去。</p><p style=\"text-indent:2em;\">时候既然是深冬；渐近故乡时，天气又阴晦了，冷风吹进船舱中，呜呜的响，从篷隙向外一望，苍黄的天底下，远近横着几个肃索的荒村，没有一些活气。我的心禁不住悲凉起来了。</p><p style=\"text-indent:2em;\">阿！这不是我20年来时时记得的故乡？</p><p style=\"text-indent:2em;\">我所记得的故乡全不如此。我的故乡好得多了。但要我记起他的美丽，说出他的佳处来，却又没有影像，没有言辞了。仿佛也就如此。于是我自己解释说：故乡本也如此-虽然没有进步，也未必有如我所感的悲凉，这只是我自己心情的改变罢了，因为我这次回乡，本没有什么好心绪。</p><p style=\"text-indent:2em;\">我这次是专为了别他而来的。我们多年聚族而居的老屋，已经公同卖给别姓了，交屋的期限，只在本年，所以必须赶在正月以前，永别了熟识的老屋，而且远离了熟识的故乡，搬家到我在谋食的异地去。</p><p style=\"text-indent:2em;\">第二日清早晨我到了我家的门口了。瓦楞上许多枯草的断茎当风抖着，正在说明这老屋难免易主的原因。几房的本家大约已经搬走了，所以很寂静。我到了自家的房外，我的母亲早已迎着出来了，接着便飞出了八岁的侄儿宏儿。</p><p style=\"text-indent:2em;\">我的母亲很高兴，但也藏着许多凄凉的神情，教我坐下，歇息，喝茶，且不谈搬家的事。宏儿没有见过我，远远的对面站着只是看。</p><p style=\"text-indent:2em;\">但我们终于谈到搬家的事。我说外间的寓所已经租定了，又买了几件家具，此外须将家里所有的木器卖去，再去增添。母亲也说好，而且行李也略已齐集，木器不便搬运的，也小半卖去了，只是收不起钱来。</p><p style=\"text-indent:2em;\">\"你休息一两天，去拜望亲戚本家一回，我们便可以走了。\"母亲说。</p><p style=\"text-indent:2em;\">\"是的。\"</p><p style=\"text-indent:2em;\">\"还有闰土，他每到我家来时，总问起你，很想见你一回面。我已经将你到家的大约日期通知他，他也许就要来了。\"</p><p style=\"text-indent:2em;\">这时候，我的脑里忽然闪出一幅神异的图画来：深蓝的天空中挂着一轮金黄的圆月，下面是海边的沙地，都种着一望无际的碧绿的西瓜，其间有一个十一二岁的少年，项带银圈，手捏一柄钢叉，向一匹猹尽力的刺去，那猹却将身一扭，反从他的胯下逃走了。</p><img src=\"data:image/jpeg;base64,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\" width=\"440\" height=\"290\" style=\"float: right;\" class=\"note-float-right\"><p style=\"text-indent:2em;\">这少年便是闰土。我认识他时，也不过十多岁，离现在将有30年了；那时我的父亲还在世，家景也好，我正是一个少爷。那一年，我家是一件大祭祀的值年。这祭祀，说是30多年才能轮到一回，所以很郑重；正月里供祖像，供品很多，祭器很讲究，拜的人也很多，祭器也很要防偷去。我家只有一个忙月（我们这里给人做工的分三种：整年给一定人家做工的叫长年；按日给人做工的叫短工；自己也种地，只在过年过节以及收租时候来给一定的人家做工的称忙月），忙不过来，他便对父亲说，可以叫他的儿子闰土来管祭器的。</p><p style=\"text-indent:2em;\"></p><p style=\"text-indent:2em;\">我的父亲允许了；我也很高兴，因为我早听到闰土这名字，而且知道他和我仿佛年纪，闰月生的，五行缺土，所以他的父亲叫他闰土。他是能装捉小鸟雀的。</p><p style=\"text-indent:2em;\">我于是日日盼望新年，新年到，闰土也就到了。好容易到了年末，有一日，母亲告诉我，闰土来了，我便飞跑的去看。他正在厨房里，紫色的圆脸，头戴一顶小毡帽，颈上套一个明晃晃的银项圈，这可见他的父亲十分爱他，怕他死去，所以在神佛面前许下愿心，用圈子将他套住了。他见人很怕羞，只是不怕我，没有旁人的时候，便和我说话，于是不到半日，我们便熟识了。</p><p style=\"text-indent:2em;\">我们那时候不知道谈些什么，只记得闰土很高兴，说是上城之后，见了许多没有见过的东西。</p><p style=\"text-indent:2em;\">第二日，我便要他捕鸟。他说：</p><p style=\"text-indent:2em;\">\"这不能。须大雪下了才好。我们沙地上，下了雪，我扫出一块空地来，用短棒支起一个大竹匾，撒下秕谷，看鸟雀来吃时，我远远地将缚在棒上的绳子只一拉，那鸟雀就罩在竹匾下了。什么都有：稻鸡，角鸡，鹁鸪，蓝背......\"</p><p style=\"text-indent:2em;\">我于是又很盼望下雪。</p><p style=\"text-indent:2em;\">闰土又对我说：</p><p style=\"text-indent:2em;\">\"现在太冷，你夏天到我们这里来。我们日里到海边检鬼见怕也有，观音后也有。晚上我和爹管西瓜去，你也去。\"</p><p style=\"text-indent:2em;\">\"管贼么？\"</p><p style=\"text-indent:2em;\">\"不是。走路的人口渴了摘一个瓜吃，我们这里是不算偷的。要管的是獾猪，刺猬，猹。月亮地下，你听，啦啦的响了，猹在咬瓜了。你便捏了胡叉，轻轻地走去......\"</p><p style=\"text-indent:2em;\">我那时并不知道这所谓猹的是怎么一件东西-便是现在也没有知道--只是无端的觉得状如小狗而很凶猛。</p><p style=\"text-indent:2em;\">\"他不咬人么？\"</p><p style=\"text-indent:2em;\">\"有胡叉呢。走到了，看见猹了，你便刺。这畜生很伶俐，倒向你奔来，反从胯下窜了。他的皮毛是油一般的滑......\"</p><p style=\"text-indent:2em;\">我素不知道天下有这许多新鲜事：海边有如许五色的贝壳；西瓜有这样危险的经历，我先前单知道他在水果店里出卖罢了。</p><p style=\"text-indent:2em;\">\"我们沙地里，潮汛要来的时候，就有许多跳鱼儿只是跳，都有青蛙似的两个脚......\"</p><p style=\"text-indent:2em;\">阿！闰土的心里有无穷无尽的希奇的事，都是我往常的朋友所不知道的。他们不知道一些事，闰土在海边时，他们都和我一样只看见院子里高墙上的四角的天空。</p><p style=\"text-indent:2em;\">可惜正月过去了，闰土须回家里去，我急得大哭，他也躲到厨房里，哭着不肯出门，但终于被他父亲带走了。他后来还托他的父亲带给我一包贝壳和几支很好看的鸟毛，我也曾送他一两次东西，但从此没有再见面。</p><p style=\"text-indent:2em;\">现在我的母亲提起了他，我这儿时的记忆，忽而全都闪电似的苏生过来，似乎看到了我的美丽的故乡了。我应声说：</p><p style=\"text-indent:2em;\">\"这好极！他，--怎样？......\"</p><p style=\"text-indent:2em;\">\"他？......他景况也很不如意......\"母亲说着，便向房外看，\"这些人又来了。说是买木器，顺手也就随便拿走的，我得去看看。\"</p><p style=\"text-indent:2em;\">母亲站起身，出去了。门外有几个女人的声音。我便招宏儿走近面前，和他闲话：问他可会写字，可愿意出门。</p><p style=\"text-indent:2em;\">\"我们坐火车去么？\"　　\"我们坐火车去。\"</p><p style=\"text-indent:2em;\">\"船呢？\"</p><p style=\"text-indent:2em;\">\"先坐船，......\"</p><p style=\"text-indent:2em;\">\"哈！这模样了！胡子这么长了！\"一种尖利的怪声突然大叫起来。</p><p style=\"text-indent:2em;\">我吃了一吓，赶忙抬起头，却见一个凸颧骨，薄嘴唇，50岁上下的女人站在我面前，两手搭在髀间，没有系裙，张着两脚，正像一个画图仪器里细脚伶仃的圆规。</p><p style=\"text-indent:2em;\">我愕然了。</p><p style=\"text-indent:2em;\">\"不认识了么？我还抱过你咧！\"</p><p style=\"text-indent:2em;\">我愈加愕然了。幸而我的母亲也就进来，从旁说：\"他多年出门，统忘却了。你该记得罢，\"便向着我说，\"这是斜对门的杨二嫂，......开豆腐店的。\"</p><p style=\"text-indent:2em;\">哦，我记得了。我孩子时候，在斜对门的豆腐店里确乎终日坐着一个杨二嫂，人都叫伊\"豆腐西施\"。但是擦着白粉，颧骨没有这么高，嘴唇也没有这么薄，而且终日坐着，我也从没有见过这圆规式的姿势。那时人说：因为伊，这豆腐店的买卖非常好。但这大约因为年龄的关系，我却并未蒙着一毫感化，所以竟完全忘却了。然而圆规很不平，显出鄙夷的神色，仿佛嗤笑法国人不知道拿破仑，美国人不知道华盛顿似的，冷笑说：\"忘了？这真是贵人眼高......\"</p><p style=\"text-indent:2em;\">\"那有这事......我......\"我惶恐着，站起来说。</p><p style=\"text-indent:2em;\"><span style=\"text-indent: 0px;\">\"那么，我对你说。迅哥儿，你阔了，搬动又笨重，你还要什么这些破烂木器，让我拿去罢。我们小户人家，用得着。\"</span></p><p style=\"text-indent:2em;\"></p><p style=\"text-indent:2em;\">\"我并没有阔哩。我须卖了这些，再去......\"</p><p style=\"text-indent:2em;\">\"阿呀呀，你放了道台了，还说不阔？你现在有三房姨太太；出门便是八抬的大轿，还说不阔？吓，什么都瞒不过我。\"</p><p style=\"text-indent:2em;\">我知道无话可说了，便闭了口，默默的站着。</p><p style=\"text-indent:2em;\">\"阿呀阿呀，真是愈有钱，便愈是一毫不肯放松，愈是一毫不肯放松，便愈有钱......\"圆规一面愤愤的回转身，一面絮絮的说，慢慢向外走，顺便将我母亲的一副手套塞在裤腰里，出去了。</p><p style=\"text-indent:2em;\">此后又有近处的本家和亲戚来访问我。我一面应酬，偷空便收拾些行李，这样的过了三四天。</p><p style=\"text-indent:2em;\">一日是天气很冷的午后，我吃过午饭，坐着喝茶，觉得外面有人进来了，便回头去看。我看时，不由的非常出惊，慌忙站起身，迎着走去。</p><p style=\"text-indent:2em;\">这来的便是闰土。虽然我一见便知道是闰土，但又不是我这记忆上的闰土了。他身材增加了一倍；先前的紫色的圆脸，已经变作灰黄，而且加上了很深的皱纹；眼睛也像他父亲一样，周围都肿得通红，这我知道，在海边种地的人，终日吹着海风，大抵是这样的。他头上是一顶破毡帽，身上只一件极薄的棉衣，浑身瑟索着；手里提着一个纸包和一支长烟管，那手也不是我所记得的红活圆实的手，却又粗又笨而且开裂，像是松树皮了。</p><p style=\"text-indent:2em;\">我这时很兴奋，但不知道怎么说才好，只是说：\"阿！闰土哥，--你来了？......\"</p><p style=\"text-indent:2em;\">我接着便有许多话，想要连珠一般涌出：角鸡，跳鱼儿，贝壳，猹，......但又总觉得被什么挡着似的，单在脑里面回旋，吐不出口外去。</p><p style=\"text-indent:2em;\">他站住了，脸上现出欢喜和凄凉的神情；动着嘴唇，却没有作声。他的态度终于恭敬起来了，分明的叫道：\"老爷！......\"</p><p style=\"text-indent:2em;\">我似乎打了一个寒噤；我就知道，我们之间已经隔了一层可悲的厚障壁了。我也说不出话。</p><p style=\"text-indent:2em;\">他回过头去说，\"水生，给老爷磕头。\"便拖出躲在背后的孩子来，这正是一个廿年前的闰土，只是黄瘦些，颈子上没有银圈罢了。\"这是第五个孩没有见过世面，躲躲闪闪......\"</p><p style=\"text-indent:2em;\">母亲和宏儿下楼来了，他们大约也听到了声音。</p><p style=\"text-indent:2em;\">\"老太太。信是早收到了。我实在喜欢的了不得，知道老爷回来......\"闰土说。</p><p style=\"text-indent:2em;\"></p><p style=\"text-indent:2em;\">\"阿，你怎的这样客气起来。你们先前不是哥弟称呼么？还是照旧：迅哥儿。\"母亲高兴的说。</p><p style=\"text-indent:2em;\">\"阿呀，老太太真是......这成什么规矩。那时是孩子，不懂事......\"闰土说着，又叫水生上来打拱，那孩子害羞，紧紧的只贴在他背后。</p><p style=\"text-indent:2em;\">\"他就是水生？第五个？都是生人，怕生也难怪的；还是宏儿和他去走走。\"母亲说。</p><p style=\"text-indent:2em;\">宏儿听得这话，便来招水生，水生却松松爽爽同他一路出去了。母亲叫闰土坐，他迟疑了回，终于就了坐，将长烟管靠在桌旁，递过纸包来，说：\"冬天没有什么东西了。这一点干青豆倒是自家晒在那里的，请老爷......\"</p><p style=\"text-indent:2em;\">我问问他的景况。他只是摇头。</p><p style=\"text-indent:2em;\">\"非常难。第六个孩子也会帮忙了，却总是吃不够......又不太平......什么地方都要钱，没有定规......收成又坏。种出东西来，挑去卖，总要捐几回钱，折了本；不去卖，又只能烂掉......\"</p><p style=\"text-indent:2em;\">他只是摇头；脸上虽然刻着许多皱纹，却全然不动，仿佛石像一般。他大约只是觉得苦，却又形容不出，沉默了片时，便拿起烟管来默默的吸烟了。</p><p style=\"text-indent:2em;\">母亲问他，知道他的家里事务忙，明天便得回去；又没有吃过午饭，便叫他自己到厨下炒饭吃去。</p><p style=\"text-indent:2em;\">他出去了；母亲和我都叹息他的景况：多子，饥荒，苛税，兵，匪，官，绅，都苦得他像一个木偶人了。母亲对我说，凡是不必搬走的东西，尽可以送他，可以听他自己去拣择。</p><p style=\"text-indent:2em;\">下午，他拣好了几件东西：两条长桌，四个椅子，一副香炉和烛台，一杆抬秤。他又要所有的草灰（我们这里煮饭是烧稻草的，那灰，可以做沙地的肥料），待我们启程的时候，他用船来载去。</p><p style=\"text-indent:2em;\">夜间，我们又谈些闲天，都是无关紧要的话；第二天早晨，他就领了水生回去了。</p><p style=\"text-indent:2em;\">又过了九日，是我们启程的日期。闰土早晨便到了，水生没有同来，却只带着一个五岁的女儿管船只。我们终日很忙碌，再没有谈天的工夫。来客也不少，有送行的，有拿东西的，有送行兼拿东西的。待到傍晚我们上船的时候，这老屋里的所有破旧大小粗细东西，已经一扫而空了。</p><p style=\"text-indent:2em;\">我们的船向前走，两岸的青山在黄昏中，都装成了深黛颜色，连着退向船后梢去。</p><p style=\"text-indent:2em;\">宏儿和我靠着船窗，同看外面模糊的风景，他忽然问道：\"大伯！我们什么时候回来？\"<span style=\"text-indent: 2em;\">\"回来？你怎么还没有走就想回来了。\"</span></p><p style=\"text-indent:2em;\">\"可是，水生约我到他家玩去咧......\"他睁着大的黑眼睛，痴痴的想。</p><p style=\"text-indent:2em;\">我和母亲也都有些惘然，于是又提起闰土来。母亲说，那豆腐西施的杨二嫂，自从我家收拾行李以来，本是每日必到的，前天伊在灰堆里，掏出十多个碗碟来，议论之后，便定说是闰土埋着的，他可以在运灰的时候，一齐搬回家里去；杨二嫂发见了这件事，自已很以为功，便拿了那狗气杀（这是我们这里养鸡的器具，木盘上面有着栅栏，内盛食料，鸡可以伸进颈子去啄，狗却不能，只能看着气死），飞也似的跑了，亏伊装着这么高底的小脚，竟跑得这样快。</p><p style=\"text-indent:2em;\">老屋离我愈远了；故乡的山水也都渐渐远离了我，但我却并不感到怎样的留恋。我只觉得我四面有看不见的高墙，将我隔成孤身，使我非常气闷；那西瓜地上的银项圈的小英雄的影像，我本来十分清楚，现在却忽地模糊了，又使我非常的悲哀。</p><p style=\"text-indent:2em;\">母亲和宏儿都睡着了。</p><p style=\"text-indent:2em;\">我躺着，听船底潺潺的水声，知道我在走我的路。我想：我竟与闰土隔绝到这地步了，但我们的后辈还是一气，宏儿不是正在想念水生么。我希望他们不再像我，又大家隔膜起来......然而我又不愿意他们因为要一气，都如我的辛苦展转而生活，也不愿意他们都如闰土的辛苦麻木而生活，也不愿意都如别人的辛苦恣睢而生活。他们应该有新的生活，为我们所未经生活过的。</p><p style=\"text-indent:2em;\">我想到希望，忽然害怕起来了。闰土要香炉和独台的时候，我还暗地里笑他，以为他总是崇拜偶像，什么时候都不忘却。现在我所谓希望，不也是我自己手制的偶像么？只是他的愿望切近，我的愿望茫远罢了。</p><p style=\"text-indent:2em;\">我在蒙中，眼前展开一片海边碧绿的沙地来，上面深蓝的天空中挂着一轮金黄的圆月。我想：希望是本无所谓有，无所谓无的。这正如地上的路；其实地上本没有路，走的人多了，也便成了路。</p><p style=\"text-indent:2em;\">一九二一年一月。</p>\n			\n			', 64, 10, 4, 10, 1676477110864, 1677946928125);
INSERT INTO `t_blog` VALUES (18, 1, 20, '春', '\n				<p style=\"text-align: center; padding: 0px; line-height: 28px;\"><img src=\"data:image/jpeg;base64,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\" class=\"note-float-right\" style=\"float: right; margin: 20px;\"></p><div style=\"text-align: left;\">　　盼望着，盼望着，东风来了，春天的脚步近了。</div><p></p><p style=\"padding: 0px; line-height: 28px;\">　　一切都像刚睡醒的样子，欣欣然张开了眼。山朗润起来了，水涨起来了，太阳的脸红起来了。</p><p style=\"padding: 0px; line-height: 28px;\">　　小草偷偷地从土里钻出来，嫩嫩的，绿绿的。园子里，田野里，瞧去，一大片一大片满是的。坐着，躺着，打两个滚，踢几脚球，赛几趟跑，捉几回迷藏。风轻悄悄的，草软绵绵的。</p><p style=\"padding: 0px; line-height: 28px;\">　　桃树、杏树、梨树，你不让我，我不让你，都开满了花赶趟儿。红的像火，粉的像霞，白的像雪。花里带着甜味；闭了眼，树上仿佛已经满是桃儿、杏儿、梨儿。花下成千成百的蜜蜂嗡嗡地闹着，大小的蝴蝶飞来飞去。野花遍地是：杂样儿，有名字的，没名字的，散在草丛里，像眼睛，像星星，还眨呀眨的。</p><p style=\"padding: 0px; line-height: 28px;\">　　“吹面不寒杨柳风”，不错的，像母亲的手抚摸着你。风里带来些新翻的泥土的气息，混着青草味，还有各种花的香，都在微微润湿的空气里酝酿。鸟儿将巢安在繁花嫩叶当中，高兴起来了，呼朋引伴地卖弄清脆的喉咙，唱出宛转的曲子，与轻风流水应和着。牛背上牧童的短笛，这时候也成天在嘹亮地响着。</p><p style=\"padding: 0px; line-height: 28px;\">　　雨是最寻常的，一下就是三两天。可别恼。看，像牛毛，像花针，像细丝，密密地斜织着，人家屋顶上全笼着一层薄烟。树叶子却绿得发亮，小草也青得逼你的眼。傍晚时候，上灯了，一点点黄晕的光，烘托出一片安静而和平的夜。乡下去，小路上，石桥边，撑起伞慢慢走着的人；还有地里工作的农夫，披着簔，戴着笠的。他们的房屋，稀稀疏疏的，在雨里静默着。</p><p style=\"padding: 0px; line-height: 28px;\">　　天上风筝渐渐多了，地上孩子也多了。城里乡下，家家户户，老老小小，他们也赶趟儿似的，一个个都出来了。舒活舒活筋骨，抖擞抖擞精神，各做各的一份事去。“一年之计在于春”；刚起头儿，有的是工夫，有的是希望。</p><p style=\"padding: 0px; line-height: 28px;\">　　春天像刚落地的娃娃，从头到脚都是新的，他生长着。</p><p style=\"padding: 0px; line-height: 28px;\">　　春天像小姑娘，花枝招展的，笑着，走着。</p><p style=\"padding: 0px; line-height: 28px;\">　　春天像健壮的青年，有铁一般的胳膊和腰脚，领着我们上前去。</p>\n			', 3, 2, 0, 1, 1676477792037, 1677846954662);
INSERT INTO `t_blog` VALUES (19, 1, 20, '匆匆', '\n				<img src=\"data:image/jpeg;base64,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\" style=\"margin: 10px; float: right;\" class=\"note-float-right\"><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">燕子去了，有再来的时候；杨柳枯了，有再青的时候；桃花谢了，有再开的时候。但是，聪明的，你告诉我，我们的日子为什么一去不复返呢？——是有人偷了他们罢：那是谁？又藏在何处呢？是他们自己逃走了罢：现在又到了哪里呢？</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我不知道他们给了我多少日子；但我的手确乎是渐渐空虚了。在默默里算着，八千多日子已经从我手中溜去；像针尖上一滴水滴在大海里，我的日子滴在时间的流里，没有声音，也没有影子。我不禁头涔涔而泪潸潸了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">去的尽管去了，来的尽管来着；去来的中间，又怎样地匆匆呢？早上我起来的时候，小屋里射进两三方斜斜的太阳。太阳他有脚啊，轻轻悄悄地挪移了；我也茫茫然跟着旋转。于是——洗手的时候，日子从水盆里过去；吃饭的时候，日子从饭碗里过去；默默时，便从凝然的双眼前过去。我觉察他去的匆匆了，伸出手遮挽时，他又从遮挽着的手边过去，天黑时，我躺在床上，他便伶伶俐俐地从我身上跨过，从我脚边飞去了。等我睁开眼和太阳再见，这算又溜走了一日。我掩着面叹息。但是新来的日子的影儿又开始在叹息里闪过了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">在逃去如飞的日子里，在千门万户的世界里的我能做些什么呢？只有徘徊罢了，只有匆匆罢了；在八千多日的匆匆里，除徘徊外，又剩些什么呢？过去的日子如轻烟，被微风吹散了，如薄雾，被初阳蒸融了；我留着些什么痕迹呢？我何曾留着像游丝样的痕迹呢？我赤裸裸来到这世界，转眼间也将赤裸裸的回去罢？但不能平的，为什么偏要白白走这一遭啊？</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">你聪明的，告诉我，我们的日子为什么一去不复返呢？</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p>\n			', 5, 1, 1, 1, 1676478305170, 1677846548601);
INSERT INTO `t_blog` VALUES (20, 1, 20, '月亮上的足迹', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">在茫茫太空，月亮是地球的近邻。虽说是近邻，离地球也有38万公里，真是可望而不可即。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">然而，1969年7月，美国宇航员阿姆斯特朗、科林斯、奥尔德林终于代表全人类拜访了月球，迈开了人类探索太空的重要一步，树起了宇航事业的一块新的里程碑。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这一年的7月16日，美国佛罗里达半岛中部的肯尼迪航天中心的火箭发射架上，“土星5号”火箭像巨人一样昂首挺立着，尖端直指蓝天，高达一百多米。它将推动“阿波罗11号”飞船进入太空。地面服务人员已经为它的三级燃料罐加满了燃料，第一级火箭加进了煤油，第二级和第三级加进了液氧液氢。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">飞船指令长阿姆斯特朗、指令舱驾驶员科林斯和登月舱驾驶员奥尔德林在宇航中心的食堂里吃了早饭，穿上了宇航服。一个伟大的时刻就要来到了，他们就要踏上探索月球的征程。他们同前来送行的人们一一道别。这将是人类进行的距离最为遥远的一次旅行。他们健步来到发射架下，乘上电梯，来到指令舱前，进入狭小的指令舱。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">地勤人员对火箭作了极为仔细的检查，情况一切正常。指挥中心发出点火指令，计算机开始自动工作。自动点火装置点燃了点火器，“土星5号”发出隆隆的声音，大地剧烈地震动起来，火箭缓缓上升，不断加速。三位宇航员躺在舱内，观察着各种仪表的读数。此时，他们承受着巨大的压力，那是由于火箭的加速而引起的超重力。发射后2分42秒，第一级火箭自动脱落，二三两级火箭继续上升。达到182公里高度时，第二级火箭自动脱落，速度达到每秒68公里。离地9分5秒，第三级火箭发动机启动工作，飞船在预定的时间、预定的高度进入预定的轨道。此刻，“阿波罗11号”飞船的高度为2650公里，速度为每秒767公里。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">飞船进入预定的轨道后，先绕着地球飞行，以便检测飞船是否正常，能否向月球飞行。根据飞行状况的测定，休斯敦地面指挥中心发出了向月球进军的指令。于是，第三级火箭再次发动，使速度达到每秒105公里，进入登月轨道，向着月球奔去。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">三名宇航员在舱内吃了晚饭。在发射后13小时30分开始平静地进入梦乡。地面站停止对他们发出指令，以免干扰他们的好梦。他们必须好好休息，因为要成功地进行登月飞行，没有良好的体力和精力是不行的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">飞船像一叶孤舟在太空中缓缓地行驶。它飞过了月亮和地球距离的中间点，19日晚上8点33分，又飞过了月亮和地球引力的中和点。这个引力的静止点在离月球28000公里的地方，月亮和地球在这一点上引力平衡。从飞船上可以看到美丽的月球已经遥遥在望。它发着美丽的银光，静静地悬在飞船的上方。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">19日晚上9点32分，地面指挥中心发来呼叫。三个人急忙起身。这一天，他们应该按计划登上月球。飞船开始作减速飞行，用不了多久，他们就要到达神往已久的月亮上空了。三个宇航员紧张地工作着，他们手握操纵杆，以防一旦计算机出现故障，就用手工操纵。还好，计算机发着正常的指令，飞船减慢到一定速度时，就自动作出停火的指令。7月20日上午7点32分，阿姆斯特朗和奥尔德林换乘登月舱，并与地面指挥中心通了话。不久，登月舱和飞船脱离，飞船继续在绕月轨道上飞行，登月舱则开始降落，在椭圆形轨道上缓缓下降。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">7月21日凌晨5点17分40秒，登月舱平稳地降落在月球上。登月的宇航员兴奋地向休斯敦地面中心报告：他们已经胜利着陆。休斯敦地面中心也高兴地祝贺他们的成功。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">21日上午11点39分，登月舱打开了舱门。11点51分，阿姆斯特朗走下阶梯，登上了月球。月面上到处是细小的颗粒，有点像地球的海滩。紧接着，奥尔德林也来到了月面。这是一个伟大的时刻。这是人类伟大的一步。这一时刻的精确时间是1969年7月21日11点56分20秒。这是人类探索太空的里程碑。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">一到月球表面，阿姆斯特朗和奥尔德林马上开始了紧张的工作。他们的任务很多，但是供给他们呼吸的氧气却很有限，只够使用四个小时。因此，分分秒秒都得抓紧。他们检查了登月器的着陆情况，情况一切正常；他们拿出铁锹，采集了月壤和月岩的样品；他们从登月舱中取出一块纪念碑，把它树立在月球上。纪念碑刻着地球东半球和西半球的图像，上面还刻着：</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">1969年7月，太阳系的行星地球上的人类第一次在月球上留下足迹。我们代表全人类，来这里作一次和平的旅行。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">然后，奥尔德林从登月舱中取出电视摄像机，安装在月球的表面；他们又安装了一台太阳风测定装置，用来检测宇宙射线；还安装了用来精确测定月球和地球之间距离的激光仪；还安装了测定月震的月震仪。他们又取出美国的星条旗，神色庄重地把它插在月亮上。这些工作完成后，他们舒了一口气，跟美国总统尼克松进行了月亮和地球之间的第一次通话。总统热情地祝贺他们登月成功。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">三个小时很快就过去了，他们的氧气袋中只剩下够一个小时使用的氧气。休斯敦地面中心命令他们停止作业，从月球返回登月舱内。他们小心翼翼地登上登月舱，脱掉登月服，换上舱内航天服，美美地吃了顿中饭，甜甜地睡了七八个小时。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">1969年7月22日0点15分，休斯敦地面中心唤醒了飞船上的科林斯和登月舱中的两名宇航员，命令登月舱升到一定的绕月轨道，与“阿波罗11号”飞船对接。登月舱发动机启动了，它不断地上升，不断地加速，进入了预定轨道。22日上午6点35分，它与去那里等候的“阿波罗11号”飞船对接成功。三位宇航员在月亮上空会合了，他们激动地在狭窄的指令舱里紧紧地握手。登月舱已经完成了它的历史使命，将它带回地球是不合算的。于是，它被甩在太空。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">飞船开始向遥远的地球返航。25日凌晨1点35分8秒，它以合适的角度进入地球大气层。下降到4000米高度的时候，三个大型降落伞在空中张开，“阿波罗11号”飞船准确地溅落在预定的海域，被早已等候在那边的海军救起。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">人类第一次踏上了月球。这次伟大的探险来回经过76万公里，历时195个小时，三位宇航员共同完成了一次从一个星球到另一个星球的探险。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">登月归来不久，1969年9月16日，三位宇航员到美国国会大厦，在国会联席会议上发表了演说，畅谈登月的感受。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">阿姆斯特朗谈到了登月的意义。他这样评论他们离开登月舱、踏上月球的“一小步”：“这一小步，对一个人来说，是小小的一步；对整个人类来说，是巨大的飞跃。”</p>', 4, 1, 0, 1, 1676478475666, 0);
INSERT INTO `t_blog` VALUES (21, 1, 20, '为什么不要空腹喝牛奶', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">牛奶营养丰富，但是如果空腹饮用，由于牛奶中大部分是水分，将会使胃液稀释，影响其消化和吸收；另外，牛奶为液体，在胃肠道滞留时间较短，营养成分难以充分吸收，所以最好将面包、饼干等食物与牛奶同时食用。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">牛奶中有一种会使人有疲劳感的物质—色氨酸，对人体有镇静作用。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">如果在早晨空腹喝一杯牛奶，可能使人在上午出现疲劳感，从而影响白天的工作和学习效果。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">而睡前喝一杯牛奶，能够补充营养，促进睡眠，保证充分的休息，特别对神经衰弱、睡眠不佳的人有明显作用。</p>', 2, 1, 1, 1, 1676478541580, 0);
INSERT INTO `t_blog` VALUES (22, 1, 20, '开国大典', '\n				<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">1949年10月1日，中华人民共和国中央人民政府成立，在首都北京举行典礼。参加开国大典的，有中华人民共和国中央人民政府主席、副主席、各位委员，有中国人民政治协商会议全体代表，有工人、农民、学校师生、机关工作人员、城防部队，总数达三十万人。观礼台上还有外宾。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n会场在天安门广场。广场呈丁字形。丁字形一横的北面是一道河，河上并排架着五座白石桥；再北面是城墙，城墙中央高高耸起天安门的城楼。丁字形的一竖向南直伸到中华门。在一横一竖的交点的南面，场中挺立着一根电动旗杆。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n主席台设在天安门城楼上。城楼檐下，八盏大红宫灯分挂两边。靠着城楼左右两边的石栏，八面红旗迎风招展。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n丁字形的广场汇集了从四面八方来的群众队伍。早上六点钟起，就有群众的队伍入场了。人们有的擎着红旗，有的提着红灯。进入会场后，按照预定的地点排列。工人队伍中，有从老远的长辛店、丰台、通县来的铁路工人，他们清早到了北京车站，一下火车就直奔会场。郊区的农民是五更天摸着黑起床，步行四五十里路赶来的。到了正午，天安门广场已经成了人的海洋，红旗翻动，像海上的波浪。</p><p style=\"text-align: center; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><img src=\"data:image/jpeg;base64,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\" width=\"657\" height=\"383\" style=\"margin: 10px; float: left;\" class=\"note-float-left\"></p>\n\n<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n下午三点整，会场上爆发出一阵排山倒海的掌声，中华人民共和国中央人民政府主席毛泽东出现在主席台上，跟群众见面了。三十万人的目光一齐投向主席台。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n中央人民政府秘书长林伯渠宣布典礼开始。中央人民政府主席、副主席、各位委员就位。接着，毛泽东主席宣布:“中华人民共和国中央人民政府今天成立了！”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n这庄严的宣告，这雄伟的声音，使全场三十万人一齐欢呼起来。这庄严的宣告，这雄伟的声音，经过无线电广播，传到长城内外，传到大江南北，使全中国人民的心一齐欢跃起来。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n接着，升国旗。毛主席亲自按动连通电动旗杆的电钮，新中国的国旗——五星红旗在雄壮的《义勇军进行曲》中徐徐上升。三十万人一齐脱帽肃立，一齐抬起头，瞻仰这鲜红的国旗。五星红旗升起来了，表明中国人民从此站起来了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n升旗的时候，礼炮响起来。每一响都是五十四门大炮齐发，一共二十八响。起初是全场肃静，只听见炮声和乐曲声，只听见国旗和其他许多旗帜飘拂的声音，到后来，每一声炮响后，全场就响起一阵雷鸣般的掌声。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n接着，毛主席在群众一阵又一阵的掌声中宣读中央人民政府的公告。他用强有力的语调向全世界发出新中国的声音。他读到“选举了毛泽东为中央人民政府主席”这一句的时候，广场上的人们热爱领袖的心情融成一阵热烈的欢呼。观礼台上同时响起一阵掌声。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n毛主席宣读公告完毕，阅兵式开始。中国人民解放军朱德总司令任检阅司令员，聂荣臻将军任阅兵总指挥。朱总司令和聂将军同乘汽车，先检阅部队，然后朱总司令回到主席台，宣读中国人民解放军总部的命令。受检阅的部队就由聂将军率领，在《中国人民解放军进行曲》的乐曲声中，由东往西，缓缓进场。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n开头是海军两个排，雪白的帽子，跟海洋一个颜色的蓝制服。接着是步兵一个师，以连为单位，列成方阵，齐步行进。接着是炮兵一个师，野炮、榴弹炮等各式各样的炮，都排成一字形的横列前进。接着是一个战车师，各种装甲车和坦克车两辆或三辆一排，整整齐齐地前进；战士们挺着胸膛站在战车上，像钢铁巨人一样。接着是一个骑兵师，“红马连”一色红马，“白马连”一色白马，六马并行，马腿的动作完全一致。以上这些部队，全都以相等的距离和相同的速度经过主席台前。当战车部队经过的时候，人民空军的飞机也一队队排成人字形，飞过天空。毛主席首先向空中招手。群众看见了，都把头上的帽子、手里的报纸和别的东西抛上天去，欢呼声盖过了飞机的隆隆声。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n两个半钟头的检阅，广场上不断地欢呼，不断地鼓掌，一个高潮接着一个高潮。群众差不多把嗓子都喊哑了，把手掌都拍麻了，还觉得不能够表达自己心里的欢喜和激动。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n阅兵式完毕，已经是傍晚的时候。天安门广场上的灯笼火把全都点起来，一万支礼花陆续射入天空。天上五颜六色的火花结成彩，地上千千万万的灯火一片红。群众游行就在这时候开始。游行队伍分东西两个方向出发，他们擎着灯，舞着火把，高呼“中国共产党万岁！”“中华人民共和国万岁！”“中央人民政府万岁！”他们一队一队按照次序走，走到正对天安门的白石桥前，就举起灯笼火把，高声欢呼“毛主席万岁！”“毛主席万岁！”毛主席在城楼上主席台前边，向前探着身子，不断地向群众挥手，不断地高呼“人民万岁！”“同志们万岁！”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">\n晚上九点半，游行队伍才完全走出会场。两股“红流”分头向东城、西城的街道流去，光明充满了整个北京城。</p>\n\n\n\n			', 26, 5, 1, 1, 1676480594307, 1677826476673);
INSERT INTO `t_blog` VALUES (23, 1, 20, '没有手的姑娘', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">从前有位磨房主，他越来越穷，除了磨房后有棵大大的苹果树外一无所有。有一天，他 到森林里去砍柴，一个他从没见过的老头走近前来对他说：“你何苦这么辛苦地砍柴呀？ 只要你答应把你磨房后的东西给我，我就让你过富人的日子。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“磨房后面不就是那棵苹果树吗？”磨房主想。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“行。”他说着就写了个承诺给陌生 人。陌生人嘲笑地说：“三年之后，我会来取走属于我的东西。”说完便走了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">磨房主回到家中，妻子迎出来对他说：“快告诉我，咱们家这些财富突然从什么地方来 的？家里所有的箱笼一下子全被装满了，又没人来过，到底是怎么回事呀？”磨房主回答 说：“是我在森林里碰到的一个陌生人给的。他只要我们磨房后的东西作为回报。我们把那 棵大苹果树给他不就得了。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“唉呀，老公，”妻子吓坏了，“那准是恶魔！他不是要苹果树，他要的是我们女儿， 她正在磨房后面扫院子呢。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">磨房主的女儿是个美丽、虔诚的姑娘，她敬畏上帝、没犯任何过失。三年过去了，在恶 魔要来带她走那天，她将自己从头到脚洗得干干净净，用粉笔绕着自己画了一个圈。恶魔很 早就来了，可就是没法靠近姑娘。他怒气冲冲地对磨房主说：“把水全给我拿走！让她没法 洗得那么干净。要不然我对她就没有魔法了。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">磨房主害怕，只得照办。第二天，恶魔又来了。可姑娘的泪水把她的手冲得十分干净。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">恶魔还是没法靠近她，因此气势汹汹地对磨房主说：“把她的手砍掉，要不然我对她就没有 魔力了！”磨房主吓了一跳，回答说：“我怎么能砍自己孩子的手呢！”恶魔威胁说：“如 果你不这么做，你就是我的，我就要把你带走。”这位父亲吓坏了，答应照他说的去做。他 走到女儿跟前，对她说：“我的孩子，假如我不砍掉你的手，恶魔就要把我抓走，我吓坏 了，就答应了他。现在请你帮帮我，饶恕我对你的伤害吧。”姑娘回答说：“亲爱的父亲， 尽管砍吧，我是你的孩子。”说着，她伸出了双手，让父亲砍下了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">恶魔第三次来到磨房。可是姑娘一直在哭泣，泪水将残肢冲洗得十分洁净。恶魔只好放 弃了，而且对姑娘失去了所有权。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">磨房主对女儿说：“我以你为代价换取了这么多财富。只要你活着，我就会让你过得舒 舒服服的。”可是姑娘回答说：“我不能住在这里，我情愿出去，有同情心的人们会给我所 需要的东西的，”她请人将她残废的手绑到身后，等太阳升起来的时候，便出发了。她走了 一整天，太阳下山时她来到一个皇家花园，在闪烁的月光中，她看到园子里挂满了诱人的果 子的果树。但是她无法进去，因为果园被一道满是水的深壕围住了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">姑娘已经走了整整一天了，而且没吃过任何东西。她饿得要命。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“啊，如果我在果园里 面就能吃到水果了，”她想，“否则我准会饿死的！”她跪到地上向上帝祈祷。忽然，有个 天使向她走来，在水中筑起一道堤坝。这样一来，壕中的水干了，姑娘就可以走到果园去 了，天使陪着她一起进了果园。果园的树上挂满了迷人的梨子，可每个上面都编了号，姑娘 来到梨子树前，用嘴咬下一只吃了，然后满足地钻进了灌木丛。园丁看到了这一切，可见天 使站在姑娘身边，便以为是幽灵，有些害怕，所以不敢出声，更不敢大声喊叫。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">果园的主人是个国王。第二天，他来到果园数梨时发现少了一个，而且并没有落在地 上。他问园丁怎么回事，园丁回复说：“昨晚来了个幽灵，没有手，用嘴咬掉了一个。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“幽灵怎么越过水沟的呢？吃完梨之后上哪儿去了呢？”国王问。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">园丁回答说：“有个浑身雪白的人从天而降。他筑起一道堤坝拦住了水，让幽灵走了过 来。我想那人准是个天使，所以有些惧怕，没敢出声。幽灵吃完梨就走了。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">“我今晚和你一起看看是不是真像你说的那样。”国王说。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">天黑了，国王带着牧师来到果园。他要牧师来是为了和幽灵对话。他们三人坐在树下等 着、看着。半夜时分，姑娘从灌木丛里爬了出来，走到梨树下，用嘴咬下一个梨，身穿白袍 的天使仍然陪着她。牧师从树下走出来对他们说：“你们是从天上来的，还是从地下来的？ 是人还是鬼？”姑娘回答说：“我不是鬼，我是个不幸的人。除了上帝外，人人都抛弃了 我。”国王接口说：“即使世界上所有的人都抛弃了你，我也不会那么做的。”他将姑娘带 回王宫，姑娘的美貌和善良使国王深深地爱上了她。他为姑娘做了一双银手，并娶她为妻。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">一年以后，国王不得不远行。他将年轻的王后托咐给母亲，说：“假如她生了孩子，请 好好照顾她，同时尽快把消息告诉我。”后来姑娘果真生了个健康漂亮的男孩，国王年迈的 母亲立刻将这一令人振奋的消息写在信上派人给国王送去。但送信人在路上的一条小溪边歇 息的时候睡着了。再说那个恶魔一直想伤害好心的王后。这时，他将另一封信放进信使的口 袋里，上面说王后生了一个妖怪。国王收到信后十分震惊，而且百思不得其解。他回信要大 家仍悉心照料王后，一切等他回来再说。送信人带着国王的信往回走，又在来时歇息的地方 打了个盹。恶魔又把另一封信装进信使的口袋，上面要他们将王后和她生的孩子处死。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">国王的母亲见信后大惊失色，简直不敢相信。因此又写了一封信给国王，可是没有回 音。因为恶魔每次都把信换了。最后一封信上要求把王后的舌头和眼睛挖出来留作服从国王 命令的见证。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">国王的母亲哭了，她不愿意看到无辜的人被杀害。于是她趁天黑时杀了一头鹿，留下了 舌头和眼睛，然后对王后说：“我不愿按国王的命令杀你，但是你不能再住在这儿了。带着 孩子走吧，别再回来。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">可怜的妇人把孩子背到背上，含泪离开了王宫。她来到一座大森林里，跪下来向上帝祈 祷。天使来到她跟前，把她领到一座小屋前。那里挂着一块牌子，上面写着：“一切免 费。”一位雪白的侍女从屋里走出来说：“欢迎你，王后。”然后将她引进屋里。她将孩子 从王后背上解下来，抱到她怀里让孩子吃奶，随后将孩子放到一张做得极其精致的小床上。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">可怜的妇人问：“你怎么知道我是个王后。”白侍女回答说：“我是个天使，上帝派我来照 顾你和孩子的。”王后在这里生活了七年，受到很好的照顾。由于她虔诚地信仰上帝，因此 上帝让她被砍断的双手又长了出来。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">国王终于归来了，他的第一个愿望就是看看他的妻子和儿子。他年迈的妈妈哭着对他 说：“你这个坏家伙，为什么写信要我杀那两个无辜的人？”她拿出那两封被恶魔换了的信 给国王看，接着说：“我已经照办了。”说着拿出舌头和眼睛作证。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">国王为可怜的妻子和儿子痛哭流涕，伤心的程度远超过他母亲。老母看他哭得实在可 怜，就对他说：“别哭了，她还活着。我悄悄地杀了一头鹿，取了那些证物。实际上我把孩 子绑到你妻子的背上，让她到野外谋生，要她别再回来，因为你信上似乎对她很恼怒。”国 王说：“只要我亲爱的妻子和儿子没被杀害或饿死，走遍天崖海角我也一定要找到他们，否 则我不吃也不喝。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">于是国王找了七年，不吃也不喝，但是上帝在暗中帮助他支撑着。他找遍了每一个石 缝、每一个山洞，但还是没有找到，他想她准是因为缺衣少食死了。最后他来到了大森林， 看到了小屋和上面挂着的“一切免费”的牌子。白衣侍女走出来，拉着他的手将他领进屋子 说：“欢迎光临，国王陛下。”又问他从何而来。国王回答说：“我出来寻找我妻子和孩子 已经七年了，我几乎找遍了每一个地方，可就是找不到。”天使请国王吃点肉、喝点酒，国 王什么也没吃，说只想休息一下。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">他躺下，将一块手帕遮在脸上睡了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">天使走进王后和她儿子“悲伤”住的房间，对她说：“带着孩子出去吧，你丈夫找你们 来了。”于是王后带着儿子来到国王睡觉的地方。手帕从国王的脸上滑落到地上，王后对儿 子：“悲伤，去把你父亲的手帕捡起来，盖到他脸上。”孩子走过去，捡起手帕盖到国王脸 上。国王在睡梦中听到了，便很高兴地让手帕再次滑落到地上。可孩子不耐烦地说：“亲爱 的母亲，我在这世上不是没父亲吗？你怎么叫我用手帕盖住父亲的脸？我已经学会祈祷‘我 们在天之父’，你不是说我父亲在天国吗，是仁慈的上帝，现在怎么又说这陌生人是我父 亲？他不是我父亲。”国王一听，马上坐了起来，问他们是谁。王后回答说：“我是你的妻 子，他是你的儿子‘悲伤’。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">国王看到王后那双自然生长的手，说：“我妻子的手是银子做的。”王后回答说：“仁 慈的上帝让我又长出了一双手。”天使走进内室，拿出那双银手给国王看。这时国王才确信这就是他亲爱的妻子和儿子，他亲吻了他们，高兴地说：“这下我心中的石头算是落地了。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">上帝派来的天使和他们一起吃了最后一顿饭。随后国王带着妻儿回到王宫，见到了老母亲，到处一片欢腾。国王和王后再次举行了婚礼，从此永远幸福满足地生活在一起。 　　</p>', 1, 0, 0, 0, 1676481129025, 0);
INSERT INTO `t_blog` VALUES (24, 1, 20, '少女时代', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">昨天回老家搬家，说是搬家，其实就是把以前的家具电器等全处理送人了。在最后收拾七零八散的东西时，在墙角躺着一小堆废纸，本准备全丢垃圾桶的，就随意翻翻，这一翻不要紧，却翻出了我尘封已久一本影集，这本叫着“少女时代”的影集。上面记载着我少女时代的照片，看到这些照片，我心里一下沉重起来，这是我最重要的东西，怎么就忘记了呢？­</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我一页页的翻开，看到我13岁的照片，学生头的我戴着红色的压发条，身上穿着的可是那个时代比较流行的衣服和踩脚裤，脚上也穿着黑色皮鞋，呵呵，我不禁笑出声了，照片上那个小姑娘就是我吗？恩，这个小姑娘挺不错，我喜欢！嘿嘿……­</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">影集里还有我弟弟学生时代的照片，我和同学的合影，学生时候每次出去野炊的照片，出去旅行的照片。和毕业留影的照片……­</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">每张毕业留影里，我一个一个同学的看，有些记得名字，有些使劲想也不知道名字了，想想当初我们坐在一个教室里读书的点点滴滴，仿佛此时此刻又回到教室了，看着合影里我曾经喜欢过的男孩，心里不禁又一次出现了小波浪。他现在过的还好吗？现在也结婚生子了吗？不知道他也会保存这些照片吗？看到照片上我。还记得曾经喜欢过你的那个女孩吗？不过这些你是不会知道的，因为我那时只是心里喜欢， 没有对你说，也更不会对别人说了，因为这是青涩年龄的一个青涩而纯真梦了，也看见了喜欢过我男孩的照片。不知道现在过的还好吗？谢谢、谢谢你……­</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">还有我的那些好同学，好姐妹们。现在你们都过的还好吧，能记得我们曾经悄悄话么？记得我们纯正的<a href=\"https://www.thn21.com/top/Special/youyi/\" target=\"_blank\" class=\"infotextkey\" style=\"color: rgb(45, 100, 179);\">友谊</a>么，记得我们彻夜不眠对以后那个他的描述吗？记得听鬼故事后我们的尖叫声吗？613的室友们，记得有人半夜起床方便，其他人全体把头发吊在床沿上吓唬的吗？记得有一次我们为了尝酒醉后滋味，全体喝酒全体酒醉的事吗？平时唧唧喳说不停的酒醉后便沉默了，平时少言寡语的人醉酒后唧唧喳的了。还记得我们的小矛盾吗？­</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">照片一页页翻开，也把我的记忆一点点的翻出来。让我想起几句话：“也许时间可以冲淡一切，岁月腐蚀记忆。而天真浪漫少女时代，却总是令我们深深向往……&nbsp; ­</p>', 3, 1, 0, 1, 1676481264141, 0);
INSERT INTO `t_blog` VALUES (25, 1, 20, '公输', '\n				<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘为楚造云梯之械，成，将以攻宋。子墨子闻之，起于鲁，行十日十夜而至于郢，见公输盘。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘曰：“夫子何命焉为？”</p><img src=\"data:image/jpeg;base64,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\" width=\"536\" height=\"402\" style=\"margin-top: 10px; margin-right: 10px; margin-bottom: 10px; float: right;\" class=\"note-float-right\"><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“北方有侮臣，愿藉子杀之。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘不说。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“请献十金。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘曰：“吾义固不杀人。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子起，再拜，曰：“请说之。吾从北方闻子为梯，将以攻宋。宋何罪之有？荆国有余于地而不足于民。杀所不足而争所有余，不可谓智。宋无罪而攻之，不可谓仁。知而不争，不可谓忠。争而不得，不可谓强。义不杀少而杀众，不可谓知类。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘服。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“然胡不已乎？”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘曰：“不可，吾既已言之王矣。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“胡不见我于王？”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘曰：“诺。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子见王，曰：“今有人于此，舍其文轩，邻有敝舆而欲窃之；舍其锦绣，邻有短褐而欲窃之；舍其粱肉，邻有穅糟而欲窃之——此为何若人？”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">王曰：“必为有窃疾矣。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“荆之地方五千里，宋之地方五百里，此犹文轩之与敝舆也。荆有云梦，犀兕麋鹿满之，江汉之鱼鳖鼋鼍为天下富，宋所为无雉兔鲋血鱼者也，此犹粱肉之与糠糟也。荆有长松文梓楩楠豫章，宋元长木，此犹锦绣之与短褐也。臣以王吏之攻宋也，为与此同类。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">王曰：“善哉。虽然，公输盘为我为云梯，必取宋。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">于是见公输盘。子墨子解带为城，以牒为械，公输盘九设攻城之机变，子墨子九距之。公输盘之攻械尽，子墨子之守围有余。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">公输盘诎，而曰：“吾知所以距子矣，吾不言。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子亦曰：“吾知子之所以距我，吾不言。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">楚王问其故。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">子墨子曰：“公输子之意不过欲杀臣。杀臣，宋莫能守，乃可攻也。然臣之弟子禽滑厘等三百人，已持臣守圉之器在宋城上而待楚寇矣。虽杀臣，不能绝也。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">楚王曰：“善哉！吾请无攻宋矣。”</p>\n			', 1, 0, 0, 0, 1676481600000, 1677847024863);
INSERT INTO `t_blog` VALUES (26, 1, 20, '九十九度加一度才会沸腾', '<p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">如果让水发出饱和蒸气的力，必先把水烧到摄氏二百十二度的温度。二百度不成，二百十度也不能办到。<span style=\"text-indent: 2em;\">水在压力下一定要沸腾，才能发出蒸气，才能转动机器，才能推动水车。</span><span style=\"text-indent: 2em;\">“温热”能推动任何东西的。</span></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">许多人都是想用温热的水，或将未沸腾的水，去推动他们生命的火车；而同时却还诧异着，为什么在事业上自己总是不尽人意。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">一个人态度的温热，对于他自己的事业工作所产生的影响，与温热的水对于机车所产生的影响相等。</p><img src=\"data:image/jpeg;base64,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\" width=\"531\" height=\"416\" class=\"note-float-right\" style=\"margin-top: 10px; margin-right: 10px; margin-bottom: 10px; float: right;\"><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">凡是有着强有力的中心意志，一定是个积极的、有建设与创造本领的人。每个人都会向往一件事，希冀一件事，但真能做事、成事的，却只有那些怀着中心意志或意志坚强的人。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">有着坚强的中心意志的人，在社会中一定能够占得重要的位置，并为他人所敬仰。他的言语行动，表现出有定力、有作为、有主见、有生命之目标，而又必求达到其目标。他坚定地朝着目标前进，有如急矢之趋向红心。在这样的一种意志之下，一切的阴影都会消融逝去了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">目标的认清，意志的坚定，从这中间，是可以生出一种可以使人成功的力量来的。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">假使一个人于某一日，在心中决定了一个新的中心意志，新的生命目标。那么，从那一天起，他就是一个新生的人。他的耳目所接触的四周都已气象一新。昨天还在包围和阻碍他的种种恐惧、狐疑、不快的思想及罪恶的试探，现在烟消雾散了。因为，一个新的中心意志，已经把那些东西一起赶掉了。他的生命现在是统一而不是混乱，积极而不是消极。他一切的酣睡着的能力，现在是已经唤醒而准备行动了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">有些青年人很想在事业上发愤上进，但为了细故，往往会于一夕之间，抛掉事业，而去迁就环境。他们常常自己怀疑，现在的事业究竟与自己的性情是否适合。他们一遇挫折，就要灰心；一听到别人在别种事业上得到成功，就要生出羡慕，而要想自己也向那方面去试试。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">假使一个青年对自己从事的事业态度游移，则可断定，他还没有怀着一个中心意志，他的事业总还与他的天性不尽适合。否则，他的事业，应当与他的中心意志相符，与他的天性相合，而他的事业就是他生命中的一部分，不能分离。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">在心中决定一个中心意志，寻觅到最高的生命理想或目标，并且觉得不能不实现，必须实现而后已；不论怎样费力、怎样费时，也仍然不会放弃追求、停止努力。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这是使我们的生命成为有价值与得到胜利的原则！</p>\n\n			', 3, 0, 0, 0, 1676481902366, 1677846924486);
INSERT INTO `t_blog` VALUES (27, 1, 20, '草原', '\n				\n				<p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这次，我看到了草原。那里的天比别处的更可爱，空气是那么新鲜，天空是那么明朗，使我总想高歌一曲，表示我满心的愉快。在天底下，一碧千里，而并不茫茫。四面都有小丘，平地是绿的，小丘也是绿的，羊群一会儿上了小丘，一会儿又下来，走在哪里都像给无边的绿毯绣上了白色的大花。那些小丘的线条是那么柔美，就像只用绿色渲染，不用墨线勾勒的中国画那样，到处翠色欲留，轻轻流入云际。这种境界，即使人惊叹，又叫人舒服，既愿旧立四望，又想坐下低吟一首奇丽的小诗。在这境界里，连骏马和大牛都有时候静立不动，好像回味着草原的无限乐趣。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">我们访问的是陈巴尔虎旗。汽车走了一百五十里，才到达目的地。一百五十里全是草原。再走一百五十里，也还是草原。草原上行车十分洒脱，只要方向不错，怎么走都可以。初入草原，听不见一点儿声音，也看不见什么东西，除了一些忽飞忽落的小鸟。走了许久，远远的望见了一条迂回明如玻璃的带子——河！牛羊多起来，也看到了马群，隐隐有鞭子的轻响。快了，快到了。忽然，像被一整风吹来似的，远处的小丘上出现了一群马，马上的男女老少穿着各色的衣裳，群马疾驰，襟飘带舞，像一条彩虹向我们飞过来。这是主人来到几十里外欢迎远客。见到我么，主人们立刻拨转马头，欢呼着，飞驰着，在汽车的左右与前面引路。静寂的草原热闹起来：欢呼声，车声，马蹄声，响成一片。车跟着马飞过小丘，看见了几坐蒙古包。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">蒙古包外，很多匹马，许多辆车。人很多，都是从几十里外乘马或坐车来看我们的。主人们下了马，我们下了车。也不知道是谁的手，总是热乎乎的握着，握住不散。大家的语言不同，心可是一样。握手再握手，笑了再笑。你说你的，我说我的，总的意思是民族团结互助。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">也不知怎的，就进了蒙古包。奶茶倒上了，奶豆腐摆上了，主客都盘腿坐下，谁都有礼貌，谁都又那么亲热，一点而都不拘束。不到一会儿，好客的主人端进来大盘的手抓羊肉。干部向我们敬酒，七十岁的老翁向我们敬酒。我们回敬，主人再举杯，我们再回敬。这时候，鄂温克姑娘们带着尖尖的帽子，既大方，又稍有点羞涩，来给客人们唱民歌。我们同行的歌手也赶紧唱起来，歌声似乎比什么语言都更响亮，都更感人，不管唱地是什么，听者总会露出会心的微笑。</p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">饭后，小伙子们表演套马，摔跤，姑娘们也表演了名族舞蹈。客人们也舞的舞，唱德唱，并且要骑一骑蒙古的马。太阳以偏西，谁也不肯走。是啊！蒙汉情深何忍别，天涯碧草话斜阳！</p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><img src=\"data:image/jpeg;base64,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\" data-filename=\"image.png\" style=\"text-align: center; text-indent: 2em; width: 790px; float: left;\" class=\"note-float-left\"></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p><p style=\"text-align: left; padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"><br></p>\n			\n			', 6, 1, 0, 1, 1676482550637, 1677846425220);
INSERT INTO `t_blog` VALUES (28, 1, 20, '怎么轻松学习JavaScript', '<p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp; &nbsp; &nbsp; &nbsp; js给初学者的印象总是那么的“杂而乱”，相信很多初学者都在找轻松学习js的途径。我试着总结自己学习多年js的经验，希望能给后来的学习者探索出一条“轻松学习js之路”。js给人那种感觉的原因多半是因为它如下的特点：</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">A：本身知识很抽象、晦涩难懂，如：闭包、内置对象、DOM。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">B：本身内容很多，如函数库、对象库就一大堆。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">C：混合多种编程思想。它里面不但牵涉面向过程编程思想，又有面向对象编程思想，同时，它的面向对象还和别的编程语言（如：C++，JAVA，PHP）不大一样。就好像又是新的一样，让你对曾经学的面向对象产生了怀疑......</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">D：辛苦学习后又看似和实际应用脱节。通常学了很久的js基础之后，变量、函数、对象你也都略知一二，但一到公司开发项目的时候，却又难以下手。因为公司在开发实际项目的时候通常都是直接用它的衍生库，如：jquery，angular，boostrap，amaze，layui，ueditor等，而这些库又多如牛毛，同时还有自己的难点。让你都不知道该学哪个好，甚至都怀疑自己学的是不是js了，好像有多个版本的js一样，总是学不完......</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">那么，怎么才能在js领域内学的轻松甚至游刃有余呢？我总结了一些实战意义的js学习经验：</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">首先要紧紧抓住它的地位</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><a href=\"http://upload-images.jianshu.io/upload_images/5256822-d6ea1ce7970bef4d?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\"></a></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 时刻都不能忘记，否则很容易犯“一叶障目不见泰山”的错误。不要学了很久就知道js是编程语言，就是写代码，而且特点就是乱七八糟就完了，那样是学不好js的。要时时抓住它的地位，确切的说是它在整个Web中的地位：它属于前端的核心，主要用来操控和重新调整DOM，通过修改DOM结构，从而来达到修改页面效果的目的。要用这个中心思想去指导后续的一切js的学习，并且形成条件反射。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">要有一条清晰的学习路线</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><a href=\"http://upload-images.jianshu.io/upload_images/5256822-1e595907df2472c2?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\"></a></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 这个只能是过来人给你提供参考了。我的学习路线如下：</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">A：js基础部分</span>，如：定义变量、函数、数组、字符串等的处理，内置函数、内置对象等；</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">B：js面向过程编程思想</span>，封装出各个函数，试着用这些去做一些常见的小功能，如：选项卡、自定义多选按钮、自定义播放器、3D幻灯片；</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">C：js面向对象编程思想</span>，试着去封装一些你自己的对象，提供出有意义的接口出来；</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">D：学了上述的内容，然后学常用的库，这里必须学jquery</span>；</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">E：学基于jquery之上的常见插件</span>，如：bootstrap，Layer，富文本编辑器等；</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">F：综合应用上面的多种库写实际项目的模板</span>，多写几套。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">注意学习方法</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><a href=\"http://upload-images.jianshu.io/upload_images/5256822-bfbbb3deffcba908?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\"></a></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">我的学习方法总结如下：</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">A：多买几本国外的js书籍</span>，不要购买那种20天精通之类的书。否则你是很难学通的，更可怕的是：本来你买本好书自学3个月可能学会的，它们硬是能折腾你两年......</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">书籍推荐（仅供参考）</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">《JavaScript&nbsp;DOM编程艺术》</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">《JavaScript权威指南》</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">《javaScript&nbsp;DOM高级程序设计》</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">《JavaScript设计模式》</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">《锋利的jquery》</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">争取把书上的功能都自己练习多次，不是一次。书读百遍，其义自见。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">B：从多角度去学习和领悟</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 充分调动你所学的东西，从多角度去做某一功能，如：以前你是从面向过程角度做的，现在改为从面向对象的角度再来做，或者继续做成可以直接使用的插件，提供属性、方法等出来。争取让你做的这个功能逐渐能使用到实际项目中来。这样的好处：既综合应用了你的所学，又能有实际意义。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">C：一定不要好高骛远</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 不要放过哪怕很小的动手机会，如做一个选项卡。千万不要认为有了类似的甚至更好的插件就不需要自己写了，知识是别人的，不是你的，你即使会用了也对你的技术技能水平没有任何提升。你要多问自己，如果要我来做，我该怎么做？</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">D：脚踏实地的同时，也不要脱离实际</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 多看现在网上已经出现的效果好的功能，让它去激发你的学习热情，尽量去学着模拟，调动你的知识去和实际相结合。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">E：多写总结</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 这种总结不但包括源代码、显示效果截图，还应该很容易犯的错误和对应的解决方法以及最后一两句精简的结论性语句。对自己写的总结不是写完了就了事了，要多回顾、多改进、多精简。到做项目的时候，应该是看里面的一两句话就知道是讲什么了，而不要再去看长篇大论了。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">F：构建知识导图</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 这个可以让你越学越清晰，比如：<a href=\"http://www.phpkhbd.com/sky.html\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\">http://www.phpkhbd.com/sky.html</a>，你可以按你喜欢的任何形式去做，只要自己印象深刻就行。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">注意：知识导图也应该是经常修改、修正，让它更合理、更清晰。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">注意事项</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><a href=\"http://upload-images.jianshu.io/upload_images/5256822-bdcaea6856af0f41?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\"></a></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">A：充分利用一切手段</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 很多人总感觉时间紧，没有大块的时间学习。我要说你不会学了，你不应该只是抱怨，而是要利用一切手段去学习，要知道，不一定只有看书才叫学习。当你冷静的坐在某个地方，思考了一下，总结了一下，你也都叫学习，但凡有灵感，就可以记录下来，比如：记录在手机上，等方便了再记录在专门的地方。这都叫学习。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">B：贵在坚持</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 要沉的下心。没有一蹴而就的成功，否则那也不是成功，只能叫“侥幸”。不但要老老实实的把每个功能都试着去实现，而且要精益求精地不断去修正，这个过程是漫长的，也是考验一个人是否是人才的标准。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">C：注意培养信心</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 此时的你，不适合一来就看很复杂很炫的网页效果的源代码，也不适合一来就学jquery，angular，vue，bootstrap这些东西。这些内容包含了很多深奥的知识在里面，在没有任何基础的情况下直接学这些，会严重打击你的自信心。而此时你是弱小的，你需要的是培养信心，而不是反过来，否则结局很可能是“夭折”，离学有所成也就遥遥无期了。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">D：多跟学的好的过来人学习</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">站在巨人的肩上，才能看的更远。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">E：不要浪费在工具的不停选择上</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;js的编辑工具很多，如果无从下手，建议使用：sublime，或者使用Hbuilder。很多公司里的技术人员都用这些，你直接用这个也减少了和别人之间的沟通问题。我也是用这个，感觉很好。</p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px 0px 0px 30px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><span style=\"margin: 0px; padding: 0px; font-weight: 700; color: rgb(51, 51, 51);\">总结</span></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \"><a href=\"http://upload-images.jianshu.io/upload_images/5256822-0f3b58bd6989f4f4?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(26, 100, 162);\"></a></p><p style=\"margin-top: 5px; margin-bottom: 5px; padding: 0px; font-family: ‘PingFang SC‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; \">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 感觉js学起来“杂而乱”的原因是因为你太“聪明”了，一开始就管的太宽，利害得失也计算的太精细。要求太完美则心里承受能力下降，很容易出现“障”。此时，你应该“笨”一些，不要考虑那么长远，“傻人有傻福”，只要做好今天就够了。一些不合理的学习方法和心态也让你迷失了自我，如：心浮气躁、眼高手低、好高骛远，这些都会让你在“乱七八糟”的js面前深陷迷雾、不能自拔。此时，你应该重新定位自己的位置，重新去认识js，放下包袱，方能轻松上阵。把杯子先倒空，才能灌新水......其实，js是前端的核心。影响越来越深的互联网+会渴求越来越多的js人才，只有经历过真正刻骨铭心的学习经历，才能造就出赢得未来的真正精英。</p>', 2, 0, 0, 0, 1676482974844, 0);
INSERT INTO `t_blog` VALUES (29, 1, 20, '如何高效地学习技术', '<p>　　我们相信努力学习一定会有收获，但是方法不当，既让人身心疲惫，也没有切实的回报。高中时代，我的同桌是个漂亮女同学。她的物理成绩很差，虽然她非常勤奋的学习，但成绩总是不理想。为了巩固纯洁的同学关系，我亲密无间地辅导她的物理，发现她不知道题目考什么。我们的教科书与试题都围绕着考试大纲展开，看到一道题，应该先想想它在考哪些定理和公式的运用。<br></p><p>  不少朋友每天都阅读技术文章，但是第二天就忘干净了。工作中领导和同事都认可你的沟通和技术能力，但是跳槽面试却屡屡碰壁。面试官问技术方案，明明心里清楚，用嘴说出来却前言不搭后语。面试官再问底层算法，你说看过但是忘记了。他不在乎你看没看过，答不上就是零分。正如男女相亲，男方谈吐潇洒才能吸引姑娘。可是男方紧张了，平时挺能说，关键时候却支支吾吾，姑娘必然认为他不行。人生充满了许多考试，有形的和无形的，每次考试的机会只有一次。</p><p>  工作五年十年后，别人成了架构师，自己还在基层打滚，原因是什么？职场上无法成功升迁的原因有很多，没有持续学习、学习效果不好、无法通过心仪公司的的面试，一定是很重要的原因。</p><p>  <span style=\"  font-weight: 700; color: rgb(51, 51, 51);\">把自己当成一台计算机，既有输入，也要有输出，用输出倒逼输入</span>。</p><h3 id=\"学什么\" style=\"margin: 5px auto;   font-size: 14px;  \">　　<span style=\"  font-size: 16px;\">学什么</span></h3><h4 id=\"基础与应用\" style=\"margin: 5px auto;  font-size: 14px;  \">　　基础与应用</h4><p>  近些年诞生了许多新技术，比如最时髦的AI(目前还在智障阶段)，数学基础是初中就接触过的概率统计。万丈高楼从地起，不要被新工具或者中间件迷住双眼，一味地追新求快。基础知识是所有技术的基石，在未来很长的时间都不会变化，应该花费足够的时间巩固基础。</p><p>  以数据结构和算法为例，大家阅读一下Java的BitSet的源码，里面有大量的移位操作，移位运算掌握的好，看这份源码就没问题。Java同步工具类AQS用到了双向链表，链表知识不过关，肯定搞不懂它的原理。互联网大厂都喜欢考算法，为了通过面试也要精通算法。</p><p>  以Java工程师应该掌握的知识为例，按重要程度排出六个梯度：</p><ul style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 50px;  font-size: 12px;  list-style: none; \"><li style=\"  font-size: 14px; list-style: disc;\">第一梯度：计算机组成原理、数据结构和算法、网络通信原理、操作系统原理；</li><li style=\"  font-size: 14px; list-style: disc;\">第二梯度：Java基础、JVM内存模型和GC算法、JVM性能调优、JDK工具、设计模式；</li><li style=\"  font-size: 14px; list-style: disc;\">第三梯度：Spring系列、Mybatis、Dubbo等主流框架的运用和原理；</li><li style=\"  font-size: 14px; list-style: disc;\">第四梯度：MySQL(含SQL编程)、Redis、RabbitMQ/RocketMQ/Kafka、ZooKeeper等数据库或者中间件的运用和原理；</li><li style=\"  font-size: 14px; list-style: disc;\">第五梯度：CAP理论、BASE理论、Paxos和Raft算法等其他分布式理论；</li><li style=\"  font-size: 14px; list-style: disc;\">第六梯度：容器化、大数据、AI、区块链等等前沿技术理论。</li></ul><p>　　有同学认为第五梯度应该在移到第一梯度。其实很多小公司的日活犹如古天乐一样平平无奇，离大型分布式架构还远得很。学习框架和中间件的时候，顺手掌握分布式理论，效果更好。</p><h4 id=\"广度与深度\" style=\"margin: 5px auto;  font-size: 14px;  \">　　广度与深度</h4><p>  许多公司的招聘JD没有设定技术人员年龄门槛，但是会加上一句“具备与年龄相当的知识的广度与深度”。多广才算广，多深才算深？这是很主观的话题，这里不展开讨论。</p><p>  如何变得更广更深呢？<span style=\"  font-weight: 700; color: rgb(51, 51, 51);\">突破收入上升的瓶颈，发掘自己真正的兴趣</span>。</p><p>  大多数人只是公司的普通职员，收入上升的瓶颈就是升职加薪。许多IT公司会对技术人员有个评级，如果你的评级不高，那就依照晋级章程努力升级。如果你在一个小公司，收入一般，发展前景不明，准备大厂的面试就是最好的学习过程。在这些过程中，你必然学习更多知识，变得更广更深。</p><p>  个人兴趣是前进的动力之一，许多知名开源项目都源于作者的兴趣。个人兴趣并不局限技术领域，可以是其他学科。我有个朋友喜欢玩山地自行车，还给一些做自行车话题的自媒体投稿。久而久之，居然能够写一手好文章了，我相信他也能写好技术文档。</p><h4 id=\"哲学\" style=\"margin: 5px auto;  font-size: 14px;  \">　　哲学</h4><p>  哲学不是故作高深的学科，它的现实意义就是解决问题。年轻小伙是怎么泡妞的？三天两头花不断，大庭广众跪求爱。这类套路为什么总是能成功呢？礼物满足女人的物欲，当众求爱满足女人的虚荣心，投其所好。食堂大妈打菜的手越来越抖，辣子鸡丁变成辣子辣丁，为什么呢？食堂要控制成本，直接提价会惹众怒。</p><p>  科学上的哲学，一般指研究事物发展的规律，归纳终极的解决方案。软件行业充满哲学味道的作品非常多，比如《人月神话》。举个例子，当软件系统遇到性能问题，尝试下面两种哲学思想提升性能：</p><ul style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 50px;  font-size: 12px;  list-style: none; \"><li style=\"  font-size: 14px; list-style: disc;\">空间换时间：比如引入缓存，消耗额外的存储提高响应速度。</li><li style=\"  font-size: 14px; list-style: disc;\">时间换空间：比如大文件的分片处理，分段处理后再汇总结果。</li></ul><p>　　设计稳健高可用的系统，尝试从三个方面考虑问题：</p><ul style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 50px;  font-size: 12px;  list-style: none; \"><li style=\"  font-size: 14px; list-style: disc;\">存储：数据会丢失吗，数据一致性怎么解决。</li><li style=\"  font-size: 14px; list-style: disc;\">计算：计算怎么扩容，应用允许任意增加节点吗。</li><li style=\"  font-size: 14px; list-style: disc;\">传输：网络中断或拥塞怎么办。</li></ul><p>　　从无数的失败或者成功的经验中，总结出高度概括性的方案，让我们下一步做的更好。</p><h4 id=\"英语\" style=\"margin: 5px auto;  font-size: 14px;  \">　　英语</h4><p>  英语是极为重要的基础，学好英语与掌握编程语言一样重要。且不说外企对英语的要求，许多知名博客就是把英文翻译成中文，充当知识的搬运工。如果英语足够好，直接阅读一手英语资料，避免他人翻译存在的谬误。</p><p>　　<span style=\"  font-weight: 700; color: rgb(51, 51, 51);\"><span style=\"  font-size: 16px;\">怎么学</span></span></p><h4 id=\"知识体系\" style=\"margin: 5px auto;  font-size: 14px;  \">　　知识体系</h4><p>  体系化的知识比零散的更容易记忆和理解，这正如一部好的电视剧，剧情环环相扣才能吸引观众。建议大家使用思维导图罗列知识点，构建体系结构，如下图所示：</p><p style=\"text-align: center;     \"><img style=\"width: 300px;\" src=\"data:image/jpeg;base64,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\" data-filename=\"image.png\"><br></p><p></p><h4 id=\"克服遗忘\" style=\"margin: 5px auto;  font-size: 14px;  \">　　克服遗忘</h4><p style=\"text-align: center;     \">  高中是我们知识的巅峰时刻，每周小考每月大考，教辅资料堆成山，地狱式的反复操练强化记忆。复习是对抗遗忘的唯一办法。大脑的遗忘是有规律的，先快后慢。一天后，学到的知识只剩下原来的25%，甚至更低。随着时间的推移，遗忘的速度减慢，遗忘的数量也就减少。</p><table class=\"table table-bordered\" style=\"text-align: center; margin: 20px; width: 60%;margin-left:18%\"><tbody><tr><td style=\"text-align: center;\"><b>时间间隔</b></td><td style=\"text-align: center;\"><b>记忆量</b></td></tr><tr><td style=\"text-align: center;\">刚刚看完</td><td style=\"text-align: center;\">100%</td></tr><tr><td style=\"text-align: center;\">20分钟后</td><td style=\"text-align: center;\">60%</td></tr><tr><td style=\"text-align: center;\">1小时后</td><td style=\"text-align: center;\">40%</td></tr><tr><td style=\"text-align: center;\">1天后</td><td style=\"text-align: center;\">30%</td></tr><tr><td style=\"text-align: center;\">2天后</td><td style=\"text-align: center;\">27%</td></tr></tbody></table><div style=\"margin: 0 auto;\">人的遗忘<p></p>程度都不一样，建议第二天复习前一天的内容，七天后复习这段时间的所有内容。<p></p><h4 id=\"碎片时间\" style=\"margin: 5px auto;  font-size: 14px;  \">　　碎片时间</h4><p>  不少朋友利用碎片时间学习，比如在公交上看公众号的推送。其实我们都高估了自己的抗干扰能力，如果处在嘈杂的环境，注意力容易被打断，记忆留存度也很低。碎片时间适合学习简单孤立的知识点，比如链表的定义与实现。</p><p>  学习复杂的知识，需要大段的连续时间。图书馆是个好地方，安静氛围好。手机放一边，不要理会QQ微信，最好阅读纸质书，泡上一整天。有些城市出现了付费自习室，提供格子间、茶水等等，也是非常好的选择。</p><h3 id=\"用起来\" style=\"margin: 5px auto;   font-size: 14px;  \">　　<span style=\"  font-size: 16px;\">用起来</span></h3><h3 id=\"技术分享\" style=\"margin: 5px auto;   font-size: 14px;  \">　　技术分享</h3><p>  从下面这张图我们可以看到，教授他人是知识留存率最高的方式。</p><p style=\"text-align: center;     \"><img style=\"width: 400px;\" src=\"data:image/jpeg;base64,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\" data-filename=\"image.png\"><br></p><p></p><p>  准备PPT和演讲内容，给同事来一场技术分享。不光复习知识，还锻炼口才。曾经有个同事说话又快又急，口头禅也多，比如\"对吧、是不是”，别人经常听不清，但是他本人不以为然。领导让他做了几次技术分享，听众的反应可想而知，他才彻底认清缺点。</p><p>  坚持写技术博客，别在意你写的东西在网上已经重复千百遍。当自己动手的时候，才会意识到眼高手低。让文章读起来流畅清晰，需要呕心沥血的删改。写作是对大脑的长期考验，想不到肯定写不出，想不清楚肯定写不清楚。</p><h3 id=\"造个轮子\" style=\"margin: 5px auto;   font-size: 14px;  \">　　造个轮子</h3><p>　　我们经常说不要重复造轮子。为了开发效率，可以不造轮子，但是必须具备造轮子的能力。建议造一个简单的MQ，你能用到通信协议、设计模式、队列等许多知识。在造轮子的过程中，你会频繁的翻阅各种手册或者博客，这就是用输出倒逼输入。</p><table <br=\"\"></table></div>', 4, 1, 0, 1, 1676484956358, 0);
INSERT INTO `t_blog` VALUES (30, 1, 20, '我应该使用哪个版本的 JDK？', '<blockquote><p>本文在写作过程中参考了<a href=\"http://whichjdk.com\" title=\"whichJDK\">whichJDK</a></p></blockquote><div><p><img alt=\"\" src=\"data:image/jpeg;base64,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\">​</p></div><p>要构建和运行Java应用程序，就需要安装JDK环境。</p><p>OpenJDK是Java SE规范的开源软件，但它只是源代码。二进制发行版由不同的供应商提供，适用于许多受支持的平台，这些发行版在许可证、商业支持、支持的平台和更新频率方面有所不同。</p><h2>先说结论：</h2><p>✅建议使用<strong>Adoptium Eclipse Temurin 17</strong>并确保您的本地版本与CI和生产版本匹配。</p><hr><h2>首先介绍不同版本的JDK</h2><p>当前，JDK计划每六个月（即每年的三月和九月）发布一个具有新版本。第三年的9月发布一个长期支持(LTS)版本，承诺最少更新三年。</p><div class=\"table-box\"><table border=\"1\" cellspacing=\"0\"><thead><tr><th>JDK版本</th><th>类型</th><th>发布日期</th><th>主要更新</th><th>推荐</th></tr></thead><tbody><tr><td>8</td><td><strong>长期支持</strong></td><td><strong>03/2014</strong></td><td>lambda</td><td>先前发布模型下的最后一个LTS版本。Oracle的免费更新已<a href=\"https://www.oracle.com/java/technologies/java-se-support-roadmap.html\" title=\"结束\">结束</a>，但仍由其他人维护。在接下来的几个月内升级到11或17！</td></tr><tr><td>9</td><td>特征</td><td>09/2017</td><td>模块</td><td>引入了新的发布模型。停产。现在升级到11或17！</td></tr><tr><td>10</td><td>特征</td><td>03/2018</td><td>var</td><td>停产。现在升级到11或17！</td></tr><tr><td>11</td><td><strong>长期支持</strong></td><td><strong>09/2018</strong></td><td>新的HTTP客户端</td><td>广泛使用的LTS版本。计划在未来几个月内升级到版本17。</td></tr><tr><td>12</td><td>特征</td><td>03/2019</td><td></td><td>停产。现在升级到17！</td></tr><tr><td>13</td><td>特征</td><td>09/2019</td><td></td><td>停产。现在升级到17！</td></tr><tr><td>14</td><td>特征</td><td>03/2020</td><td>新的Switch表达式</td><td>停产。现在升级到17！</td></tr><tr><td>15</td><td>特征</td><td>09/2020</td><td>文本块</td><td>停产。现在升级到17！</td></tr><tr><td>16</td><td>特征</td><td>03/2021</td><td>记录</td><td>停产。现在升级到17！</td></tr><tr><td>17</td><td><strong>长期支持</strong></td><td><strong>09/2021</strong></td><td>密封类</td><td>当前的LTS版本。立即更新至17.0.3+！</td></tr><tr><td>18</td><td>特征</td><td>03/2022</td><td>默认为UTF-8</td><td>坚持17！<br>这是一个没有重要功能的短期版本。<code>-Dfile.encoding=UTF-8</code>您可能想通过在当前的JDK中进行设置来检查是否遇到“默认UTF-8”的任何问题。</td></tr><tr><td>19</td><td>特征</td><td>09/2022</td><td>仅预览和孵化器功能</td><td>坚持17！<br>如果您之前升级到18，请立即升级到19。</td></tr></tbody></table></div><p>您必须决定是要坚持使用最新的LTS版本，还是要使用最新的功能版本并每六个月升级一次。两种选择都可以，但如果您不确定，请坚持使用最新的LTS版本。</p><p>OpenJDK项目本身在<a href=\"https://openjdk.java.net/\" title=\"openjdk.java.net\">openjdk.java.net</a>上进行管理，您可以在其中找到规范、源代码和邮件列表，但没有可供下载的构建版本。您需要选择一个发行版。</p><hr><h1>不同的厂商版本：</h1><h3 style=\"color:#fe2c24;\">Oracle OpenJDK</h3><p>Oracle以压缩存档格式为Linux、macOS和Windows提供OpenJDK构建。</p><p>这些构建只会更新6个月。在此短时间后将无法获得更新和安全补丁。这也适用于LTS版本！例如，最新的OpenJDK 11版本是<a href=\"https://jdk.java.net/archive/\" title=\"11.0.2+9\">11.0.2+9</a>而当前的OpenJDK版本是<a href=\"https://wiki.openjdk.java.net/display/JDKUpdates/JDK11u\" title=\"11.0.12+7\">11.0.12+7</a>。</p><h3 style=\"color:#fe2c24;\">Oracle Java SE Development Kit(JDK)</h3><p>Oracle提供了OpenJDK的商业版本，它基于与OpenJDK完全相同的来源：Oracle Java SE Development Kit(JDK)。Oracle为这些构建提供更新定期更新和安全补丁。</p><h3 style=\"color:#fe2c24;\">Adoptium Eclipse Temurin</h3><p>Eclipse Adoptium是Eclipse Foundation旗下的顶级项目，为开源软件提供资源和专业的治理模型。Adoptium工作组由对Java技术有战略兴趣的主要公司和组织组成，包括Red Hat、IBM、Microsoft、Azul和iJUG。之前的AdoptOpenJDK项目已经迁移到Eclipse Adoptium。</p><p>Adoptium OpenJDK构建称为<em>Eclipse Temurin</em>，以区分项目和构建。</p><p>Eclipse Temurin构建是高质量的、供应商中立的，并且在宽松许可下经过了TCK测试。</p><p>Adoptium表示，只要积极维护相应的上游源代码，它将继续为LTS版本构建二进制文件。</p><h3 style=\"color:#fe2c24;\">AdoptOpenJDK</h3><p>AdoptOpenJDK项目是Eclipse Adoptium的前身，为默认的HotSpot和OpenJ9虚拟机提供高质量的OpenJDK构建。</p><h3 style=\"color:#fe2c24;\">Azul Zulu</h3><p>Azul Systems,Inc.专注于专业的Java技术和JDK的商业支持。Azul在业界享有很高的声誉，并参与了各种工作组来发展Java平台。</p><p>Azul为许多操作系统和架构提供名为<em>Azul Zulu</em>的开源OpenJDK构建。此外，Azul还提供满足特殊要求的构建，例如精简的JRE和包含OpenJFX的构建。</p><p>这些构建的缺点是依赖于一家公司，这可能会突然更改其许可或更新政策。</p><h3 style=\"color:#fe2c24;\">Azul Zing</h3><p>Azul Zing是一个商业JDK，目前作为<em>Azul Platform Prime</em>销售。它需要与Azul Systems签订商业合同才能用于生产。</p><p>Zing基于OpenJDK，并添加了获得专利的“C4无间断垃圾收集器”、“Falcon JIT编译器”（以更高的CPU使用率和更长的启动和预热时间为代价优化吞吐量）和一些功能加快编译器预热时间（通过分析和存储文件中训练运行的优化来减轻Falcon JIT编译器较慢的预热时间）。</p><p>Azul Zing在金融交易应用程序中有一些用例，其中GC暂停是一个问题。除此之外，常规OpenJDK包含免费的低暂停时间GC&nbsp;<a href=\"https://wiki.openjdk.java.net/display/shenandoah/Main\" title=\"Shenandoah\">Shenandoah</a>和<a href=\"https://wiki.openjdk.java.net/display/zgc\" title=\"ZGC\">ZGC</a>，它们可能是替代方案。</p><h3 style=\"color:#fe2c24;\">BellSoft Liberica JDK</h3><p>与Azul类似，BellSoft专注于专业的Java技术和对JDK的商业支持。此外，BellSoft在业界享有很高的声誉，并参与了各种工作组来发展Java平台。</p><p>BellSoft为几乎所有操作系统和架构提供名为<em>Liberica JDK</em>的开源OpenJDK构建。</p><p>流行的Spring Boot框架选择Liberica JDK作为其<a href=\"https://github.com/paketo-buildpacks/bellsoft-liberica\" title=\"buildpack\">buildpack</a>的运行时。</p><p>这些构建的缺点是依赖于一家公司，这可能会突然更改其许可或更新政策。</p><h3 style=\"color:#fe2c24;\">IBM Semeru Runtime</h3><p>IBM开发了自己的Java虚拟机版本，称为J9，并作为<em>Eclipse OpenJ9开源</em>。它是默认HotSpot Java虚拟机的替代品，但它从未获得太多人气。</p><p>IBM现在提供基于Eclipse OpenJ9 Java虚拟机和一些OpenJDK类库的名为<em>Semeru Runtime的构建。</em>OpenJ9<a href=\"https://www.eclipse.org/openj9/performance/\" title=\"内存占用低，使用共享类启动速度快\">内存占用低，使用共享类启动速度快</a>，但与Hotspot虚拟机相比吞吐量较低。</p><h3 style=\"color:#fe2c24;\">Amazon Corretto&nbsp;</h3><p>由于Oracle改变了对其OpenJDK构建的支持和许可政策，主要的云提供商决定建立自己的托管OpenJDK构建并提供长期更新。显然，这是为了规避风险，尤其是对甲骨文的诉讼。</p><p>2018年，AWS发布了<em>Corretto</em>，这是另一个OpenJDK构建。</p><p>AWS包括来自较新OpenJDK版本的错误修复的反向端口，并<a href=\"https://aws.amazon.com/corretto/faqs/\" title=\"声称\">声称</a>他们将添加可能尚未集成到OpenJDK项目中的补丁。亚马逊已经实施了一个替代<a href=\"https://github.com/corretto/amazon-corretto-crypto-provider\" title=\"加密提供商\">加密提供商</a>，该提供商已针对其服务进行了优化。它<a href=\"https://aws.amazon.com/blogs/opensource/introducing-amazon-corretto-crypto-provider-accp/\" title=\"计划\">计划</a>用作Corretto中的默认加密实现。</p><p>Amazon为主要开发平台提供发行版，并为其自己的Amazon Linux 2提供优化版本。</p><h3 style=\"color:#fe2c24;\">Microsoft&nbsp;OpenJDK</h3><p>2021年，微软发布<em>了OpenJDK的Microsoft Build</em>，这是另一个OpenJDK构建。</p><p>Microsoft可能会包含来自较新OpenJDK版本的错误修复的反向端口，并声称他们将添加可能尚未集成到OpenJDK项目中的补丁。</p><p>Microsoft为主要开发平台提供版本。</p><h3 style=\"color:#fe2c24;\">Alibaba Dragonwell</h3><p>阿里巴巴提供了一个OpenJDK构建，其中包括后台端口和一些<em>额外的功能</em>。</p><h3 style=\"color:#fe2c24;\">SapMachine</h3><p>SapMachine是另一个OpenJDK Build，由SAP维护。</p><h3 style=\"color:#fe2c24;\">Red Hat&nbsp;OpenJDK</h3><p>Red Hat为LTS版本提供OpenJDK构建。</p><h3 style=\"color:#fe2c24;\">OJDK</h3><p>该项目已停止。ojdkbuild项目的目标是提供OpenJDK的Windows x86_64二进制文件，这些二进制文件在行为上尽可能接近Linux OpenJDK包，例如，通过使用系统库而不是zlib或OpenSSL的打包版本。它使用了CentOS中包含的软件包。这些构建的一个用例是在Windows机器上开发Java软件并将它们部署到生产环境中的Linux服务器。</p><h3 style=\"color:#fe2c24;\">GraalVM</h3><p>GraalVM是一个完全兼容的JDK，但与所有其他构建有很大不同。</p><p>GraalVM由Oracle开发。它基于OpenJDK，但包括一个新的高性能编译器和一个新的多语言虚拟机（可以执行用不同编程语言编写的代码）。还可以创建高度优化且启动速度极快的特定于平台的本机可执行文件。</p><p></p><p></p>', 0, 0, 0, 0, 1676486597178, 0);
INSERT INTO `t_blog` VALUES (34, 1, 20, '我好喜欢你呀', '<div style=\"padding: 20px;background-color:rgb(254, 248, 246);border-radius:10px;\">\r\n    <p style=\"text-align: center;\"><img src=\"data:image/png;base64,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\" width=\"400px\"></p>\r\n    <div style=\"color:rgb(86, 86, 86);background-color:rgb(254, 248, 246);line-height:2;letter-spacing:1.5px;\">\r\n        <p style=\"text-indent:2em;\"><span>今天，我坐在桌前，从楼上往下看，远处的大街上车流不断向前流淌着，因为离得有点远，一切都变得很缓慢。看得我有一种错觉，似乎时间也慢下来，</span><strong><span style=\"color:rgb(250, 150, 120)\">这个时候，我<strong style=\"text-align:left\"><span>就</span></strong>突然好想你。</span></strong></p>\r\n        <p style=\"text-indent:0em;\"><br></p>\r\n        <p style=\"text-indent:2em;\"><span>你正在出差，要10天才能回来，到今天已经过去了7天。看不见你的这些天，我常常会望着窗外出神。周围很安静，好像能听到时间滴答滴答地走过。</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>这几天，我们一直通过网络联系。早上我给你发了一张照片，是我在楼下便利店买的咖啡。</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>开盖之后，上面的拉花是一个心形，于是我拍了照片发给你。“喏，连咖啡都是爱你的形状～”其实，我的潜台词是我想你了。</span><br></p><br>\r\n        <p style=\"text-indent:2em;\"><strong><span style=\"color:rgb(250, 150, 120)\">分开的这几天，我每天都会想你。</span></strong></p>\r\n        <p style=\"text-indent:2em\"><br></p>\r\n    </div>\r\n    <p style=\"text-align: center;\"><img style=\"border-radius: 20px;\" src=\"data:image/jpeg;base64,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\" width=\"140px\"></p>\r\n    <div style=\"color:rgb(86, 86, 86);background-color:rgb(254, 248, 246);line-height:2;letter-spacing:1.5px;\">\r\n        <p style=\"text-indent:2em\"><br></p>\r\n        <p style=\"text-indent:2em;\"><span>以前我看过一句话：</span><strong><span style=\"color:rgb(250, 150, 120)\">当你非常想念一个人的时候，一天就会被分成好几段。</span></strong></p>\r\n        <p style=\"text-indent:2em;\"><span>这几天我才明白，它说的是真的。今天我在凌晨5点多就醒了，拿起手机看了一眼日期，发现离你回来还有3天。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>早上在通勤的地铁上，我看到身边坐着一对情侣，他们穿的情侣款羽绒服很好看。我盯着看了好久，一直在想你和我穿上同款的样子。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>中午我去楼下吃饭，抬头看着天空的时候，突然想起那句：你笑起来就像好天气。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>下午，我看到朋友圈有小伙伴和男朋友去了一片杉树林。你知道冬天的杉树林有多好看吗？人很少，很安静，很适合拍照片。阳光透过杉树林照射下来，树影斑驳，很有意境。我就想着啊，等你回来，我们就可以去一趟了。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>傍晚，我就坐在窗前，看着天边的夕阳一点点沉落下去，终于又过完了一天......</span></p>\r\n        <p style=\"text-indent:2em;\"><strong><span style=\"color:rgb(250, 150, 120)\">我从不知道，原来一天有这么漫长。</span></strong></p>\r\n        <p style=\"text-indent:2em\"><br></p>\r\n    </div>\r\n    <p style=\"text-align: center;\"><img src=\"data:image/gif;base64,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\" width=\"100px\"></p>\r\n    <div style=\"color:rgb(86, 86, 86);background-color:rgb(254, 248, 246);line-height:2;letter-spacing:1.5px;\">\r\n        <p style=\"text-indent:2em;\"><span>对了，这段时间，我还发现了很多秘密。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>我发现对面大厦外的停车场，最多的时候可以停满27辆车；发现路灯亮起来的时间是下午5点35分；而路灯旁的三棵香樟树，中间那棵比旁边两棵粗一点。</span></p>\r\n        <p style=\"text-indent:2em;\"><strong><span style=\"color:rgb(250, 150, 120)\">除此之外，我还会玩一些“无聊的”游戏。</span></strong></p>\r\n        <p style=\"text-indent:2em;\"><span>比如，我想和你发信息的时候，我就一直很犹豫。因为我知道你很忙，我怕给你发信息会打扰到你。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>不过后来我就想让别的东西替我决定，我和自己说好，如果出地铁口的台阶是单数，我就找你；如果是双数，就等你来找我。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>数完之后我发现是36阶，于是我就把地上的那一级也算上了。所以我就理直气壮地给你发消息了。</span></p>\r\n        <p style=\"text-indent:2em\"><br></p>\r\n    </div>\r\n    <p style=\"text-align: center;\"><img style=\"border-radius: 20px;\" src=\"data:image/jpeg;base64,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\" width=\"140px\"></p>\r\n    <div style=\"color:rgb(86, 86, 86);background-color:rgb(254, 248, 246);line-height:2;letter-spacing:1.5px;\">\r\n        <p style=\"text-indent:2em\"><br></p>\r\n        <p style=\"text-indent:2em;\"><span>昨晚刷手机的时候，看到这样一段话：“今天和朋友聊为什么对喜欢的人好，他说一方面是为对方好，另一方面是成全自己的喜欢，但后者的意义更大。”我听后思考了许久......</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span style=\"text-indent:2em;\">认识你之后，我发现自己变了很多。之前每每遇到棘手的问题我都会下意识地逃避，是你告诉我，</span><span style=\"text-indent:2em\"><strong><span style=\"text-indent:2em;color:rgb(250, 150, 120)\">逃避解决不了任何问题，只会带来更深的负担。</span></strong></span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>也是你让我知道，喜欢一个人，就要表达出来。</span></p><br>\r\n        <p style=\"text-indent:2em\"><br></p>\r\n    </div>\r\n    <p style=\"text-align: center;\"><img src=\"data:image/jpeg;base64,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\" width=\"100px\"></p>\r\n    <div style=\"color:rgb(86, 86, 86);background-color:rgb(254, 248, 246);line-height:2;letter-spacing:1.5px;\"><br>\r\n        <p style=\"text-indent:2em;\"><span>生活大爆炸里面，谢耳朵说：</span><strong><span style=\"color:rgb(250, 150, 120)\">想你的时候，我的大脑眼窝前额会亮起来，就像闪耀的星辰。</span></strong><span>所以，想一个人的时候是寂寞多一些，还是美好多一些呢？</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>我想，应该是美好多一点吧。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>前几天早上打车的时候，我在车上听了广播。广播里主持人讲到了一件艺术品。艺术品很简单，只是一堆糖果，但又不是一堆普通的糖果。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>过去的很多年里，这堆糖果曾经出现在世界各地的很多著名展览馆里。它是一件艺术作品，最初创造这个作品的人，是个艺术家，糖果的重量不多不少，正好是79.4公斤。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>这是个什么重量呢？这是艺术家的爱人生前的体重。</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>展出的时候，在糖果的周围，没有任何护栏。也就是说，来参观的人，可以随意拿走一些做纪念，带走也行，吃了也可以。但是，每一天的展览结束，艺术家都会给这堆糖果重新称重，然后补齐被拿走的部分。就这样日复一日，从不间断。</span></p><br>\r\n        <p style=\"text-indent:2em;\"><span>这堆糖果的重量，始终是79.4公斤。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>主持人说，这件作品想表达什么呢？生命是那么甜蜜，就像糖果。但生命终会流逝，就像糖果总会被人拿走。</span><strong><span style=\"color:rgb(250, 150, 120)\">最重要的是不管发生什么，爱你的人，总会让你一次次重生。</span></strong><span>但是你知道我听到这个故事时，我是怎么想的吗。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>我想到的是，思念一个人那么苦涩，艺术家却把它做成了糖果。</span></p>\r\n        <p style=\"text-indent:2em;\"><span>什么意思呢？每每想你的时候，虽然我也会觉得孤独和寂寞。</span><strong><span style=\"color:rgb(250, 150, 120)\">可我也真的，真的好喜欢你呀。</span></strong></p>\r\n    </div>\r\n</div>', 23, 7, 20, 1, 1676492360417, 0);
INSERT INTO `t_blog` VALUES (35, 1, 20, '“留言式”聊天：我回你是秒回，你回我是轮回', '<section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; visibility: visible; overflow-wrap: break-word !important;\">一个心情愉快的下午，小桐偶然在路边看见了一只小猫，便随手拍了下来，把照片发给了闺蜜。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">“看，好可爱的小猫啊！”</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">到了晚上，闺蜜并没有回复。小桐想，她是不是很忙，还没来得及回消息呢？</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">睡觉之前，闺蜜还是没有回复。小桐不禁猜测，难道是自己发的内容太无聊了，对方并不想回……</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">小桐本来轻松的一天，以一种略紧张的心情结束了。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">直到两天后，闺蜜终于发来了消息，但是说的却是另一件事，完全忽略了之前的消息。这让小桐更加难受了。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">无论是朋友间的日常互动，还是线上办公时的合作沟通，我们都经历过发出去的消息长时间没有回应的情况。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">“留言式聊天”指的就是这种短期内得不到回复的聊天方式。聊天框变成了留言板，只有一方在说话，或者双方的对话时隔很久，不在一个频道。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">线上聊天软件使得沟通更加便捷，但遥远的网络交流也增加了不确定性。在线下互动中，动作、表情、预期都可以帮助我们传达和接受信息，而线上交流时，我们却可以轻而易举地逃避对方的请求，做到“杳无音讯”。</span></section></section><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px 10px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(0, 122, 170); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">“杳无音讯”的杀伤力</span></strong></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section></section></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">大多数时候，我们在发出消息之后，都希望得到对方及时的、认真的回应，而信息接收方的“沉默”或“滞后”却违背了这种期待。到底会不会使发出信息的一方感到受伤？首先要看双方的关系状态。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">周玮有个闺蜜3人群，她们从上大学就是同一专业的校友，毕业后又先后应聘到同一个单位，经过10年左右的交往，3人早已发展为超越其他关系的老友记。她们在群里讲话随意，分享多样，谁多说一句少说一句，有可能收到回应，或者完全没回应，如同多年老夫老妻，即便是隔好几天再回复，都没有被冷落的担忧。</span></section></section><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">这种关系安全感强，情感稳定，谁也不会把“回复是否及时”当作检验的信号。<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">但如果双方不是“强关系”，而是一般关系或“弱关系”，肯定会使发出信息的一方产生挫败感，影响双方的连接。</strong></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">当发出的消息长久没有得到回复，或者超出对方以往回复消息的时间间隔时，我们就容易产生对方“已读不回”的判断，进而陷入一种“不确定”的处境，忍不住猜测对方不回复的原因，甚至将这种不回复解读为轻视和反感。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">心理学研究发现，相比于粗鲁的回应，这种不回复、迟回复导致的“忐忑”心境会给消息发出方带来更大的伤害，甚至影响消息发出当天的睡眠质量和第二天早晨的情绪。</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">培训机构顾问娜娜一直都和老师们保持密切合作，但突然有一天她发现，当她向一位老师发出讲课邀约时，老师不再及时回复，而是隔天回复，当这样的情况持续两次，娜娜对于继续合作有点没信心了，第三次邀请，老师就不再回复了。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">娜娜托别人打听老师的近况，同时一直反思自己到底做错了什么，日常关系到底出了哪些问题……娜娜说：“相处多年、合作特别愉快的关系突然死亡，让人觉得极其挫败，也很莫名其妙。还不如直接告诉我，我到底哪里做得不好。”</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">长久的间隔和沉默不仅会影响线上沟通的效率，还会减少沟通双方对情绪的积极表达：如喜爱和赞赏，建议和意见，最终恶化双方的关系。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">当人们把“留言式聊天”当成了一种惯常的沟通方式。经历了他人沉默的对待之后，我们渐渐习惯了这种表达，最后可能也成为沉默的一方。不经意间，我们也“随意地”忽视新消息，而屏幕那头，可能有个忐忑的心情，正焦急地期待着。</span></section></section><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 14px; color: rgb(100, 100, 100); line-height: 1.8; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section></section></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-align: center; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; color: rgb(0, 122, 170); overflow-wrap: break-word !important;\">拒绝“沉默”的伤害</span></strong></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p></section></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">消息没有得到期待中的回应，怎样解释对方的沉默很重要。我们可能会“简单粗暴”地归结为“逃避和厌烦”。正是这种解释对自身的心理健康和双方的关系造成了损害。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">在生活节奏加快的当下，各种消息肆意地“入侵”生活的每个角落。这种情况下，收到消息却忘记回复，或者用“意念”回复的情况常有发生。当我们需要对方及时地回应时，直接向对方表达，比暗自神伤要好得多。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">有一种方式可以延迟双方处理信息的焦虑：收到请求后及时确认，无法立即给对方答案，也应该说“稍候看”“收到”，让对方知道会在一段时间内再联系等。<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">有时，我们可能因为太忙来不及回复对方，但也应该在沉默后及时地作出解释，告知原因。</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">职场上的合作关系中，沉默或迟滞回复除了给对方造成不良感受，对自己来说也是一种损失。当信息发出的那一方没有收到期待的回复时，继续合作的欲望也会大大降低。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; overflow-wrap: break-word !important;\">无论是发出消息的一方，还是沉默的一方，都应该尽量减少“留言式聊天”的出现，避免把这个习惯当成理所当然。</span></p></section></section></section>', 13, 3, 15, 1, 1676492770603, 0);
INSERT INTO `t_blog` VALUES (36, 1, 20, '让绿色成为美丽中国最鲜明、最厚重、最牢靠的底色', '<p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">国务院新闻办公室1月19日发布《新时代的中国绿色发展》白皮书，从坚定不移走绿色发展之路、绿色空间格局基本形成、产业结构持续调整优化等7个方面，全面介绍新时代中国绿色发展理念、实践与成效，分享中国绿色发展经验。我国绿色发展取得的巨大成就，赢得了国际社会高度赞誉和广泛认同。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">绿色是生命的象征、大自然的底色，良好生态环境是美好生活的基础、人民共同的期盼。党的十八大以来，在习近平新时代中国特色社会主义思想指导下，中国坚持绿水青山就是金山银山的理念，坚定不移走生态优先、绿色发展之路，促进经济社会发展全面绿色转型，建设人与自然和谐共生的现代化，创造了举世瞩目的生态奇迹和绿色发展奇迹，美丽中国建设迈出重大步伐。绿色成为新时代中国的鲜明底色，绿色发展成为中国式现代化的显著特征，广袤中华大地天更蓝、山更绿、水更清，人民享有更多、更普惠、更可持续的绿色福祉。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">数据最有说服力。2012－2021年，累计完成造林9.6亿亩，防沙治沙2.78亿亩，种草改良6亿亩；2018年以来，累计腾退长江岸线162公里，滩岸复绿1213万平方米，恢复水域面积6.8万亩；城市建成区绿化覆盖率由2012年的39.22%提高到2021年的42.06%，人均公园绿地面积由11.8平方米提高到14.78平方米……白皮书以大量详实的数据、丰富的案例，生动展现了我国绿色发展取得的历史性成就。十年砥砺前行，我国生态环境保护发生历史性、转折性、全局性变化，走出了一条生产发展、生活富裕、生态良好的文明发展道路，实现了经济社会发展和生态环境保护的协调统一，形成了全社会共同推进绿色发展的良好氛围，顺应了人民对美好生活的新期待，也为经济社会高质量发展奠定了坚实基础。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">中国的绿色发展，为地球增添了更多“中国绿”，扩大了全球绿色版图，既造福了中国，也造福了世界。应当看到，保护生态环境、应对气候变化，是全人类的共同责任。中国站在对人类文明负责的高度，积极参与全球环境治理，携手共建美丽地球家园。从向世界承诺力争于2030年前实现碳达峰、努力争取2060年前实现碳中和，到坚定落实《联合国气候变化框架公约》，以积极建设性姿态参与全球气候谈判议程；从积极推动建立共建“一带一路”绿色低碳发展合作机制，到成功举办《生物多样性公约》第十五次缔约方大会第一阶段会议，以及《湿地公约》第十四届缔约方大会……实践充分证明，中国始终是全球生态文明建设的重要参与者、贡献者和引领者。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">党的二十大擘画了中国未来发展蓝图，描绘了青山常在、绿水长流、空气常新的美丽中国画卷，指出中国式现代化是人与自然和谐共生的现代化，对“推动绿色发展、促进人与自然和谐共生”作出战略部署。踏上新征程，站在人与自然和谐共生的高度谋划发展，坚定不移走绿色发展之路，推进生态文明建设，推动实现更高质量、更有效率、更加公平、更可持续、更为安全的发展，必能让绿色成为美丽中国最鲜明、最厚重、最牢靠的底色，让人民在绿水青山中共享自然之美、生命之美、生活之美。站在历史正确的一边、站在人类文明进步的一边，以“碳达峰碳中和”目标为牵引推动绿色转型，以更加积极的姿态开展绿色发展双多边国际合作，必能为全球可持续发展贡献更多中国智慧和中国力量。</p>', 3, 0, 0, 0, 1676492865717, 0);
INSERT INTO `t_blog` VALUES (37, 1, 20, '专家：ChatGPT尚不具备自主的“心智”', '<p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">德国比勒菲尔德大学的金耀初教授长期从事计算智能、演化计算、机器学习、计算神经科学等交叉学科的理论研究和工程应用，目前已发表学术论文500余篇，论文被引用次数达37400余次，2019—2022年连续4年被Web of Science评为“全球高被引科学家”。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">近日，围绕热门科技话题ChatGPT，记者专访了欧洲科学院院士、德国比勒菲尔德大学洪堡人工智能教席教授金耀初。金教授同时兼任英国萨里大学计算系“计算智能”讲席教授 、IEEE计算智能学会候任理事长，曾任《IEEE认知与发育系统汇刊》主编等职。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>生成式模型的重大进展</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">谈到ChatGPT最核心的东西，金耀初表示，ChatGPT所代表的技术是第三波人工智能技术取得的一个重大进展。它基于生成式预训练Transformer模型，采用了“自注意力机制”。与传统的判别式模型相比，生成式模型的最大特点是直接学习训练数据本身的特点，因而能更有效地学习大容量的样本，特别是海量的语言、视觉信息。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">传统的语言处理模型一般只能根据字词的前后相邻词语来找它们之间的关系，因此有很大的局限性。Transformer引入了自注意力机制后，它就能很灵活地找出不单是某一个句子，而是不同句子，甚至是整篇文章或不同的文章之间词的相互关系，学习能力就增强了很多。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>横空出世非一日之功</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">对于ChatGPT的横空出世，金耀初强调这仅仅是大众的感受。从科研的角度看，ChatGPT也是一步一步演进而来的。根据OpenAI发表的论文，ChatGPT是花了很长时间，用了各种学习方法不断训练和微调出来的。生成式模型给出的答案并不是人们事先给它的训练数据，而是模型生成出来的，所以很难保证百分之百正确。ChatGPT在训练过程中用到非常多的最新的学习技术。例如，无监督学习、有监督学习、多任务学习、小样本学习、自监督学习等。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">此外，它还加入了基于人类反馈的强化学习，以获得与人类对齐、共情能力。通过人类评价，即给它生成的答案打分来选择一个最佳的答案。这个过程实际上是一个强化学习过程，也就是对原来的模型进行微调。其他AI模型可能没有像ChatGPT这样，用大量的人类反馈来使得模型能产生更加符合人类期待的回答，相应的体验就会有差距。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>尚不具备自主的“心智”</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">金耀初谈到，作为一个从文本到文本的对话系统，ChatGPT最强的地方是对自然语言的充分学习，生成的文本更加“流畅”并符合人类体验，这是一个重大的技术创新。但值得注意的是，生成式机器学习模型有很多，比如从文本到语音信息，或者文本到图像信息，这些方面ChatGPT的表现可能就没那么好了。这是它的一个局限性。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">另一方面，目前ChatGPT训练的数据截至2021年，没有训练过的东西，它是不可能准确回答出来的。换句话说，目前的模型不具备创造新知识的能力。ChatGPT回答问题时用的是推理。它不是那种在数据库中搜索答案的概念。生成式模型是根据问题本身联想出一个答案。这个答案是模型“学习消化”后产生出来的东西，不是原始的数据。严格意义上来说，模型本身甚至不知道这个答案的真正含义，它也不能保证答案肯定是对的。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>ChatGPT不是“万能”的</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">金耀初认为，ChatGPT离真正的专业应用还有一定的距离。现在大家感觉很新奇，都在尝试玩一玩。有的人甚至以为ChatGPT什么都能干，可以很快用在自动驾驶之类的很多应用上，这其实是误解。自动驾驶的重点不是文本到文本的问题，纯粹的生成式模型是不够的。它需要其他判别式的机器学习模型，特别是实时场景的识别。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">以现在热议的医疗服务为例，尽管ChatGPT在美国执业医师资格考试中取得不错的成绩，但真实情况下人们会用ChatGPT来代替医师进行诊疗吗？至少目前还不行，因为无法保证它的答案百分之百是正确的。有人说ChatGPT有时会一本正经地胡说八道，这样的描述是比较中肯的，人们不能忽视这种风险。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>期待未来更多突破</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">金耀初表示，这一波人工智能可能不会像第一波和第二波人工智能浪潮那样很快偃旗息鼓。它会继续发展下去，未来三五年，人工智能领域可能还会涌现一些令人吃惊的突破。很多基于ChatGPT的新的想法或技术或会涌现，并在此基础上找到真正好的细分领域的应用。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">至于人工智能和机器人的结合，金耀初强调，从某种意义上来说，这一直是人工智能研究的重点之一。现在ChatGPT与人对话这么流畅，如果把它与数字虚拟人技术结合起来，一般人可能很难分辨出计算机屏幕里回答问题的是真人还是一个数字人。当然，未来的发展过程中会涉及很多人工智能的本质问题，包括信任、责任、伦理、法律问题等。乐观地看，ChatGPT等人工智能应用的影响力急剧扩大，反过来会在一定程度上推动上述问题的解决。</p>', 1, 0, 0, 0, 1676492937898, 0);
INSERT INTO `t_blog` VALUES (38, 1, 20, '对撞机，究竟是个什么机', '<p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">在由科幻小说《三体》改编的同名电视剧中，对撞机可以说是最重要的道具了——正是因为“三体人”利用它们的高科技产物“智子”影响了地球上对撞机的实验，使得物理实验结果变得无规律可循，才让一部分科学家的信念崩塌，走上了自绝之路。那么，作为真实存在的科研设备，对撞机究竟是什么？它又对人类有哪些作用呢？</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>1.对撞机因何而生？</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>研究微观世界的大科学装置</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">在19世纪末期之前，人类对于世界的运行规律的认知几乎都只停留在宏观物体和现象上。19世纪末，从伦琴发现X射线，J.J.汤姆孙发现电子，卢瑟福发现α射线和β射线等实验起，物理学家们开始专注于微观世界的物理现象。特别是20世纪20年代量子力学建立之后，物理学家们逐渐意识到，在微观的尺度上，存在着一个跟宏观世界很不一样的世界，它的尺度如此之小，所以科学家们不得不借助一些特殊的实验仪器来观测其中的现象。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">早期对于微观世界的研究，通常是对天然的放射性物质或宇宙线进行观测。那时的科学家，会将微观尺度的现象放大至宏观可见的尺度，然后再进行观测——科学家们会使用能在一些射线中曝光的照片底片，或者使入射粒子在过饱和蒸气中形成一连串的电离原子作为凝结核，进而在粒子轨迹上形成一连串的雾气的“云室”等来观测微观粒子造成的现象，并通过分析这些微观粒子所留下的径迹的结构和形状来推测粒子的性质。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">在20世纪30年代前后，一个更加强大的粒子物理的研究工具出现了——劳伦斯发明了回旋粒子加速器。它的基本结构是两个半圆D型盒，以及D型盒之间的交流电场，两个半圆D型盒上则施加有可以使带电粒子偏转的磁场。在加速器的中心处放置有一个粒子源，其发射出的带电粒子受到电场的作用可以被加速，在进入半圆D型盒的磁场中时，则被磁场所偏转反向，并再次进入D型盒之间的交流电场。若时间调整合适，此时交流电场的方向正好可以翻转，带电粒子则再一次被加速。如此往复很多次，带电粒子就会被加速至带有较高的能量，其能量与方向均可被控制，可以极大地提高对微观粒子的研究能力。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">回旋粒子加速器使得人类能够可控地获得带有较高能量的微观带电粒子，进而可以更准确地研究这些粒子的性质。然而由于相对论效应，高能量的粒子的回旋周期会随能量的增高而发生改变。于是科学家们将回旋粒子加速器的均匀磁场以及电场变化频率也做了调整，使之能够最大程度地让带电粒子获得能量。这种电场及磁场可控的粒子加速器叫做同步加速器。同时改变电场和磁场，也使得带电粒子在加速的时候不必须经历一个连续变化的半径，因此，同步加速器可以被做成环形。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">由于量子效应的存在，想要研究更精细的粒子的结构，就必须获得更高的能量。加速器可以让粒子物理学家们获得前所未有的可控的高能量，于是粒子物理学的主要研究方式就变成了利用高能粒子加速器进行研究。因此，粒子物理学现在也被称为高能物理学。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">早期的加速器主要用来加速带电粒子并轰击原子靶，进而对轰击产物进行统计分析。随着粒子物理实验的进展，粒子物理的理论也得到了蓬勃的发展。一些能量更高的粒子被预言，而想要产生这些粒子，则需要建设更高能量的实验设备。并且，利用被加速的粒子束来轰击固定靶的实验形式会将绝大多数的能量浪费在轰击产物的动能上，于是，实验物理学家们开发了一种能够大大节约能量的办法，那就是加速两束运动方向相反的粒子，以极为精细的操作控制粒子们的位置，让他们在极小的空间内对撞。利用这种办法，可以使粒子的动能最大化地被利用，而这，就是目前粒子物理学研究最重要的研究设备：对撞机。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>2.对撞机有什么用？</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>科学发现的助推器，高技术应用的试验田</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">作为粒子物理学最重要研究设施的对撞机，能够直接决定粒子物理学大多数研究方向的发展水平。而粒子物理学的研究，则会直接面对物质最基本的组成成分，以及物质间的最基本的相互作用这样的研究对象，进而探索质量起源、宇宙演化、暗物质等最深刻、最神秘的课题。对物质的最基本的成分和相互作用的探索不仅仅可以满足人类的好奇心，也会为未来几十甚至上百年后的应用储备知识。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">在一个科学技术健康发展的社会，基础科学的研究水平应该是超越当前的时代的。也只有如此，能够影响人类生活的技术才能在有科学理论指导的情况下发展。如果基础科学研究停滞，那么在一段时间之后，技术的发展也会因为缺乏科学依据而难以进步。也正是因为这样的逻辑，《三体》小说和电视剧才会有“三体人”利用干扰对撞机实验来“锁死”人类科技的情节。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">然而，对撞机不仅仅能够对粒子物理学研究起到至关重要的作用。作为世界上最宏大与最先进的一类基础研究设施，对撞机也经常是最新、最大胆的技术的试验田。就比如，人类第一次大规模使用超导磁铁就是在建设于美国芝加哥郊外的费米实验室的Tevatron对撞机上。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">再比如，万维网的诞生，也与对撞机有密切的联系。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">虽然因特网在20世纪六七十年代就已诞生，但早期的因特网没有网站，因此，因特网的使用是一个高度技术性和专业性的工作。20世纪80年代末，在位于欧洲核子研究中心的大型正负电子对撞机正式开机运行的前夕，欧洲核子研究中心的数据科学家蒂姆·伯纳斯-李为了让粒子物理学家们更高效地共享信息，设计了超文本传输协议（HTTP）。不久，欧洲核子研究中心的科学家们按照这个协议搭建了人类历史上第一台万维网（WWW）服务器。从此，用户登录服务器上的网站，浏览网页获取信息成为可能。万维网的出现彻底改变了人类信息交流的方式，使得“上网”这件事从高度技术性的专业工作变成了人人可以完成的轻松小事。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">可见，对撞机这种由成千上万不同组件构成的、汇集了数千科学家与工程师的智慧才能建造而成的设施，其发展也能够带动许多不同应用领域的发展。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>3.未来对撞机什么样？</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>实现“希格斯工厂”对撞机</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">正如国内的很多现代学科一样，中国的粒子物理实验发展的历史比较短，道路也很曲折，但中国的高能物理学科发展得很快。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">早在20世纪50年代，中国的物理学家就曾在苏联科学家的帮助下设想过在中国建设自己的粒子加速器。然而直到改革开放初期，中国的粒子加速器的最终建设方案才得以成型。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">1981年12月22日，邓小平亲自听取了中国科学院关于建造22亿电子伏特正负电子对撞机建议报告会，并在会上批示：“这项工程进行到这个程度不宜中断，他们所提方案比较切实可行，我赞成加以批准，不再犹豫。”1984年10月7日，北京正负电子对撞机正式破土动工。1988年的10月18日，北京正负电子对撞机成功实现了首次对撞。至此，北京正负电子对撞机开始了它三十多年的科研生涯，在北京正负电子对撞机上运行的北京谱仪实验也成为第一个由我国主导的国际合作科学实验。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">如今，在经过了几次重大升级改造之后，北京正负电子对撞机仍在运行中，并且已经是τ-粲能区物理领域全球最重要的研究设备。它也使得中国能在世界粒子物理研究的舞台上占据一席之地，也启发了不少科幻作品——电视剧《三体》中关于对撞机的部分，就是在北京正负电子对撞机的加速器隧道内取景拍摄的。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">那么，未来对撞机会如何发展？中国又有哪些机会？</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">其实，对撞机物理一直在稳定发展中。2012年，在欧洲的大型强子对撞机上，科学家们发现了一种可以给其他基本粒子赋予质量的粒子，这种粒子被称为“希格斯粒子”，因为这种粒子与质量的特殊关系，它也常被媒体称为“上帝粒子”。希格斯粒子不仅仅和物质质量的起源有关系，早期宇宙演化的过程、暗物质等待探索的领域也与希格斯粒子息息相关。因此，未来对希格斯粒子的精确研究是国际粒子物理学界的共识。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">在发现这种粒子的同时，科学家们也对它的质量进行了测量，并得出了最高效地产生这种粒子的方式，那就是以特定的能量进行正负电子对撞，能够通过这种形式大量产生希格斯粒子的对撞机被称为“希格斯工厂”。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">有了这一信息，全球粒子物理研究主要强国纷纷提出了各自未来的“希格斯工厂”的方案。其中，2012年下半年，中国的科学家就率先提出了在中国建造环形正负电子对撞机方案，而欧洲科学家也紧随其后，提出了欧洲版的环形正负电子对撞机方案。日本的粒子物理学家则调整了原有的直线对撞机运行方案的能量，使得日本的对撞机方案也能大量产生希格斯粒子。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">最近几年，在欧美日等国家和地区制定的粒子物理发展规划中，希格斯粒子的研究无一例外地均居于核心地位。欧洲的粒子物理发展战略认为，“希格斯工厂”是未来发展的最高优先级；美国的粒子物理战略讨论报告指出，美国将参加有希望最早实现“希格斯工厂”对撞机的项目。而2016年中国物理学会高能物理分会的决议中，也明确写明，我国提出的环形正负电子对撞机是我国未来高能加速器物理发展的首选项目。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">与国际上其他几个“希格斯工厂”方案相比，中国方案在时间线上、粒子产出效率以及造价上均有一定的优势，因此也被国际粒子物理学界广泛视作未来旗舰型项目的主要选择之一。由于下一代对撞机的强大能力，国际上普遍认为，最先实现的“希格斯工厂”对撞机，将会成为未来国际粒子物理研究的核心。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">应该说，如果中国能够把握住建设“希格斯工厂”对撞机的机会，那么下一代的中国粒子物理学家就真的有机会站到国际粒子物理学研究舞台的正中央。</p>', 1, 0, 0, 0, 1676492990358, 0);
INSERT INTO `t_blog` VALUES (39, 1, 20, '一开学就生病？做好这几点摆脱开学综合征', '<p style=\" margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">近日，全国各地大中小学陆续开学，家长们终于迎来“神兽归笼”的时刻。但对部分家长来说，怎么在新学期开始，帮孩子快速摆脱开学综合征，成为摆在他们面前的一大难题。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">天津市第一中心医院营养科主任谭桂军在接受人民网记者采访时介绍，开学综合征是指在开学前后，部分儿童青少年表现出焦虑、紧张，甚至恐惧等情绪反应，还可能伴有头疼、胃疼、恶心、腹泻等症状。患者以中小学生居多。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">谭桂军表示，部分学生放假期间饮食作息不规律、暴饮暴食、过度食用不健康零食、不注意食物合理搭配等，导致营养状况及免疫力下降，开学后难以适应规律的学习生活。再加上开学时正值季节交替之际，气温变化大，且学生集中返校后，加大了病毒细菌传播和交叉感染的机会，为呼吸道、肠道和传染性疾病的传播与流行创造了条件。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">那么，家长怎么做才能帮孩子摆脱开学综合征呢？谭桂军给出以下建议。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>营养均衡</strong><strong>&nbsp;食物</strong><strong>多样</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">儿童青少年生长发育迅速，代谢相对旺盛，开学后用脑增加、运动量增大，需要摄入充足的营养素。建议每日保证12种以上的食物摄入，包含谷薯、果蔬、鱼、禽、蛋、奶、瘦肉、大豆、坚果等。每餐合理搭配各类食物，确保食物摄入充足。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>饮食规律</strong><strong>&nbsp;</strong><strong>不暴饮暴食</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">饮食不规律容易导致营养摄入不均衡，易引发身体不适，如胃肠道功能紊乱，出现腹痛、腹泻等。饮食要定时定量，规律进餐，每餐七分饱即可，避免暴饮暴食。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>早餐要吃好 质量很重要</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">不吃早餐或者早餐质量不好，会导致精神差、反应迟钝、注意力无法集中，从而影响学习。长期不吃早餐还容易引发胆结石等疾病的发生。早餐不但要吃，还要保证质量。早餐的营养应全面均衡，要摄入充足的优质蛋白，如牛奶、鸡蛋、豆浆、瘦肉等，同时搭配一定量的谷类食物。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>充足饮水 饮料不能代替水</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">水是人体正常代谢所必需的物质。建议6至10岁学生每日饮水800至1000毫升，11至17岁学生每日饮水1100至1400毫升，尽量选择白开水，也可以通过汤、粥等补充水分。不喝或少喝含糖饮料，多数饮料含有大量的添加糖，不能用饮料替代水。一瓶500毫升的含糖饮料含糖量可达50克，摄入过量含糖饮料已成为青少年超重或肥胖的重要因素。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\"><strong>选择健康零食</strong><strong>&nbsp;</strong><strong>零食</strong><strong>不可</strong><strong>代替正餐</strong></p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">学生尽量不吃或少吃零食。如需食用可以选择卫生、营养丰富的食物，如水果、奶类、坚果等。油炸、高盐或高糖的食品不宜作零食。吃零食的量以不影响正餐为宜，更不能用零食代替正餐。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">“除此之外，开学后儿童青少年要多晒太阳、多运动、规律作息，坚持做好个人防护，科学佩戴口罩、勤洗手、遵守呼吸道礼仪等。”谭桂军说。</p>', 2, 1, 0, 1, 1676493045780, 0);
INSERT INTO `t_blog` VALUES (40, 1, 20, '“阳康”后如何做好健康管理？', '<p style=\" margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">日前，有不少人都经历了从“阳”到“阳康”的过程，“阳康”之后，新冠病毒已经从体内清除，但是身体状态却难以在短时间内恢复到最佳状态。“阳康”后，我们该如何健康管理？就此人民网记者采访了应急总医院呼吸内科主任医师张洁莉。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">张洁莉表示，“阳康”后在饮食方面，要少食多餐，进食馒头、粥等易消化的食物。蛋白质是构成人体免疫系统的物质基础，可适当增加牛肉、鸡蛋、牛奶等富含优质蛋白质食物的摄入。保证每日新鲜果蔬摄入，每日摄入蔬菜不少于500克，水果200至350克。如果出现进食欠佳的情况，也可适当补充多种维生素片。必要时可适量补充一点食盐，以维持电解质的平衡。同时，足量饮水，建议少量多次饮水，每日饮水量1500至2000毫升。另外，戒烟限酒，少吃辛辣及油炸的食物。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">“适量运动有利于康复，但康复初期不宜剧烈运动。”张洁莉说，运动应循序渐进，建议用5周时间逐渐恢复锻炼。第一周，可以把运动量恢复至原先的25%至50%，可以做拉伸运动或者呼吸训练；第二周，可以恢复至原先运动量的70%，可以进行散步等运动；第三周，可以恢复至原先运动量的80%，可以进行快步走等运动；第四周，可以将运动量恢复至原先的90%，可以进行游泳、骑自行车等运动；第五周，可以恢复至感染前的运动量，但需要注意如果在运动期间出现胸闷、气短、胸痛等症状，要立即停止运动，如停止后仍不能缓解，要尽快就医。</p><p style=\"margin-top: 23px; margin-bottom: 0px; padding: 0px; text-align: justify; font-size: 20px; line-height: 38px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 微软雅黑;\">“‘阳康’后，可以稍微放缓生活和工作节奏。”张洁莉提示，不要想着用几天时间补回感染后落下的工作，要规律作息，不熬夜，保证充足的睡眠。</p>', 0, 0, 0, 0, 1676493094703, 0);
INSERT INTO `t_blog` VALUES (43, 1, 20, 'Why You Should Travel With Your Parents as an Adult', '\n    <p>When you became independent, you were eager to enjoy your newly acquired autonomy. You focused on building your career, family, and new routines, and the time you spent with your parents was greatly reduced.</p>\n    <p>You might share some holidays with them or visit them occasionally and help them with certain daily chores, but your quality moments together have become increasingly rare. It\'s for this reason that we suggest you travel with your parents as an adult and enjoy all its associated benefits.</p>\n    <p><br></p>\n    <p>#1 It increases the well-being and happiness of both parties</p>\n    <p><br></p>\n    <p>Traveling makes us happy.Indeed, this has been proven on numerous occasions.Getting out of your routine and having new experiences helps you reduce everyday stress and experience more positive emotions.As a matter of fact, this happiness arises even before you leave home.In fact, research has found that planning and anticipating a trip improves our subjective well-being and feelings of satisfaction with life.</p>\n    <p><br></p>\n    <p>#2 It fosters a feeling of belonging and purpose</p>\n    <p><br></p>\n    <p>One of the hardest aspects of growing old is feeling that we\'re no longer needed. Indeed, when children become independent, parents can experience a real shake-up in their identities that for so long have been closely built around fatherhood and motherhood. Gradually, they begin to feel more distant from their offspring, less useful and necessary to them, and even almost invisible.</p>\n    <p>For this reason, proposing a shared trip with your own parents is an excellent way of expressing how important they continue to be in your life. After all, despite the fact that you no longer depend on them, you continue to need and value their support, advice, experience, and company.</p>\n    <p><br></p>\n    <p>#3 It allows you to strengthen the ties between you</p>\n    <p><br></p>\n    <p>As we mentioned earlier, the quality time you share with your parents in adulthood is usually increasingly scarce. The work, family, and personal obligations of both parties can make it difficult to find moments to be together. Therefore, if you want to continue nurturing the ties between you, traveling is an excellent way to achieve it.</p>\n    <p>Traveling together is an experience in which there\'ll be no schedules or pressures. Consequently, you\'ll be able to talk together, feel closer, rediscover yourselves, and, ultimately, dedicate quality time to each other. Furthermore, it allows you to improve communication between you, strengthen ties, and increase your overall satisfaction with your relationship.</p>\n', 3, 0, 0, 0, 1676494305457, 0);
INSERT INTO `t_blog` VALUES (44, 1, 20, '我结婚那天你可一定要来啊', '<p></p><p></p><section style=\"margin:0px 8px 24px;color:rgb(34, 34, 34);font-size:17px;letter-spacing:0.544px;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;vertical-align:top;width:528.792px;align-self:flex-start;flex:0 0 auto;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;width:528.792px;vertical-align:top;align-self:flex-start;flex:0 0 auto;\"><section style=\"transform:translate3d(10px, 0px, 0px);\"><section style=\"font-size:12px;letter-spacing:4px;font-family:Optima-Regular, PingFangTC-light;\"><p style=\"clear: both; min-height: 1em;\"><span>01</span></p></section></section><section style=\"margin:6px 0px 8px;transform:translate3d(10px, 0px, 0px);\"><section style=\"background-color:rgb(0, 19, 46);height:1px;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin:0px 0px 24px;padding:0px 20px;color:rgb(0, 19, 46);line-height:2;letter-spacing:2px;\"><section style=\"text-indent:2.2857em;\"><br></section><section style=\"text-indent:2.2857em;\"><span>大学毕业的时候和天南地北的同学说得最多的一句话就是：结婚了可千万记得叫我。曾经觉得不就是抽个周末，高铁或是飞机，来回一天也没多麻烦，可是在过去几年的时间里，大学时玩得还算不错的几个同学陆续成家，能抽时间去一趟的婚礼实在少得可怜。周六的婚礼周五就要出发，请个假出个省得提前好几周报备，整个行程匆匆忙忙，只是和老同学见上一面，新郎新娘忙得也顾不上和每一位来宾叙话，还没等到单独的同学聚会，我就得踏上返程回来上班，周一拖着旅途的疲惫开工——这还是工作不忙的情况。</span></section><section style=\"text-indent:2.2857em;\"><br></section></section><section style=\"margin:0px 8px 24px;color:rgb(34, 34, 34);font-size:17px;letter-spacing:0.544px;\"><section style=\"margin:20px 0px 10px;text-align:center;justify-content:flex-end;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;width:148.625px;vertical-align:top;align-self:flex-start;flex:0 0 auto;height:auto;\"><section style=\"margin:0px 0px 40px;transform:scale(2);transform-origin:right top;\"><section style=\"margin:-48px 0px 0px;\"><section style=\"display:inline-block;width:40px;height:40px;vertical-align:top;overflow:hidden;background-color:rgb(237, 164, 171);border-width:0px;border-radius:65px;border-style:none;border-color:rgb(62, 62, 62);\"><section style=\"margin:7px 0px 0px;display:flex;flex-flow:row nowrap;justify-content:center;\"><section style=\"display:inline-block;vertical-align:top;width:20px;flex:0 0 auto;align-self:flex-start;height:auto;line-height:0;border-width:0px;border-style:none;border-color:rgb(62, 62, 62);overflow:hidden;\"><section style=\"transform:rotateZ(55deg);\"><section style=\"margin:0px 0px 18px;text-align:right;transform:translate3d(13px, 0px, 0px);\"><section style=\"display:inline-block;width:20px;height:8px;vertical-align:top;overflow:hidden;background-color:rgb(255, 255, 255);border-radius:50%;border-width:0px;border-style:none;border-color:rgb(62, 62, 62);\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"display:inline-block;vertical-align:top;width:20px;flex:0 0 auto;align-self:flex-start;height:auto;line-height:0;border-width:0px;border-style:none;border-color:rgb(62, 62, 62);overflow:hidden;\"><section style=\"transform:rotateZ(305deg);\"><section style=\"margin:0px 0px 18px;text-align:left;transform:translate3d(-13px, 0px, 0px);\"><section style=\"display:inline-block;width:20px;height:8px;vertical-align:top;overflow:hidden;background-color:rgb(255, 255, 255);border-radius:50%;border-width:0px;border-style:none;border-color:rgb(62, 62, 62);\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section></section></section></section></section><section style=\"margin:0px 0px 24px;color:rgb(34, 34, 34);font-size:17px;letter-spacing:0.544px;opacity:0.67;\"><section style=\"padding:0px 20px;font-size:14px;color:rgb(239, 149, 150);letter-spacing:2px;line-height:2;\"><section style=\"text-indent:2.2857em;\"><br></section><section style=\"text-indent:2.2857em;\"><span><strong>这回收到大学室友婚礼邀请函的时候，我犹豫了。</strong></span></section><section style=\"text-indent:2.2857em;\"><span><strong><br></strong></span></section></section></section><section style=\"margin:0px 8px 24px;color:rgb(34, 34, 34);font-size:17px;letter-spacing:0.544px;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;vertical-align:top;width:528.792px;align-self:flex-start;flex:0 0 auto;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;width:528.792px;vertical-align:top;align-self:flex-start;flex:0 0 auto;\"><section style=\"transform:translate3d(10px, 0px, 0px);\"><section style=\"font-size:12px;letter-spacing:4px;font-family:Optima-Regular, PingFangTC-light;\"><p style=\"clear:both;min-height:1em;\"><span>02</span></p></section></section><section style=\"text-align:center;margin:6px 0px 8px;transform:translate3d(10px, 0px, 0px);\"><section style=\"background-color:rgb(0, 19, 46);height:1px;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><p></p><p></p><section style=\"text-align: center; margin: 0px 8px 24px; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px;\"><img src=\"data:image/jpeg;base64,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\"></section><section style=\"margin:0px 0px 24px;padding:0px 20px;color:rgb(0, 19, 46);line-height:2;letter-spacing:2px;\"><section style=\"text-indent:2.2857em;\"><span>以前觉得，参加婚礼就是去凑热闹，爸爸妈妈带着自己去亲朋的宴席，看一对新人礼成圆满，听一些有的没的闲谈，席后说说饭菜好不好吃，爸爸妈妈会考虑别耽误孩子上学、别影响第二天上班。参加婚礼像是一种社交，大家觥筹交错，我是一个局外人。长大后需要自己参加这样的活动，一开始还会问问爸爸妈妈我随多少份子合适，或者我该穿什么衣服，后来就越来越熟练——收到一个婚礼邀请的链接，或是一段邀请的文字，接着就根据关系的亲疏选一个吉利的数字，说一番美好的祝福，仪式当天的朋友圈点个赞，送上一串跟队形的评论，这一次云婚礼就算全部结束了。婚礼就是一则官方公告，联系一下不在同城的旧友。</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span><strong><span style=\"color:rgb(239, 149, 150);\">而这一次不一样，她说，你可一定要来啊，我最好的朋友。我相信她是发自内心地在说，我是她最好的朋友。</span></strong></span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>大学四年我们几乎形影不离，她就是本地人，安静、话少，忽闪忽闪的眼睛里有很特别的灵气，大学之前她都很少离开家乡这个二线城市，我和她几乎没有相似的脾气，我来到离家快两千公里的城市上大学，四年里的假期一个都没浪费，每次游山玩水都硬拉着她一起。她会在景点比着剪刀手打卡，即便是人山人海需要排队的网红店她也乐此不疲。我负责做景点攻略，用最少的钱吃喝玩乐，她会使劲催促我提前写完假期作业，把学业上的任务安排得清清楚楚。</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>毕业后她留在本校读研，我来了一个更加遥远的城市，我离她的距离从上下铺变成了四个小时的高铁。再后来，她在家乡的高中当老师，和我们大学时隔壁学院的一个男生恋爱。好像又过了一个春夏秋冬的循环，她在朋友圈发了订婚的好消息。男生阳光帅气，她笑起来明媚得像一只小鹿，我还记得我评论了一句，“般配”。<span style=\"color:rgb(239, 149, 150);\"><strong>转眼，就是婚礼了。</strong></span></span></section><section><br></section></section><section style=\"margin:0px 8px 24px;color:rgb(34, 34, 34);font-size:17px;letter-spacing:0.544px;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;vertical-align:top;width:528.792px;align-self:flex-start;flex:0 0 auto;\"><section style=\"justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"display:inline-block;width:528.792px;vertical-align:top;align-self:flex-start;flex:0 0 auto;\"><section style=\"transform:translate3d(10px, 0px, 0px);\"><section style=\"font-size:12px;letter-spacing:4px;font-family:Optima-Regular, PingFangTC-light;\"><p style=\"clear:both;min-height:1em;\"><span>03</span></p></section></section><section style=\"text-align:center;margin:6px 0px 8px;transform:translate3d(10px, 0px, 0px);\"><section style=\"background-color:rgb(0, 19, 46);height:1px;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><p></p><p></p><section style=\"text-align: center; margin: 0px 8px 24px; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px;\"><img src=\"data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/4gHYSUNDX1BST0ZJTEUAAQEAAAHIAAAAAAQwAABtbnRyUkdCIFhZWiAAAAAAAAAAAAAAAABhY3NwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAA9tYAAQAAAADTLQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlkZXNjAAAA8AAAACRyWFlaAAABFAAAABRnWFlaAAABKAAAABRiWFlaAAABPAAAABR3dHB0AAABUAAAABRyVFJDAAABZAAAAChnVFJDAAABZAAAAChiVFJDAAABZAAAAChjcHJ0AAABjAAAADxtbHVjAAAAAAAAAAEAAAAMZW5VUwAAAAgAAAAcAHMAUgBHAEJYWVogAAAAAAAAb6IAADj1AAADkFhZWiAAAAAAAABimQAAt4UAABjaWFlaIAAAAAAAACSgAAAPhAAAts9YWVogAAAAAAAA9tYAAQAAAADTLXBhcmEAAAAAAAQAAAACZmYAAPKnAAANWQAAE9AAAApbAAAAAAAAAABtbHVjAAAAAAAAAAEAAAAMZW5VUwAAACAAAAAcAEcAbwBvAGcAbABlACAASQBuAGMALgAgADIAMAAxADb/2wBDAA0JCgsKCA0LCgsODg0PEyAVExISEyccHhcgLikxMC4pLSwzOko+MzZGNywtQFdBRkxOUlNSMj5aYVpQYEpRUk//2wBDAQ4ODhMREyYVFSZPNS01T09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0//wAARCACWAGQDASIAAhEBAxEB/8QAGwAAAQUBAQAAAAAAAAAAAAAAAAIDBAUGAQf/xAA7EAACAQMCBAUDAgQDCAMAAAABAgMABBESIQUGMUETIlFhcYGRoTKxFCPB8ELR4QcVJFJiY3LxgpKi/8QAGQEAAwEBAQAAAAAAAAAAAAAAAQMEAgAF/8QAKBEAAgIBBAEEAgIDAAAAAAAAAAECEQMEEiFBMRMiMlEz8GGBQqGx/9oADAMBAAIRAxEAPwD0S5fOEHyaYBAO/SnWicsTjrvSRbOdyVpSp+RU3LpDLEsxJxk+lcpySJo8ZII9qRT010RyTT5OUV2jFGwHKK7RXWcFKj0+Iuvpnek04kLlgShxnftQbNRTb4H7ljpUA7Go1Pzly+nHl7UxqUdifxSEm/BZKSXkKK6JcDaNPrvRR2MX6kPsmk4GTUeSR274HoKePpimZBj5pY5jGSTt0opYGOhxSpcEL01Y3psZdE+SH+Q1RRRit2JoKXGmtsdPWk4p2FHB1DAHvQbpGoRtj6osY2GPemnmYnC7D804zKVIO/xTOADSGyzxwg0ljkkmmpAA2BTzuUA0gEn1pg5O5OTW4LsRlaqjlFdoptk9D8TM7+ZjsKWy560yjFDkU9G7OTkDApEkV45KqGypzsKS5LNk1JJ9KbbV659jQTo1KNqiPRSiuD7UU2yZxo5UjrCvbamAMkD1p4jQBqJONqzNjcXFnPrSSyj3+KSWZu+PiuYrKj9heT6E0V3FGKZYmjmKK7RXWChWKUrFTkUzaTC5t0lAwTkEehBwfyKdVlddSMGHqDmlqSkk12N2tMeWQE77Ui4uLe2j8S5nihTpqkYKPuaYupktbaW4lzoiQu2PQDNeY3J4hzJxZXCEeOSIyx8qKD0Hx+azJpFOGEsh6jHNBdR+NazxzRb+aNgw267ijFYiLhE3L99FPwy+kcLj+KifYSbHHtjfHcjPetjZXkV5EJIgy53CuMHHrj52+lCOWO7bfIM2nlD3VwP4wck4Aqgv+eOD20xiVpp8bF4VBXPpkkZ+m29P8dcz2kto5lihYYkkQgeXuMnp/wCxVHb8F4X/AAk000XiM7EqVJCjPYYOMe3t9lZNTGMtvaH4dHJxt9mk4Xxey4qmbSQ6tIYo6lWAPz1+RkVPxWPhuRDxNtEWlxpGonAbvg/BrWwMzx/zBhh1xR02oeZNtUL1OjeJbk+BeKMUqiqSOhFFKxRQsFFNbSvLbQ2sGfPljt2Jzv7DNWsJt4glvE6kgbAHJPqap7JGuFY24Mi58zAgZwemf7H3q2srY26tlFDNjLZyT8/6V5Oilkcra/t/S6X7/R6GdRryVnNzj/dMdu2Qt1cRwkjsCc/0qoKzxXQSOBY1BK4Qb574x7Gn+bLnxeO8JsEkZQkqyybjAGevyArHf1rvF+Y4rLj1jaRxQSW1xGJDKDnJY+Ug9MZUHPv7VZn06zO7qh+kn6caryK4wJVUaWbfYPo06e2AT/fTrU7l2AxxFy5LE6WUj2yD+aoucb4jhaQxhI/FlGobEnAzt8HH4qVytdXXF4jd3F4wks/5aW0XkRgR+twOpO4HYYOBQhplHNvTHZZtw9Oiy5neKLhk1wxAKLgZGdRO2PqcUnhMcEnD1mt2OJhvhslfbY4BGcVQ893+1pZRkjW/iNv6DYEfX8VE5Pmb+JvIEcoWVXAQ42BIJ/Ip3pw9TdXJmDaioJk/jvFLXgvFIYoreO4YqXljY4KY/Tg9u+c57VK4Fc3PH7tuKTSy29tbP4cFtFKQGYAFi+MauowPx64zmMY5huF7qBk56nSDn81oOQ71UubqxcnRKFlTfYMNjj3OR9qMIxg6ijGSTfy5N7HIGwrbN+9Lxk4qIrBiR0ZeoP709FKVwrZO+Af86YyXJg7iPlQDjc0Uphvmil2xO1DL2qtMs0REcgPmwNnHvT+n0oroJBGMY70IQUW67Nt7vJQWtjI3M/EL64A/lYih+Cqkn7Y+7VgufJI5OZphGpUxoqufU4zn7EV6s7anJ9a8d5kl8fj1/I22ZDj3wdNNlwUxXBbcec3HCuD3JYM8kUniAMDggJucdCcg47Zp7kO8EPHGti2BcQkY9WU5H41U0vC7yTlx0w8gtooLiBdOSI5Q+rAH/Xv8D6VRcLvTYcYtrvUyiGVWcr105AYfbI+tY8Ss1uclyabnzhjxcRh4guTDIpQjbCMMn85J+9Q+TmK8xx5DaZonTB3xjDdftXoHFrCPiXDpbWQDzjKk/wCFh0NYzk2xccWleUMr2euN1PRXOkD2PRunp70XH3WBv2mf4/KsnM16yjAWYpj/AMdv6UcHuf4TiFndMdKwupc4ztnf8GucwW7Qcy3qE5zOz77fqGr+td4RA1xdpbhdWvUNvcVl+QrwenyLNpSRFxIgyRnZs9R/rSkuYpNlJLY3XSSasY7eKMbKTn/mYt+9LVVQYRQo9AMVtyQqOalVCY8mNdWc479aKVRWKEN8kCHi9vN5UbMjsFjRd2OQDv6YOc/BqQniKT4kmWI/T6VioLG8Tib+FNKWYkKEwoOOuCR9/mtTazRRxPqjMcoAbBbJI+d81LhzOT95ZqMOPG04slynETnOMKd68q4hy/x2W+EbcLuTK7HJVCy5Jz+obY39a3/EeJReBnOFTLSb/wCEA5qTwzjSX+qa1RpnmPkxsAo9fg5pstVic0v+c/r/AIA1JLgk8J4ULK3VLh1lc2sNsy6fLpRSO/XJZvoQMbb0nF/9n/Db6R5rOWSzkc5Kgak99uv5rWMCCCT6b+h/1pdXUibcyst4ntraKCaQySRIFZz1fAxq+vWq+wli8adUXHiTO4IH6vU/t9xU3mLaxjP/AHMfg1CtNOLaQkg6HXfuSw/yrMuBm7ciBzBy/bcVBl0vFcrg+KgzkDsVyM/vsPTFQ+AcEtrCbEjSPLMuI5WCqFBGMjc74NaUzxgyZYDw8avamprYNbBIsqyDyHuDS04t8HPclRZC5VpvDUHp6Y3p/FVUd5GzLlNPl1NtuMDV9/8AWpQ4jAWHm8pIANJU12xNkuimkuInXIcD2OxorW5HGSF1ObvwY0BlffGxCdi39/FTGCxYKsG0jB1bH9qi21zApN2UKvMSrLjzFxpAX96lXRfCHQNQ3I6htumajkuhaYu2gkvbXxgZJJDPowTsoxnO39asLHhSrKzOzaEOIyrYzgkb+h27f+qC6mkgimv4nGYlLzRPkAYHXA74FZm75q4vaBpEaFUKpoZVIMjFQxxv03P7e9bw6bDKW9ophlk1tbPXCAylWAIIwQe9CrpULknHqcmvFTzdzJPE08UziOP9bRgkL89cVYPNxabjVlAl1/wlygkEioDkAeYZx6/girZ6iEPP8/6GRwX2emcbVW4XLkAlSpGe24qrg0nha+IjOm+oL1xnqPjrtv6b1jOXBxALNNxJyP4jDQxu/mwOpC9huPxWtF9DY8LhlnmjiTXgl2xtneipxyLjkw47CIEvZ5hJaTRTQkjcnqB3J9dx27e29naP4sUsWQrKSpZTnf1qibinDzeyi0v4IoJ2Bll8QKEGNwASMMcdevU9tnbXmHhDcYMVvex6XAXBBVQQMDBIx2/NYhp4wluiqB6rlw2T7hy0SThPO4wRnBDDYr++3tTaBpIUaTy7bfH9704ZIGklhiuIis3njKONn7j6/wBTUa4uZVk0Rjy+gHbHpU+ohUr+xM1zZYRny9T13PrRXIiCgwCMbb9aKnMkPwAt613K+yNpQHooI3+pJ6+gp2W4BgimQEo4DfTqDVVffxAI4bBK8h/W7sMto2xv/fQVKnu4I8Jq8i4I1AgrvtseozWc8nFKuWOwY9/L8EDmKZoeWuIGNeoAdyf1anA2+hrA3ZeaaEamZFgTQG7nSAR/9gR8D2recWvynL08zWgmDEExuNSatvuBjOPasXb3KNZm4mGqWIGJdsAA6mH1OWH0qrSSk4+5UbcVD4uxzl+8trO/SVrh7Vv8RxrjdfQjqPnetS/EYdQW18OVYehjIZQDtjPp22/esLbRs1yqybB0ZjnsME5+nWp0ULWMbRuUcTyKEONYdcHPl691PyNqOTSwnPfLkb60ktq4NLM1rc3szG98a6vLd4EgQalQY1YB7MCB9T0rHNDMwjIjc+Lkxg7swz6fPfHXNa22jhsYSbK3KK+CH3yGx1BO4+Kn+KkltLI6GOONCPJsUUew6Y9qVj1E9LHhWv3pHPDDPL5U0ZGOOG5sZmWQRkujyAjpgNnHznpVbIQzFlGF6AfFWMYUWUkUA1CdnQMy7+UxnPt39epquYKGYK2oA4BxjIr24dnls33IjBOX5MnczNt7DTn96vo5o/GYM3lUHHx61n+R0im5feNjh/4hwp/+K/51eaYNMQl2wQxz3XBx/SvG1H5ZDV4JsI/kptjIBxRRBJ4kerB3Jxn07UUkIxKJFuk8BItci+ZnzsoO+Mdf1UzLw23mkaRw5MTHbUSDkZ6duvaiimJ1TQCl5ujFpy3JDEzYSZNJJ3GMd/qKxVpdyXEhhuiJIypJyoyNPm2P0x9TRRVOD4D4r2CrGVrnisrkDzwz4B7fymx9q5F4UfCI7h1Yus8gTB76UwT8daKKb2al0T+Wb64F3HAXDRgiONSNlZ3Az79al82vdcO4obeO5LJPArv5RuckE47dO1FFDHCLzK0LyyknwyFwzz2QhYArILo79QVhBG/zj7VTUUVfH5P9+yXo3/ISq3L10GGQLlj/APha0HhB7cmTDCNvLkdApx+cUUV4up/LIavA7NI0b4XG4zRRRSDj/9k=\"></section><section style=\"margin:0px 0px 24px;padding:0px 20px;color:rgb(0, 19, 46);line-height:2;letter-spacing:2px;\"><section style=\"text-indent:2.2857em;\"><span><strong><span style=\"color:rgb(239, 149, 150);\">“你放心，我一定去！”</span></strong></span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>那天，我早上五点不到就起床了，出租车半小时、高铁四个小时、再半小时的地铁。她和其他几个同省的舍友站在门口，还有好远距离的时候就开始冲我跑过来，不知道为什么，看着她还是这么可爱，我心里却酸酸的有一点想哭。</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>我们一边聊八卦一边看她化妆，聊着一会儿新郎来了要出些什么题，闹着笑着就到了时间。</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>这一次婚礼不是为了未来工作上的沟通，不用考虑在饭桌上说错话，也不用计较浪费了自己太多时间，这一次来，是因我们久别未疏的真心。她在给来宾的致辞中说，谢谢大家的到来，她朝着我一边笑一边哭，“特别谢谢你，很开心这一天，你专门为我们而来。”</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span>我曾以为自己对这些温馨的场面已经习惯，情感的体验也足够饱满，可是我忘了，看到别人幸福自己也会落泪。</span></section><section><br></section><section style=\"text-indent:2.2857em;\"><span><strong><span style=\"color:rgb(239, 149, 150);\">她在觥筹交错之中有了新的人生，我在人群里举杯祝福。</span></strong></span></section></section><p></p><p></p>', 11, 1, 0, 1, 1676521803863, 0);
INSERT INTO `t_blog` VALUES (45, 1, 20, 'Ta恋爱了，我只能点个赞……', '\n				<br><br><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p><section style=\"margin: -30px 0px 0px;color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"><section style=\"display: inline-block;width: 90%;vertical-align: top;background-position: 25.8037% -43.1473%;background-repeat: repeat;background-size: 29.7866%;background-attachment: scroll;flex: 0 0 auto;height: auto;overflow: hidden;align-self: flex-start;border-top-left-radius: 10px;border-top-right-radius: 10px;border-width: 5px;border-style: dotted;border-color: rgb(175, 208, 190);\"><section></section><section style=\"padding: 0px 20px;font-size: 14px;color: rgb(150, 189, 168);letter-spacing: 2px;line-height: 2;\"><p style=\"text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\"><br></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\">越长大越会明白，很多东西在人生这条漫长旅途里，就是会不可避免地走一路，丢一路，比如友情。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\"><br></span></p></section><section style=\"text-align: left;justify-content: flex-start;display: flex;flex-flow: row nowrap;\"><section style=\"display: inline-block;vertical-align: top;width: 479.427px;align-self: flex-start;flex: 0 0 auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"font-size: 16px;letter-spacing: 0.544px;display: flex;flex-flow: row nowrap;text-align: center;justify-content: center;\"><section style=\"display: inline-block;vertical-align: middle;width: auto;min-width: 10%;flex: 0 0 auto;height: auto;align-self: center;\"><section><section style=\"display: inline-block;width: 200px;height: 70px;vertical-align: top;overflow: hidden;background-position: 50% 50%;background-repeat: no-repeat;background-size: contain;background-attachment: scroll;\"><section style=\"margin: 20px 0px 0px;\"><section style=\"font-size: 20px;letter-spacing: 2px;\"><p><span><strong></strong></span></p><h4 color=\"#000000\"><strong>01</strong></h4><strong></strong><p></p></section></section></section></section></section><section style=\"color: rgb(34, 34, 34);display: inline-block;vertical-align: middle;width: 60px;flex: 0 0 auto;align-self: center;height: auto;\"></section></section><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"></section><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"><section style=\"padding: 8px;display: inline-block;width: 90%;vertical-align: top;flex: 0 0 auto;height: auto;border-style: dotted;border-width: 5px;border-radius: 10px;border-color: rgb(175, 208, 190);overflow: hidden;align-self: flex-start;\"><section style=\"margin: 10px 0px 0px;line-height: 0;\"><section style=\"vertical-align: middle;display: inline-block;line-height: 0;width: 90%;height: auto;border-style: solid;border-width: 2px;border-color: rgb(255, 236, 208);\"><img class=\"rich_pages wxw-img\" data-ratio=\"0.6659365\" data-type=\"jpeg\" data-w=\"913\" data-index=\"6\" src=\"data:image/jpeg;base64,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\" _width=\"100%\" crossorigin=\"anonymous\" alt=\"图片\" data-fail=\"0\" style=\"width: auto;height: auto !important;visibility: visible !important;\"></section></section></section></section><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"></section><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"><section style=\"display: inline-block;width: 90%;vertical-align: top;flex: 0 0 auto;height: auto;border-width: 5px;border-radius: 10px;border-style: dotted;border-color: rgb(175, 208, 190);overflow: hidden;align-self: flex-start;\"><section style=\"margin: -1px 0px 0px;line-height: 0;pointer-events: none;\"><br></section><section style=\"padding: 0px 10px;color: rgb(71, 124, 77);font-size: 14px;line-height: 2;letter-spacing: 2px;\"><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong><br></strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>曾经我也遇到过自以为一辈子的朋友。</strong>她是我高中第一个同桌，我们脾气互补，一拍即合，我们无话不说，毫无保留，我们分享彼此的日记，把友谊地久天长写在给对方的生日贺卡里。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>她失恋我陪她，我和别人吵架她站出来替我出头。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>我们把对方的开心、难过看得比自己的更重要，那个时候，我们生活里90%都是彼此。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>这种关系现在想起来都觉得不可思议，怎么就能那么要好呢？</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>可就是这么要好的朋友，在毕业之后，却再也没有见过一次面，最后一次聊天，是四年以前。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>年轻的时候，我们总是觉得友情牢不可破，坚不可摧，但越长大越会发现，原来友情也是一种很脆弱的东西。</strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>我们就像坐在一辆开往未知目的地的火车里，中途不断有人上车、下车，你不能因为邻座的人提前下车，而否定他陪伴过你的那段日子，毕竟，你们曾一起看过窗外的同一片风景。</strong></span></p><p style=\"text-indent: 2.2857em;\"><span><strong><br></strong></span></p></section><section style=\"margin: 10px 0px 0px;line-height: 0;pointer-events: none;\"><br></section></section></section><section style=\"font-size: 16px;letter-spacing: 0.544px;display: flex;flex-flow: row nowrap;text-align: center;justify-content: center;\"><section style=\"display: inline-block;vertical-align: middle;width: auto;min-width: 10%;flex: 0 0 auto;height: auto;align-self: center;\"><section><section style=\"display: inline-block;width: 200px;height: 70px;vertical-align: top;overflow: hidden;background-position: 50% 50%;background-repeat: no-repeat;background-size: contain;background-attachment: scroll;\"><section style=\"margin: 20px 0px 0px;\"><section style=\"font-size: 20px;letter-spacing: 2px;\"><p><span><strong></strong></span></p><h4 color=\"#000000\"><strong>02</strong></h4><strong></strong><p></p></section></section></section></section></section></section><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;display: flex;width: 677px;flex-flow: column nowrap;\"><section style=\"z-index: 1;\"><section style=\"margin: 10px 0px -15px;text-align: center;line-height: 0;\"><section style=\"vertical-align: middle;display: inline-block;line-height: 0;width: 45.95px;height: auto;\"></section></section></section></section><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p><section style=\"margin: -30px 0px 0px;color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"><section style=\"display: inline-block;width: 90%;vertical-align: top;background-position: 25.8037% -43.1473%;background-repeat: repeat;background-size: 29.7866%;background-attachment: scroll;flex: 0 0 auto;height: auto;border-width: 5px;border-top-left-radius: 10px;border-style: dotted;border-color: rgb(175, 208, 190);border-top-right-radius: 10px;overflow: hidden;align-self: flex-start;\"><section style=\"padding: 0px 20px;font-size: 14px;color: rgb(71, 124, 77);letter-spacing: 2px;line-height: 2;\"><p style=\"text-indent: 2.2857em;\"><span><br></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>不知道你有没有发现，长大后的我们好像没有那么需要朋友了，或者说，我们在开始慢慢学着独处，习惯独处，享受独处，那些除了工作以外的闲暇时间，我们更想留给自己。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>前几天最好的闺蜜谈恋爱了，而我，是通过她发的朋友圈知道的。</strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>如果要是以前，我一定会难过好几天，我没办法接受我最好的朋友，谈恋爱了却不告诉我，也没办法理解为什么曾经我们无话不谈，知道彼此所有的小秘密，而现在却要从朋友圈了解对方的近况和生活。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>可现在，我也只是唏嘘、难过了一小下，然后默默地给那条朋友圈点了个赞，就继续忙活我自己的事。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>因为我理解她没能和我分享生活的原因。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>我们是群居动物，天然地需要陪伴，害怕孤独，但我们每个人都有自己的事业和追求，都有对自己来说更重要的事情要做。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>我们都在往前走，而既然要往前走，就免不了要和没办法与自己同行的人一一道别，哪怕那个人曾经和你一起走过很长的路。</strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong>我们因为机缘遇见，在相交的生命轨迹中，彼此陪伴，共同经历了一段难忘又美好的日子，可在相交点之后，我们又离开彼此的身旁，去过截然不同的，只属于自己的生活。</strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span>跟从前熟悉的一切渐行渐远，去感受未知的、充满挑战的“以后”，这大概就是成长。</span></p><p style=\"text-indent: 2.2857em;\"><span><br></span></p></section></section></section><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p><section style=\"font-size: 16px;letter-spacing: 0.544px;display: flex;flex-flow: row nowrap;text-align: center;justify-content: center;\"><section style=\"display: inline-block;vertical-align: middle;width: auto;min-width: 10%;flex: 0 0 auto;height: auto;align-self: center;\"><section><section style=\"display: inline-block;width: 200px;height: 70px;vertical-align: top;overflow: hidden;background-position: 50% 50%;background-repeat: no-repeat;background-size: contain;background-attachment: scroll;\"><section style=\"margin: 20px 0px 0px;\"><section style=\"font-size: 20px;letter-spacing: 2px;\"><p><span><strong></strong></span></p><h4 color=\"#000000\"><strong>03</strong></h4><strong></strong><p></p></section></section></section></section></section></section><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"></section><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p><section style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;text-align: center;justify-content: center;display: flex;flex-flow: row nowrap;\"><section style=\"display: inline-block;width: 90%;vertical-align: top;flex: 0 0 auto;height: auto;border-width: 5px;border-radius: 10px;border-style: dotted;border-color: rgb(175, 208, 190);overflow: hidden;align-self: flex-start;\"><section style=\"margin: -1px 0px 0px;line-height: 0;pointer-events: none;\"></section><section style=\"padding: 0px 10px;color: rgb(150, 189, 168);font-size: 14px;line-height: 2;letter-spacing: 2px;\"><p style=\"text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\"><br></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\">关于聚散无常，我曾看到过这样一段文字：</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span><strong><span style=\"color: rgb(71, 124, 77);\">“我在路上走着，路上遇到了你。大家点头微笑，结伴一程。缘深缘浅，缘聚缘散，该分手时分手，该重逢时重逢。惜缘即可，不必攀缘，同路人而已，能不远不近地陪伴一程，不是已经很好了嘛？”</span></strong></span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\">或许，友情的本质就是如此，在人生的不同阶段，我们会遇到很多不同的人，而只有极少数的，彼此心灵相通的人愿意陪伴你走一段路。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\">但这条路不是没有尽头的，因为我们不是始终步调一致、目的地相同，总是要经历“从无到有、从有到无”，总是要说再见的。</span></p><p style=\"text-align: left; text-indent: 2.2857em;\"><br></p><p style=\"text-align: left; text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\">可即便如此，我还是想和那些渐行渐远的朋友们说：<strong>“你们始终是我心底最宝贵的存在，那些从前彼此陪伴的最明亮的时刻，我也真的一直都记得，只希望在未来无法彼此参与的各自人生里，我们都能熠熠生辉，过得精彩。”</strong></span></p><p style=\"text-indent: 2.2857em;\"><span style=\"color: rgb(71, 124, 77);\"><strong><br></strong></span></p></section><section style=\"margin: 10px 0px 0px;line-height: 0;pointer-events: none;\"></section></section></section><p style=\"color: rgb(34, 34, 34);font-size: 16px;letter-spacing: 0.544px;\"><br></p>\n			', 46, 5, 42, 1, 1676523069248, 1677862000558);
INSERT INTO `t_blog` VALUES (48, 1, 20, '那些意欲取代 C++ 的编程语言，成功了吗？', '<p>2022年出现了许多可以与C++竞争的语言。就在今年的CPP North C++大会上，谷歌宣布了一门新的编程语言Carbon，并称其将是「C++的继任者」。</p><p>对于这一事件，国外媒体和开发者们也询问了C++之父Bjarne Stroustrup的看法，他表示：“这些年总是有新的语言试图成为C++的继承者，我欢迎对编程语言和编程风格进行实验。但Carbon太新且规范不足，我无法真正做出有意义的技术评论。而通常在不开发全新语言规则、库和管理方案的情况下，很难提供C++的替代方案。”</p><p>该语言发出后，也让一众网友浅来围观，有支持，也有反对的声音。</p><p>近日，Garmin的一名软件工程师Lucian Radu Teodorescu在文章中报道了目前C++继任语言的技术状况。</p><p>C++是一种特殊的编程语言，也是最常用的编程语言之一，但它也是最受批评的语言之一。根据TIOBE指数，30年来，C++一直是排名前4的编程语言（使用12个月的平均值），并且还成功摘得了<a href=\"//www.oschina.net/news/223917/tiobe-index-202301\">2022年的年度编程语言称号</a>。</p><table style=\"text-align: center; width: 80%;margin: 0 10%;\"><colgroup><col><col></colgroup><tbody><tr><td>Feb-23</td><td>Feb-22</td><td>Change</td><td>Programming Language</td><td>Ratings</td><td>Change</td></tr><tr><td>1</td><td>1</td><td></td><td>Python</td><td>15.49%</td><td>0.16%</td></tr><tr><td>2</td><td>2</td><td></td><td>C</td><td>15.39%</td><td>1.31%</td></tr><tr><td>3</td><td>4</td><td>↑</td><td>C++</td><td>13.94%</td><td>5.93%</td></tr><tr><td>4</td><td>3</td><td>↓</td><td>Java</td><td>13.21%</td><td>1.07%</td></tr><tr><td>5</td><td>5</td><td></td><td>C#</td><td>6.38%</td><td>1.01%</td></tr><tr><td>6</td><td>6</td><td></td><td>Visual Basic</td><td>4.14%</td><td>-1.09%</td></tr><tr><td>7</td><td>7</td><td></td><td>JavaScript</td><td>2.52%</td><td>0.70%</td></tr><tr><td>8</td><td>10</td><td>↑</td><td>SQL</td><td>2.12%</td><td>0.58%</td></tr><tr><td>9</td><td>9</td><td></td><td>Assembly language</td><td>1.38%</td><td>-0.21%</td></tr><tr><td>10</td><td>8</td><td>↓</td><td>PHP</td><td>1.29%</td><td>-0.49%</td></tr></tbody></table><p>参见下图，可了解过去20年的语言趋势（2022年10月的TIOBE编程社区指数）。</p><div style=\"text-align: center;\"><img src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"422\"></div><p>对于一种已经存在了近40年的编程语言来说，能经常出现在顶级编程语言的名单中，的确是一个伟大的成就。在颇受欢迎的同时，C++的批评声却接连不断，例如Liunx之父直接说C++是一门糟糕的语言。大部分的人都在抱怨这种语言太大了，太复杂了，有一些是应该被扼杀的功能，有太多的功能，反之，又有些功能不够用。以偏概全，C++可以被看作是一个没有清晰连贯的故事的各种功能的随机集合。</p><p>在为该语言辩护时，Bjarne Stroustrup认为，\"在 C++ 中，有一种更小、更干净的语言正在努力摆脱\"。这句话在28年后的今天仍然被广泛使用。虽然这句话意在为C++辩护，但如果仔细分析一下，就会发现这也是一种隐含的批评。C++仍然没有成为人们所期望的那种更小、更干净的语言。它可能仅仅意味着这种更小更干净的语言只是一个海市蜃楼。</p><br><h3 style=\"text-align: center;\">意欲取代C++的编程语言</h3><br><p>那么问题来了，怎样才能获得一个更好的编程语言呢？它比现在的C++更简单、更干净，并且与C++占据同样的空间（系统编程语言）？一个C++的继任语言是什么样子的？</p><p>虽然过去也有一些尝试，但像2022年这样的还是很少见的，一下子有3种继任者语言在C++主题演讲中公布。</p><p>首先，有Dave Abrahams和Dimitri Racordon在C++Now上宣布的Val。Val的核心思想是，我们可以使用可变值语义建立安全且高效的程序。</p><p>两个月后，在CppNorth上，Chandler Carruth宣布了Carbon语言。Carbon语言试图解决C++的几个方面：几十年来积累的技术债务、优先考虑向后兼容性和C++的进化过程。</p><p>又过了两个月，在CppCon上，Herb Sutter宣布了CppFront，作为C++的可能继承者。他的主要目标是\"使 C++ 本身向前发展，并使 C++ 加倍发展\"，防止用户迁移到其他语言。宣称的目标是使C++的安全性提高50倍，简单10倍。</p><p>本文作者Lucian Radu Teodorescu试图对这三种语言提供一个批判性的观点。他解释道：“这样做并不是认为它们不能成为C++的继承者；恰恰相反，我试图在希望取代C++的位置之前列出这些语言在需要解决的问题。虽然我确实有一些个人偏见，但我会尽力客观地进行分析。”</p><br><h3 style=\"text-align: center;\">早期取代者</h3><br><p>D编程语言由Walter Bright创建，出现在2001年；在2007年时，Andrei Alexandrescu加入了设计和开发工作。这种语言本应从C++的错误中学习，并成为其继承者。它承诺了同样的效率水平，但增加了大量的新功能，并简化了C++的一些更复杂的部分。D的主页将D宣传为一种可以\"写得快、读得快、跑得快 \"的语言。</p><p>D已经吸引了一些商业用户，但可以说它并没有达到重要的编程语言的地位。Andrei是作者长期以来的偶像之一，而且对Walter相当尊敬，但主要把D看作是一个语言功能的大集合，松散地绑在一起。在我看来，这门语言缺乏一个清晰的基础，可以让所有的功能都有凝聚力。</p><p>Go编程语言于2009年由谷歌推出；1.0版本于2012年发布。这种语言的目标是让程序员\"大规模地构建快速、可靠和高效的软件\"。Go语言的设计者不喜欢C++，因此，Go似乎更像是C的进化，而不是C++的进化。Go在2022年才增加了泛型，并且仍然缺乏广泛使用的功能，如异常处理。</p><p>虽然Go可以说是一种成功的编程语言，但它的成功主要是在云计算业务中。尽管它取得了相对的成功，但它不能被称为C++的继承者。</p><p>Rust是Mozilla开发的一种编程语言，2010年时公布，第一个版本在2015年发布。Rust专注于可靠（内存和线程安全）和高效的软件。Rust语言模型是围绕着所谓的借用检查器，它能跟踪所有对象的生命周期；因此，它可以在编译时检测安全错误，并不需要使用垃圾收集器。</p><p>Rust虽然不像Go那样流行，但似乎被认为是C++的良好替代品。问题是，Rust和C++之间没有清晰/干净/通用的接口方式，这使得想转到Rust的C++程序员经历了突然的迁移。</p><br><h3 style=\"text-align: center;\">Val</h3><br><p><strong>Val给自己的目标定位是：</strong></p><ul><li>快速的定义</li><li>默认情况下是安全的</li><li>简单</li><li>可与C++互操作</li></ul><p>Val以这些目标针对C++、Rust和Swift语言的受众。它的目标是实现C++的性能，但要比Rust更简单的方式保证安全。在性能方面，Val旨在减少编写安全软件所需的对象复制和内存分配的数量。在安全性方面，Val中的所有结构都保证是安全的，除非用户明确要求额外的控制（将代码的一部分标记为不安全）。该语言的简单性主要来自于它对Swift的强烈影响，通常被认为是一种简单易用的语言。</p><p>许多编程语言不一定有一个贯穿其所有功能的核心思想，就像语言的催化剂一样；这会给人的印象是这些语言缺乏连贯性。这不能说是Val的问题。这门语言突出之处在于它有一个模型可以在程序上消除安全问题：它被称为Mutable Value Semantics（变值语义）。但是，在这之前，一起先来探讨一下它所解决的主要问题。</p><p><strong style=\"color:blue\">C++本质上是不安全的</strong></p><p>这一切都始于这样的观察：在存在突变的情况下，引用语义可能会导致不安全的程序。因为引用语义允许创建复杂的依赖关系图，所以突变不能保证在整个图中保留安全性。例如，如果一个函数对两个对象进行操作并改变了其中一个对象时，就不能保证另一个对象不会以完全意想不到的方式发生变化。这在单线程和多线程环境中都会产生问题。此外，如果不深入检查所有可能受到影响的代码，程序员们也没有系统的方法来验证突变的后果。这简直打破了结构化编程的核心思想。</p><p>以下面这个C++代码片段为例：</p><section style=\"background-color: rgba(0, 0, 0, 0.03); border: 1px solid rgb(240, 240, 240); border-radius: 2px;line-height: 26px;\"><code style=\"display: block;\">void append_vec(vector<int>&nbsp;&amp;dest,const vector<int>&nbsp;&amp;src){</int></int></code><code style=\"display: block; padding-left: 40px;\">for(auto x:src)</code><code style=\"display: block; padding-left: 80px;\">dest.push_back(x)</code><code style=\"display: block;\">}</code></section><p>忽略执行中的低效率，这段代码有一个严重的安全问题。而且，如果只看这段代码，就不容易发现这个问题；还必须看一下周围的代码。如果此函数的调用者提供相同的向量作为源参数和目标参数，那么就会导致未定义的行为。</p><p>为了确保像这样的函数有正确的语义，则需要一个独立性的保证：程序员们需要确保所交互的对象（至少写给其中一个对象）是不相同的。这在语言中无法得到适当的执行；因此，就处于不安全的领域。</p><p>这里的问题比它看起来要复杂得多。如果一个函数的两个参数都是引用（也就是说，我们没有在其中改变任何东西），那么就没有问题。只有当我们有mutation.const时，问题才会出现。</p><p>Swift通过使用copy-on-write技术来解决这个问题，但这可能会导致效率低下。</p><p>Rust通过跟踪对象的生命周期来解决这个问题。这给程序员增加了负担，而且会给程序增加不必要的限制。</p><p><strong style=\"color:blue\">可变值语义</strong></p><p>函数式编程语言通过禁止突变来避免上述问题。可以对多个对象有多个引用，因为没有人可以改变这些对象。这对许多程序员来说感觉很不自然，而且对无数的算法来说效率很低。</p><p>Val以一种完全不同的方式解决了这个问题：它对引用增加了限制，并确保没有人可以读取一个对象，而其他人却可以改变它。</p><p>Val认识到整体/部分关系的重要性。这些关系只能形成一棵树，而不是一个循环图。如果想修改这棵树上的一个对象，马上就能知道这个变化的影响，也就是所有其他可能受到这个突变影响的对象。它允许程序员们推理出哪些对象可以安全地作为读和写传入一个函数。</p><p>最后，按照这个逻辑，可以安全地添加引用来表示整体/部分关系。</p><p>在Val模型中，突变是不被禁止的，但是每次突变一个对象时，编译器可以计算出哪些对象可以安全地读取，哪些对象可以同时安全地写入。安全性可以通过构造来保证。</p><p>消除对象之间的任意引用并关注整体/部分关系是赋予Val价值语义的原因。但是，由于Val也允许值的突变，就可以把这个模型称为可变值语义学。</p><p><strong style=\"color:blue\">科学的方法</strong></p><p>走到这一步，作者认为很重要的一个方面：Val似乎遵循了一种科学的方法。可以看到，在上述内容简单地描述了一个确保安全的计算模型。这不仅仅是作者提出的关于语言安全的主张。他们有一个安全的证明，在语言的限制下。</p><p>该语言的主要创造者Dimitri Racordon，实际上是一名博士后研究员。Dave Abrahams似乎也是志同道合的人。Dave和Sean Parent一起重新组建了Adobe的STLabs。可以看出Alex Stepanov（STL的创造者，也是STLabs的前成员）对Dave和Sean的研究导向的影响。</p><p>不能保证Val会像C++那样成功，但可以发现解决C++的一些基本问题的合理方法：清楚地定义问题，然后提出一个通用而优雅的解决方案。</p><p><strong style=\"color:blue\">使用临时引用</strong></p><p>Val简单地指出使用临时引用是不安全的。这使得人们不清楚如何实现需要引用的程序，而不是表达整体/部分关系。</p><p>例如，实现一个双链表需要不能被模拟为整体/部分关系的引用。目前还不清楚如何实现具有可变值语义的双链表。另一个例子，考虑一个应用程序中的共享缓存组件。根据定义，这样的组件需要被多方访问，并且需要允许突变。同样，我们也不清楚如何在Val中实现这一点。</p><p>也许这些例子的简单答案是，用户必须将一些代码标记为不安全。这也许是可以的；作为语言的使用者，我们只是缺乏如何处理这些情况的经验。Val必须为处理这些情况提供良好的指导。</p><p><strong style=\"color:blue\">C++的互操作性</strong></p><p>在写这篇文章的时候，Val还没有明确的公开计划如何来处理与C++的互操作性，它只是宣布了它的意图。为了成为C++的继任语言，Val需要解决这个问题。而且，这个问题似乎并不容易。</p><p>首先要注意的是，根据它的描述，Val的灵感主要来自Swift。这意味着Val和C++之间的差距不小（一边是Carbon和Cpp2的差距，另一边是C++的差距）。缩小这个差距可能需要很大的努力。</p><p>第二个障碍是可变值语义系统所带来的限制。C++本质上包含了大量的临时引用。这意味着，C++代码在Val中会被视为包含无数的不安全操作。在作者看来，几乎所有的C++操作都应该在Val中被标记为不安全。这似乎增加了互操作性的差距。</p><p>请注意，作者并不是说Val不能与C++适当地互操作。只是想表述实现这一点可能不是一个简单的努力。</p><br><h3 style=\"text-align: center;\">Carbon</h3><br><p>Carbon是在CppNorth 2022上面世，意欲成为C++继任语言。Carbon得到了谷歌的支持（据Chandler说，也得到了Adobe的支持）。此外，一个有趣的事实是，谷歌则在CppCon 2022上缺席；也许这是谷歌在考虑放弃C++的一个标志。</p><p>在演讲中，Chandler列举了目前C++的问题。</p><ul><li>大量的技术债务</li><li>C++优先考虑向后兼容，而不是语言演进；这也阻碍了对技术债务的修复</li><li>国际标准化组织的语言发展过程并没有针对C++发展的实际需求进行优化。</li></ul><p>Chandler认为，解决这些问题的办法是开始考虑C++的后继任语言。类似于C++被创造为C的继承者，Swift被创造为ObjectiveC的继承者，Kotlin被创造为Java的继承者，则需要找到C++的继承语言。</p><p>为了创建一个C++的继任语言，需要在现有的生态系统中构建，提供双向的互操作性，并确保有工具来帮助迁移和学习。而这些实际上就是新宣布的Carbon语言的目标。</p><p>与C++相比，Carbon似乎没有一个标志性的特征。它就像是一个C++的清理项目。在演讲中，Chandler展示了更简洁的语法、更干净的指针语义、更好的包装、更好的公共/私有成员的默认值、显式参数、继承清理、API扩展点和C++0x风格的泛型。所有这些功能都以这样或那样的方式存在于其他编程语言中。</p><p>Carbon可以被看作是具有更好的默认值的C++，这是件好事。人们会看到一种熟悉的语言更好/更简单。Carbon的学习曲线可以很平滑，从C++到Carbon的过渡不需要跳过太多的障碍。</p><p>但是，另一方面，这与D有什么不同？D也试图通过学习C++的错误和清理其粗糙的边缘而成为C++的继承者。是什么让Carbon语言具有内部一致性，而不是让它感觉像一群不相关的功能？</p><p>如果从进化的角度来看，即使今天所有的默认值都很有意义，又有什么能保证它们在接下来的几十年里都有意义？怎样才能防止Carbon积累技术债务？这个问题的部分答案是，正如Chandler提到的，使用工具来协助迁移。但是，都看到了从Python 2迁移到Python 3是多么的痛苦；可能不是每个人都相信工具可以帮助解决未来的问题。</p><p>这些问题都是Carbon团队需要回答的问题。作者表示并不是想说这些问题很难回答，但它们需要被回答。</p><p><strong style=\"color:blue\">与C++的互操作性是困难的</strong></p><p>即使Carbon可以成为一个具有更好的默认值的C++，与C++的互操作性也不一定容易。下面是Sean Baxter提出的一些观点：</p><ul><li>在Carbon中没有功能过载</li><li>在Carbon中没有异常处理</li><li>在Carbon中没有多重继承，但人们仍然可以在C++中使用它</li><li>与C++不同，Carbon不处理原始指针</li><li>Carbon没有构造函数</li></ul><p>从这些方面来看，可以很容易地看出，与C++的互操作性将是一个复杂的问题。最有可能的是，即使互操作性问题能够完全解决，对于大型软件来说，从C++迁移到Carbon也不会是一个简单的过渡。</p><p><strong style=\"color:blue\">文化的兴衰</strong></p><p>谷歌是一家坚信文化是软件开发的驱动力的公司。Chandler在他的主题演讲中也用Peter Drucker的一句话表达了这一点。</p><p>文化把战略当作早餐，把技术当作午餐，把产品当作晚餐，不久也会把其他一切都吃掉。</p><p>虽然企业文化确实是必不可少的，但仅仅引用Peter Drucker的话并不是成功的秘诀。主要问题是很难衡量文化及其影响。Chandler列出了关于Carbon文化的几个要点（包容性、社区友好等）。虽然所有这些观点都是好的，但它们不足以定义文化，也不足以让文化在Carbon项目中发挥作用。例如，Chandler没有提到卓越的技术、毅力、尝试新事物的勇气，或者如何优先考虑不同的（与文化有关的）目标。</p><p>Lucian Radu Teodorescu表示在他以前工作的一家公司，有一句口头禅是\"我们从不让项目失败\"。谷歌和Carbon项目的文化中是否有一个类似的目标？人们似乎把谷歌看作是一家尝试许多产品并在一段时间后关闭它们的公司。例如，如下图，Victor Zverovich的一条推特，他利用这种看法开了一个关于Carbon的玩笑。考虑到Chandler还宣布谷歌有一个不同的团队有同样的目标，但他们从Rus t开始，转向C++后，这种思路可能并不太牵强。</p><p>Lucian Radu Teodorescu表示文化是好的，Chandler提出的观点也是好的。但是，想要说服一名工程师则需要可验证的论据。</p><p><strong style=\"color:blue\">治理模式</strong></p><p>关于Carbon公告的一个有趣之处是治理模式。Carbon项目的目标是实现一种没有任何公司能决定语言未来的治理。每个人都可以通过创建拉动请求来参与语言的发展，但越是重要的功能，就越需要分析/论证。</p><p>对于没有达成共识的重要功能，有一个由三名成员（Chandler Carruth,Kate Gregory,Richard Smith）组成的指导委员会，负责达成决定。他们没有机会对设计做出贡献；他们只需要权衡提交给他们的论据并做出选择。</p><p>有趣的是，这个模型试图强调一个民主的过程，这在某种程度上类似于ISO的目标。这只是对参与各方的不同划分，当陷入僵局时会有更明确的规则来做什么。如果从事C++标准化工作的人也从事Carbon的工作，那么Carbon的过程是否会明显好转就不清楚了。</p><p>虽然民主方法是目前最好的治理方式，但我们最近看到了一系列重大的政治失败，这些失败可能与民主的负面影响直接相关。值得一提的是，在古希腊，民主被认为是一种糟糕的治理方式。</p><br><h3 style=\"text-align: center;\">Cpp2</h3><br><p>CppFront是Herb Sutter在CppCon 2022的闭幕主题演讲中宣布的一个项目。它是一个转码器，可以将\"更好的 C++\"，即Cpp2，转换为旧的C++。虽然CppFront/Cpp2是今年正式宣布的，但Herb已经在这个项目上工作了大约7年；每年，Herb都会展示Cpp2的一小部分。</p><p>Herb希望改进C++（即10倍），而不是进行增量式的改变（即10%）。他希望使C++实现30年前Stroustrup设想的那个更简单、更干净的语言的老目标。有趣的是，它采用了Stroustrup想改进C语言时相同的方法：开始一种新的语言并将代码翻译成以前的语言。因此，CppFront是一个小型转译器，它接收Cpp2代码（Herb的新语言）并输出常规的C++代码。</p><p>Herb还设定了一些指标，我们可以用这些指标来评估这个实验是否成功。更安全50倍（也就是减少98%的CVE），更简单10倍（减少90%的教学指导）。预先定义指标是一个很好的策略，能够评估实验的成功；我非常喜欢这个想法。</p><p><strong style=\"color:blue\">向后兼容性和互操作性</strong></p><p>通过放弃向后兼容性，Cpp2可以比C++更简单。这最终允许该语言删除那些被认为是有害的功能，并重新审视一些被证明是次优的设计选择。通过放弃向后兼容性，Cpp2最终可以解决C++中几十年积累的技术债务。</p><p>说实话，在C++中优先考虑向后兼容性优先于语言发展并不是一个可靠的例子。每次我们为语言添加一个主要的功能（例如，概念、程序、模块等）时，我们实际上是在语言中创造一个新的时代。新的代码可以与旧的代码互动，但旧代码不能简单地依赖用新特性编写的新代码。尽管C++标准没有正式提及语言时代，但是在语言中有一个底层的时代系统，由新特性的发布所决定。</p><p>可以将Cpp2看作是C++的一个主要新特性。在互操作性和工具方面，事情要复杂一些，但本质是一样的。在同一个应用程序中，旧式C++不能与Cpp2共存，这在技术上没有充分的理由。</p><p>按照设计，Cpp2在语义上与C++接近；这使得互操作性更容易。另一方面，这也会阻止Cpp2拥有与C++完全不同的特性。例如，Cpp2就很难使用C++0x式的泛型。</p><p><strong style=\"color:blue\">解决安全问题</strong></p><p>安全性提高50倍的目标听起来令人印象深刻。如果Cpp2能够实现这个目标，我相信大多数语言的用户都会感到高兴。</p><p>让我们从这个数字的角度来全面了解其影响。这意味着98%的C++应用程序如果被翻译成Cpp2就不会再崩溃了（假设崩溃只由不安全的应用程序产生）。或者说，98%的C++网络应用不会有漏洞（如果没有其他非C++的漏洞）。这将大幅减少崩溃和安全漏洞。</p><p>这似乎好得令人难以置信。实际上，如果我们更详细地分析，这些数字似乎太高了。</p><p>首先，如果讨论安全问题，需要清楚地知道什么是安全。安全性包括：</p><ul><li>类型安全</li><li>边界安全</li><li>生命周期安全</li><li>初始化安全</li><li>对象访问安全</li><li>线程安全</li><li>算术安全</li></ul><p>Herb在他的主题演讲中提到了上述的前4个项目。然而，这些安全项目的所有方面并没有得到解决。作为一个主要的例子，在存在原始pointer时不能保证生命周期安全；仅仅检查pointer是远远不够的。也没有任何一个功能来检测pointer.null的使用后删除情况。</p><p>Cpp2，正如CppCon主题演讲中所描述的，无法检测到这段代码的问题：</p><section style=\"background-color: rgba(0, 0, 0, 0.03); border: 1px solid rgb(240, 240, 240); border-radius: 2px;line-height: 26px;\"><code>vec.push_back(vec.front());</code></section><p>Herb定义了他的安全指标，包括前四个安全组件；故意忽略其他类型的安全似乎很奇怪。尤其是如果被忽略的安全成分很重要的话。</p><p>对象访问安全是指受对象访问模式影响的安全规则。一般来说，这一类的不安全代码可以转化为类型安全、边界安全或生命周期安全。无效迭代器的规则是这个类别中很好的例子。</p><p>线程安全是C++的一个大问题，Herb完全没有提到。在她2021年的C++Now演讲中，Anastasia Kazakova展示了数据，显示在C++社区中，并发安全占用户setback的27%。相比之下，边界安全问题只占16%，使用后删除问题占用户setback的15%。并发安全是安全性方面最大的痛点，而这一点没有在Herb的列表中得到体现。</p><p>Herb在他的幻灯片上表示，Cpp2获得了\"结构安全\"。这不可能是真的。结构安全性应该是指语言的构建方式总是能够导致安全的构造（除非程序员真的忽略了类型系统并将安全性掌握在自己手中）——类似于Val或Rust的构建方式。但Cpp2并没有这样做；它只是对一些常见的不安全行为的来源增加了更多的安全检查。如果你看过Dave Abrahams和Dimitri Racordon的演讲，以及Sean Parent的演讲，这一点应该马上就能看出来。</p><p>这让我相信，在安全性上提高50倍是不可能实现的目标。</p><p><strong style=\"color:blue\">关于目标的可衡量性</strong></p><p>理论上，在任何时候，我们都可以根据这些指标来衡量进展，可以评估这个实验是否成功或能否成功。</p><p>让我们从第二个指标开始：简单10倍，就像我们需要在C++书籍中教授的指导中衡量的那样。在这个实验被证明是成功之前，人们不太可能写关于Cpp2的书，但可以想象这样一本书的内容是什么。可以确定哪些是我们需要教授的关于Cpp2的一系列概念，并且我们可以将其与我们目前正在教授的关于C++的内容清单进行比较。因此，我们可以衡量这个指标。</p><p>这并不像人们想象的那样简单。C++有很长的历史；因此我们知道它的陷阱，人们在C++书籍中记录了这些陷阱。但是，Cpp2没有这么丰富的历史，所以，人们总是怀疑我们不知道它的所有陷阱。然而，Cpp2与C++如此接近，我真诚地相信可以排除这些顾虑，得到一个关于简单性的准确测量。</p><p>但是，我不能对第二个指标说同样的话。我们如何衡量CVE和安全漏洞的百分比？首先需要有一个足够大的Cpp2程序的语料库，由大量的程序员和公司编写。然而，为了实现这一点，Cpp2需要被认为是一种成功——一种循环的依赖。因此，在Herb的演讲中定义的安全度量并不是衡量实验成功的指标。</p><p>在主流语言使用一段时间后，使用这个指标来评估语言是有意义的，但不能判断实验的成功。</p><p><strong style=\"color:blue\">有还是没有monads</strong></p><p>在主题演讲的1小时33分（以YouTube视频为参考）中，Herb Sutter骄傲地说：\"我没有说过一次 monads 这个词\"。然后他继续解释说，Cpp2是关于我们目前在C++中使用的语言理念；而不是来自其他语言的奇怪的外来术语。</p><p>虽然这句话可能会吸引C++社区中以自我为中心的部分人，但我认为它对社区的伤害要大于帮助。</p><p>首先，C++到处都在使用monads。新的C+ +23特性可能是使用monads的一个已知例子，但C++从根本上说是围绕着monads建立的。当我们调用可能抛出异常的函数时，我们隐含地使用了monads。也就是说，几乎到处都是。</p><p>其次，它在语言用户中创造了一种自给自足的感觉。这样的声明不是向社区开放新的想法，而是传递了一个信息：C++不需要向其他语言学习。但是，该语言拥有的大量技术债务，以及三种继任语言的出现，证明了这一点。</p><br><h3 style=\"text-align: center;\">比较</h3><br><p>下面的表中试图提供三种语言之间的比较；C++也是一个基准。</p><table width=\"80%\" style=\"margin: 0 10%;\"><tbody><tr><td>Metric</td><td>Val</td><td>Carbon</td><td>cpp2</td><td>C++</td></tr><tr><td>Project status</td><td>experiment</td><td>experiment</td><td>experiment</td><td>experiment</td></tr><tr><td>GitHub stars</td><td x:num=\"272\">272</td><td>28.5k</td><td>2.4k</td><td>millions</td></tr><tr><td>Resemblance to C++</td><td>lower</td><td>medium</td><td>high</td><td>perfect</td></tr><tr><td>safety</td><td>strong</td><td>unsafe+</td><td>unsafe+</td><td>unsafe</td></tr><tr><td>Decision coherence</td><td>high</td><td>medium</td><td>medium</td><td>low</td></tr><tr><td>Theory based</td><td>yes</td><td>no</td><td>no</td><td>no</td></tr></tbody></table><p>今年宣布的3种C++继任语言都被认为是试验品。并没有很好的指标表明它们是否真的能成功地吸引足够数量的编码人员/代码库，在生产环境中使用它们。</p><p>看看GitHub上的星星数量，我们看到Carbon是这群人中的佼佼者，与其他两个相比，有很大的差距。Carbon已经成功地在社区内进行了更多的炒作；对包容性的关注和治理模式可能对此有贡献。</p><br><br><a><svg aria-hidden=\"true\" height=\"16\" viewBox=\"0 0 16 16\" version=\"1.1\" width=\"16\" data-view-component=\"true\" class=\"octicon octicon-star v-align-text-bottom d-inline-block mr-2\"><path fill-rule=\"evenodd\" d=\"M8 .25a.75.75 0 01.673.418l1.882 3.815 4.21.612a.75.75 0 01.416 1.279l-3.046 2.97.719 4.192a.75.75 0 01-1.088.791L8 12.347l-3.766 1.98a.75.75 0 01-1.088-.79l.72-4.194L.818 6.374a.75.75 0 01.416-1.28l4.21-.611L7.327.668A.75.75 0 018 .25zm0 2.445L6.615 5.5a.75.75 0 01-.564.41l-3.097.45 2.24 2.184a.75.75 0 01.216.664l-.528 3.084 2.769-1.456a.75.75 0 01.698 0l2.77 1.456-.53-3.084a.75.75 0 01.216-.664l2.24-2.183-3.096-.45a.75.75 0 01-.564-.41L8 2.694v.001z\"></path></svg><span>Star</span><span>29.6k</span></a><br><br><p>这三种语言也在它们与C++的相似程度方面有所区别。正如所料，Cpp2是三种语言中最接近C++的。Carbon似乎离C++更远，但使用了与C++相同的基本构件块；在Carbon中，用户的思考方式与他们在C++中的方式基本相同。由于可变值语义，Val程序员在编程时需要有一个稍微不同的思维模型，这可能使Val成为一种离C++更远的语言。另一方面，如果我们看一下Val的快速定义口号，特别是在默认安全和简单的背景下，该语言的原则似乎可以很好地转化为C++的受众。</p><p>在这三种新的语言中，Val是唯一一种能够支持其安全承诺的语言。其他两种语言试图改变一些最不安全的操作的默认值；目前还不清楚这是否有很大的区别。</p><p>就语言特性的一致性而言，这三种语言似乎都比C++更好。但在语言的连贯性方面，改变默认值并不能让你走得那么远。在这里，与Carbon和Cpp2相比，Val的方法似乎更有连贯性。</p><p>最后，我认为在我们这样的工程学科中很重要的一点是：有多少语言设计决定是由某种科学支持的？在这方面，Val似乎是唯一有一些理论基础的。这可以为其用户提供真正的保证。</p><br><h3 style=\"text-align: center;\">放弃还为时过早</h3><br><p>Herb在他的主题演讲中呼吁不要放弃C++。这是一个来自C++的领导层的证明，人们正在考虑放弃C++。在一年内出现了三种C++的继任语言，正好证实了这一想法。C++是否开始默默无闻还不得而知，但我们大概可以认为，今年是C++未来的一个拐点。</p><p>目前，要判断这些实验是否会成功还为时过早。所有的语言都有优点，也都有弱点。如果其中至少有一种成功了，我相信我们会推进编程语言的实践；这可能意味着在整个软件行业的积极影响。</p><p>在这次比较中，尽可能地保持了客观，但我确实有自己的偏见。我希望这些偏见不会妨碍在比较这些语言时做得很好。</p><p>说到偏见，我确实需要承认：在业余时间，我已经开始与Val团队合作，推动语言的核心理念。对我来说，这些想法，如果能在实践中得到完善和成功采用，比特定的语言更重要。如果Val作为一种编程语言消亡了，但它的所有想法都被纳入了C++，那么我会很高兴。</p><p>自从我看到Dave和Dimitri在C++Now上的演讲录音后，我就被可变值语义的思想所吸引。在2022年的CppCon上，我见到了Dave和Dimitri，并和他们一起探讨了一些细节，使我相信Val背后的想法是深刻的，经过深思熟虑的，值得密切关注。</p><p>看一下流行的数字，Val的表现并不那么好。可能其中一个原因是，好的想法需要时间来沉淀。套用一个著名的演讲，我选择为Val工作，不是因为它容易，而是因为它困难；因为Val的目标是值得的。</p><br><p>引用：</p><ul><li>[ADSP22]Connor Hoekstra,Bryce Adelstein Lelbach,Connor,Sean Baxter,ADSP:The Podcast,Episode 97:‘C++vs Carbon vs Circle vs CppFront with Sean Baxter’,2022</li><li>[Abrahams22a]Dave Abrahams,A Future of Value Semantics and Generic Programming(part 1),C++Now 2022</li><li>[Abrahams22b]Dave Abrahams,Dimitri Racordon,A Future of Value Semantics and Generic Programming(part 2),C++Now 2022</li><li>[Abrahams22c]Dave Abrahams,‘Values:Safety,Regularity,Independence,and the Future of Programming’,CppCon 2022</li><li>[Carbon]GitHub,Carbon Language:An experimental successor to C++</li><li>[Carruth22]Chandler Carruth,‘Carbon Language:An experimental successor to C++’,CppNorth 2022</li><li>[Kazakova21]Anastasia Kazakova,‘Code Analysis++’,CppNow,2021</li><li>[Parent22]Sean Parent,‘Exceptions the Other Way Around’</li><li>[Racordon22a]Dimitri Racordon,Denys Shabalin,Daniel Zheng,Dave Abrahams,Brennan Saeta,‘Implementation Strategies for Mutable Value Semantics’</li><li>[Racordon22b]Dimitri Racordon,‘Val Wants To Be Your Friend:The design of a safe,fast,and simple programming language’,CppCon 2022</li><li>[Stroustrup94]Bjarne Stroustrup,The Design and Evolution of C++,Addison-Wesley Professional,1994</li><li>[Sutter22]Herb Sutter,‘Can C++be 10×simpler&amp;safer…?’,CppCon 2022</li><li>[TIOBE22]TIOBE,TIOBE Index for October 2022,Octobe</li></ul>', 10, 5, 7, 1, 1676571785840, 0);
INSERT INTO `t_blog` VALUES (50, 1, 20, '程序？进程？傻傻分不清楚', '<section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\">今天，我们来回顾一下操作系统相关知识，算是温故知新吧，以下是正文。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\">到目前为止，你肯定已经见过很多次这两个词了，“程序”和“进程”。那么，二者有什么区别呢？</span></section><ul class=\"list-paddingleft-1\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 0px 0px 0px 1.2em; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><li style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 8px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; visibility: visible; overflow-wrap: break-word !important;\">程序</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; visibility: visible; overflow-wrap: break-word !important;\">是一个静态的概念</span></p></li><li style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; visibility: visible; overflow-wrap: break-word !important;\">进程</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; visibility: visible; overflow-wrap: break-word !important;\">是一个动态的概念</span></section></li></ul><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\">下面，我们用一个例子来形象地讲解一下。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; visibility: visible; overflow-wrap: break-word !important;\">程序其实本质上和我们的菜谱非常类似，一个菜谱规定了完成一道菜的整个流程，一步一步每个节点执行什么样的操作。但是，看一遍菜谱是不能变出一道美味可口的菜肴的。要想真正做出一道菜，就应该按照菜谱的要求走一遍，准备好食材，按照菜谱的指导，打开燃气，锅热后倒入油，待油温适宜后放入准备好的食材、调味料，然后不断翻炒直至炒熟，这样一道美味就新鲜出锅啦。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">在这个例子中，<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">如果把菜谱比作我们写的程序，那么按照菜谱真正炒菜的这个过程才是进程</strong>。如果你自己真的炒过菜，相信会对此有更加深刻地的理解，如果你还没有做过菜，那么笔者强烈建议读者自己真正的去炒一道菜感受一下。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">进程是计算机科学当中一个及其重要的概念，彻底理解进程是理解操作系统工作原理的关键所在，同时也是编程高手的标志之一。</span></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-weight: bold; color: rgb(217, 33, 66); text-decoration-line: underline; overflow-wrap: break-word !important;\">编程高手与普通程序员的分水岭</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-weight: bold; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">进程是计算机操作系统中至关重要的一个概念，可以说，彻底理解进程这个概念是能否成为拥有“自我探索”能力的编程高手的一个分水岭，<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">能彻底理解操作系统如何实现进程是编程高手的关键性标志。</strong></span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">理解了这个概念以后，你几乎不会再遇到程序出现了问题，但你根本就不知道到底哪里出现问题的窘境。正因为这个概念的重要性，因此我们后面的文章会有很大一部分都是围绕着进程来进行讲解的，目的就是确保大家能真正掌握这一思想，从而在成为高手的道路上迈出坚实的一步。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">接下来，我们再看一下程序是如何生成的。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-weight: bold; color: rgb(217, 33, 66); text-decoration-line: underline; overflow-wrap: break-word !important;\">程序是如何生成的？</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></strong></p><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">程序这个词其实是比较笼统的，在我们学习工作工作过程中，即指我们人类可以认识的字符串程序，也可以指机器可以运行的二进制机器指令程序，这个程序就是可执行程序。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">所以，在这里需要大家能意识到一点，程序这个词有两种含义：</span></section><ul type=\"disc\" class=\"list-paddingleft-1\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 0px 0px 0px 1.2em; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><li style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; letter-spacing: normal; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 8px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">人类可以认识的程序，这些程序就是用比如C/C++、Java、Python语言写成的文本文件，比如helloworld.c、hellworld.java、helloworld.py。</span></p></li><li style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; letter-spacing: normal; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">机器可以认识的程序，这些程序就是可执行程序，Windows下就是exe程序，Linux下就是elf程序。</span></p></li></ul><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">因为计算机看不懂人类可以认识的文本文件程序，因此需要将文本文件程序转换为机器可以认识的可执行程序，这个翻译过程就是编译器来完成的，编译器将文本文件程序翻译成二进制机器指令程序。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; orphans: 4; white-space: pre-wrap; overflow-wrap: break-word !important;\">在前几节中，有两种类型的语言，一类是C/C++这种编译型语言，一类是比如Python、Java等解释型语言，CPU可以直接运行C/C++程序经编译后生成的机器指令，但解释型语言不能直接被CPU执行，解释型语言是被解释器直接执行的，而解释器可以被CPU直接执行，因为这些解释器通常都是C/C++语言编写的，就好比下面这样：</span></section><section class=\"code-snippet__fix code-snippet__js\" style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 1000%; position: relative; background-color: rgba(0, 0, 0, 0.03); border: 1px solid rgb(240, 240, 240); border-radius: 2px; display: flex; line-height: 26px; font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><ul class=\"code-snippet__line-index code-snippet__js\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 1em; outline: 0px; max-width: 1000%; counter-reset: line 0; flex-shrink: 0; height: 54px; list-style-type: none; overflow-wrap: break-word !important;\"><li style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 1000%; list-style-type: none; text-align: right; overflow-wrap: break-word !important;\"></li></ul><pre class=\"code-snippet__js\" data-lang=\"shell\" style=\"margin-bottom: 0px; padding: 1em 1em 1em 0px; outline: 0px; max-width: 1000%; white-space: normal; flex: 1 1 0%;\"><code style=\"margin: 0px; outline: 0px; max-width: 1000%; text-align: left; font-size: 14px; white-space: pre; display: flex; position: relative; font-family: Consolas, ‘Liberation Mono‘, Menlo, Courier, monospace; overflow-wrap: break-word !important;\"><span class=\"code-snippet_outer\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 1000%; overflow-wrap: break-word !important;\">$ python helloworld.py</span></code></pre></section><p style=\"margin-top: 24px; margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">其中python就是一个C语言程序，只不过这个C语言程序可以来执行python程序。有了这些背景后，接下来我们重点关注C/C++这类解释型语言是如何从文本文件转变为可执行文件的。</span></p><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: normal; overflow-wrap: break-word !important;\">接下来的这句话，大家一定要理解，那就是：</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">“程序其实包含两部分内容，一部分是指令（代码），另一部分是数据”。</strong></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">有的同学可能会问了，程序里面不都是“指令（代码）”吗，</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-weight: bold; overflow-wrap: break-word !important;\">不是的，</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">大家一定要意识到这一点，非常重要。程序中不都是指令(代码)，还包括数据。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">比如 int a = 100; 这段代码在生成的可执行程序中是没有对应的机器指令的，为什么，因为这是数据。那么什么样的代码才有对应的可执行程序呢？比如if... while... +-*/，return等语句才会有对应的机器指令。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">现在你应该清楚了吧，一般来说，对数据的操作部分我们都可以认为是指令，而除此之外的定义都是数据。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; overflow-wrap: break-word !important;\">有了这些知识，你就能理解编译器啦，编译器的工作就是把C程序中的对数据的操作部分翻译成二进制机器指令，这些指令统一放在二进制文件中的一部分，这一部分就叫代码段，然后编译器收集C程序中定义的数据，把这些数据统一放在二进制文件中的另一部分，这一部分就叫数据段，就好比披萨一样分为两层，一个可执行文件就如下图所示：</span></section><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; line-height: 1.75em; overflow-wrap: break-word !important;\"><img src=\"data:image/png;base64,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\" style=\"width: 100px;\" data-filename=\"image.png\"><br></p><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">这就是为什么最终可执行文件中有两部分的原因，这也是可执行程序在磁盘中的看起来是样子的。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">这里需要大家意识到的一点就是可执行程序也是一个保存在磁盘上的普通文件，和我们的经常使用的文本文件没有本质的区别。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">我们来总结一下，编译器将源代码分成两类，一类是对数据的操作，这一部分就被编译器翻译成了机器指令；另一类是数据，这些数据被编译器收集后放到了可执行文件的数据段。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">可执行程序也是文件，和普通的文本文件没有什么本质的区别，只不过文本文件中保存的是人类认识的字符，而可执行程序保存的是机器指令以及机器指令操作的数据，这些二进制的指令或数据人类是很难直观理解的，但是CPU不一样，CPU可以直接执行这些二进制机器指令。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">现在你应该清楚程序是如何生成的了吧，程序是编译器翻译而成的，可执行程序和普通文件一样，生成后被安静的保存在磁盘上。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">从这里我们也可以看出，程序其实和菜谱一样是一个静态的概念。程序被保存在磁盘上，只要磁盘没被破坏程序就可以一直被保存下去。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">接下来，让我们看看进程又是怎么来的。</span></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-weight: bold; color: rgb(217, 33, 66); text-decoration-line: underline; overflow-wrap: break-word !important;\">进程是如何生成的？</span></p><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">到目前为止，保存在磁盘上的可执行程序和操作系统还没有半毛钱关系。如果一个程序仅仅是放在磁盘上除了占用磁盘控制之外其实是没有任何用处的，只有程序运行起来才能真正发挥它的作用。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">那么，程序是如何被运行起来的呢？</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">这点大家应该都非常熟悉，在Windows中我们通过双击程序图标，在Linux下直接键入程序的名字。但是，这个回答大家可能并不满意，因为计算机的角度上看我们依然不清楚程序是如何运行起来的。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">要回答这个问题，就需要我们的主角登场了，这里的主角就是操作系统。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">我们的程序实际上是被操作系统运行起来的，大体经过了以下几个阶段：</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">1）当我们双击程序图标或者键入程序名字后，操作系统根据程序的名字去磁盘中找到可执行程序。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">2）操作系统在内存为即将要运行的程序划出一块区域。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">3）操作系统将找到的可执行程序从磁盘中copy到刚刚划分出的内存区域当中。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">4）操作系统在内存中找到可执行程序代码段的起始位置，假设这个地址是A。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">5）操作系统告诉CPU从A这个位置开始执行。</span></p><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">经过了这几个步骤后，CPU就开始运行我们的程序啦。值得注意的是，以上只简化后的几个重要步骤，实际情况要更加复杂，但是，这个简化的步骤已经足以让我们理解操作系统是如何来运行程序的了。所以，你会看到当打开一个比较大的程序，比如游戏时，总是非常慢，还会给出“正在加载”的提示，其实就是操作系统在忙着以上几个步骤。</span></p><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">在这里，我们可以给出进程的定义了。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><blockquote cid=\"n55\" mdtype=\"blockquote\" style=\"margin-top: 0.8em; margin-bottom: 0.8em; padding: 0px 15px; outline: 0px; border-left-width: 4px; border-left-color: rgb(223, 226, 229); color: rgb(119, 119, 119); font-size: 16px; max-width: 100%; letter-spacing: 0.544px; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; orphans: 4; white-space: pre-wrap; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 15px; letter-spacing: normal; overflow-wrap: break-word !important;\">程序运行起来之后就叫进程。</span></section></blockquote><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">而进程也是我们后面文章的重中之重。</span></p><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">进程是操作系统精心构筑的一个概念，理解进程对理解操作系统来说至关重要，同时深刻理解进程也是编程高手和普通程序员的分水岭。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-weight: bold; color: rgb(217, 33, 66); text-decoration-line: underline; overflow-wrap: break-word !important;\">总 结</span></p><p style=\"margin-top: 0.8em; margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); letter-spacing: 0.544px; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">本文我们重点关注了程序和进程，下面做个简单的总结，<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">希望</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">大家看完能够清楚地理解这两个概念。</span></span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">小结1：</span></strong></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\">程序是静态的，放在磁盘上的，保存了程序的指令和数据普通文件。</section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">进程是动态的，存防在内存中的，CPU执行程序时的样子。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">小结2：</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">只要磁盘没有被破坏，程序就可以永久保存。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">而进程一旦在内存中被CPU执行完毕，操作系统就会回收进程占据的所有内存空间，进程的生命周期取决于程序的运行时间。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">小结3：</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">程序需要存放在磁盘上，占用的是磁盘的空间。</span></section><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); letter-spacing: 0.544px; text-align: justify; orphans: 4; white-space: pre-wrap; font-family: ‘Open Sans‘, ‘Clear Sans‘, ‘Helvetica Neue‘, Helvetica, Arial, sans-serif; font-size: 16px; line-height: 1.75em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: normal; overflow-wrap: break-word !important;\">而进程需要在内存中被运行，占用的是内存空间。</span></section>', 19, 1, 0, 1, 1676572161854, 0);
INSERT INTO `t_blog` VALUES (51, 1, 27, '草船借箭', '<p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">周瑜看到诸葛亮挺有才干，心里很妒忌。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">有一天，周瑜请诸葛亮商议军事，说：“我们就要跟曹军交战。水上交战，用什么兵器最好？”诸葛亮说：“用弓箭最好。”周瑜说：“对，先生跟我想的一样。现在军中缺箭，想请先生负责赶造十万支。这是公事，希望先生不要推却。”诸葛亮说：“都督委托，当然照办。不知道这十万支箭什么时候用？”周瑜问：“十天造得好吗？”诸葛亮说：“既然就要交战，十天造好，必然误了大事。”周瑜问：“先生预计几天可以造好？”诸葛亮说：“只要三天。”周瑜说：“军情紧急，可不能开玩笑。”诸葛亮说：“怎么敢跟都督开玩笑？我愿意立下军令状，三天造不好，甘受惩罚。”周瑜很高兴，叫诸葛亮当面立下军令状，又摆了酒席招待他。诸葛亮说：“今天来不及了。从明天起，到第三天，请派五百个军士到江边来搬箭。”诸葛亮喝了几杯酒就走了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">鲁肃对周瑜说：“十万支箭，三天怎么造得成呢？诸葛亮说的是假话吧？”周瑜说：“是他自己说的，我可没逼他。我得吩咐军匠们，叫他们故意迟延，造箭用的材料，不给他准备齐全。到时候造不成，定他的罪，他就没话可说了。你去探听探听，看他怎么打算，回来报告我。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">鲁肃见了诸葛亮。诸葛亮说：“三天要造好十万支箭，得请你帮帮我的忙。”鲁肃说：“都是你自己找的，我怎么帮得了你的忙？”诸葛亮说：“你借给我二十条船，每条船上要三十名军士。船要用青布幔子遮起来，还要一千多个草把子，排在船的两边。我自有妙用。第三天管保有十万支箭。不过不能让都督知道。他要是知道了，我的计划就完了。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">鲁肃答应了，他并不知道诸葛亮借船有什么用，回来报告周瑜，果然不提借船的事，只说诸葛亮不用竹子、翎毛、胶漆这些材料。周瑜疑惑起来，说：“到了第三天，看他怎么办！”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">鲁肃私自拨了二十条快船，每条船上配三十名军士，照诸葛亮说的，布置好青布幔子和草把子，等诸葛亮调度。第一天，不见诸葛亮有什么动静；第二天，仍然不见诸葛亮有什么动静；直到第三天四更时候，诸葛亮秘密地把鲁肃请到船里。鲁肃问他：“你叫我来做什么？”诸葛亮说：“请你一起去取箭。”鲁肃问：“哪里去取？”诸葛亮说：“不用问，去了就知道。”诸葛亮吩咐把二十条船用绳索连接起来，朝北岸开去。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\"></p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">这时候大雾漫天，江上连面对面都看不清。天还没亮，船已经靠近曹军水寨。诸葛亮下令把船头朝西，船尾朝东，一字儿摆开，又叫船上的军士一边擂鼓，一边大声呐喊。鲁肃吃惊地说：“如果曹兵出来，怎么办？”诸葛亮笑着说：“雾这样大，曹操一定不敢派兵出来。我们只管饮酒取乐，天亮了就回去。”</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">曹操听到鼓声和呐喊声，就下令说：“江上雾很大，敌人忽然来攻，我们看不清虚实，不要轻易出动。只叫弓弩手朝他们射箭，不让他们近前。”他派人去旱寨调来六千名弓弩手，到江边支援水军。一万多名弓弩手一齐朝江中放箭，箭好象下雨一样。诸葛亮又下令把船掉过来，船头朝东，船尾朝西，仍旧擂鼓呐喊，逼近曹军水寨去受箭。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">天渐渐亮了，雾还没有散。这时候，船两边的草把子上都插满了箭。诸葛亮吩咐军士们齐声高喊：“谢谢曹丞相的箭！”接着叫二十条船驶回南岸。曹操知道上了当，可是这边的船顺风顺水，已经驶出二十多里，要追也来不及了。</p><p style=\"padding: 0px; text-indent: 2em; color: rgb(0, 0, 0); font-family: 新宋体, Arial, sans-serif;\">二十条船靠岸的时候，周瑜派来的五百个军士正好来到江边搬箭。每条船大约有五六千支箭，二十条船总共有十万多支。鲁肃见了周瑜，告诉他借箭的经过。周瑜长叹一声，说：“诸葛亮神机妙算，我真比不上他！”</p>', 3, 3, 0, 1, 1676647846054, 0);
INSERT INTO `t_blog` VALUES (52, 1, 27, '人生最该坚持的三件事', '\n				\n				<p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><br></strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"font-size: 18px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\">1</strong></section></section></section></section></section><p></p><p></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><br></section></section></section></section></section><p></p><p></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(171, 25, 66); font-size: 18px; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">坚持运动，保养身体</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; overflow-wrap: break-word !important;\"></p><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">有人说，“运动应当像吃饭睡觉一样，成为生活里的必需品。”</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">一个人运动和不运动，在短时间内，也许变化并不大，但在日积月累中，你就会拥有越来越健康的身体、越来越积极的生活，以及一个越来越好的人生。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">告别过去的懒惰吧，为自己制定一份长期的健身计划。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">这也许要经历艰难的开端和痛苦的过程，</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">可当你坚持下去，身心都会收获巨大的快乐和满足。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">一个好身体，是人生最大的财富，也是一切希望和幸福的前提。</span></section><p></p><p></p><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><br></span></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: auto; padding: 0px; outline: 0px; max-width: 100%; width: 90px; transform: translateZ(5px); visibility: visible; overflow-wrap: break-word !important;\"></section><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\">2</strong></span></section></section></section></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; clear: both; min-height: 1em; text-align: center; visibility: visible; line-height: 1.75em; font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, Arial, sans-serif; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; visibility: visible; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(171, 25, 66); font-size: 18px; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">坚持读书，滋养头脑</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">有人说，<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">“</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">书不是棍棒，却会使人铿锵有力；</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">书不是羽毛，却会使人飞翔。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">”</span></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">其实，无论是驱赶迷茫，还是对抗平庸，读书都是一剂良药。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">从泼墨飘香的文字里</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">，你可以收获内心的宁静；</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">从流转千年的智慧中，你也可以窥探人生的真理。</span></section><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-indent: 2em; overflow-wrap: break-word !important;\"></span></span></section><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></section><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-indent: 34px; overflow-wrap: break-word !important;\">去阅读，去学习，用</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-indent: 34px; overflow-wrap: break-word !important;\">书籍来面对充满不确定性的人生吧。<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">世上没有白走</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\">的路，更没有白读的书。</span></span></span></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 36px; overflow-wrap: break-word !important;\"></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; letter-spacing: 0.544px; text-indent: 2em; overflow-wrap: break-word !important;\">&nbsp;</span></section><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">不要低估阅读的力量，哪怕每天10分钟，累积起来，也足以让生活发生惊人的改变。</span></section><p></p><p></p><section style=\"margin: 0px 0px 0em; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; font-family: -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\"><br></span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><section data-role=\"title\" data-tools=\"135编辑器\" data-id=\"115966\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><section style=\"margin: auto; padding: 0px; outline: 0px; max-width: 100%; width: 90px; transform: translateZ(5px); visibility: visible; overflow-wrap: break-word !important;\"></section><section hm_fix=\"335:556\" style=\"margin: -35px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 20px; letter-spacing: 1.5px; text-align: center; transform: translateZ(10px); visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"><strong data-original-title=\"\" title=\"\" style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\">3</strong></span></section></section></section></section></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; clear: both; min-height: 1em; text-align: center; visibility: visible; line-height: 1.75em; font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, Arial, sans-serif; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; visibility: visible; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(171, 25, 66); font-size: 18px; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">坚持思考，富养心灵</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\"></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">不知你有时是否也会觉得，日子好像总是按部就班。可人生就像赶路，如果一直匆匆向前，很容易忘记自己为什么出发。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">偶尔停下脚步，</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">静下心来思考，是认识自己最好的途径。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">你不能只</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">把日子简单地重复，而是要不断地翻新自己</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\">。</span></section><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></section><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">每一天都问问今天的自己，比昨天有哪一些进步、有哪一些不足、有哪一些可以改进之处。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; text-indent: 2em; overflow-wrap: break-word !important;\"></span><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 18px; overflow-wrap: break-word !important;\">就像有人说的：“一个人具备思考的能力，就拥有了内在的自由。”<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">在喧嚣中保持思考，看清自己、守住自己，才能远离无谓的焦虑和困扰</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">。</span>&nbsp;</span></p><p></p>\n			\n			', 2, 0, 0, 0, 1676650873386, 1677826206158);
INSERT INTO `t_blog` VALUES (59, 1, 29, 'Write a story for children about a dog who lives on the moon', '\n<pre style=\"border: 0;background-color:#00000000;margin: 0px 0px 4px;padding: 6px 10px;font-size: 16px;font-style: normal;font-variant-ligatures: normal;font-variant-caps: normal;font-weight: 400;letter-spacing: normal;orphans: 2;text-align: start;text-indent: 0px;text-transform: none;widows: 2;word-spacing: 0px;-webkit-text-stroke-width: 0px;text-decoration-thickness: initial;text-decoration-style: initial;text-decoration-color: initial;\"><p style=\"white-space: pre-wrap; font-size: 14px;\">Luna was a very special dog. She was born on the moon, where her parents were part of a team of astronauts who were exploring the lunar surface. Luna loved the moon, because it was her home. She enjoyed bouncing around in the low gravity, digging holes in the dust, and chasing the moon rocks that rolled down the craters.\n\nLuna was curious about everything, and she always wanted to learn new things. She liked to listen to the stories that her parents and the other astronauts told her about Earth, the blue planet that shone brightly in the sky. She wondered what it was like to see the sun, the stars, the clouds, and the oceans. She wondered what it was like to smell the flowers, to feel the wind, and to hear the birds. She wondered what it was like to meet other dogs, and to play with them.\n\nOne day, Luna decided that she wanted to go to Earth. She asked her parents if they could take her with them on their next mission, but they said no. They said that Earth was too dangerous for a moon dog, and that she would not be happy there. They said that she belonged on the moon, where she was safe and loved.\n\nLuna was sad, but she did not give up. She thought that maybe she could sneak into the rocket when no one was looking, and hide until they reached Earth. She waited for the right moment, and then she ran towards the rocket. But before she could get inside, she was stopped by a friendly voice.\n\n\"Hey, where are you going, little one?\" the voice said.\n\nLuna looked up and saw a robot. It was a rover, a machine that explored the moon and collected data. It had wheels, a camera, a solar panel, and a antenna. It was one of Luna\'s friends, and she often played with it.\n\n\"I\'m going to Earth,\" Luna said. \"I want to see what it\'s like.\"\n\nThe rover shook its head. \"That\'s not a good idea, Luna. Earth is not for you. You wouldn\'t like it there.\"\n\n\"Why not?\" Luna asked.\n\n\"Because Earth is very different from the moon,\" the rover said. \"It has a lot of things that you are not used to. It has a lot of noise, a lot of people, a lot of pollution. It has a lot of dangers, like cars, animals, diseases, and natural disasters. It has a lot of rules, like laws, customs, and manners. You would have to wear a special suit, and a special collar, and a special leash. You would have to stay indoors most of the time, and follow orders from strangers. You would have to give up your freedom, your fun, and your friends.\"\n\nLuna frowned. \"But Earth also has a lot of good things, right? It has a lot of beauty, a lot of diversity, a lot of wonder. It has a lot of things that I want to see, and smell, and hear, and touch. It has a lot of things that I want to learn, and experience, and enjoy. It has a lot of things that I want to love.\"\n\nThe rover nodded. \"That\'s true, Luna. Earth also has a lot of good things. But you can\'t have them all. You have to choose. You have to decide what is more important to you. You have to decide where you belong.\"\n\nLuna thought for a moment. She looked at the rocket, and then she looked at the moon. She looked at the Earth, and then she looked at the rover. She realized that the rover was right. She had to choose. And she knew what she wanted.\n\nShe smiled and said, \"I belong here. I belong on the moon. This is my home. This is where I\'m happy.\"\n\nThe rover smiled back and said, \"I\'m glad you feel that way, Luna. You are a very special dog. You are a moon dog. And I\'m proud to be your friend.\"\n\nLuna wagged her tail and said, \"Thank you, rover. You are a very special robot. You are a moon rover. And I\'m happy to be your friend too.\"\n\nThey hugged each other, and then they went to play. They bounced around in the low gravity, dug holes in the dust, and chased the moon rocks that rolled down the craters. They had fun, and they learned new things. They enjoyed the moon, and they loved each other.\n\nAnd they lived happily ever after.\n\nThe end.</p></pre><p></p>\n			', 8, 1, 3, 1, 1677516057608, 1677637736591);
INSERT INTO `t_blog` VALUES (61, 1, 27, 'Java提取${...}占位符并组装对应值', '\n        <h1 id=\"java提取占位符并组装对应值\" style=\"margin-top: 10px;  font-size: 28px; font-weight: bold; line-height: 1.5; color: black; \">\n            Java提取${}占位符并组装对应值<button title=\"显示目录导航\" aria-expanded=\"false\" style=\"margin-left: 0.5rem;  opacity: 0.5; outline: none; appearance: none; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; border-width: 0px; border-style: initial; border-color: initial;  vertical-align: middle; display: inline;\"></button>\n        </h1>\n        <p style=\"margin-top: 10px;  color: black; \">\n            实现了一个${}装配工~</p>\n        <h2 id=\"零起因\" style=\"margin-top: 10px; margin-right: 0px; margin-left: 0px;  font-size: 21px; font-weight: bold; line-height: 1.5; color: black; \">\n            零、起因</h2>\n        <p style=\"margin-top: 10px;  color: black; \">\n            最近写个JavaWeb项目，数据库相关的配置想放到properties文件中，用的H2，想直接内嵌，但是数据库文件位置想随程序移动，因为这个项目准备是放到U盘里随插随用的程序。然后配置URL时一开始用的是<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">./data</code>，它是在Tomcat\n            bin目录下生成的，后面了解到有个私有的工作目录：<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">${catalina.base}</code>，想我的数据库初始化程序也支持这个，直接加到H2的URL中<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">jdbc:h2:${catalina.base}/data;</code>报错，H2不支持。现在了解到可以通过<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">System.getProperty(\"catalina.base\")</code>的方式获取到这个路径，那如何把URL中的<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">${catalina.base}</code>替换成<code style=\"margin: 0px 3px; padding: 0px 5px;  font-size: 12px; line-height: 1.8; display: inline-block;  vertical-align: middle; border-radius: 3px; background-color: rgb(246, 246, 246); color: rgb(232, 62, 140);\">System.getProperty(\"catalina.base\")</code>的值呢？\n        </p>\n        <h2 id=\"壹想法\" style=\"margin-top: 10px; margin-right: 0px; margin-left: 0px;  font-size: 21px; font-weight: bold; line-height: 1.5; color: black; \">\n            壹、想法</h2>\n        <p style=\"margin-top: 10px;  color: black; \">\n            百度没得啥资料，我感觉可以通过正则匹配${}，然后一个一个替换掉。</p>\n        <h2 id=\"贰实现\" style=\"margin-top: 10px; margin-right: 0px; margin-left: 0px;  font-size: 21px; font-weight: bold; line-height: 1.5; color: black; \">\n            贰、实现</h2>\n        <p style=\"margin-top: 10px;  color: black; \">\n            首先写了个正则表达式</p>\n        <pre highlighted=\"true\" has-selection=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\">\\<span style=\"  color: rgb(0, 128, 0);\">$\\</span>{[^}]+}</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            在菜鸟在线工具上测试通过<br>输入：</p>\n        <pre highlighted=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\">jdbc:h2:<span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span>/<span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span>work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            输出：</p>\n        <pre highlighted=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\">共找到 2 处匹配：</td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\"><span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span></td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\"><span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span></td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            然后在Java中实现了这个正则表达式的匹配</p>\n        <pre highlighted=\"true\" has-selection=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">str</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"jdbc:h2:${catalina.base}/${catalina.base}work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;\"</span>;</td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\"><span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">pattern</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"\\\\$\\\\{[^}]+}\"</span>;</td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\"> </td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\"><span style=\"  color: rgb(163, 21, 21);\">Pattern</span> <span style=\"  color: rgb(0, 128, 0);\">r</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> Pattern.compile(pattern);</td></tr><tr><td data-line-number=\"5\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"5\"></div></td><td data-line-number=\"5\"><span style=\"  color: rgb(163, 21, 21);\">Matcher</span> <span style=\"  color: rgb(0, 128, 0);\">m</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> r.matcher(str);</td></tr><tr><td data-line-number=\"6\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"6\"></div></td><td data-line-number=\"6\"><span style=\"  color: blue;\">if</span>(m.find()) {</td></tr><tr><td data-line-number=\"7\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"7\"></div></td><td data-line-number=\"7\">    System.out.println(m.group());</td></tr><tr><td data-line-number=\"8\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"8\"></div></td><td data-line-number=\"8\">    str = m.replaceFirst(<span style=\"  color: rgb(163, 21, 21);\">\"第一个位置\"</span>);</td></tr><tr><td data-line-number=\"9\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"9\"></div></td><td data-line-number=\"9\">    System.out.println(str);</td></tr><tr><td data-line-number=\"10\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"10\"></div></td><td data-line-number=\"10\">}</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            输出</p>\n        <pre highlighted=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span></td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\">jdbc:h2:第一个位置/<span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span>work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            很好，加了个循环，依次替换掉后面的值</p>\n        <pre highlighted=\"true\" has-selection=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">str</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"jdbc:h2:${catalina.base}/${catalina.base}work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;\"</span>;</td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\"><span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">pattern</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"\\\\$\\\\{[^}]+}\"</span>;</td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\"> </td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\"><span style=\"  color: rgb(163, 21, 21);\">Pattern</span> <span style=\"  color: rgb(0, 128, 0);\">r</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> Pattern.compile(pattern);</td></tr><tr><td data-line-number=\"5\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"5\"></div></td><td data-line-number=\"5\"><span style=\"  color: rgb(163, 21, 21);\">int</span> <span style=\"  color: rgb(0, 128, 0);\">index</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(136, 0, 0);\">0</span>;</td></tr><tr><td data-line-number=\"6\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"6\"></div></td><td data-line-number=\"6\"><span style=\"  color: blue;\">while</span> (<span style=\"  color: rgb(163, 21, 21);\">true</span>) {</td></tr><tr><td data-line-number=\"7\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"7\"></div></td><td data-line-number=\"7\">    <span style=\"  color: rgb(163, 21, 21);\">Matcher</span> <span style=\"  color: rgb(0, 128, 0);\">m</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> r.matcher(str);</td></tr><tr><td data-line-number=\"8\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"8\"></div></td><td data-line-number=\"8\">    <span style=\"  color: blue;\">if</span>(m.find()){</td></tr><tr><td data-line-number=\"9\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"9\"></div></td><td data-line-number=\"9\">        index++;</td></tr><tr><td data-line-number=\"10\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"10\"></div></td><td data-line-number=\"10\">        System.out.println(m.group());</td></tr><tr><td data-line-number=\"11\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"11\"></div></td><td data-line-number=\"11\">        str = m.replaceFirst(<span style=\"  color: rgb(163, 21, 21);\">\"第\"</span> + index + <span style=\"  color: rgb(163, 21, 21);\">\"个位置\"</span>);</td></tr><tr><td data-line-number=\"12\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"12\"></div></td><td data-line-number=\"12\">        System.out.println(str);</td></tr><tr><td data-line-number=\"13\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"13\"></div></td><td data-line-number=\"13\">    }<span style=\"  color: blue;\">else</span> {</td></tr><tr><td data-line-number=\"14\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"14\"></div></td><td data-line-number=\"14\">        <span style=\"  color: blue;\">break</span>;</td></tr><tr><td data-line-number=\"15\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"15\"></div></td><td data-line-number=\"15\">    }</td></tr><tr><td data-line-number=\"16\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"16\"></div></td><td data-line-number=\"16\">}</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            输出</p>\n        <pre highlighted=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span></td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\">jdbc:h2:第1个位置/<span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span>work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;</td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\"><span style=\"  color: rgb(0, 128, 0);\">${catalina.base}</span></td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\">jdbc:h2:第1个位置/第2个位置work/data;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CIPHER=AES;</td></tr></tbody></table></code></pre>\n        <hr style=\"margin: 5px 0px;  border-top: rgb(136, 136, 136); color: black; \">\n        <p style=\"margin-top: 10px;  color: black; \">\n            好，真不戳，然后封装一下，替换的值由接口来决定，到时候重写这个接口就好了</p>\n        <pre highlighted=\"true\" has-selection=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: blue;\">package</span> minuhy.ymz.WorkManage.Util;</td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\"> </td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\"><span style=\"  color: blue;\">import</span> java.util.regex.Matcher;</td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\"><span style=\"  color: blue;\">import</span> java.util.regex.Pattern;</td></tr><tr><td data-line-number=\"5\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"5\"></div></td><td data-line-number=\"5\"> </td></tr><tr><td data-line-number=\"6\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"6\"></div></td><td data-line-number=\"6\"><span style=\"  color: rgb(0, 128, 0);\">/**</span></td></tr><tr><td data-line-number=\"7\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"7\"></div></td><td data-line-number=\"7\"><span style=\"  color: rgb(0, 128, 0);\"> * <span style=\"  color: rgb(128, 128, 128);\">@Auther</span>: Minuhy</span></td></tr><tr><td data-line-number=\"8\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"8\"></div></td><td data-line-number=\"8\"><span style=\"  color: rgb(0, 128, 0);\"> * <span style=\"  color: rgb(128, 128, 128);\">@Date</span>: 2022/10/2 13:02</span></td></tr><tr><td data-line-number=\"9\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"9\"></div></td><td data-line-number=\"9\"><span style=\"  color: rgb(0, 128, 0);\"> * <span style=\"  color: rgb(128, 128, 128);\">@Decsription</span>: 装配 ${} 表达式的值</span></td></tr><tr><td data-line-number=\"10\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"10\"></div></td><td data-line-number=\"10\"><span style=\"  color: rgb(0, 128, 0);\"> */</span></td></tr><tr><td data-line-number=\"11\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"11\"></div></td><td data-line-number=\"11\"><span style=\"  color: blue;\">public</span> <span style=\"  color: blue;\">class</span> <span style=\"  color: rgb(163, 21, 21);\">StringAssembler</span> {</td></tr><tr><td data-line-number=\"12\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"12\"></div></td><td data-line-number=\"12\">    <span style=\"  color: blue;\">public</span> <span style=\"  color: blue;\">interface</span> <span style=\"  color: rgb(163, 21, 21);\">Assemble</span> {</td></tr><tr><td data-line-number=\"13\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"13\"></div></td><td data-line-number=\"13\">        <span style=\"  color: rgb(0, 128, 0);\">/**</span></td></tr><tr><td data-line-number=\"14\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"14\"></div></td><td data-line-number=\"14\"><span style=\"  color: rgb(0, 128, 0);\">         * 装配过程中需要通过${}里面的表达式找到对应的值</span></td></tr><tr><td data-line-number=\"15\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"15\"></div></td><td data-line-number=\"15\"><span style=\"  color: rgb(0, 128, 0);\">         * <span style=\"  color: rgb(128, 128, 128);\">@param</span> key ${}里面的表达式</span></td></tr><tr><td data-line-number=\"16\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"16\"></div></td><td data-line-number=\"16\"><span style=\"  color: rgb(0, 128, 0);\">         * <span style=\"  color: rgb(128, 128, 128);\">@return</span> ${}里面的表达式对应的值</span></td></tr><tr><td data-line-number=\"17\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"17\"></div></td><td data-line-number=\"17\"><span style=\"  color: rgb(0, 128, 0);\">         */</span></td></tr><tr><td data-line-number=\"18\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"18\"></div></td><td data-line-number=\"18\">        String <span style=\"  color: rgb(163, 21, 21);\">getStringByKey</span><span>(String key)</span>;</td></tr><tr><td data-line-number=\"19\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"19\"></div></td><td data-line-number=\"19\">    }</td></tr><tr><td data-line-number=\"20\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"20\"></div></td><td data-line-number=\"20\"> </td></tr><tr><td data-line-number=\"21\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"21\"></div></td><td data-line-number=\"21\">    <span style=\"  color: rgb(0, 128, 0);\">/**</span></td></tr><tr><td data-line-number=\"22\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"22\"></div></td><td data-line-number=\"22\"><span style=\"  color: rgb(0, 128, 0);\">     * 装配 ${} 格式的字符串</span></td></tr><tr><td data-line-number=\"23\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"23\"></div></td><td data-line-number=\"23\"><span style=\"  color: rgb(0, 128, 0);\">     * <span style=\"  color: rgb(128, 128, 128);\">@param</span> str 原始字符串</span></td></tr><tr><td data-line-number=\"24\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"24\"></div></td><td data-line-number=\"24\"><span style=\"  color: rgb(0, 128, 0);\">     * <span style=\"  color: rgb(128, 128, 128);\">@param</span> assemble 装配过程中获取值的接口</span></td></tr><tr><td data-line-number=\"25\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"25\"></div></td><td data-line-number=\"25\"><span style=\"  color: rgb(0, 128, 0);\">     * <span style=\"  color: rgb(128, 128, 128);\">@return</span> 装配好之后的字符串</span></td></tr><tr><td data-line-number=\"26\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"26\"></div></td><td data-line-number=\"26\"><span style=\"  color: rgb(0, 128, 0);\">     */</span></td></tr><tr><td data-line-number=\"27\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"27\"></div></td><td data-line-number=\"27\">    <span style=\"  color: blue;\">public</span> <span style=\"  color: blue;\">static</span> String <span style=\"  color: rgb(163, 21, 21);\">assemble</span><span>(String str, Assemble assemble)</span> {</td></tr><tr><td data-line-number=\"28\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"28\"></div></td><td data-line-number=\"28\">        <span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">pattern</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"\\\\$\\\\{[^}]+}\"</span>;</td></tr><tr><td data-line-number=\"29\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"29\"></div></td><td data-line-number=\"29\"> </td></tr><tr><td data-line-number=\"30\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"30\"></div></td><td data-line-number=\"30\">        <span style=\"  color: rgb(163, 21, 21);\">Pattern</span> <span style=\"  color: rgb(0, 128, 0);\">r</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> Pattern.compile(pattern);</td></tr><tr><td data-line-number=\"31\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"31\"></div></td><td data-line-number=\"31\"> </td></tr><tr><td data-line-number=\"32\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"32\"></div></td><td data-line-number=\"32\">        <span style=\"  color: blue;\">while</span> (<span style=\"  color: rgb(163, 21, 21);\">true</span>) {</td></tr><tr><td data-line-number=\"33\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"33\"></div></td><td data-line-number=\"33\">            <span style=\"  color: rgb(163, 21, 21);\">Matcher</span> <span style=\"  color: rgb(0, 128, 0);\">m</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> r.matcher(str);</td></tr><tr><td data-line-number=\"34\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"34\"></div></td><td data-line-number=\"34\">            <span style=\"  color: blue;\">if</span> (m.find()) {</td></tr><tr><td data-line-number=\"35\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"35\"></div></td><td data-line-number=\"35\">                <span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">key</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> getKey(m.group());</td></tr><tr><td data-line-number=\"36\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"36\"></div></td><td data-line-number=\"36\">                str = m.replaceFirst(assemble.getStringByKey(key));</td></tr><tr><td data-line-number=\"37\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"37\"></div></td><td data-line-number=\"37\">            } <span style=\"  color: blue;\">else</span> {</td></tr><tr><td data-line-number=\"38\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"38\"></div></td><td data-line-number=\"38\">                <span style=\"  color: blue;\">break</span>;</td></tr><tr><td data-line-number=\"39\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"39\"></div></td><td data-line-number=\"39\">            }</td></tr><tr><td data-line-number=\"40\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"40\"></div></td><td data-line-number=\"40\">        }</td></tr><tr><td data-line-number=\"41\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"41\"></div></td><td data-line-number=\"41\"> </td></tr><tr><td data-line-number=\"42\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"42\"></div></td><td data-line-number=\"42\">        <span style=\"  color: blue;\">return</span> str;</td></tr><tr><td data-line-number=\"43\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"43\"></div></td><td data-line-number=\"43\">    }</td></tr><tr><td data-line-number=\"44\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"44\"></div></td><td data-line-number=\"44\"> </td></tr><tr><td data-line-number=\"45\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"45\"></div></td><td data-line-number=\"45\">    <span style=\"  color: rgb(0, 128, 0);\">/**</span></td></tr><tr><td data-line-number=\"46\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"46\"></div></td><td data-line-number=\"46\"><span style=\"  color: rgb(0, 128, 0);\">     * 获取 ${} 里面的值</span></td></tr><tr><td data-line-number=\"47\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"47\"></div></td><td data-line-number=\"47\"><span style=\"  color: rgb(0, 128, 0);\">     * <span style=\"  color: rgb(128, 128, 128);\">@param</span> g ${} 表达式</span></td></tr><tr><td data-line-number=\"48\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"48\"></div></td><td data-line-number=\"48\"><span style=\"  color: rgb(0, 128, 0);\">     * <span style=\"  color: rgb(128, 128, 128);\">@return</span> ${} 里面的值</span></td></tr><tr><td data-line-number=\"49\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"49\"></div></td><td data-line-number=\"49\"><span style=\"  color: rgb(0, 128, 0);\">     */</span></td></tr><tr><td data-line-number=\"50\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"50\"></div></td><td data-line-number=\"50\">    <span style=\"  color: blue;\">public</span> <span style=\"  color: blue;\">static</span> String <span style=\"  color: rgb(163, 21, 21);\">getKey</span><span>(String g)</span> {</td></tr><tr><td data-line-number=\"51\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"51\"></div></td><td data-line-number=\"51\">        <span style=\"  color: blue;\">return</span> g.substring(<span style=\"  color: rgb(136, 0, 0);\">2</span>, g.length() - <span style=\"  color: rgb(136, 0, 0);\">1</span>);</td></tr><tr><td data-line-number=\"52\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"52\"></div></td><td data-line-number=\"52\">    }</td></tr><tr><td data-line-number=\"53\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"53\"></div></td><td data-line-number=\"53\">}</td></tr><tr><td data-line-number=\"54\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"54\"></div></td><td data-line-number=\"54\"> </td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            测试：</p>\n        <pre highlighted=\"true\" has-selection=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\">	<span style=\"  color: rgb(43, 145, 175);\">@Test</span></td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\">    <span style=\"  color: blue;\">public</span> <span style=\"  color: blue;\">void</span> Test$Exp() {</td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\">        <span style=\"  color: rgb(163, 21, 21);\">String</span> <span style=\"  color: rgb(0, 128, 0);\">str</span> <span style=\"  color: rgb(171, 86, 86);\">=</span> <span style=\"  color: rgb(163, 21, 21);\">\"jdbc:h2:${key1}/${key2}work/data;\"</span>;</td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\">        str = StringAssembler.assemble(str, key -&gt;{</td></tr><tr><td data-line-number=\"5\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"5\"></div></td><td data-line-number=\"5\">            System.out.println(key);</td></tr><tr><td data-line-number=\"6\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"6\"></div></td><td data-line-number=\"6\">            <span style=\"  color: blue;\">if</span> (key.equals(<span style=\"  color: rgb(163, 21, 21);\">\"key1\"</span>)) {</td></tr><tr><td data-line-number=\"7\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"7\"></div></td><td data-line-number=\"7\">                <span style=\"  color: blue;\">return</span> <span style=\"  color: rgb(163, 21, 21);\">\"第一个键\"</span>;</td></tr><tr><td data-line-number=\"8\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"8\"></div></td><td data-line-number=\"8\">            } <span style=\"  color: blue;\">else</span> <span style=\"  color: blue;\">if</span> (key.equals(<span style=\"  color: rgb(163, 21, 21);\">\"key2\"</span>)) {</td></tr><tr><td data-line-number=\"9\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"9\"></div></td><td data-line-number=\"9\">                <span style=\"  color: blue;\">return</span> <span style=\"  color: rgb(163, 21, 21);\">\"第二个键\"</span>;</td></tr><tr><td data-line-number=\"10\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"10\"></div></td><td data-line-number=\"10\">            }</td></tr><tr><td data-line-number=\"11\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"11\"></div></td><td data-line-number=\"11\">            <span style=\"  color: blue;\">return</span> <span style=\"  color: rgb(163, 21, 21);\">\"\"</span>;</td></tr><tr><td data-line-number=\"12\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"12\"></div></td><td data-line-number=\"12\">        });</td></tr><tr><td data-line-number=\"13\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"13\"></div></td><td data-line-number=\"13\">        System.out.println(str);</td></tr><tr><td data-line-number=\"14\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"14\"></div></td><td data-line-number=\"14\">    }</td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            输出：</p>\n        <pre highlighted=\"true\" style=\"margin-top: 10px;  transition-duration: 0.2s;   color: black; font-size: 14px; background-color: white;\"><code style=\" padding: 1em;  transition-duration: 0.2s;  background: rgb(245, 245, 245); color: rgb(68, 68, 68); display: block; font-size: 12px; border: 1px solid rgb(204, 204, 204); border-radius: 3px;  line-height: 1.5;\"><table style=\"  transition-duration: 0.2s;  word-break: break-word;\"><tbody><tr><td data-line-number=\"1\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"1\"></div></td><td data-line-number=\"1\"><span style=\"  color: rgb(163, 21, 21);\">\"C:\\Program Files\\Java\\jdk1.8.0_301\\bin\\java.exe\"</span> -ea -......</td></tr><tr><td data-line-number=\"2\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"2\"></div></td><td data-line-number=\"2\">key1</td></tr><tr><td data-line-number=\"3\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"3\"></div></td><td data-line-number=\"3\">key2</td></tr><tr><td data-line-number=\"4\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"4\"></div></td><td data-line-number=\"4\"><span style=\"  color: rgb(0, 176, 232);\">jdbc:</span>h2:第一个键/第二个键work/data;</td></tr><tr><td data-line-number=\"5\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"5\"></div></td><td data-line-number=\"5\"> </td></tr><tr><td data-line-number=\"6\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"6\"></div></td><td data-line-number=\"6\">Process finished <span style=\"  color: blue;\">with</span> <span style=\"  color: blue;\">exit</span> code <span style=\"  color: rgb(136, 0, 0);\">0</span></td></tr><tr><td data-line-number=\"7\" style=\" padding-right: 14px; padding-left: 14px;     text-align: center; vertical-align: top; color: rgb(191, 191, 191); \"><div data-line-number=\"7\"></div></td><td data-line-number=\"7\"> </td></tr></tbody></table></code></pre>\n        <p style=\"margin-top: 10px;  color: black; \">\n            成功！</p>\n        <h2 id=\"叁总结\" style=\"margin-top: 10px; margin-right: 0px; margin-left: 0px;  font-size: 21px; font-weight: bold; line-height: 1.5; color: black; \">\n            叁、总结</h2>\n        <p style=\"margin-top: 10px;  color: black; \">\n            这个方式实现比较简单，但是复杂度应该是挺高的，后面可以尝试优化一下。</p>\n        <h2 id=\"肆参考文档\" style=\"margin-top: 10px; margin-right: 0px; margin-left: 0px;  font-size: 21px; font-weight: bold; line-height: 1.5; color: black; \">\n            肆、参考文档</h2>\n        <p style=\"margin-top: 10px;  color: black; \">\n            <a href=\"https://c.runoob.com/front-end/854/\" target=\"_blank\" rel=\"noopener\" style=\"  outline: none; color: black; text-decoration-line: underline;\">菜鸟正则表达式工具</a><br><a href=\"http://www.gaodaima.com/190989.html\" target=\"_blank\" rel=\"noopener\" style=\"  outline: none; color: black; text-decoration-line: underline;\">问题：Java正则表达式匹配不到结果的解决</a>\n        </p>', 6, 2, 3, 1, 1677848850844, 0);
INSERT INTO `t_blog` VALUES (62, 1, 30, '秋天的雨', '<p style=\"text-indent:2em;\">\n秋天的雨，是一把钥匙。它带着清凉和温柔，轻轻地，轻轻地，趁你没留意，把秋天的大门打开了。</p>\n\n<p style=\"text-indent:2em;\">秋天的雨，有一盒五彩缤纷的颜料。你看，它把黄色给了银杏树，黄黄的叶子像一把把小扇子，扇哪扇哪，扇走了夏天的炎热。它把红色给了枫树，红红的枫叶像一枚枚邮票，飘哇飘哇，邮来了秋天的凉爽。金黄色是给田野的，看，田野像金色的海洋。橙红色是给果树的，橘子、柿子你挤我碰，争着要人们去摘呢！菊花仙子得到的颜色就更多了，紫红的、淡黄的、雪白的……美丽的菊花在秋雨里频频点头。</p>\n\n<p style=\"text-indent:2em;\">\n秋天的雨，藏着非常好闻的气味。梨香香的，菠萝甜甜的，还有苹果、橘子，好多好多香甜的气味，都躲在小雨滴里呢！小朋友的脚，常被那香味勾住。</p>\n\n<p style=\"text-indent:2em;\">\n秋天的雨，吹起了金色的小喇叭。它告诉大家，冬天快要来了。小喜鹊衔来树枝造房子，小松鼠找来松果当粮食，小青蛙在加紧挖洞，准备舒舒服服地睡大觉。松柏穿上厚厚的、油亮亮的衣裳，杨树、柳树的叶子飘到树妈妈脚下。它们都在准备过冬了。</p>\n\n<p style=\"text-indent:2em;\">\n秋天的雨，带给大地的是一曲丰收的歌，带给小朋友的是一首欢乐的歌。</p>', 3, 3, 2, 1, 1677856980143, 0);
INSERT INTO `t_blog` VALUES (66, 1, 35, '染琪不绣花', '<p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“丞相府小姐也太刁蛮任性了吧，听说她前几天趁萧将军洗澡，顺走了将军的腰带。将军追去她还不给。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“天呐，真的吗？这也太不矜持了吧。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">两位官家小姐走过，窃窃私语道。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 染琪坐在树上晃着腿，我不是，我没有，别瞎说。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">她真的只是爱慕萧景淮已久，所以看着别的姑娘都绣个花给心上人，所以她就……但怎么也不能把衣服拿走不是，所以她就顺个腰带了。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 至于，人家要的时候为什么不给。陈染琪摸摸鼻子，别问我，我什么也不知道。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">眼看着要日上三竿了，染琪从树上跳下来，拍拍裙摆上的灰，这个时辰萧景淮该练完兵了，她要去给他带饭吃。 顺手打包了西南阁的饭菜，就蹦哒的朝练兵场跑，从门口进去时还有士兵和她打招呼：“陈小姐又来找将军了。” “是哒是哒”，染琪一阵风的跑过去。奔向萧景淮。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“……景淮哥哥”，萧景淮老远就看着一道倩影奔来，想躲开，只见陈染琪鼓足劲一头装进他怀里。他倒是没事，染琪就捂着头喊疼。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">男人深深的皱起眉头，“你到底要干嘛啊”。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">染琪放下揉脑袋的手：“我来给你送吃的。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“不必了，我还要忙”萧景淮推开了她：“自己吃好就行”，就急匆匆朝远处走去。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “哎，你怎么又走了？”染琪站在原地，每次都这样。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">看着手中的食盒，染琪愤愤的拎着它回到丞相府，愤愤的吃完了全部，腮帮子一鼓一鼓的。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">染琪的表姐站在桌边：“就你这个样子，谁敢要你。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">染琪嘎嘣一声咬住筷子，愤愤的撇了撇那个女人。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">到了晚上，染琪躺在床上，滚来滚去想着萧景淮冷漠的样子，没办法那个面瘫总能气死她。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">她转头看了眼床头被她添上了歪歪扭扭针脚的腰带，悄悄把它藏在了枕头下面。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">又暗暗给自己打气，明天再来。就不信搞不定他。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 果然第二天，染琪就起了个大早。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">穿了件超好看的流仙裙，又打算去找萧景淮。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">出府门前，表姐打趣到：“哟，阿染穿这么好看去爬树吗？” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“你才去爬树，你全家都去爬树。”染琪哼了一声，急匆匆的超门外跑去。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">今天，她要早点去练兵场等他，就不信他能忙一天。果然等她到的时候，练兵场的人还很少很少，染琪溜了进去，找了棵树拎起裙摆别在腰上，就爬了上去。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 萧景淮骑着马从门口进来时，迎着朝阳，一身月牙白的衣服衬得他特别好看。染琪咽了咽口水。跳下树，跟着他偷偷进了营账。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 躲在帘子后面，看着萧景淮换衣服。“我也太不矜持了吧？”染琪想了想，很快否决了自己的想法。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “哦吼吼，这身材也太好了吧，我的天啊。”陈染琪没忍住叫出了声。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 萧景淮已经黑着脸来到了她面前，黑眸盯着她也不说话。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “早上好！”染琪笑着开口。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “你究竟想干什么？”低沉磁性的声音字耳边传来。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “我不干什么阿，我就来看看你。”</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “看别人换衣服吗？”萧景淮脸色很不好。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “我......” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">陈染琪被扔出了营帐。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “这也太欺负人了，怎么可以乱扔人呢？”陈染琪嘟着嘴。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> “还老问我干什么，我能干什么啊。喜欢你看不出来吗？猪头！”染琪从地上起来，拍了拍屁股。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“你给我等着！”就风风火火的离开了。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">营帐内，一对漆黑的眸子悄悄看了她好久，男人抿着唇不知道在想什么。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">染琪哭着跑去了公主府，抱着沅芷腿嚎啕大哭：“你说他怎么这么欺负人啊，我都那么不顾我女孩子的矜持了，为什么阿啊啊啊。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">沅芷也是心疼她，手摸了摸她的头。“要不我直接向父皇请旨，要他娶了你。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“不要”，染琪摇头：“那样不是真爱，我不要。”</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“那你怎么办啊，”沅芷又心疼的摸了摸她的头：“不如，你就矜持一点，说不定他喜欢这样的！” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">“嗯嗯”，染琪吸了吸鼻子“那我尽量克制我自己。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">染琪回了丞相府，在房间里闷了一夜。第二天天亮时，她决定走矜持路线。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">所以，第一天她没有去练兵场。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">第二天，她没有去练兵场。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">第三天…… </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">某人好像开始坐不住了，萧景淮连着两天练兵时都心不在焉的超门口看去。又连着两天都没见人。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 某人以为她出了什么事，打听完才发现陈染琪什么事都没有，就是最近老喜欢去西南阁听书。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">萧景淮的脸变得比那天发现染琪偷看他换衣服时，还要黑。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">他想要找她要个说法。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 所以，去街上堵了染琪。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 小姑娘被按在墙上，一脸不知所措。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 萧景淮低低的开口：“你究竟想要干什么？”</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 我....我最近不是挺乖的吗？他怎么又这么生气啊，我也没缠着他不是。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 萧景淮看着她不说话的样子，心口郁结。朝墙上打了一圈，又气呼呼的走了。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 染琪吸了吸鼻子，又跑去去公主府。一把抱住了沅芷的大腿：“我受不了，我受不了。我怎么做那个面瘫都不为所动，你还是让陛下下个旨吧。我不要他的心了，我只要他的人呐。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">沅芷摸了摸她的头：“乖啊，本公主这就去宫里。” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">沅芷去了宫里，陛下不是很愿意让自己年轻英俊的大将军娶个疯丫头，虽然那丫头的确挺可爱，招他喜欢。但是…… </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">沅芷抱着皇上的大腿，扯着嗓子哭：“父皇，阿染她好可怜啊，你就帮帮她吧，她好可怜好可怜啊……” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">陛下被吵得头疼，反正也不是什么大事，就挥手下了婚旨。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">若是萧景淮不愿意，他也不会怪罪他的。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">萧景淮接到婚旨时也是一愣，着实没想到。心里却是有一种说不清道不明的情绪。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">而陈染琪，简直是开心死了。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">婚礼很快举行，朝中百官一边在婚宴上祝福着，一边提萧景淮捏把汗，丞相家这位可是个小霸王。</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 洞房花烛夜，萧景淮掀开染琪的盖头。目光一眨不眨的看着眼前皓齿明眸的小姑娘。 </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">陈染琪十分机智的甜甜的叫了声：“夫君！” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">某人一愣，眉宇间松动了不少：“陈染琪，你究竟想干嘛！” </span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\">他又这么问了！染琪翻了个白眼，很快又狡黠的笑了笑，一把扑倒了萧景淮：“我呀，想做你的心上人。”</span></p><p><span style=\"color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; font-size: medium;\"> 这一回，某人没有皱眉，没有推开她，没有把她扔出去，某人只是耳尖泛了红：“我等你这句话好久了。”</span><br></p>', 11, 3, 5, 1, 1677859694622, 0);
INSERT INTO `t_blog` VALUES (67, 1, 41, '一场大雨足以让万物润泽', '\n				<h3 style=\"text-align: center; \" class=\"\">得胜令·四月一日喜雨</h3><p style=\"text-align: center; \">元·张养浩</p><p style=\"text-align: center; \">万象欲焦枯，一雨足沾濡。</p><p style=\"text-align: center; \">天地回生意，风云起壮图。</p><p style=\"text-align: center; \">农夫，舞破蓑衣绿；和余，欢喜的无是处。</p><p style=\"text-align: center; \"><br></p><p style=\"text-align: center; \"><br></p><p style=\"text-align: center; \"><br></p><h3 style=\"text-align: left;\" class=\"\">诗词赏析</h3><p style=\"text-align: left;\">&nbsp; &nbsp; &nbsp; &nbsp; 此曲为元代著名散曲家张养浩所作，描写了久旱雨后，天地间充满生机的情景。天降大雨，农民和张养浩自己都极为喜悦，也正是这一场大雨，使干枯的万物都得到了滋润。全曲情真意切，语言朴实无华，浑然天成，充分表现了张养浩的忧民爱民之心、与民同乐之情。</p>\n			', 2, 0, 0, 0, 1678034524812, 1678034559587);
INSERT INTO `t_blog` VALUES (68, 1, 41, '春日山景，美不胜收', '<h2 style=\"text-align: center; line-height: 1.6;\" class=\"\">春山夜月</h2><p style=\"text-align: center; \">唐·于良史</p><p style=\"text-align: center; line-height: 1.6;\">春山多胜事，赏玩夜忘归。</p><p style=\"text-align: center; \">掬水月在手，弄花香满衣。</p><p style=\"text-align: center; \">兴来无远近，欲去惜芳菲。</p><p style=\"text-align: center; \">南望鸣钟处，楼台深翠微。</p><p style=\"text-align: center; \"><br></p><h3 style=\"text-align: left;\" class=\"\">诗词赏析</h3><p style=\"text-align: left;\">&nbsp; &nbsp; &nbsp; &nbsp; 这首诗是唐代诗人于良史所作，诗中描写了春夜山中景色，以及赏月的乐趣。春日山中有许多美好的事物，而诗人自己更是沉醉在这美景之中，甚至忘了归去。全诗风格清新淡雅，描绘的事物极富神韵，既写景又写人，既写照又传神，真是神来之笔。</p>', 1, 0, 0, 0, 1678034906305, 0);
INSERT INTO `t_blog` VALUES (69, 1, 39, '让雷锋精神在志愿服务中璀璨绽放', '<h2 style=\"margin-top: 0px; margin-bottom: 0px; padding: 0.13333rem; outline: 0px; font-size: 0.53333rem; max-width: 100%; letter-spacing: 0.544px; text-indent: 0em; text-align: center; color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; visibility: visible; overflow-wrap: break-word !important;\" class=\"\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(255, 76, 65); visibility: visible; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; visibility: visible; overflow-wrap: break-word !important;\">让雷锋精神在志愿服务中璀璨绽放</span></strong></span></h2><h1 data-v-2c7b875f=\"\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0.13333rem; outline: 0px; font-size: 0.53333rem; max-width: 100%; letter-spacing: 0.544px; text-indent: 0em; text-align: center; color: rgb(0, 0, 0); font-family: ‘Times New Roman‘; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 14px; visibility: visible; overflow-wrap: break-word !important;\">共青团湖南省委</span><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(255, 76, 65); font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; font-size: 16px; text-align: justify; text-indent: 0em; visibility: visible; overflow-wrap: break-word !important;\"></strong></h1><section style=\"margin: 0px 0px 24px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; text-indent: 0em; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 14px; visibility: visible; overflow-wrap: break-word !important;\"></span></section><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; visibility: visible; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; visibility: visible; overflow-wrap: break-word !important;\">　　今年是毛泽东等老一辈革命家为雷锋同志题词60周年，也是中国青年志愿者行动诞生30周年。湖南是雷锋家乡，60年来，雷锋精神历久弥新，成为湖湘青年的精神标杆。习近平总书记近日在关于深入开展学雷锋活动的重要指示中强调，“加强志愿服务保障和支持，不断发展壮大学雷锋志愿服务队伍，让学雷锋在人民群众特别是青少年中蔚然成风”。志愿精神与雷锋精神高度契合，志愿服务实践与学雷锋活动高度融合。近年来，湖南共青团学习贯彻习近平总书记关于弘扬雷锋精神的重要论述和重要指示精神，探索构建“四链融合”“四位一体”的湖南青少年志愿服务模式，持续擦亮“雷锋家乡学雷锋”品牌，推动学雷锋志愿服务在三湘大地蔚然成风，让雷锋精神在志愿服务中璀璨绽放。</span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">　</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\">　<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">志愿精神是雷锋精神的衍生与传承</strong></span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">　　深刻把握雷锋精神的时代内涵，要深刻理解志愿精神与雷锋精神的内在逻辑关系。雷锋精神的核心是“信念的能量、大爱的胸怀、忘我的精神、进取的锐气”，随着时代的发展而不断被赋予新的内涵。1993年，共青团中央在“向雷锋同志学习”的基础上，启动中国青年志愿者行动，形成了“奉献、友爱、互助、进步”的志愿精神。志愿精神是雷锋精神的重要组成部分，志愿精神是雷锋精神的衍生与传承，他们是一脉相承的。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">其一，奉献是一种信念的能量。</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">雷锋精神的核心是为了党和人民的事业而无私奉献、忘我奋斗，这是“奉献”志愿精神要素的基础。新时代青年志愿者要为中国式现代化持续奋斗，奉献青春力量。</span><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\">其二，友爱是一种大爱的情怀。</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">“我要把有限的生命，投入到无限的为人民服务之中去。”雷锋精神强调胸怀大爱，将“小我”融入“大我”的境界和行动。新时代青年志愿者要传承这大爱情怀，自觉将个人的前途命运与国家、民族的前途命运紧密联系在一起。</span><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\">其三，互助是一种社会行动。</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">雷锋精神不是停留在口头上，而是体现在具体的日常行动之中。新时代青年志愿者要传承互助精神，做群众身边的“雷锋”，解决群众“急难愁盼”问题，营造互助的社会氛围。</span><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\">其四，进步是一种锐意进取。</span></strong><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">雷锋曾说过：“我们靠什么战胜困难呢？主要就是要把一切有利的因素充分调动起来，用以克服不利的因素。”雷锋精神能够激发进取的锐气，增强中国人的志气、骨气、底气。新时代青年志愿者要传承追求进步的精神，拒绝“佛系”“躺平”“摆烂”，踔厉奋发，开拓创新。</span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 169, 0); overflow-wrap: break-word !important;\">　　</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">雷锋精神引领青年志愿者成长发展</strong></span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">　　学雷锋志愿服务活动是共青团为党育人的有效载体。近年来，湖南共青团积极响应党的号召，深入开展“百万青少年学雷锋志愿服务实践育人行动”，把学雷锋志愿服务活动作为引领凝聚青年的有效抓手，把雷锋精神转化为青年志愿者参与志愿服务的强大动力和生动实践。青年是学雷锋的先锋力量，也是志愿服务发展的先行力量。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">一是青年在学雷锋志愿服务中淬炼思想道德</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">。雷锋同志是一位忠于党、忠于人民的好战士。广大青年要向雷锋同志学习，在志愿服务中“边实践、边学习、边提高”，时刻与党和国家同频共振，坚定不移听党话、跟党走，做有理想、敢担当、能吃苦、肯奋斗的新时代好青年。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">二是青年在学雷锋志愿服务中发挥先锋作用。</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">雷锋在学习和工作中一直坚持高标准、严要求，始终昂扬着“进取的锐气”，发挥示范带头作用。广大青年要向雷锋同志学习，在志愿服务中走在前列，充当先锋。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">三是青年在学雷锋志愿服务中强化精神动力。</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">在雷锋身上，我们看到了精神的力量。广大青年要深刻把握学雷锋志愿服务“坚守崇高理想、秉持人民情怀、践行奉献精神、投身民族复兴”的精神内涵和实践要求，以积极的精神状态投身火热的社会主义现代化建设中。</span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">　</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 169, 0); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">　</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">推动学雷锋志愿服务制度化常态化长效化</strong></span></p><p style=\"margin: 0.42667rem 8px 24px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 0.46667rem; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">　　新时代新征程，湖南共青团将深入学习贯彻习近平总书记关于弘扬雷锋精神的重要论述和重要指示精神，把学雷锋活动作为新时代面向青少年开展思想政治引领的宝贵资源，把学雷锋活动与团、队教育有机融合，与青年志愿服务活动有机结合，推动学雷锋志愿服务制度化常态化长效化。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">一是建章立制，推动学雷锋志愿服务制度化。</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">共青团要将学雷锋志愿服务纳入青年志愿服务制度和工作体系，充分发挥共青团和少先队的组织优势，将学雷锋志愿服务活动与主题团课、队课结合起来，融入团、队教育之中。建立健全学雷锋志愿服务供需对接、激励回馈、数据归集等制度机制，加强学雷锋志愿服务规范化、标准化建设。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">二是打造品牌，推动学雷锋志愿服务常态化。</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">将共青团品牌工作与学雷锋志愿服务有机融合，聚焦主责主业，在乡村振兴、社会治理、应急救援抢险等领域不断开发打造“青字号”学雷锋志愿服务项目，让广大青少年通过常态化项目自觉践行雷锋精神，用实际行动彰显雷锋精神的时代价值。</span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; color: rgb(255, 76, 65); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">三是融入日常，推动学雷锋志愿服务长效化</strong></span><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">。“学雷锋”不是一句口号，学雷锋活动不能“三月里来四月走”，要让学雷锋活动融入日常、化作经常。要把学雷锋志愿服务活动融入党政中心工作、融入共青团品牌工作、融入社会主义核心价值观的践行、融入公民道德建设工程、融入青少年的日常生活。</span></p>', 1, 0, 0, 0, 1678035517750, 0);
INSERT INTO `t_blog` VALUES (70, 1, 39, '“其实真遇上了，是不会想那么多的……”', '<p><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; text-align: justify; line-height: 2; letter-spacing: 1px; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; color: rgb(178, 65, 65); margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">雷锋，一个伴随着一代代人成长的名字，他的故事人们耳熟能详。即便不在特殊日期，我们也会把做好事的行为称作“学雷锋”。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">当下，雷锋精神已经贯穿于普通人日常生活的始终。</strong><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">人们或许不会一年365天都提到雷锋、想到雷锋，但在不知不觉中，雷锋精神依然被人们持续践行着。</strong>正如习近平总书记在近日作出的重要指示中特别强调的那样：“雷锋精神，人人可学；奉献爱心，处处可为。”</span></p></section><h2 class=\"\" style=\"margin-bottom: 0px; text-indent: 0em; text-align: center; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><font color=\"#000000\" face=\"Arial Black\"><b>壹</b></font></h2><h2 class=\"\" style=\"margin-bottom: 0px; text-indent: 0em; text-align: center; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><strong style=\"font-family: Optima-Regular, PingFangTC-light; text-indent: 0em; color: rgb(178, 65, 65); font-size: 18px; letter-spacing: 0.544px; margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">“其实真遇上了，不会想那么多”</strong></h2><p powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; color: rgb(34, 34, 34); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; font-size: 16px; letter-spacing: 0.544px; overflow-wrap: break-word !important;\"><br></p><section powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; color: rgb(178, 65, 65); margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">那是一年深秋夜，送完女朋友的我一路疾驰，奔向城市另一头的家，刚一下快速路，就看到冷清的马路中间伏着一个人影。大脑空白了差不多两秒钟，然后是“减速、靠边、停车”。下车后锁好车门，我装着很社会的样子走过去。走近一看明白了，一个中年醉汉坐在冰冷的地上，自行车倒着，车筐里的布兜子、车链锁、饭盒、钥匙撒了一地，像是住在郊外的务工人员。我问你还站的起来吗？他说可以。于是我先把自行车扶好，把地上零零碎碎的东西拾起来放进车筐，最后回身把他驾了起来。<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">他撑着车子摇摇晃晃，看着我说了一句“这年头还有这种好人啊”，我说“有的是”。</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">转过年来，初春时分，又一次晚上回家路上，我刚拐进另一条小道，迎面突然闪出一位老哥站在前方伸手拦我的车。幸好当时转弯车速不快，我一脚刹车停住。老哥说话磕磕巴巴，往后一指我才注意到，前面地上坐了一个人，原来又有人喝醉酒瘫在地上，电动车也倒在一边。老哥说自己刚在河边跟一群老姐们儿跳完舞，回家路上看见这人，这条小道路灯不亮，怕有车进来撞上他。老哥拦我是因为手机没电了，没法报警，于是让我打110。很快警察赶到，看了看人没事，围着我的车转了一圈，又问了我们仨情况，知道跟我没关系就让我先走了。</span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><br></p></section><section powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; line-height: 2; overflow-wrap: break-word !important;\"><p style=\"color: rgb(178, 65, 65); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">第三次是在下班后，单位门外的小路平时车也挺多，偏偏那天在尽头的路口处，我骑车经过时没什么人。路中间有一台轮椅，地上倒着一位老人。我把车放在人行道上，走上去询问情况。大爷说自己只是滑了下来，没有受伤，让我扶他起来。当时没经验，想也没想就从身后伸手穿过大爷腋下，想用双臂直接把他驾起来。没成想大爷身子那么沉，我个子也不高，驾到与我同高时大爷腿上没劲站不起来，也动不了，我只好咬牙撑着让大爷倚在我身上，可是再怎么使劲也上不去了，只好这么僵持着。我感觉最多再有一分钟，我跟大爷都得躺下，万幸此时路过一对情侣，男孩膀大腰圆，过来一把就把大爷扶到轮椅上了。我回头一看，女孩正举着手机录像。</span></p><p style=\"color: rgb(178, 65, 65); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"color: rgb(178, 65, 65); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">遇到这些事前，我曾经认真想过，自己遇上了扶还是不扶，结论是有人能帮我作证的话，就上去扶。<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">其实真遇上了不会想那么多，完全是本能反应，我这样的人应该挺多的。</strong></span></p><p style=\"color: rgb(178, 65, 65); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 0em; overflow-wrap: break-word !important;\"><br></p><h2 style=\"text-align: center; margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 0em; overflow-wrap: break-word !important;\" class=\"\"><span style=\"font-family: ‘Arial Black‘;\"><b style=\"\"><font color=\"#000000\">贰</font></b></span></h2><p style=\"color: rgb(178, 65, 65); margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 0em; overflow-wrap: break-word !important;\"><br></p></section><section powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; color: rgb(178, 65, 65); margin: 0px; padding: 0px; outline: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: center; font-size: 18px; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">“姑娘啊，可算找到你了！”</strong></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br></strong></p></section><section powered-by=\"xiumi.us\" style=\"font-family: Optima-Regular, PingFangTC-light; color: rgb(34, 34, 34); margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: 0.544px; text-align: center; line-height: 0; overflow-wrap: break-word !important;\"><br></section></section></p><p><section powered-by=\"xiumi.us\" style=\"margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; font-family: Optima-Regular, PingFangTC-light; text-align: justify; line-height: 2; letter-spacing: 1px; overflow-wrap: break-word !important;\"><section powered-by=\"xiumi.us\" style=\"color: rgb(178, 65, 65); margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">我的第一份实习是在离学校很远的工业园区，每天上下班最快乐的事就是下了公交车有一个馄饨铺子，不想吃食堂或者来不及吃早饭的时候给老板娘发条微信就能打包带走，当然也有烦恼——下班回宿舍的路上要经过一段灯光昏暗的巷子，秋天的时候还好，我身后有满天的晚霞照着，入冬以后明显觉得天黑得早了，每每走到路口都会觉得心跳加速，脚步也不由得加快，一条几十米的巷子好像被延长到几百米。<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">城市初雪那天，大家都沉浸在白雪皑皑的兴奋里，我却在担心没带伞，今天晚上怎么回去。走出大楼，黑漆漆的脚印穿插在还没有完全化开的雪里，我想快点坐车回去，又担心我会冷不丁地摔上一跤。<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">果然是怕什么来什么，小巷子我才走过一半，就沉沉地摔了一跤，我怀里抱着电脑，手在雪里冻得通红，掏出手机想打个电话，手机在关键时刻关机了，在儿时觉得无比浪漫的雪天，我第一次感受到无助，委屈和疼痛一起袭来，我没忍住开始大哭。一边抹眼泪一边撑着墙往外走，好在雪地映得眼前还算亮堂，除了冻得慌我也没有其他感觉。<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">几十米的小巷子我走得好慢好慢，快到拐弯的地方我心头又开始泛酸，<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">毕业的压力，工作的任务，路途的遥远，微薄的薪水，走夜路的恐惧，还有忘记给老板娘发消息打包的委屈，一股脑涌了上来。</strong><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">“姑娘啊，可算找到你了！”<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">一抬头，是馄饨店的老板娘，她打着伞朝我跑过来，“姑娘啊，早上来店里的时候看你没带伞，想着你今天咋还没下班呢，末班车都没有啦，过来找找你。”</strong><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">我的眼泪再也忍不住，或许是因为平常多聊了几句家常，结账的时候多说了几句谢谢，上下班这段时间养成了打招呼的习惯……<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">现在每到下雪天，我都会想起那天，她撑着伞出现在那里，让我在异乡收到来自陌生人的暖意。</span><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p></section><section powered-by=\"xiumi.us\" style=\"color: rgb(34, 34, 34); margin: 10px 0px 0px; padding: 0px; outline: 0px; max-width: 100%; font-size: 16px; letter-spacing: 0.544px; text-align: left; line-height: 0; overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; vertical-align: middle; display: inline-block; line-height: 0; width: 473.891px; height: auto; overflow-wrap: break-word !important;\"></section></section><section powered-by=\"xiumi.us\" style=\"color: rgb(178, 65, 65); margin: 0px; padding: 0px 20px; outline: 0px; max-width: 100%; line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; font-family: ‘Helvetica Neue‘, Helvetica, ‘Hiragino Sans GB‘,  Arial, sans-serif; overflow-wrap: break-word !important;\">今年是毛泽东等老一辈革命家为雷锋同志题词60周年。雷锋精神源于雷锋本人，但“雷锋”不仅是历史书中的一个人名，更是一种品质、一种行动的代名词。<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">如今，人们虽然不常把“雷锋”挂在嘴边，但在日常生活中总能看见雷锋精神的传承。你，我，每个人都可以成为他。</strong></span></p></section></section></p>', 4, 2, 0, 1, 1678071253908, 0);
INSERT INTO `t_blog` VALUES (71, 1, 36, '关于春天的16个成语，如诗如画', '<p></p><p></p><p></p><p></p><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; visibility: visible; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); visibility: visible; overflow-wrap: break-word \"><strong style=\"visibility: visible; overflow-wrap: break-word \">春风得意</strong></span></section></section></section><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; visibility: visible; overflow-wrap: break-word \"><span style=\" font-size: 16px; visibility: visible; overflow-wrap: break-word \"><strong style=\"visibility: visible; overflow-wrap: break-word \">出处：</strong>唐·孟郊《登科后》：“春风得意马蹄疾，一日看尽长安花。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; visibility: visible; overflow-wrap: break-word \"><br style=\"visibility: visible; overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; visibility: visible; overflow-wrap: break-word \"><span style=\" font-size: 16px; visibility: visible; overflow-wrap: break-word \"><strong style=\"visibility: visible; overflow-wrap: break-word \">释义：</strong>和暖的春风很适合人的心意，后形容人处境顺利，做事如意，事业有成。</span></section><section style=\"margin: 0px 8px;line-height: 2em; visibility: visible; overflow-wrap: break-word \"><br style=\"visibility: visible; overflow-wrap: break-word \"></section><section style=\"visibility: visible; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; visibility: visible; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">枯木逢春</strong></span></section></section></section><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋·释道原《景德传灯录·卷二十三·唐州大乘山和尚》：“问‘枯树逢春时如何？’师曰：‘世间希有。’”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>枯干的树遇到了春天，又恢复了活力。比喻垂危的病人或事物重新获得生机。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春满人间</strong></span></section></section></section><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•曾巩《班春亭》：“山亭尝自绝浮埃，山路辉光五马来。春满人间不知主，谁言炉冶此中开？”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>指生机勃勃的春意充满人间。</span></section></section></section></section></section><p></p><section style=\"color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春和景明</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•范仲淹《岳阳楼记》:“至若春和景明，波澜不惊，上下天光，一碧万顷。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>春光和煦，风景鲜明艳丽。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春风风人</strong></span></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>汉·刘向《说苑·贵德》：“管仲上车曰：‘嗟兹乎，我穷必矣！吾不能以春风风人，吾不能以夏雨雨人，吾穷必矣。’”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>和煦的春风吹拂着人们，比喻及时给人以良好的教育和帮助。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春晖寸草</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>唐•孟郊《游子吟》：“慈母手中线，游子身上衣。临行密密缝，意恐迟迟归。谁言寸草心，报得三春晖。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>寸草，指小草；春晖，指春天的阳光，象征父母的慈爱。比喻儿女难以报答父母的恩惠。</span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><br></span></section></section></section></span></section></section></section></section></section><p></p><section style=\"color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春冰虎尾</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>《尚书•君牙》:“心之忧危，若蹈虎尾，涉于春冰。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>意思为踩着老虎尾巴，走在春天将解冻的冰上，比喻处境非常危险。</span></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">日和风暖</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•范纯仁《鹧鸪天•和韩持国》：“腊后春前暖律催，日和风暖欲开梅。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>风很平静，阳光暖人。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">莺歌燕舞</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•苏轼《锦被亭》词：“烟红露绿晓风香，燕舞莺啼春日长。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>黄莺在歌唱，燕子在飞舞，形容春天鸟儿喧闹活跃的样子。现在常用来比喻蓬勃兴旺的景象。</span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><br></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><section style=\"color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">绿肥红瘦</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•李清照《如梦令》词：“知否知否，应是绿肥红瘦。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>绿叶茂盛，花渐凋谢，指暮春时节，也形容春残的景象。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;letter-spacing: 1.5px; text-align: center; font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, Arial, sans-serif; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; letter-spacing: normal; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"color: rgb(123, 12, 0); font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, , PingFang SC Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word \"><strong style=\"color: rgb(61, 167, 66);  overflow-wrap: break-word \">春色撩人</strong></strong></span></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•陆游《剑南诗稿•山园杂咏五首》：“桃花烂漫杏花稀，春色撩人不忍为。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>春天的景色引起人们的兴致。撩，撩拔，挑逗、招惹。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">草长莺飞</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>南朝梁•丘迟《与陈伯之书》：“暮春三月，江南草长，杂花生树，羣莺乱飞。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>江南暮春时节景象，形容生机勃勃、万物复苏的景象。后来多用“草长莺飞”形容春天的美好的景色。</span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><br></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><section style=\"color: rgb(34, 34, 34); font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春树暮云</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>唐•杜甫《春日忆李白》诗：“渭北春天树，江东日暮云。何时一樽酒，重与细论文？”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>表示对远方友人的思念。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">春深似海</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>清•文康《儿女英雄传》第三十回：“这屋里那块四乐堂的匾，可算挂定了！不然，这春深似海的屋子，也就难免欲深似海。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>春天的美景似大海般深广。形容大地呈现出春光明媚，鸟语花香的情景。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">惠风和畅</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>晋•王羲之《兰亭集序》：“是日也，天朗气清，惠风和畅。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong>是指柔和的风，使人感到温暖、舒适。</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section data-css=\"border-color: initial;border-style: none;border-width: initial;margin: 5px auto;width: 80%\" style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;text-align: center; line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; color: rgb(61, 167, 66); overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">傍花随柳</strong></span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section></section></section><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">出处：</strong>宋•程灏《春日偶成》：“云淡风轻近午天，傍花随柳过前川。”</span></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><br style=\"overflow-wrap: break-word \"></section><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><strong style=\"overflow-wrap: break-word \">释义：</strong><span style=\"letter-spacing: 1px; overflow-wrap: break-word \">用来形容春游的快乐。</span></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"></section></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><span style=\"letter-spacing: 1px; overflow-wrap: break-word \"><br></span></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px 0px 24px;color: rgb(34, 34, 34);  overflow-wrap: break-word \"><section style=\"visibility: visible; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><section data-role=\"outer\" style=\"font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><section style=\"overflow-wrap: break-word \"><section style=\"margin: 0px 8px;line-height: 2em; overflow-wrap: break-word \"><span style=\" font-size: 16px; overflow-wrap: break-word \"><span style=\"letter-spacing: 1px; overflow-wrap: break-word \"><pre style=\"margin-bottom: 0px;background-color: rgb(255, 255, 255); font-size: 16px; color: rgb(62, 62, 62); letter-spacing: 0.5px; text-align: center; widows: 1; caret-color: rgb(62, 62, 62); text-size-adjust: inherit;\"><section style=\"margin: 8px 8px 0em;  color: rgb(34, 34, 34); letter-spacing: 0.544px; text-indent: 0em; white-space: normal; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); font-family: -apple-system, BlinkMacSystemFont, , PingFang SC Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; caret-color: rgba(0, 0, 0, 0); cursor: text; line-height: 1.75em; max-width: 100%; max-inline-size: 100%; outline: none 0px  overflow-wrap: break-word \"><img class=\"rich_pages wxw-img\" data-ratio=\"0.46808510638297873\" data-type=\"png\" data-w=\"47\" data-index=\"7\" src=\"data:image/png;base64,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\" _width=\"47px\" crossorigin=\"anonymous\" alt=\"图片\" data-fail=\"0\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border-style: none; letter-spacing: 0.544px; display: initial; overflow-wrap: break-word  height: auto  visibility: visible  width: 47px \" data-src=\"https://mmbiz.qpic.cn/mmbiz_png/SzK1NthS8ib782Fru8DM3SSV1BicL4cJFWSXibgIXAh7DxIwYgTicrvr5an7wFNVOxPH16XouhFU26UUKklWQ5W4OA/640?wx_fmt=png&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\"></section><section powered-by=\"xiumi.us\" style=\"color: rgb(34, 34, 34); letter-spacing: 0.544px; white-space: normal; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); font-family: -apple-system, BlinkMacSystemFont, , PingFang SC Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; caret-color: rgba(0, 0, 0, 0); transform-origin: center center; overflow-wrap: break-word \"><p style=\"margin: 8px 16px 0px;clear: both; min-height: 1em; -webkit-tap-highlight-color: rgba(0, 0, 0, 0); line-height: 1.75em; text-indent: 0em; overflow-wrap: break-word \"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); letter-spacing: 2px; font-size: 15px; overflow-wrap: break-word \">END<span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); color: rgb(83, 59, 60); text-align: justify; overflow-wrap: break-word \">&nbsp;</span></span></p></section></pre></span></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></span></section></section></section></section></section><p></p><p></p><p></p>', 1, 1, 0, 0, 1678072301255, 0);
INSERT INTO `t_blog` VALUES (72, 1, 36, '充实自我的6个习惯', '<section style=\"margin: auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, \"helvetica=\"\"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; visibility: visible; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); visibility: visible; overflow-wrap: break-word \"><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); visibility: visible; overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; visibility: visible; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; visibility: visible; overflow-wrap: break-word \"></p><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; visibility: visible; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  visibility: visible; overflow-wrap: break-word \">作息规律</strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">规律的作息方式不仅有利于身体健康，还能影响一个人的生活状态。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">有句话说得好：睡前放下一切，醒来便是新生。无论白天有多劳累，只要晚上及时休息，保持充足的睡眠，精神就能得到恢复。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">第二天醒来拉开窗帘，让自己沐浴在清晨的阳光里，世界就又是全新而美好的样子。然后带着这份愉悦的心情去工作，自然也会更高效，更得心应手。</span></section></section></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 16px; overflow-wrap: break-word \"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px -8px 0px 0px;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; height: auto; flex: 0 0 0%; align-self: flex-start; border-width: 0px; line-height: 0; z-index: 2; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  transform: rotateZ(39deg); overflow-wrap: break-word \"><section style=\"margin: -7px 0px 0px;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 16px; height: 16px; vertical-align: top; overflow: hidden; border-width: 2px; border-radius: 125px; border-style: solid; border-color: rgb(255, 215, 106) rgba(255, 255, 255, 0) rgb(255, 215, 106) rgb(255, 215, 106); background-color: rgba(255, 255, 255, 0); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); overflow-wrap: break-word \"><section style=\"margin: 4px 0px 0px;  outline: 0px;  transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 125px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(255, 255, 255); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \">开放心态<br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">经常有人把故步自封的状态和年龄挂钩，觉得是自己到了一定年龄，接受新事物的能力才开始变差。但实际上，真正的衰老，是从你丧失对新事物的好奇心开始的。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; text-indent: 2em; overflow-wrap: break-word \">要想让日子过得丰富，就应该保持积极开放的心态，多接触新生事物。</span><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; text-indent: 2em; overflow-wrap: break-word \">不要总是怀有偏见，更不要盲目抗拒，因为很多时候，你拒绝的可能不是一件事，而是通往新生活的一扇门。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; text-indent: 2em; overflow-wrap: break-word \">打开眼界，才能改变认知。</span><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; text-indent: 2em; overflow-wrap: break-word \">世界其实很精彩，就看你愿不愿走出来。</span></section></section></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 16px; overflow-wrap: break-word \"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px -8px 0px 0px;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; height: auto; flex: 0 0 0%; align-self: flex-start; border-width: 0px; line-height: 0; z-index: 2; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  transform: rotateZ(39deg); overflow-wrap: break-word \"><section style=\"margin: -7px 0px 0px;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 16px; height: 16px; vertical-align: top; overflow: hidden; border-width: 2px; border-radius: 125px; border-style: solid; border-color: rgb(255, 215, 106) rgba(255, 255, 255, 0) rgb(255, 215, 106) rgb(255, 215, 106); background-color: rgba(255, 255, 255, 0); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); overflow-wrap: break-word \"><section style=\"margin: 4px 0px 0px;  outline: 0px;  transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 125px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(255, 255, 255); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \">找到热爱</strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">人生最好的状态，莫过于有事做、有人爱、有所期待。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">很多人之所以能越活越优秀，都因心中葆有热爱之事，让他们可以全身心地投入工作，并从中找到自我的意义和价值所在。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">心有热爱，眼中自有光芒。去找到你所热爱的事，并为之全力以赴，才能活成自己喜欢的样子。</span></section></section></section></section></section></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 16px; overflow-wrap: break-word \"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px -8px 0px 0px;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; height: auto; flex: 0 0 0%; align-self: flex-start; border-width: 0px; line-height: 0; z-index: 2; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  transform: rotateZ(39deg); overflow-wrap: break-word \"><section style=\"margin: -7px 0px 0px;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 16px; height: 16px; vertical-align: top; overflow: hidden; border-width: 2px; border-radius: 125px; border-style: solid; border-color: rgb(255, 215, 106) rgba(255, 255, 255, 0) rgb(255, 215, 106) rgb(255, 215, 106); background-color: rgba(255, 255, 255, 0); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); overflow-wrap: break-word \"><section style=\"margin: 4px 0px 0px;  outline: 0px;  transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 125px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(255, 255, 255); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \">不断学习</strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">学习对一个人的重要性，不只在于习得新知识，更在于它能帮助我们保持深度思考，从中不断修正对世界的认知、对自我的了解，继而获得真正的成长。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">学习从来不是一件一劳永逸的事情，它应该是人生任何阶段都不可或缺的一种能力。唯有不断学习，才能与时俱进。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">无知者，以为学有涯；有知者，明白学无境。让不断学习成为一种习惯，你所收获的将会是应对生活最大的底气和智慧。</span></section></section></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"></span><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 16px; overflow-wrap: break-word \"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px -8px 0px 0px;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; height: auto; flex: 0 0 0%; align-self: flex-start; border-width: 0px; line-height: 0; z-index: 2; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  transform: rotateZ(39deg); overflow-wrap: break-word \"><section style=\"margin: -7px 0px 0px;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 16px; height: 16px; vertical-align: top; overflow: hidden; border-width: 2px; border-radius: 125px; border-style: solid; border-color: rgb(255, 215, 106) rgba(255, 255, 255, 0) rgb(255, 215, 106) rgb(255, 215, 106); background-color: rgba(255, 255, 255, 0); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); overflow-wrap: break-word \"><section style=\"margin: 4px 0px 0px;  outline: 0px;  transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 125px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(255, 255, 255); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \">发掘兴趣</strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">经常听到有人感慨，业余时间不想浪费，却又不知道可以做点什么。其实，兴趣并不是一开始就摆在那里的。恰恰相反，它需要你一步步去探索，才能在众多的选择中，逐渐培养出对某件事的喜好。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">所以，迈出第一步至关重要。不必给自己设定太高的目标。你可以学一门乐器、练一项手艺，也可去集集邮、插插花。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">当你学会享受兴趣带来的快乐，让性情在兴趣中得到陶冶和升华，生活自会变得与众不同、充满滋味。</span></section></section></section></section></section></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"margin: 0px auto;  outline: 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 0.544px; text-align: justify; font-size: 16px; overflow-wrap: break-word \"><section style=\"margin: 40px 0px 10px;  outline: 0px;  text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 677px; vertical-align: top; background-color: rgba(187, 212, 155, 0.15); align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: -18px 0px 0px;  outline: 0px;  display: flex; flex-flow: row nowrap; justify-content: flex-start; transform: translate3d(16px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px -8px 0px 0px;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; height: auto; flex: 0 0 0%; align-self: flex-start; border-width: 0px; line-height: 0; z-index: 2; overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  transform: rotateZ(39deg); overflow-wrap: break-word \"><section style=\"margin: -7px 0px 0px;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 16px; height: 16px; vertical-align: top; overflow: hidden; border-width: 2px; border-radius: 125px; border-style: solid; border-color: rgb(255, 215, 106) rgba(255, 255, 255, 0) rgb(255, 215, 106) rgb(255, 215, 106); background-color: rgba(255, 255, 255, 0); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; vertical-align: top; width: auto; background-color: rgb(187, 212, 155); align-self: flex-start; line-height: 0; min-width: 10%; flex: 0 0 auto; height: auto; border-width: 0px; border-style: none; border-color: rgb(62, 62, 62); overflow-wrap: break-word \"><section style=\"margin: 4px 0px 0px;  outline: 0px;  transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto;  outline: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 125px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(255, 255, 255); overflow-wrap: break-word \"><div style=\"text-align: center;\"></div><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: -7px 0px 2px;  outline: 0px;  text-align: center; transform: translate3d(4px, 0px, 0px); overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 18px; outline: 0px;  font-size: 20px; color: rgb(255, 255, 255); line-height: 1.6; text-align: justify; overflow-wrap: break-word \"><p style=\"text-align: left; margin-bottom: 0px;  outline: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><strong style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \">&nbsp;学会感恩</strong></p></section></section></section></section><section style=\"margin: 20px auto;  outline: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px auto; padding: 0px 27px; outline: 0px;  text-align: justify; overflow-wrap: break-word \"><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">幸福随处可见，只等着有心之人去感受。每晚等你回家的那盏灯，刚晾晒过的满是阳光气息的被单，窗台上终于盛开的那朵花，都是幸福。<br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">再忙都别忘了好好生活。做好手上的每一件小事，学会关心和理解身边的每一个人，用心欣赏路边的每一道风景，把这些组合起来，其实就是你离幸福最近的距离。</span></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px auto;  outline: 0px;  overflow-wrap: break-word \"></section><section style=\"text-align: left; margin: 0px auto;  outline: 0px;  text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px auto;  outline: 0px;  font-size: 18px; overflow-wrap: break-word \">愿接下来每一天，我们都能把日子过得越来越有滋味，成为更好的自己。</span></section></section></section></section></section></section>', 2, 1, 0, 0, 1678072801293, 0);
INSERT INTO `t_blog` VALUES (73, 1, 36, '一个人去医院是十级孤独吗？', '<p></p><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">网上有个流行的说法，孤独有十级，第十级是一个人做手术。在外打拼的你有没有体验过，一个人去医院治疗骨折？</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br></p><h3 style=\"text-align: center; margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \" class=\"\">01</h3><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br></p></section></section><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section></section></section><section style=\"margin: -60px 0px -12px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: 162.469px; align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: 352.031px; align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: 162.469px; align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  text-align: right; line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 73.5156px; height: auto; overflow-wrap: break-word \"></section></section></section></section><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 10px 0px 0px;  justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 341.578px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  height: auto; transform: perspective(0px); transform-style: flat; overflow-wrap: break-word \"><section style=\"margin: 0px;  justify-content: center; display: flex; flex-flow: row nowrap; transform: rotateX(180deg); overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg><br></section></section></section></section></section></section></section></section></section><p></p><p></p><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"text-align: center; margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><span style=\"text-indent: 2em; text-align: justify;\">几天前，我唱着歌下楼准备去上班，脑子里想着点什么好吃的外卖，当手正准备插进衣兜拿出手机的时候，“叭嚓”我一个黛玉葬花整个人侧身扑倒在五层人家的门口，随之而来的是一阵脚踝的剧痛。</span><br></p></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">“完了”，我心里想着，想挣扎着爬起来，却一动不能动。五分钟后，我站在没有电梯的五层楼梯口深思，“我该怎么下去？”</p></section></section><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br></p></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">想到医保卡和一票证件前一天都留在了办公室，我咬牙一步步跳下去，打车，再一步步蹦上同样没有电梯的四层办公室。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">曾经崴脚的经历告诉我，第一天很痛，三五天就好了。抱着侥幸心理，我处理了些当天的工作才蹦跶着去了医院。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">急诊，外科，年轻的大夫忙碌着，身边每一位患者都看起来比我病情严重，我靠着拐角墙壁等待叫号、拍X光片、缴费、拿药，握着“未见明确骨折移位征象”的报告单和三天假条蹦跶回家休假。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">然而，事情没这么简单。</p></section></section><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br></p><h3 style=\"text-align: center; margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \" class=\"\">02</h3></section><section style=\"margin: 0px 0px -3px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 569.297px; height: auto; overflow-wrap: break-word \"></section></section></section></section><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: justify; transform: perspective(0px); transform-style: flat; overflow-wrap: break-word \"><section style=\"margin: 10px 0px;  text-align: center; transform: rotateY(180deg); line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word \"></section></section></section><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 0px;  text-align: left; line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 569.297px; height: auto; border-style: none; border-width: 2px; border-radius: 20px; border-color: rgb(230, 235, 176); overflow: hidden; overflow-wrap: break-word \"><br></section></section></section></section><section style=\"margin: -60px 0px -12px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: 162.469px; align-self: flex-start; flex: 0 0 auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  text-align: right; line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 73.5156px; height: auto; overflow-wrap: break-word \"></section></section></section></section><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 10px 0px 0px;  justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 341.578px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  height: auto; transform: perspective(0px); transform-style: flat; overflow-wrap: break-word \"><section style=\"margin: 0px;  justify-content: center; display: flex; flex-flow: row nowrap; transform: rotateX(180deg); overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \">肿胀和淤青持续不断，脚迟迟无法着地，网络问诊上“韧带断裂”“崴脚之后不能动”“崴脚之后不能不动”的混乱信息加剧着我的焦虑，眼看着药就快吃完用尽，我决定再去医院门诊进行复诊。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \">不同于第一家医院离家近在咫尺，朋友老张推荐的鼎鼎有名的骨科医院在十二公里开外，他驱车带我复诊，过程还算轻松，可到了医院，困难模式开启。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px;  text-indent: 2em; overflow-wrap: break-word \">诺大的医院，和我一样需求的患者不计其数，一时间没有空闲的轮椅租赁，我拄着双拐从门诊一区蹦到门诊二区，从门诊二区上二层蹦到最里间的骨科诊室，老张提前把号交到分诊台，刚蹦出电梯我就听见“87号姜美玉到骨科37诊室就诊”的音响急促的呼唤，双拐蹦开始加速……</span><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section></section><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section><section style=\"margin: 10px 0px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; border-radius: 20px; overflow: hidden; overflow-wrap: break-word \"></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \">“十天了还这么多血？可能不止韧带伤”，大夫看看我的脚、看看X光片，“拍个CT吧，普通光片看不出来”。模式再次切换——地狱模式。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \">我从门诊二层到一层急诊再到CT室，实在蹦不动了，胸腔因为全身用力和来自双拐的压力而疼痛不已，老张也终于成功租来了共享轮椅。拍照结束。因为工作的特殊性，老张不得不赶去上班，留下我一个人，完成后面的就诊。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: justify; text-indent: 2em; overflow-wrap: break-word \"><br></p><h3 style=\"text-align: center; margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \" class=\"\"><b>03</b></h3></section></section><section style=\"margin: 0px 0px -3px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 569.297px; height: auto; overflow-wrap: break-word \"><br></section></section></section></section><section style=\"margin: 0px;  color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; display: flex; flex-flow: row nowrap; text-align: center; justify-content: center; overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; display: inline-block; width: 609.297px; vertical-align: top; flex: 0 0 auto; height: auto; align-self: flex-start; border-width: 0px; border-radius: 20px; border-style: none; border-color: rgb(253, 182, 153); overflow: hidden; overflow-wrap: break-word \"><section style=\"margin: 10px 0px 0px;  justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 341.578px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  height: auto; transform: perspective(0px); transform-style: flat; overflow-wrap: break-word \"><section style=\"margin: 0px;  justify-content: center; display: flex; flex-flow: row nowrap; transform: rotateX(180deg); overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto; overflow-wrap: break-word \"><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px;  display: inline-block; width: 8px; height: 8px; vertical-align: top; overflow: hidden; border-width: 0px; border-radius: 285px; border-style: none; border-color: rgb(62, 62, 62); background-color: rgb(230, 235, 176); overflow-wrap: break-word \"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">“肯定没问题”，习惯性的坚强，我安慰老张不要担心，我自己也能推着轮椅走。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">乒乓球届公认顶级难度叫中国队模式，那么现在的我，就开启了独自就诊的“中国队模式”，但在这其中，发生了我意想不到的感动。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section></section><section style=\"margin: 10px 0px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word \"></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">前轮故障的轮椅，让我的操作异常困难，距离影像打印机十米的路程，任凭双臂用力滚动转轮，轮椅仍打滑着向一侧倾斜，怎么都过不去。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">这时一股力量推动轮椅走了起来，耳后传来温柔的女声“你要去哪儿啊？我推你”，回头一看是位长发的姐姐，“我看你一个人挺困难的”，她说。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">我赶忙抬手指向打印机，在陪我打印之后，她又推我到电梯等待。她是陪老人就诊的，她的父亲患上了脑梗，在看到丈夫扶着老人从诊室出来后，她对我说了声抱歉，便赶去搀扶父亲，把我交给了一旁的安保小哥哥。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">我只能不断地说着“谢谢”与她道别。诺大的医院，安保小哥带我从急诊区到了门诊二区的二层诊室，期间，他胸口的手台一直响着，呼唤他去6层执勤。仍然只能是简单的道谢，他赶去自己的工作岗位，我也接到了脚踝骨骨折的确诊报告，拿着单子独自缴费、找分诊台约医生、去换药室取绷带、去诊室打石膏。</p></section></section><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p></section><section style=\"margin: 10px 0px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word \"></section></section><section style=\"margin: 0px;  overflow-wrap: break-word \"><section style=\"margin: 0px; padding: 0px 20px; font-size: 14px; text-align: justify; line-height: 2; color: rgb(62, 62, 62); letter-spacing: 1px; overflow-wrap: break-word \"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><strong style=\"margin: 0px;  overflow-wrap: break-word \">一路上，一双、两双、三双……陌生人的手在我难走的拐角、诊室的门前帮我推上一把，</strong>或是扶好轮椅帮我起身，换药室的护士大喊着“姜美玉的家属”后看到我自己弱弱举手回应，帮我取来绷带，打石膏的年轻医生一边打石膏一边陪我聊天“怎么一个人来的？一会儿怎么回家？”我们开着一个人在外工作如何如何困难的玩笑，聊着工作忙没空谈恋爱的无奈。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">然后，固定好了脚的我在轮椅上又开始了一双又一双手的接力，有年轻的情侣、读高中的男孩、黑色风衣的中年男人、带着老人来看病的阿姨，还有一位陪着我取药、还共享轮椅的白发医生，我不断地说着感谢，也只能说声感谢，心里默默祝福他们和他们的家人早日康复，身体健康。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \">平时总觉得，依靠网络就能工作、生活，小小的工作圈就是全部，恰恰忘了与圈子外的陌生人接触，忘了我是生活在人群之中。</p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><strong style=\"margin: 0px;  overflow-wrap: break-word \">在这一天里，当我遭遇困境，是陌生人，用善意轻抚我的伤口，那一份份雷锋般的帮助和保护，带我体会人与人之间的温情。</strong><span style=\"margin: 0px;  text-indent: 2em; overflow-wrap: break-word \">回家的出租车上，司机大叔一路嘱咐我要吃好的、多补补，临走扶我下车，他大声地对我说“给你点赞！”</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px;  text-indent: 2em; overflow-wrap: break-word \"><br style=\"margin: 0px;  overflow-wrap: break-word \"></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word \"><span style=\"margin: 0px;  text-indent: 2em; overflow-wrap: break-word \">夕阳下，老张下班从单位赶来我家，背我上楼，我对他讲着这一天发生的事，他用力地把背上的我往上抬了一下，说<strong style=\"margin: 0px;  overflow-wrap: break-word \">“还是好人多啊”。</strong></span></p></section></section><section style=\"margin: 0px 0px -3px;  line-height: 0; overflow-wrap: break-word \"><section style=\"margin: 0px;  vertical-align: middle; display: inline-block; line-height: 0; width: 569.297px; height: auto; overflow-wrap: break-word \"></section></section></section></section><p></p>', 0, 0, 0, 0, 1678073459119, 0);
INSERT INTO `t_blog` VALUES (74, 1, 36, '为了脱单，我报了一个恋爱班', '<p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\">三十出头的晓雯被父母催着谈恋爱结婚，她一直不肯，因为她亲眼见证了闺蜜从热恋、结婚到离婚，作为旁观者她觉得自己看透了婚恋，“谈恋爱有什么好的？”<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-indent: 2.2857em; text-align: justify; overflow-wrap: break-word !important;\">李博士是一名心理咨询师，工作中会接触到很多遇到感情问题的恋人和夫妻，他意识到<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(32, 113, 185); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">很多人对于亲密关系、对于婚恋，可能看到了理性的责任与承诺，但忽略了感性的情绪与个人感受，</strong></span>“我做婚姻咨询的时候，有人说，婚姻咨询难道不应该去咨询律师吗”。</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: center; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\">亲密关系，是需要经营的。他从专业的角度告诉我们，一段亲密关系，最开始建立的1-3个月是“蜜月期”，你会觉得我终于遇到了各方面都与我完全匹配的那个人；过了这个阶段，一些原本就存在的问题就会浮到水面之上，会有好多失望和破碎的时刻；但这并不是关系的终点，<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(32, 113, 185); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">如果两个人去调整，后面就会有慢慢回升的过程，而那将是一段更稳定、更有生命力的关系。</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: center; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\">我们在人生中，不仅学习如何与亲密关系的对方相处，还在学习如何与自己相处。</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; background-color: rgb(227, 242, 252); text-align: justify; text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">有一本关于亲密关系的书，作者基于自己丰富且真实的咨询经验写就。在他看来，恋爱是一个筛选伴侣、并不断提升和认识自己的过程，<strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(32, 113, 185); overflow-wrap: break-word !important;\">“谈一场恋爱最大的好处是认识自己”。</span></strong><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">作者认为，让你反省自我的那个人正是你的恋人。“你会去反思是什么让你心酸，让你念念不忘，让你如鲠在喉。他（她）满足了你哪些人性的弱点？虚荣？不安？贪恋？自卑？寂寞？孤独？”<br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">美好的爱情会让你成长，你会少一点虚荣、少一点不安、少一点孤独和寂寞，即使那份爱情已如风消逝。</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">无论怎么避免“踩坑”，你最终还是有可能结束一段感情，因为恋爱就是一个相互筛选的过程。恋爱是亲密关系博弈的开始，这中间会经历两个人快乐甜蜜的激情期、权利斗争的独立期，以及平淡且猜疑的共生期。如果两个人可以继续在时间的长河中走下去，那么他们会多次体验这种轮回，然后一直走下去。其间争吵必不可少，生活的磨难、观念的冲突也会不断出现。</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">即使是这样，恋爱的快乐值得拥有，长久的亲密关系也值得经营。有些快乐是短暂的，即时反馈的；有些快乐是在漫长的岁月中最后才能感受到的。人生既需要短暂的快乐，也需要稳定的、高质量的陪伴。</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">每个人都是一本书，走进并读懂一个人的世界是不容易的。你读书的时候，那本书也在试图阅读你。至于结局，也许在翻开书页的那一瞬间就写好了。所以，<span style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; color: rgb(32, 113, 185); overflow-wrap: break-word !important;\"><strong style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\">不必太在乎结局的悲喜，阅读和书写的过程是美丽的。</strong></span></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">谈恋爱是否让你发现了不一样的自己？你有哪些维护亲密关系的秘诀？</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); overflow-wrap: break-word !important;\"><br style=\"margin: 0px; padding: 0px; outline: 0px; max-width: 100%; overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\">欢迎评论区分享～</p><p style=\"margin-bottom: 0px; padding: 0px; outline: 0px; max-width: 100%; clear: both; min-height: 1em; color: rgb(114, 113, 113); font-family: system-ui, -apple-system, BlinkMacSystemFont, ‘Helvetica Neue‘, ‘PingFang SC‘, ‘Hiragino Sans GB‘, ‘Microsoft YaHei UI‘,  Arial, sans-serif; letter-spacing: 2px; text-align: justify; background-color: rgb(227, 242, 252); text-indent: 2.2857em; overflow-wrap: break-word !important;\"><br></p>', 1, 0, 0, 0, 1678073677397, 0);
INSERT INTO `t_blog` VALUES (75, 1, 36, '要知道那是最后一次见面，就穿好看点了', '<section style=\"margin: 0px auto;   color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; justify-content: flex-start; display: flex; flex-flow: row nowrap; visibility: visible; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 0px 15px;  display: inline-block; width: 677px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; visibility: visible; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">最近，一位博主发布了这样一个话题#我青春里的一段小遗憾#。在1万余条的评论中，我看到了不同人心中有关遗憾的独家记忆。那么在你的青春记忆里，最难忘的遗憾是什么呢？</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 50px; height: 50px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll;  overflow-wrap: break-word ;\"><section style=\"margin: 10px 0px 0px;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   font-size: 18px; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">01</strong></span></p></section></section></section></section><section style=\"margin: 0px 0px 10px;   text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 0px 12px;  display: inline-block; width: auto; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(254, 244, 217); border-radius: 100px; overflow: hidden; min-width: 5%; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">青春里的常客</strong></span></p></section></section></section><section style=\"margin: 0px auto;   text-align: justify; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 15px;  display: inline-block; width: 647px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; border-style: solid; border-width: 1px; border-color: rgb(230, 173, 127); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">是青涩时光里一封没有递出的“情书”。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">是与好友吵架时一句未说出口的“对不起”。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">还是在离别时，没有好好说“再见。”</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">......</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">“没有拥抱过喜欢的人，半夜醒来想到这件事，都会默默叹气。”</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">“和曾经的好朋友从相约陪伴一生到如今形同陌路越走越远，我总是感慨这一切太可惜。但我也很庆幸后来遇到了志同道合的新朋友，自己也更加珍惜这段友谊。时间教会了我们很多东西，那样就不算很遗憾了吧。”</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word ;\"></section></section><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">“真的要说遗憾，应该是在爷爷以前每次问我有没有吃饱，要不要再盛点儿的时候，没有再加两筷子炸酱面。（爷爷因病截肢，没办法再给我做炸酱面了）。”</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">搜寻尘封已久的回忆录，总会有很多刻骨铭心的经历令我们久难忘怀。</span><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">在我们饰演的人生剧情里，似乎只有拥有过青春伤痛的片段，才能成就一个完美的结尾。</span></strong></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">遗憾，是青春里的常客。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 0px auto;   display: flex; flex-flow: row nowrap; text-align: justify; justify-content: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; vertical-align: top; width: auto; flex: 100 100 0%; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 10px 0px;   text-align: center; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   vertical-align: middle; display: inline-block; line-height: 0; width: 297.5px; height: auto; overflow-wrap: break-word ;\"></section></section></section><section style=\"margin: 0px 0px 0px 20px;   display: inline-block; vertical-align: middle; width: auto; flex: 100 100 0%; align-self: center; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 10px 0px;   text-align: center; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   vertical-align: middle; display: inline-block; line-height: 0; width: 297.5px; height: auto; overflow-wrap: break-word ;\"></section></section><section style=\"margin: -15px 0px 0px;   text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap; transform: translate3d(-30px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; vertical-align: middle; width: auto; min-width: 10%; flex: 0 0 auto; height: auto; line-height: 0; align-self: center; overflow-wrap: break-word ;\"><section style=\"margin: -20px -19px;  outline: 0px; transform: rotateZ(328deg) scale(0.6); transform-origin: center center; max-width: unset ; overflow-wrap: break-word ;\"><section style=\"margin: 14px 0px 11px;   text-align: center; justify-content: center; transform: translate3d(5px, 0px, 0px); display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: auto; vertical-align: top; min-width: 10%; flex: 0 0 auto; height: auto; line-height: 0; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 51px; height: 47px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 3px; border-radius: 100%; border-color: rgb(226, 164, 114) rgba(255, 255, 255, 0) rgb(226, 164, 114) rgb(226, 164, 114); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: 0px auto;   transform: rotateZ(348deg); overflow-wrap: break-word ;\"><section style=\"margin: -37px 0px 0px;   transform: translate3d(-12px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 71px; height: 42px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 3px; border-radius: 100%; border-color: rgb(226, 164, 114) rgb(226, 164, 114) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px 0px 0px -20px;   display: inline-block; vertical-align: middle; width: auto; min-width: 10%; flex: 0 0 auto; height: auto; align-self: center; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section><section style=\"margin: 0px auto;   display: inline-block; vertical-align: top; width: auto; flex: 0 0 0%; height: auto; line-height: 0; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   transform: rotateZ(145deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: right; justify-content: flex-end; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 10px; vertical-align: top; border-bottom: 2px solid rgb(226, 164, 114); border-bottom-right-radius: 0px; flex: 0 0 auto; height: auto; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   transform: rotateZ(24deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px 0px 8px;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   background-color: rgb(226, 164, 114); height: 2px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section></section></section></section></section></section><section style=\"margin: 0px auto;   text-align: justify; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 50px; height: 50px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll;overflow-wrap: break-word ;\"><section style=\"margin: 10px 0px 0px;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   font-size: 18px; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">02</strong></span></p></section></section></section></section><section style=\"margin: 0px 0px 10px;   text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 0px 12px;  display: inline-block; width: auto; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(254, 244, 217); border-radius: 100px; overflow: hidden; min-width: 5%; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">面对遗憾，尽力就好</strong></span></p></section></section></section><section style=\"margin: 0px auto;   text-align: justify; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   justify-content: flex-start; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 15px;  display: inline-block; width: 647px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; border-style: solid; border-width: 1px; border-color: rgb(230, 173, 127); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">人生不如意事常八九，而每个人面对遗憾的态度也大抵不同。有些人可能仍然将日记停留在遗憾的那一页；有些人选择将遗憾珍视为成长过程中不可或缺的一环，继续踏浪前行。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">而我的好友小风，在面对遗憾这件事上，经历过不同态度的转变。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">谈起她的遗憾，她说：“我曾以为遗憾难以释怀，但最终，我拼尽全力，为不完美的保研路画上了完美的句号。”</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">在身边人看来，小风是带着名校光环的研究生学霸，但是她也曾跌落低谷。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">保研结果出来的那天，很多人在朋友圈分享了自己上岸“梦校”的喜讯，评论区里清一色的祝福与喝彩。和他们相比，保研失败的她像被全世界遗忘了。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">那时沉浸在悲伤的情绪无法自拔的她，觉得自己像一张被现实揉皱的纸，就算被展开也是皱皱巴巴的。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word ;\"></section></section><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">选择的道路已无法走通，余下的只有迷茫。那时，对于“梦校”的执念转变为小风脸上难以止住的泪水，肿胀的喉咙和通红的双眼。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">保研机会已经失之交臂，小风的心底像打了一个死结。她将自己置入“真空”状态，一遍遍询问自己：是否真的要陷入这个无解的死环，无法保研的遗憾，是否真的无法释怀。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">终于，她决定转身走向另一条道路——备战考研，尽力弥补与“梦校”错过的遗憾，在考研这条孤单的路上，她从没有忘记过曾经的失败，她渐渐把遗憾视作动力，一步步前进。</span></p></section><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">她在看似不起波澜的日复一日里与自己的不甘对抗，在图书馆学到闭馆，在楼道里不断背书。销声匿迹的日子里，她在为考研冲刺，一刻也不曾懈怠。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">从不被注意的保研“边缘人”到一战成名考到自己“梦校”的学霸，她的逆转出乎所有人的意料，现在的她谈起那段遗憾，只是宛然一笑，心中更多的是释然。</span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\">当别人了解到她这段特殊的经历并为之感叹时，她总是淡淡地说一句<strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">“</strong><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">面对遗憾，尽力就好。”</strong></span></p><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   vertical-align: middle; display: inline-block; line-height: 0; overflow-wrap: break-word ;\"></section></section><section style=\"margin: 0px auto;   text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 0px auto;   text-align: justify; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 0px auto;   display: flex; flex-flow: row nowrap; text-align: justify; justify-content: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; vertical-align: middle; width: auto; flex: 100 100 0%; height: auto; align-self: center; overflow-wrap: break-word ;\"><section style=\"margin: -15px 0px 0px;   text-align: right; justify-content: flex-end; display: flex; flex-flow: row nowrap; transform: translate3d(30px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; vertical-align: middle; width: auto; min-width: 10%; flex: 0 0 auto; height: auto; line-height: 0; align-self: center; overflow-wrap: break-word ;\"><section style=\"margin: -20px -19px;  outline: 0px; transform: rotateZ(328deg) scale(0.6); transform-origin: center center; max-width: unset ; overflow-wrap: break-word ;\"><section style=\"margin: 14px 0px 11px;   text-align: center; justify-content: center; transform: translate3d(5px, 0px, 0px); display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: auto; vertical-align: top; min-width: 10%; flex: 0 0 auto; height: auto; line-height: 0; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 51px; height: 47px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 3px; border-radius: 100%; border-color: rgb(226, 164, 114) rgba(255, 255, 255, 0) rgb(226, 164, 114) rgb(226, 164, 114); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section><section style=\"margin: 0px auto;   transform: rotateZ(348deg); overflow-wrap: break-word ;\"><section style=\"margin: -37px 0px 0px;   transform: translate3d(-12px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 71px; height: 42px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 3px; border-radius: 100%; border-color: rgb(226, 164, 114) rgb(226, 164, 114) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px 0px 0px -20px;   display: inline-block; vertical-align: middle; width: auto; min-width: 10%; flex: 0 0 auto; height: auto; align-self: center; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section><section style=\"margin: 0px auto;   display: inline-block; vertical-align: top; width: auto; flex: 0 0 0%; height: auto; line-height: 0; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   transform: rotateZ(145deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   justify-content: flex-end; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 10px; vertical-align: top; border-bottom: 2px solid rgb(226, 164, 114); border-bottom-right-radius: 0px; flex: 0 0 auto; height: auto; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   transform: rotateZ(24deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px 0px 8px;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   background-color: rgb(226, 164, 114); height: 2px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section></section></section><section style=\"margin: 0px 0px 0px 20px;   display: inline-block; vertical-align: top; width: auto; flex: 100 100 0%; align-self: stretch; height: auto; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin: 0px auto;   text-align: justify; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><br style=\"margin: 0px auto;   overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   text-align: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   display: inline-block; width: 50px; height: 50px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll; overflow-wrap: break-word ;\"><section style=\"margin: 10px 0px 0px;   overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   font-size: 18px; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">03</strong></span></p></section></section></section></section><section style=\"margin: 0px 0px 10px;   text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto; padding: 0px 12px;  display: inline-block; width: auto; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(254, 244, 217); border-radius: 100px; overflow: hidden; min-width: 5%; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px auto;   text-align: justify; color: rgb(226, 164, 114); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;   clear: both; min-height: 1em; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   color: rgb(122, 68, 66); overflow-wrap: break-word ;\"><strong style=\"margin: 0px auto;   overflow-wrap: break-word ;\">直面遗憾，勇敢前进</strong></span></p></section></section></section></section></section><p><section style=\"margin: 0px auto;   color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: justify; transform: perspective(0px); transform-style: flat; overflow-wrap: break-word ;\"></section></p><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(34, 34, 34);  font-size: 16px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: 0.544px; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; text-align: left; justify-content: flex-start; display: flex; flex-flow: row nowrap;\"><section style=\"margin: 0px auto; padding: 0px 15px;  box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; width: 677px; vertical-align: top; align-self: flex-start; flex: 0 0 auto;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: justify;\"><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   box-sizing: border-box ; overflow-wrap: break-word ; justify-content: flex-start; display: flex; flex-flow: row nowrap;\"><section style=\"margin: 0px auto; padding: 15px;  box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; width: 647px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; border-style: solid; border-width: 1px; border-color: rgb(230, 173, 127);\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2;\"><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\">回顾自身，我也曾因许多事而遗憾。遗憾没有志得意满的青春；遗憾搁浅而未实现的计划；遗憾在多姿多彩的时光里走了许多弯路……可惜时光就这样稍纵即逝。</span></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\">书中写到：“人生这条路很长，未来星辰大海般璀璨，不必踌躇于过去的半亩方塘，那些所谓的遗憾，可能是一种成长。”</span></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: center; line-height: 0;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; vertical-align: middle; display: inline-block; line-height: 0;\"></section></section><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: justify; font-size: 14px; color: rgb(226, 164, 114); letter-spacing: 1px; line-height: 2;\"><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\">当我尝试将过去的遗憾、失意视为成长的必行之路时，那些记忆深处的悲伤、争吵、颓废......很多都化为突如其来的热血、大步向前的勇气、喜极而泣的欢乐。那些时光教会我一步步成长，成就了现在的自己。</span></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><strong style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\">那些难以忘怀的遗憾，曾让我们感到悲伤和痛苦。</span></strong></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><strong style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\">它是我们不易触碰的软肋，但也可以是我们成长路上最坚硬的盔甲。</span></strong><span style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; color: rgb(122, 68, 66);\"></span></p><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; text-indent: 2.1429em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p></section><section style=\"margin: 10px 0px 0px;   box-sizing: border-box ; overflow-wrap: break-word ; justify-content: flex-start; display: flex; flex-flow: row nowrap;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 100 100 0%; height: auto;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: center; line-height: 0;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; vertical-align: middle; display: inline-block; line-height: 0; border-width: 0px; border-style: none; border-color: rgb(247, 228, 200);\"></section></section></section><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; vertical-align: top; width: 184.5px; align-self: flex-start; flex: 0 0 auto; height: auto;\"><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; text-align: justify;\"><p style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; clear: both; min-height: 1em; white-space: normal;\"><br style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ;\"></p></section></section></section><section style=\"margin: -60px 0px 0px;   box-sizing: border-box ; overflow-wrap: break-word ; justify-content: flex-start; display: flex; flex-flow: row nowrap;\"><section style=\"margin: 0px 10px 0px 0px;   box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; vertical-align: bottom; width: auto; align-self: flex-end; flex: 60 60 0%; height: auto;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section><section style=\"margin: 0px auto;   box-sizing: border-box ; overflow-wrap: break-word ; display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 150 150 0%; height: auto;\"></section></section></section></section></section></section>', 3, 0, 0, 0, 1678074072614, 0);
INSERT INTO `t_blog` VALUES (76, 1, 36, '20岁全款拿下辣条，却要问妈妈可不可以', '<section style=\"margin: 0px 0px 50px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 20px;  display: inline-block; width: 90%; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; border-style: solid; border-width: 1px; border-color: rgb(122, 192, 113); overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 14px; line-height: 2; letter-spacing: 1px; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 30.0006px; overflow-wrap: break-word ;\">生</span>活中，你是否遇到过这样的情况：</span><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">明明心中有答案，却还是想要问别人意见。</span></p></section></section></section><section style=\"margin: 0px 0px 20px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 0px 25px;  display: inline-block; width: auto; vertical-align: middle; align-self: center; flex: 0 0 auto; min-width: 5%; height: auto; border-style: solid; border-width: 2px; border-radius: 60px; border-color: rgb(172, 217, 162); overflow: hidden; overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 20px; color: rgb(122, 192, 113); letter-spacing: 2px; line-height: 1.8; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; overflow-wrap: break-word ;\"><strong style=\"margin: 0px;overflow-wrap: break-word ;\"><em style=\"margin: 0px;overflow-wrap: break-word ;\">01</em></strong></p></section></section></section><section style=\"margin: 10px 0px 30px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: auto; vertical-align: top; background-color: rgba(255, 186, 0, 0.07); min-width: 10%; flex: 0 0 auto; height: auto; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: -10px 0px -22px;display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 11px 0px 0px;display: inline-block; vertical-align: middle; width: auto; flex: 0 0 0%; align-self: center; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(314deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: flex; flex-flow: row nowrap; font-size: 0px; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px -8px 0px 0px;display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 0 0 0%; height: auto; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(77deg); overflow-wrap: break-word ;\"><section style=\"margin: 1px 0px 0px;overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;transform: translate3d(2px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 6px; height: 6px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50px 0px 50px 50px; border-color: rgb(245, 216, 189); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: top; width: auto; flex: 0 0 0%; align-self: flex-start; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(23deg); overflow-wrap: break-word ;\"><section style=\"margin: 12px 0px 0px;transform: translate3d(-1px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(-3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section><section style=\"margin: 0px 0px 50px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 20px;  display: inline-block; width: 90%; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(255, 241, 228); height: auto; border-style: solid; border-width: 1px; border-color: rgb(122, 192, 113); overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 14px; line-height: 2; letter-spacing: 1px; color: rgb(62, 62, 62); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">在大年初一给家里人做顿饭，是属于小文特有的仪式感，今年也不例外。早上10点，小文就把自己需要用到的材料准备完毕，打算给家人露一手。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">倒油、下锅、翻炒、盛出，每一道菜的制作都按小文记忆中的步骤不断进行着，但这份有序在小文母亲进入厨房后变了样子。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">“妈，我下一步应该放盐还是放糖。”</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">“妈，我应该可以放入土豆了吧。”</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">“妈，你帮我看看，是不是已经熟了。”</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">在母亲进来之后，小文好像乱了脚步，开始不断地询问下一步的操作方法。实际上，土豆牛腩这道菜，小文做过很多次，但看到母亲在身边，就是忍不住想要询问。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><strong style=\"margin: 0px;overflow-wrap: break-word ;\">从小到大，好像有父母在的场合，我们遇到问题的第一反应都是询问。</strong>例如小时候，买东西要问父母的意见、出去玩要征求父母的同意，有时候明明已经提前得到父母的应许，在面对的时候，还是下意识地问一句：可不可以。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">在大事小事需要问父母的环境下，我们开始依赖父母的回答。这使得长大后的我们，在面对问题时，会忍不住地想要从父母这里获得答案。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">但我们真的是因为不会才去询问的吗？</p></section></section></section><section style=\"margin: 0px 0px 20px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 0px 25px;  display: inline-block; width: auto; vertical-align: middle; align-self: center; flex: 0 0 auto; min-width: 5%; height: auto; border-style: solid; border-width: 2px; border-radius: 60px; border-color: rgb(172, 217, 162); overflow: hidden; overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 20px; color: rgb(122, 192, 113); letter-spacing: 2px; line-height: 1.8; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; overflow-wrap: break-word ;\"><strong style=\"margin: 0px;overflow-wrap: break-word ;\"><em style=\"margin: 0px;overflow-wrap: break-word ;\">02</em></strong></p></section></section></section><section style=\"margin: 10px 0px 30px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: auto; vertical-align: top; background-color: rgba(255, 186, 0, 0.07); min-width: 10%; flex: 0 0 auto; height: auto; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: -10px 0px -22px;display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 11px 0px 0px;display: inline-block; vertical-align: middle; width: auto; flex: 0 0 0%; align-self: center; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(314deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: flex; flex-flow: row nowrap; font-size: 0px; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px -8px 0px 0px;display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 0 0 0%; height: auto; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(77deg); overflow-wrap: break-word ;\"><section style=\"margin: 1px 0px 0px;overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;transform: translate3d(2px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 6px; height: 6px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50px 0px 50px 50px; border-color: rgb(245, 216, 189); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: top; width: auto; flex: 0 0 0%; align-self: flex-start; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(23deg); overflow-wrap: break-word ;\"><section style=\"margin: 12px 0px 0px;transform: translate3d(-1px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(-3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section><section style=\"margin: 0px 0px 50px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 20px;  display: inline-block; width: 90%; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(255, 241, 228); height: auto; border-style: solid; border-width: 1px; border-color: rgb(122, 192, 113); overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 14px; line-height: 2; letter-spacing: 1px; color: rgb(62, 62, 62); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">我也曾在“处处询问别人”的漩涡中挣扎过很长一段时间，习惯于对自己没有把握的事情听从别人的想法。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">例如，在集体项目中，我会因为队友都很厉害，而隐藏自己的想法，听从他们的指挥；在小组作业中，我会因为他们的优秀，按照他们所认为的“答题过程”回答问题。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">因为身边人都很优秀，我总会不自觉地赞同他们的想法，在自己产生不一样想法时，下意识地将他们的想法认定为“正确答案”。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">这导致后来的我在纠结问题时，习惯性地想要询问别人，即使我心里已经有了答案，我还是想听别人的想法。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">但人与人之间的选择不会完全一样，在我很多次问朋友沐沐怎么想时，我们的观点存在差异。这时的我就会开始动摇自己的想法，思考自己的答案是否错误。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">在多方纠结后，我还是选择自己的既定答案，这时候，朋友总会打趣“你都有答案了，干嘛不相信自己”。</span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">可即便如此，我依然会在纠结的时候询问她，依旧不确定自己的想法是不是所谓的“正确答案”。</span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">后来，在与一位长辈的聊天中，我找到了原因：<strong style=\"margin: 0px;overflow-wrap: break-word ;\">不是自己不行，是我觉得自己不对。</strong></span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">在那之后，我选择相信自己，听从自己的回答。虽然有时候，我还是需要别人的肯定，但我知道，我最后的选项是自己的回答。</span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></span></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><span style=\"margin: 0px;text-indent: 2.1429em; overflow-wrap: break-word ;\">以前的我总是在纠结“万一自己选的不对怎么办”，现在的我面对选择的第一想法是“不妨先试试”。之前和别人想法不一致导致的焦虑，好像被现在的坚定慢慢地替代了。</span><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p></section></section></section><section style=\"margin: 0px 0px 20px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 0px 25px;  display: inline-block; width: auto; vertical-align: middle; align-self: center; flex: 0 0 auto; min-width: 5%; height: auto; border-style: solid; border-width: 2px; border-radius: 60px; border-color: rgb(172, 217, 162); overflow: hidden; overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 20px; color: rgb(122, 192, 113); letter-spacing: 2px; line-height: 1.8; overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; overflow-wrap: break-word ;\"><strong style=\"margin: 0px;overflow-wrap: break-word ;\"><em style=\"margin: 0px;overflow-wrap: break-word ;\">03</em></strong></p></section></section></section><section style=\"margin: 10px 0px 30px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: auto; vertical-align: top; background-color: rgba(255, 186, 0, 0.07); min-width: 10%; flex: 0 0 auto; height: auto; align-self: flex-start; overflow-wrap: break-word ;\"><section style=\"margin: -10px 0px -22px;display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 11px 0px 0px;display: inline-block; vertical-align: middle; width: auto; flex: 0 0 0%; align-self: center; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(314deg); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: flex; flex-flow: row nowrap; font-size: 0px; justify-content: center; overflow-wrap: break-word ;\"><section style=\"margin: 0px -8px 0px 0px;display: inline-block; vertical-align: top; width: auto; align-self: flex-start; flex: 0 0 0%; height: auto; line-height: 0; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(77deg); overflow-wrap: break-word ;\"><section style=\"margin: 1px 0px 0px;overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;transform: translate3d(2px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 6px; height: 6px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50px 0px 50px 50px; border-color: rgb(245, 216, 189); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: top; width: auto; flex: 0 0 0%; align-self: flex-start; height: auto; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: rotateZ(23deg); overflow-wrap: break-word ;\"><section style=\"margin: 12px 0px 0px;transform: translate3d(-1px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;display: inline-block; width: 20px; height: 10px; vertical-align: top; overflow: hidden; border-style: solid; border-width: 1px; border-radius: 50%; border-color: rgb(245, 216, 189) rgba(255, 255, 255, 0) rgba(255, 255, 255, 0); overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section></section><section style=\"margin: 0px;display: inline-block; vertical-align: middle; width: auto; align-self: center; flex: 100 100 0%; overflow-wrap: break-word ;\"><section style=\"margin: 0px;transform: translate3d(-3px, 0px, 0px); overflow-wrap: break-word ;\"><section style=\"margin: 0px;background-color: rgb(245, 216, 189); height: 1px; overflow-wrap: break-word ;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section></section><section style=\"margin: 0px 0px 50px;color: rgb(34, 34, 34);  font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word ;\"><section style=\"margin: 0px; padding: 20px;  display: inline-block; width: 90%; vertical-align: top; align-self: flex-start; flex: 0 0 auto; background-color: rgb(255, 241, 228); height: auto; border-style: solid; border-width: 1px; border-color: rgb(122, 192, 113); overflow-wrap: break-word ;\"><section style=\"margin: 0px;text-align: justify; font-size: 14px; line-height: 2; letter-spacing: 1px; color: rgb(62, 62, 62); overflow-wrap: break-word ;\"><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">“你这道题选什么啊？”&nbsp;</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">“我应该考研还是直接工作？”</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">&nbsp;“感觉现在的工作不适合我，我要不要换工作？”</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">在生活中，我们面临选择时，会犹豫自己的选择是否正确，会害怕选择错误怎么办，所以会通过寻求身边人意见的方式来实现自我肯定。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">但在身边人给出不同意见后，我们会开始思考自己的想法是否正确。其实这些不同的声音，恰恰让我们知道自己的内心想法，帮助我们做出最优的选择。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\">当你纠结问题、怀疑自己判断时，也许你需要做的第一件事是相信自己。即使害怕自己的决定不会是“正确答案”，但请先勇敢的迈出第一步。</p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><strong style=\"margin: 0px;overflow-wrap: break-word ;\">只有勇敢地迈出第一步，才能在试错中知道自己的问题所在。也许会走错路，也许会碰壁，但在这之中，我们都会有收获。不要去后悔自己的选择，也不要因为别人的想法，放弃试错的机会。</strong></p><p style=\"margin-bottom: 0px;clear: both; min-height: 1em; text-indent: 2.1429em; overflow-wrap: break-word ;\"><br style=\"margin: 0px;overflow-wrap: break-word ;\"></p></section></section></section>', 2, 0, 0, 0, 1678074604771, 0);
INSERT INTO `t_blog` VALUES (77, 1, 36, '你觉得，怎么才算友尽？', '<section style=\"margin: 40px 0px 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 649.906px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; border-style: dashed; border-width: 2px; border-color: rgb(177, 217, 248); border-radius: 15px; overflow: hidden; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px 20px; outline: 0px;  text-align: justify; font-size: 14px; color: rgb(120, 154, 79); line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">提起友情，我们耳边不由自主便会想起熟悉的旋律——</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">“旧日朋友岂能相忘，友谊地久天长”</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">与悠扬的琴声一同浮现在脑海的，是一张又一张与自己挽手并肩、欢声笑语的面孔。在故事的开始，初次相识成为朋友的那一刻，“友谊地久天长”是彼此心照不宣的预想结局。但故事的结尾，留在回忆中的最后一幕，曾经那些对自己来说重要的身影却不知从何时起开始模糊。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p></section></section><section style=\"margin: 0px 0px 10px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; color: rgb(252, 196, 82); overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: right; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">&nbsp;</span></p></section></section></section></section><section style=\"margin: 45px 0px 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 649.906px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; border-style: dashed; border-width: 2px; border-color: rgb(250, 220, 113); border-radius: 15px; overflow: hidden; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: auto; vertical-align: top; flex: 0 0 auto; align-self: flex-start; min-width: 10%; height: auto; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 130px; height: 89px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll;  overflow-wrap: break-word !important;\"><section style=\"margin: 26px 0px 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  font-size: 22px; color: rgb(250, 164, 102); text-shadow: rgb(255, 255, 255) 0px 1px, rgb(255, 255, 255) 0px -1px, rgb(255, 255, 255) 1px 1px, rgb(255, 255, 255) 1px 0px, rgb(255, 255, 255) 1px -1px, rgb(255, 255, 255) -1px 1px, rgb(255, 255, 255) -1px 0px, rgb(255, 255, 255) -1px -1px, rgb(255, 169, 169) 0px 2px, rgb(255, 169, 169) 1px 2px, rgb(255, 169, 169) -1px 2px; letter-spacing: 4px; line-height: 1.8; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">01</strong></span></p></section></section></section></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  color: rgb(250, 164, 102); letter-spacing: 2px; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">“其实，我总会怀念和他们在一起的时候”</strong></span></p></section></section><section style=\"margin: -5px 0px;  transform: scale(0.2); transform-origin: center center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  background-color: rgb(120, 154, 79); height: 4px; overflow-wrap: break-word !important;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p></section></section><section style=\"margin: -20px 0px 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 220, 113); font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">——————</strong></span></p></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px 20px; outline: 0px;  text-align: justify; font-size: 14px; color: rgb(120, 154, 79); line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">每当想起儿时的朋友，浩宇的嘴角就会挂起笑容。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">“小时候我们家住在县城的胡同里，那时候胡同里有几个和我年龄相仿的小男孩，我们总凑在一起玩。”在没有互联网的年代，无论是谁买来的什么小玩意儿，都值得整条胡同的小朋友聚在一起围观。无论是一叠全新图案的卡通圆片儿，还是一包没尝过味道的干脆面，只要大家在一起，那就是“见者有份”。浩宇说，“刚到手的新鲜玩意儿还没捂热，大家抢着、笑着就瓜分完了。”</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">儿时的“一起玩”是纯粹且公平的，兴致淋漓的玩闹、不存差别的分享让这段友情中的每个角色都享受着参与的快乐。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">“现在呢？现在的你们也是这样吗？”在浩宇回答前，我期待着这样幸福的友情能够一直延续下去。“现在？嗐，早就没联系了。”他摆了摆手，接着故作轻松地向我讲述读小学之后的事情，“为了上学方便，大家都搬去离学校更近的地方了。后来我们家也搬到了市区的小学旁，我转到了一个人都不认识的学校重新认识新的朋友。”</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">纯真的友谊背后是青涩与稚嫩，青涩地与朝夕相处的玩伴告别却不知留下联系方式，稚嫩地期待未知的新世界却不懂究竟什么是分别。“其实，我经常会怀念和他们在一起的时候。”浩宇说。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">“和他们在一起时的快乐是真的很快乐。”</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p></section></section><section style=\"margin: 0px 0px 10px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; color: rgb(252, 196, 82); overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: right; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">&nbsp;</span></p></section></section></section></section><section style=\"margin: 45px 0px 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 649.906px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; border-style: dashed; border-width: 2px; border-color: rgb(177, 217, 248); border-radius: 15px; overflow: hidden; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: auto; vertical-align: top; flex: 0 0 auto; align-self: flex-start; min-width: 10%; height: auto; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 130px; height: 89px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll; overflow-wrap: break-word !important;\"><section style=\"margin: 26px 0px 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  font-size: 22px; color: rgb(250, 164, 102); text-shadow: rgb(255, 255, 255) 0px 1px, rgb(255, 255, 255) 0px -1px, rgb(255, 255, 255) 1px 1px, rgb(255, 255, 255) 1px 0px, rgb(255, 255, 255) 1px -1px, rgb(255, 255, 255) -1px 1px, rgb(255, 255, 255) -1px 0px, rgb(255, 255, 255) -1px -1px, rgb(255, 169, 169) 0px 2px, rgb(255, 169, 169) 1px 2px, rgb(255, 169, 169) -1px 2px; letter-spacing: 4px; line-height: 1.8; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">02</strong></span></p></section></section></section></section></section></section><section style=\"margin: -15px 0px 5px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; font-size: 17px; color: rgb(250, 164, 102); letter-spacing: 2px; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: center; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">“我和她的对话框永远停留在了一年前”</strong></span></p></section></section><section style=\"margin: -5px 0px;  transform: scale(0.2); transform-origin: center center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  background-color: rgb(120, 154, 79); height: 4px; overflow-wrap: break-word !important;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px 20px; outline: 0px;  text-align: justify; font-size: 14px; color: rgb(120, 154, 79); line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">问起曾经的朋友，依一总会意难平地提起自己以前的闺蜜。<strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">“有的友情就是不知不觉间消失的，无论以前有多亲密，最后两个人还是会无缘无故断了联系。”</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">校园里的女孩子总是三三两两地在一起，即使只是课间凑在一起说说话，也是每日难忘的快乐。依一和闺蜜在一起时也一样，争分夺秒地说话就是友情的最佳见证，课间她们在校园里挽着手说笑话，假期她们在对话框里疯狂刷屏。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">“我们关系一直很好的，可是后来突然就不说话了。”先是对话框里闺蜜没了音讯，后来课间走廊上也不再有她的身影。“也许是因为我变了，以前我和她一样，学习好。”依一认真地分析着，“但她也不是以成绩交友的人，也许是因为她和其他朋友玩得更好了。”</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">在依一眼里，<strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">“闺蜜”和“朋友”是两个不同量级，但这并不意味着闺蜜之间的友情必须具有排他性。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2.4286em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">当她意识到闺蜜只是选择了其他朋友后便不再执着，重新结识新的朋友。也许朋友之间就应该像依一这样，保持松弛的友谊边界。在友情结束的最后，对曾经亲密的朋友依然给予尊重。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p></section></section><section style=\"margin: 0px 0px 10px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; color: rgb(252, 196, 82); overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-align: right; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">&nbsp;</span></p></section></section></section></section><section style=\"margin: 45px 0px 0px;  color: rgb(34, 34, 34); font-family: system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif; font-size: 16px; letter-spacing: 0.544px; text-align: center; justify-content: center; display: flex; flex-flow: row nowrap; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 649.906px; vertical-align: top; align-self: flex-start; flex: 0 0 auto; height: auto; border-style: dashed; border-width: 2px; border-color: rgb(250, 220, 113); border-radius: 15px; overflow: hidden; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: flex; flex-flow: row nowrap; justify-content: center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: auto; vertical-align: top; flex: 0 0 auto; align-self: flex-start; min-width: 10%; height: auto; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  display: inline-block; width: 130px; height: 89px; vertical-align: top; overflow: hidden; background-position: 50% 50%; background-repeat: no-repeat; background-size: contain; background-attachment: scroll; overflow-wrap: break-word !important;\"><section style=\"margin: 26px 0px 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  font-size: 22px; color: rgb(250, 164, 102); text-shadow: rgb(255, 255, 255) 0px 1px, rgb(255, 255, 255) 0px -1px, rgb(255, 255, 255) 1px 1px, rgb(255, 255, 255) 1px 0px, rgb(255, 255, 255) 1px -1px, rgb(255, 255, 255) -1px 1px, rgb(255, 255, 255) -1px 0px, rgb(255, 255, 255) -1px -1px, rgb(255, 169, 169) 0px 2px, rgb(255, 169, 169) 1px 2px, rgb(255, 169, 169) -1px 2px; letter-spacing: 4px; line-height: 1.8; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">03</strong></span></p></section></section></section></section></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  color: rgb(250, 164, 102); letter-spacing: 2px; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">“长大才明白，友情里也有事与愿违”</strong></span></p></section></section><section style=\"margin: -5px 0px;  transform: scale(0.2); transform-origin: center center; overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"></section></section><section style=\"margin: -20px 0px 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px;  text-align: justify; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 220, 113); font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\">——————</strong></span></p></section></section><section style=\"margin: 0px;  overflow-wrap: break-word !important;\"><section style=\"margin: 0px; padding: 0px 20px; outline: 0px;  text-align: justify; font-size: 14px; color: rgb(120, 154, 79); line-height: 2; overflow-wrap: break-word !important;\"><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">听完前两个故事，突然意识到，似乎每一段友情的结局都事与愿违。回想起自己从小到大的友情，也有几段无疾而终——中学原本亲如姐妹的同桌聊天框里只剩过年时的群发问候，大学社团遇到志趣相投的学姐最终沦为朋友圈的点赞之交。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">其实我们是可以一直做朋友的，但在我们结束特定的身份关系后，我没主动联系她，她也没主动联系我，然后就没有了然后。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">总觉得自己身边朋友数不胜数，其实长年相伴的实为少数，但与多年好友寥寥无几的人相比，已是百般幸运。如果较起真来，我们身边真的不缺朋友，一直坚信只要抱着开放、尊重的心态，无论是在网络上还是现实中，我们都能轻松结交朋友，果真如此，友情应如春花一般，漫山遍野。<strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">但我们总会忘记，春花能细阅盛夏，却难赏寒冬。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">友情，需要倾注情感，但也需要一直有所回应的对话。</span></strong>也许正是因为友情的附加条件更多，所以长久持续的友情才更显珍贵。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">在我们飞驰的人生列车上，友情总是比亲情与爱情更加广泛地存在着。</span></strong>走进不同的人生车厢，我们会与不同的朋友相遇——</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">儿时的朋友在和自己无忧无虑地追逐疯跑，少时的朋友在怂恿自己尝试前所未有的新鲜体验，青春期的朋友在因叛逆而狭小的成长空间里与自己相依相偎，长大后的朋友在月色静谧的夜晚与自己畅快淋漓地交换肺腑之言。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">漫长的生命中，每一个朋友的出现都承载着不同的意义，而与他们并肩的每一段记忆，都是我们彼此搀扶着奔向成长的脚印。经历过不止一段有始无终的友情，才恍然领悟——</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">友情中的相守是彼此同频的缘分，而相离意味着各自朝着不同方向继续前行的勇气。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">人生是一步一步走出的路，是路便总会有许多的岔路口，走着走着，有些朋友难免会与我们告别。</span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\"><strong style=\"margin: 0px;  overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  color: rgb(250, 164, 102); overflow-wrap: break-word !important;\">但没关系，也许此刻走散的他们，正和我们一样期待着，在下个路口重新相遇。</span></strong></span></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; word-break: break-all; overflow-wrap: break-word !important;\"><br style=\"margin: 0px;  overflow-wrap: break-word !important;\"></p><p style=\"margin-bottom: 0px;  clear: both; min-height: 1em; text-indent: 2em; word-break: break-all; overflow-wrap: break-word !important;\"><span style=\"margin: 0px;  font-family: Helvetica Neue, Helvetica, Hiragino Sans GB, Microsoft YaHei, Arial, sans-serif; overflow-wrap: break-word !important;\">祝在下个路口等待我们的友情地久天长。</span></p></section></section></section></section>', 0, 0, 0, 0, 1678074987187, 0);
INSERT INTO `t_blog` VALUES (78, 1, 36, '4个方法，让你越来越有价值', '<p><br></p><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:30px 0px 10px;text-align:center;justify-content:center;display:flex;flex-flow:row nowrap;visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgb(225, 244, 254);height:auto;visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:-17px 0px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;transform:translate3d(-12px, 0px, 0px);visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:0px;justify-content:flex-start;display:flex;flex-flow:row nowrap;visibility:visible;overflow-wrap:break-word;\"><section style=\"margin:0px;padding:9px 19px 0px;  display:inline-block;vertical-align:top;width:auto;align-self:stretch;flex:0 0 auto;min-width:5%;height:auto;background-color:rgb(244, 228, 100);overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:center;overflow-wrap:break-word;\"><section style=\"margin:0px;font-size:17px;color:rgb(15, 41, 76);overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><strong style=\"margin:0px;overflow-wrap:break-word;\">时间增值</strong></span></p></section></section></section><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateX(180deg) rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-color:rgb(15, 41, 76) rgba(255, 255, 255, 0) rgb(62, 62, 62) rgb(62, 62, 62);border-width:12px 12px 0px 0px;border-style:solid;overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;text-indent:2em;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;padding:0px 31px 31px;  display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:justify;overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">时间是最公平的，因为它每天给任何人的都是24小时；但时间也是最不公平的，因为每个人24小时的价值并不相同。当有的人在肆意荒废时间时，有的人却在努力为自己的时间增值。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">如何让时间增值？首先，可以将大块时间分解为小块时间，提高单位时间的效率。例如小事在15分钟内完成，大事每15分钟跟进一次进度。这样一来，有效地避免了懒惰和拖延，工作效率极大提升。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">其次是“一时多用”。跑步时，听知识性内容；坐地铁时，回回邮件、读读书。碎片化的时间被最大程度利用起来，价值倍增。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;text-indent:2em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;text-indent:2em;overflow-wrap:break-word;\">当你让自己的时间有价值，时间自会让你的生命有价值。</span></p></section></section></section></section></section></section></section><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></section><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;overflow-wrap:break-word;\"><section style=\"margin:30px 0px 10px;text-align:center;justify-content:center;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgb(225, 244, 254);height:auto;overflow-wrap:break-word;\"><section style=\"margin:-17px 0px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;transform:translate3d(-12px, 0px, 0px);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;overflow-wrap:break-word;\"><section style=\"margin:0px;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin:0px;padding:9px 19px 0px;  display:inline-block;vertical-align:top;width:auto;align-self:stretch;flex:0 0 auto;min-width:5%;height:auto;background-color:rgb(244, 228, 100);overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:center;overflow-wrap:break-word;\"><section style=\"margin:0px;font-size:17px;color:rgb(15, 41, 76);overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><strong style=\"margin:0px;overflow-wrap:break-word;\">习惯增值</strong></span></p></section></section></section><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateX(180deg) rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-color:rgb(15, 41, 76) rgba(255, 255, 255, 0) rgb(62, 62, 62) rgb(62, 62, 62);border-width:12px 12px 0px 0px;border-style:solid;overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;text-indent:2em;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;padding:0px 31px 31px;  display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:justify;overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">好习惯让人受益终身，坏习惯却可以毁掉一个人。我们每一个人都是由自己一再重复的行为所铸造的，优秀不仅是一种品质，更是一种习惯。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">优秀的人，总能让自己在好习惯中实现自我增值。每天学习10分钟，日积月累，会大幅提升业务能力；每天跑步30分钟，日积月累，身体素质会越来越好。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">与其去期待人生短时间内发生巨变，不如从现在起去建立一个又一个看似微小的好习惯。每天进步一点点，慢慢地你就能成为更优秀的自己。</span></p></section></section></section></section></section></section></section><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></section><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;overflow-wrap:break-word;\"><section style=\"margin:30px 0px 10px;text-align:center;justify-content:center;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgb(225, 244, 254);height:auto;overflow-wrap:break-word;\"><section style=\"margin:-17px 0px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;transform:translate3d(-12px, 0px, 0px);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;overflow-wrap:break-word;\"><section style=\"margin:0px;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin:0px;padding:9px 19px 0px;  display:inline-block;vertical-align:top;width:auto;align-self:stretch;flex:0 0 auto;min-width:5%;height:auto;background-color:rgb(244, 228, 100);overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:center;overflow-wrap:break-word;\"><section style=\"margin:0px;font-size:17px;color:rgb(15, 41, 76);overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><strong style=\"margin:0px;overflow-wrap:break-word;\">阅读增值</strong></span></p></section></section></section><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateX(180deg) rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-color:rgb(15, 41, 76) rgba(255, 255, 255, 0) rgb(62, 62, 62) rgb(62, 62, 62);border-width:12px 12px 0px 0px;border-style:solid;overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;text-indent:2em;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;padding:0px 31px 31px;  display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:justify;overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">读书是给自己的智慧增值的最好方式。多学一种知识，就多一种能力；多懂一门学问，就多一层底气。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">迷茫时，书是一个盾牌，帮你抵挡浮躁诱惑；低谷时，书是一种工具，帮你更好答疑解惑；沮丧时，书是一件武器，助你走过艰难险阻。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">一个人人生的高度，就是他脚下书本的厚度。你读过的每一本书，都会成为你的内在力量，助你以更好的姿态应对生活中的疾风骤雨。</span></p></section></section></section></section></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></p><section style=\"margin:0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;overflow-wrap:break-word;\"><section style=\"margin:30px 0px 10px;text-align:center;justify-content:center;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgb(225, 244, 254);height:auto;overflow-wrap:break-word;\"><section style=\"margin:-17px 0px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;transform:translate3d(-12px, 0px, 0px);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;overflow-wrap:break-word;\"><section style=\"margin:0px;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section><section style=\"margin:0px;padding:9px 19px 0px;  display:inline-block;vertical-align:top;width:auto;align-self:stretch;flex:0 0 auto;min-width:5%;height:auto;background-color:rgb(244, 228, 100);overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:center;overflow-wrap:break-word;\"><section style=\"margin:0px;font-size:17px;color:rgb(15, 41, 76);overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><strong style=\"margin:0px;overflow-wrap:break-word;\">情绪增值</strong></span></p></section></section></section><section style=\"margin:0px;display:inline-block;vertical-align:top;width:auto;flex:0 0 0%;height:auto;align-self:stretch;overflow-wrap:break-word;\"><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateX(180deg) rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-style:solid;border-width:46px 10px 0px 0px;border-color:rgba(255, 255, 255, 0) rgb(244, 228, 100) rgb(62, 62, 62) rgb(62, 62, 62);overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;transform:perspective(0px);transform-style:flat;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:right;transform:rotateY(180deg);overflow-wrap:break-word;\"><section style=\"margin:0px;display:inline-block;width:0px;height:0px;vertical-align:top;overflow:hidden;border-color:rgb(15, 41, 76) rgba(255, 255, 255, 0) rgb(62, 62, 62) rgb(62, 62, 62);border-width:12px 12px 0px 0px;border-style:solid;overflow-wrap:break-word;\"><svg viewBox=\"0 0 1 1\"style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section></section><section style=\"margin:0px;text-indent:2em;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;overflow-wrap:break-word;\"><section style=\"margin:0px;padding:0px 31px 31px;  display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;overflow-wrap:break-word;\"><section style=\"margin:0px;text-align:justify;overflow-wrap:break-word;\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">人生在世，总有起起伏伏，难得的是，在低谷时保持乐观，不在情绪黑洞中沉沦。为自己的情绪增值，是通往幸福的最佳途径。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">遇事时，聪明的人总能及时调整好自己的情绪，他们从来不会乱发脾气，而是以积极乐观的态度面对一切挑战。正是这种发自心底的愉悦，滋养了他们的人生，让他们变得更加优秀。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">一个能够掌控自己情绪的人，才能用好心态去感染他人。别让坏情绪毁了我们用心珍惜的关系，也别让坏情绪拖累了你的人生。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\"><br style=\"margin:0px;overflow-wrap:break-word;\"></span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;overflow-wrap:break-word;\"><span style=\"margin:0px;font-size:18px;overflow-wrap:break-word;\">每一个人的人生价值，都由自己赋予。当你学会为自己增值，才能持续进步，收获更好的人生。余生宝贵，愿我们都能不断为自己增值，不负时光不负己。</span></p></section></section></section></section></section></section></section>', 2, 1, 0, 0, 1678075326708, 0);
INSERT INTO `t_blog` VALUES (79, 1, 36, '善待自己，过张弛有度的生活', '<section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;\"><section style=\"margin:10px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">结交益友</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\">古语云，与善人居，如入芝兰之室，久而不闻其香，即与之化矣。结交益友，可以排忧解闷，收获一份良好的心态，增加人生的宽度。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">生命中人来人往</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">，多结交好的朋友</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">，世界就可以是你想要的样子。</span><span style=\"margin:0px auto;text-align:justify;text-indent:2em;\"></span></p></section></section></section><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;\"><br style=\"margin:0px auto;\"></section><section style=\"margin:10px 0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">适量运动</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;text-indent:2em;\"><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\">流汗使人放松，运动让人快乐。工作压力大时，别犹豫，来一场属于自己的长跑；遭遇挫折时，振作起来，打球、游泳、跳操，随你开心。<span style=\"margin:0px auto;text-indent:2em;\">每天坚持适量运动，</span>久而久之你会发现，<span style=\"margin:0px auto;text-indent:2em;\">身材越来越好，内心也越来越强大。运动不只解决烦恼，还令生活充满无限可能。</span></span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\"><br style=\"margin:0px auto;\"></span></p><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;\"><section style=\"margin:10px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">心态乐观</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\">有人说，“生命中，我们都接到不同的剧本。平淡或浓烈，欢笑或眼泪，我们总要演好，直至落幕。”</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">心态好，一切都好。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">积极乐观的心态，是幸福生活的钥匙。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">不管发生什么事，记得告诉自己，一切都会过去，好事自会发生。</span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\"><br style=\"margin:0px auto;\"></span></p><section style=\"margin:10px 0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">记录美好</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;text-indent:2em;\"><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\">晚间的夕阳，路边的野花，屋顶的树叶……随手拍下的照片或写下的文字，可能都会在不经意间变成生活里的小确幸。善于捕捉生活中的美好，可以惊艳整个岁月。每天记录下几件让自己感到愉悦或感激的小事，便可见人生明朗，万物可爱。</span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;\"><br style=\"margin:0px auto;\"></p><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;\"><section style=\"margin:10px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">助人</span><span style=\"margin:0px auto;text-indent:34px;\">为乐</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\">力所能及地帮助别人，既可解他人之急，亦能传递善意。雨天你愿意给别人打伞，别人才会愿意在晴天时为你遮阳。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">熟人相帮，友情方能长久；</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">生人相帮，就是积一生福气。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">学会在小事上予人方便，自己也能收获幸福和快乐。</span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;\"><br style=\"margin:0px auto;\"></p><section style=\"margin:10px 0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">好好吃饭</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;text-indent:2em;\"><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\">人间烟火气，最抚凡人心。饭菜虽然简单，但充满着对生活的热爱，亦能抚平内心的浮躁，温暖而有力量。世事再纷繁复杂，也不过一日三餐。越是疲倦、烦躁，越要</span><span style=\"margin:0px auto;font-size:18px;\">用心对待每日伙食</span><span style=\"margin:0px auto;font-size:18px;\">。学会在一饭一食中汲取温暖，疗愈自己，无疑是对生活的最大尊重。</span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\"></span><span style=\"margin:0px auto;text-indent:2em;font-size:18px;\">&nbsp;</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\"></span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\"></span></p><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;\"><section style=\"margin:10px 0px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">高效睡眠</span></strong></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;text-indent:2em;\"><span style=\"margin:0px auto;font-size:18px;\">不良的睡眠习惯，损耗的是精神，拖垮的是身体。好好睡觉，是对健康的最好投资，也是富养自己的最好方式之一。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">没事儿早点睡，才能用饱满的热情，去追求那些你想要的未来。</span><span style=\"margin:0px auto;font-size:18px;text-indent:2em;\">坚持睡前摒弃一切杂念，保证高质量睡眠，醒来便是新生。</span></p></section></section></section><p style=\"margin-bottom:0px;clear:both;min-height:1em;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;text-align:justify;text-indent:2em;\"><br style=\"margin:0px auto;\"></p><section style=\"margin:10px 0px;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;font-size:17px;letter-spacing:0.544px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;display:inline-block;width:auto;vertical-align:top;align-self:flex-start;flex:0 0 auto;min-width:5%;height:auto;border-bottom:1px solid rgb(142, 201, 101);border-bottom-right-radius:0px;\"><section style=\"margin:0px 0px 4px;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:0px 11px;outline:0px;display:inline-block;width:auto;vertical-align:bottom;align-self:flex-end;flex:0 0 auto;background-color:rgb(142, 201, 101);min-width:5%;height:auto;\"><section style=\"margin:0px auto;text-align:justify;font-size:18px;color:rgb(255, 255, 255);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><strong style=\"margin:0px auto;\"><span style=\"margin:0px auto;text-indent:34px;\">亲近自然</span></strong><span style=\"margin:0px auto;text-indent:34px;\"></span></p></section></section><section style=\"margin:0px 0px 0px 10px;display:inline-block;vertical-align:bottom;width:auto;align-self:flex-end;min-width:5%;flex:0 0 auto;height:auto;\"><svg viewBox=\"0 0 1 1\" style=\"float:left;line-height:0;width:0;vertical-align:top;\"></svg></section></section></section></section><section style=\"margin:0px auto;color:rgb(34, 34, 34);font-family:system-ui, -apple-system, BlinkMacSystemFont, Helvetica Neue, PingFang SC, Hiragino Sans GB, Microsoft YaHei UI, Microsoft YaHei, Arial, sans-serif;letter-spacing:0.544px;text-align:justify;font-size:16px;text-indent:2em;\"><section style=\"margin:0px 0px 10px;text-align:left;justify-content:flex-start;display:flex;flex-flow:row nowrap;\"><section style=\"margin:0px auto;padding:20px;outline:0px;display:inline-block;width:90%;vertical-align:top;align-self:flex-start;flex:0 0 auto;background-color:rgba(171, 186, 206, 0.07);\"><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\">置身于大自然，我们会感动于万事万物的各种美好，身上的疲惫往往会一扫而空，胸怀亦会随之敞开，得到心灵上的放松和安宁。到大自然中去，当你走出去，每一步都会是风景，每一步都会是欢喜。</span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\"><br style=\"margin:0px auto;\"></span></p><p style=\"margin-bottom:0px;clear:both;min-height:1em;\"><span style=\"margin:0px auto;font-size:18px;\">人生是一场长途旅行，愿你善待自己，轻装前行，在张弛有度中把生活过成自己想要的样子。</span></p></section></section></section>', 1, 0, 0, 0, 1678075657951, 0);
INSERT INTO `t_blog` VALUES (80, 1, 36, '真实的世界', '<p><span style=\"background-color: rgb(254, 255, 251); font-family: Arial, Helvetica, sans-serif; font-size: 16px;\">　　</span><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">所见，并不即是世界。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　智者的快乐，是偏安一隅的，不求人知晓；可常人的欣喜，却是兴师动众的，恨不得逢人相告。狡黠之人的愤怒，是暗潮，披着甜美的笑；正直之人的震怒，却是明火，叫人一览无遗。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一种表情，总结一种情绪，原来并不可靠。同是喜怒哀乐，也是人各不同。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　痛苦，或是绽放的前夜。喜悦，太像稍纵即逝的一阵风。怒火，是错燃的激情。忧虑，多半只是一件多余且无益的事。思念，是一片水盈盈的月光，月出则满，日出则退。惊惶，浪里的浮萍，忽而至，忽而就远。幸福，不是目的地，而是日日的功课，不是奔向幸福，而是走進幸福……</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　情绪，并非尽是真相。快乐因何而来，愤怒是因何而起，哀伤会因何而散，没有来龙去脉，读来的情绪，都只是一面之词。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一个人与孤独时刻博弈，乘驭孤独，便会自得其乐；被孤独反噬，才会渴求倾诉与倾听。谈孤独而色变？也不尽然。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　概念，无法用来认知活脱脱的世界。正如标签，无法用来解读一个活泼泼的人。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　激情澎湃的高歌，歇斯底里的愤怒，都只是表演。站得再高的人，也会匍匐大地，摩挲山河与烟火。久在悲恫里挣扎的人，也会紧紧攥着拳头，张望曙光。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　这才是真实的世界。</span><br></p>', 0, 0, 0, 0, 1678075783653, 0);
INSERT INTO `t_blog` VALUES (81, 1, 41, '幸福是窗外的一把米', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　幸福是什么？幸福是一种心灵的感觉，幸福常常是小小的、朦胧的，幸福总是藏在每个如常的日子里，在不經意间缓缓流淌，轻轻荡漾。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我喜欢早起，早早地起床，一天的光阴就是完整的。早起并非因为“一日之计在于晨”的紧迫感，而是内心可以更从容地开始一天的生活。记得梭罗说过，每一个早晨，都是一个愉快的邀请。几年前，搬家至远离闹市的宁静小区，绿树成荫的优美环境让这儿成了鸟的幸福家园。每个清晨，鸟儿细细碎碎又清澈如山泉水般的声音唤醒了我的耳朵，我在晨曦微露中接受这份愉快的邀请。起初时，静静躺在床上听几分钟鸟儿的晨唱是每天的必修课，有轻声呢喃的，细密绵长；有唧唧啾啾的，如稚语童音；有清脆嘹亮的呼朋引伴，这边过去一声，间隔二三秒，另一边又和一声，声音细细长长，最妙不可言的是那丝婉转又干净的尾音，似乎干净利落，又似乎情意绵长。我常常在鸟儿的歌声中揣摩它们清晨聚会的模样，它们一边恬静梳着羽毛，一边交流前一天遇到的新鲜事，道道張家长李家短：什么去年被锯了枝的柑橘树今春长新叶，模样像秃头的“小瘪三”，妙源溪边那位多情的青蛙王子又新换了恋人……它们是喜悦的，每一天都是一个新的开始，对每一天都充满信心和希望，即便是雨天，也能衔着雨丝欢快地歌唱。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　每天，我在这愉快的声音中起床，下楼为家人准备早餐。窗外的樟树上有成群的鸟雀跳跃、追逐嬉戏，大多是叫不出名的小山雀。常在我窗外活动的一对鹧鸪引起我的注意，它们总是情比鸳鸯，出双入对，好像从不在樟树上逗留，要么停在对面的屋檐下“整妆”，要么在我窗外的草地上专心找寻食物，那默契有加的样子让人想起琴瑟和谐、鸾凤和鸣。也就在那一刻间，我有了收鸟雀为宠物的想法，从此，每天清晨的窗外一把米，就成了我单方面的执念——它们为我养在天空的宠物。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　每日清晨做早餐的间隙，总不忘在厨房窗外撒一把米，那是我与鸟儿的清晨之约。而后，隔着玻璃窗静静看它们怡然自得地来觅食，有灰头土脸的小山雀，拖着长尾的斑鸠，出双入对的鹧鸪……山雀来时成群，警觉性高，一片飘零的落叶也能让其惊恐，一掠而走。唯有这对鹧鸪，像一对甜蜜的恋人，每日光临我的窗外。初始，雄的放哨，雌的亦步亦趋踱向我撒有米的草地，边啄食边抬头观望，而后换之。日子久了，戒备少了，双双一低头一翘尾，边觅食边嬉戏，情意浓浓。更为可贵的是这对鹧鸪的知足和知止，它们从未一次将我撒的米吃光，每次总留下部分与后来的其他鸟雀享用。这或许是鹧鸪谨小慎微的天性使然，或许是它们真懂“知足不辱，知止不殆，可以长久”的天道。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　日子一久，我与窗外的鹧鸪默契渐深。每日清晨，当我的目光透过香樟斑驳的树影跃上对面的屋檐，总能看到鹧鸪温和的眼神，它们安静地看着我，一脸期许，满眼信任。我用目光轻抚它们的双羽，似乎能感受到那微微的颤动。在一日日的目光鼓励下，在一日日充满善意的一把米里，这对鹧鸪认下我这位朋友。间或，它们会跳到窗台上，静静盯着厨房里忙碌的我；偶尔，我在阳台洗衣，一转身，鹧鸪在身后台板上梳羽，那一刻，心如甘饴，温暖如春。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　清晨一把米，自由的鸟儿是我内心的宠物，但我不是它们的主人，只享受它们觅食的满足和沉静。《道德经》开篇就说“常无欲以观其妙，常有欲以观其徼”。清晨时光，我以无欲之心观自然万物之妙，幸福就是窗外的一把米。</span><br></p>', 0, 0, 0, 0, 1678075916620, 0);
INSERT INTO `t_blog` VALUES (82, 1, 41, '爱情的颜色', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　在一个画展上看到一幅畫，题目是《爱情的颜色》。画面五彩斑斓，没有具体的物象，像抽象派。好多人驻足，也有好多人说看不懂。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我也不知道画家的意图，但我的理解是，画家想要告诉我们的，也许是另外一层深意：爱情的色彩在每个人的心中是不同的。我心中爱情的颜色是什么？如果我也能用画笔描绘它，我会用红色画一株玫瑰，用绿色画一杯清新绿茶，用黄色描绘一碗热汤。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　在我最飞扬的青春里，盼望着的愛情如期而至，它就是我的血液，我的养分。这朵流光溢彩的花朵，有种致命的诱惑力，红艳艳地让我在时空与无限的潮水中喜悦着，所有时光都变成良辰美景。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　牵着他的手走过红毯进入婚姻，随着时间的推移，我已不再为爱情发狂。真实的生活，让我们更有机会去体验爱情的优雅。我们更愿意去细心体察爱人的内心，细腻地感受平淡生活的凡俗滋味，丢掉所有的盔甲和伪装，在爱着的人面前嬉笑怒骂。此时的爱情，犹如一杯清新绿茶，怡情怡心，滋心润肺，也隐藏在锅碗瓢盆、琐碎烦恼中。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　学者周国平说过：“如果爱情要在家庭中继续生长，就仍然会有种种亦悲亦喜的冲突和矛盾。一味地温馨，试图抹去一切不和谐音，结果不是磨灭掉夫妇双方的个性，从而窒息爱情，就是造成升平的假象，使被掩盖的差异终于演变为不可愈合的裂痕。”不可否认，我也曾一度怀疑它的存在，我们都太忙了，忙着当房奴、车奴、孩奴，在心里一遍遍地幻想另一种更美好的生活，忙累得怅然若失，心灵凋谢过多少爱情的花朵。人到中年却忽然明白，只要你愿意暂时放下手中的一切，静静地倾听一会儿爱情的潮歌，它定会如藏在泥土中的种子，发芽壮大；如同多汁的果实，香甜美好；如同春柳的叶子，温柔妖娆。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　有一首歌唱道：“这一秒突然之间想知道，我在你心里究竟多重要……这一刻突然之间才知道，你在我心里究竟多重要。”我总是忍不住想爱情凋落时的模样，疏落的枝叶似一个粗疏画手的写意？两三朵残花像世界末日最后一幅油迹？幸运的是父母相濡以沫的情感给了我答案。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　当母亲老到没有了牙齿，当病痛折磨得父亲吃不下饭，一碗热度刚刚好的浓汤或薄粥，传递出彼此间的爱意。此时的爱情早已是最成熟的状态，变成温馨的黄色，在无法割舍的亲情中可以体会它的美好。温暖、和谐、平淡与笃定，像夕阳落日，像中秋明月，甚至像大大的南瓜，粘糯又香甜。黄色被视为平安色，也正如此时的爱，它实现了对爱一生一世的承诺。过往中沉甸甸的记忆，笔触虽浅，但很用心。</span><br></p>', 0, 0, 0, 0, 1678075950989, 0);
INSERT INTO `t_blog` VALUES (83, 1, 41, '奶奶的脊背', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　奶奶的背脊像什么呢？面对这个简单的问题，我有些忧虑起来，因为我不知道怎么去形容它。在我的记忆里，奶奶的脊背是不断变化着的，它每一个阶段给我的印象也是迥然不同的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　幼年时，奶奶的脊背是一张温暖的摇篮。无论走到哪里，奶奶都把我背在背上。那时候，我喜欢热闹，哪里热闹我就吵着要到哪里去。我的这个脾性正合了奶奶的意，因为她喜欢看戏，有了我这个小祖宗，她去看戏就成了理所当然。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　每每听说有庄子唱戏，奶奶早早地把一家人的晚饭烧好，就背着我跑出了门。奶奶虽然不识字，但是对于戏文却门儿清，还能唱上一些。我在路上无聊的时候，奶奶就哼着戏文逗着我。我呢，被背篼兜着，一摇一晃的，在摇篮里一样，不大一会儿就在奶奶的催眠曲中睡着了。等到我醒来的时候，戏一般都唱了十之八九。奶奶呢，背着风，靠在稻草堆上，眼睛盯著戏台，嘴里哼着，手里打着拍子，背篼一晃一晃的，那真是一种不一样的舒适呢。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　看到我醒了，不闹腾，她也不问我；但是只要我哼唧一声，她就会从口袋里变戏法似的，掏出一两粒糖果塞进我的嘴里。有了糖果，还有热闹，我自然也就舒舒服服地享受着自己的快乐了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　看完了戏，一般都是深夜了，但是只要附近有卖零食的，奶奶就会跑去买上一点瓜子、花生之类的零食给我吃来醒瞌睡，以免睡着了感冒。我呢，就一直从戏台下吃到家里，就是嘴酸了，嘴干了，也不愿意停下来——要知道，那时这可是只有过年的时候才能吃到的美食。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　读书了，奶奶的脊背是一座平稳的桥。那时，我在小河那边的小学里读书。只要下大雨，山洪就像脱缰的野马一样从峡谷里冲下来。我们放了学，气喘吁吁地跑到小河边。河滩上都被洪水吞没了。它咆哮着，翻卷着，裹挟着树枝、砂石和泥土一头撞了下来。那声响，声如奔雷，那气势，万马奔腾。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我仗着自己会点水，脱下鞋子，把裤管绾到膝盖处，想试一试。但一下水，我就吓得退了回来。那脚底的沙“嗖嗖嗖”地往下蹿，就像受惊的兔子一样——脚都踩不实，还怎么过河？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　奶奶在对岸看到了，嚷嚷着。虽然听不见，但她那团团转的焦急我还是看在眼里的。好在小伙伴的家人也赶来了，他们在河中很快拉起了一根绳子。奶奶从不容许我一个人摸水过河，说怕我被水冲走，她总是固执地要背我。那么大的水流，人稍不留意，就有可能摔倒，我吓得趴在奶奶的背上，闭着眼睛不敢看，只是心里默默地祷告着，祖宗保佑，祖宗保佑。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　等到过了河，提着的心放下了，我从奶奶的背上溜下来，抱着奶奶的脸就亲。这么大的孩子还亲奶奶，羞不羞？乡亲打趣我。我也不害羞，我奶奶，我怎么不能亲了？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　那时，奶奶的脊背还是一根屋梁，家里大大小小的事，虽然有父亲，但是最后做决定的一般都是奶奶。人們都说，我的奶奶撑起了半边天，这话我信。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　而现在，奶奶的脊背是一个近乎完美的圆。也许是一生的劳动太过辛劳，奶奶四十多岁的时候，腰就弯了，而现在弯得更厉害了。虽然拄着拐杖，但是头却在拐杖头的下面，似乎脊背支撑不住她的身体似的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　有时候，我就悲哀地想，要是没有拐杖，奶奶是不是再也抬不起头来了呢？但是，奶奶却想得很开，人生不就是求一个圆满吗？要是哪一天，我真的成了一个圆，你们不要悲伤，因为那是圆满的圆。要高兴，知道吗？我强笑着，心底还是有些涩涩的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　这就是我奶奶的脊背。</span><br></p>', 1, 0, 0, 0, 1678075977526, 0);
INSERT INTO `t_blog` VALUES (84, 1, 41, '—方一圆一世界', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　世界处处有圆，自然界就是由大大小小的圆组成的：从大处说，地球是圆的，太阳是圆的，星星、月亮是圆的；从小处说，眼球是圆的，珍珠是圆的，西瓜、小米粒、黄豆是圆的。而方多是人工特意为之。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆的大凡都是自然的，方的大多都是人工的：院子、房子、书本、报刊、照片、手机、电脑、电视机多是方的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　人工的不一定都是方的，也有许多圆的：车轮是圆的，皮球是圆的，碗、杯、盘、盆、锅是圆的，大到500米口径的射电望远镜，小到小小衣扣，都是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　有的圆里有方：铜钱是圆的，孔是方的；光碟是圆的，DVD影碟机是方的；电影胶片盒是圆的，放映出的一个个画面是方的；照相机的镜头是圆的，拍出的一张张照片是方的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　有的方中有圆：车厢是方的，车轮是圆的；包装盒是方的，酒瓶是圆的；灯罩是方的，灯泡是圆的；砖是方的，垒成的花坛是圆的；足球场、篮球场、排球场及乒乓球案都是方的，足球、篮球、排球、乒乓球却都是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　有的又有圆又有方：如门窗，园林门窗多圆，房屋门窗多方。如桌，餐桌多圆，书桌多方；西方餐桌多方，中国餐桌多圆，因华人更喜团圆。手表外壳尽管有方的，但表针走的步伐永远是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆是力量。只有圆的才能旋转，才能转得动、转得快，才能产生巨大的能量与速度，如发电机、电动机，汽车、轮船发动机等，都是靠旋转产生电力、动力。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆是运动。风叶不停地转，车轮不停地转，地球不停地转，太阳不停地升落也是转。只有旋转，只有运动，才有生命活力。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆的容量最大，在所有体积相等的物体中，圆球的表面积最小。圆的可塑性最强，单点所受压力最小，张力却最大。圆也是最节省能量的形状，如世上车的车轮为圆。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　果实为何大都是圆的？因为圆是大自然创造的最完美形状，圆形能减少水分散失、风雨侵袭、虫害等，更利于果实生长。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　宇宙飞船的返回舱为半球形，能大大减少大气层的摩擦力。若做成方的，摩擦力太强，产生温度过高，会致飞船受损熔化。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆，既有起点，又有终点；圆，既没有起点，也没有终点；圆，哪儿都是起点，哪儿都是终点。表针虽然走得都是一个个相同的圆步，每天转得都是一个个看似一模一样的圆圈，然而它走出的时间却一秒也不会重复。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　该圆则圆，该方则方。无方光有圆不行，无圆光有方也不成。方代替不了圆，圆也取代不了方，方方圆圆才组成世界。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　方是稳固。墙砖做成方的，楼房建成方的，便大大增强了其稳固性。若垒城墙、盖房屋的砖都用成圆的，高楼大厦也都建成圆的，这些建筑会坚固牢稳吗？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆是转动。如果把自行车、三轮车、汽车、火车车轮及飞机起落轮都做成方的，这些车还跑得动吗？这飞机还能飞上天、安稳落下地吗？若把足球也做成方的，这足球还咋踢，还能踢得起来吗？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　若把电视机、手机、书刊做成圆的，同样高与宽的屏幕或版面，想想效果又怎样？只有长方形面积的约一半，不是浪费了大量资源？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　从方窗里看天，天是方的，从圆窗里看天，天又成圆的，有时事物是方是圆，取决于你站的位置与角度，但无论你怎么看，蓝天与月亮永远不会是方的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆的为何会滚动？因为圆的心与大地爱的高度永远不变。方的为何立得稳？因为方把自己的胸脯紧紧贴在了大地之上。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　方与圆各有其妙，就像田方井圆，各有各的作用，切莫以圆克方、以方治圆、有你没我。方与圆要和谐互助，才能共赢。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一个轮子是圆的，另一个轮子是方的，车难开动还会翻车。只有四个轮子都是圆的，客车车厢是方的，车才能跑得更快，乘坐的人才能更多、更舒适。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　圆规为什么能画圆？因为它的心一直没有变。一个圆有多大，取决于从圆心出发的半径有多长。爱她，就是以她为圆心，自己做圆周—那是爱的圆。有时，圆与圆不能完全重合，那是因为心与心未在同一个点上。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　石头是方的，方的一直昂首挺胸屹立在高山之巅，以至万年亿年；石头也是圆的，圆的早就滚进了山下的河沟里，渐渐成了鹅卵石，被河水一一吞没。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　大地是方的？那是因你离得太近，身在山中不知山。若拉开距离看大地，大地也是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　大海是方的？2005年夏天我乘轮船到大连，站在甲板上眺望四方，发现大海竟也是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　古人云：“天圆地方。”那是因为古人的科学知识有限。其实，天是圆的，地也是圆的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　地球为什么是圆的？就是表明地球上一切大大小小的路都没有尽头，哪一条路都是起点，哪一条路都不是终点。无论你走到哪里，都没有断头路、绝路，都不会没有路，都能一直走下去，一直通往你想去的地方。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　宇宙是圆的，所有星球也是圆的。地球若是方的，月亮、星星、太阳及其运行轨道若都是方的，它们如何转得动？与大自然背道而驰，世界与生命还会存在吗？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　象棋、围棋棋盘为方，棋子却为圆。棋下千年，棋盘上不知纵横过多少千军万马，大大小小</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　的战争不也在方圆之间？天地成最大棋局。唐宰相张说曾出上联：“方若棋盘，圆若棋子，动若棋生，静若棋死。”丞相李泌对曰：“方若行义，圆若用智，動若骋材，静若得意。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　《管子·形势解》：“以规矩为方圆则成，以尺寸量长短则得。”唐人李华《咏史》之四：“如何得良吏，一为制方圆。”中国人还常说：“没有规矩，不成方圆。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　自然以圆为本，人以方为正。无方，世界便没了规矩、准则与约束，便缺了阳刚之美；无圆，世界便无运动与活力，便成死水一潭，也没了温柔之美。有圆无方能立得稳吗？有方无圆车船能飞驰吗？圆的地球上能盖起无数方的房子，方的客车车厢下是一对又一对的圆在奔跑。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　方方正正，是做人的根本。如果感情是圆的，就会漂移不定；如果思想是圆的，就会圆滑世故。做人、做事一定要方，就是要遵循规矩，绝不可乱来。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　俗话说，圆的不稳，方的不滚。我们做任何事也不能过于教条死板，就像都说地球是圆的，可地球绝对圆吗？其实地球是椭圆的。做事要方中有圆、圆内有方、亦方亦圆、方圆有度，要外圆内方，该方则方，该圆则圆，甚至椭圆。外表可圆，内心要方；对己要方，对人要圆；做事可圆，思想一定要方。生活将每个人的外表磨圆，但人内心一定要方正。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　刚为方，柔为圆。圆，不是圆滑的圆，而是圆通、圆润、圆满、灵活、机变；方，虽是规矩、框架，但并不是死板、僵化，而是方而不僵、圆而不滑。方，没有曲线，相对稳固；圆，没有棱角，不会伤人。只有方与圆携手，方才能成为世界和谐方正的方，而圆才能成为生活圆满的圆。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一撇一捺一人字，一方一圆—人生。你是圆，你也是方，就像水，流进方池为方，流人圆池成圆。只要住在楼里，你就离不开方；只要骑车开车，你就离不开圆。天地万物，方中有圆，圆中有方；非方即圆，非圆即方。方中有方又有圆，圆中有圆又有方，方中还有正方、长方、立方，圆中还有椭圆、半圆、月牙儿圆。方中的每一块都有做人的基石，圆上的每一点都有腾飞的切线。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　人人都是圆，都想以自己为圆心，肯定不行。大圆小圆，一起做同心圆，才能共同前进。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　人人都是方，都想以自己为中心，那也不行。大方小方，手挽在一起，才能筑成人的长城。</span><br></p>', 0, 0, 0, 0, 1678076015851, 0);
INSERT INTO `t_blog` VALUES (85, 1, 41, '常回家“蹭妈妈的饭”', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　母亲进城后，一直跟作为儿子的他住在一起，平时替他打理家务，买菜做饭，一家人相处得非常融洽。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　后来，孩子要到离家较远的一所小学去读书，为了便于接送，他在孩子学校附近租了一间小房子，和妻儿一起搬了过去，把母亲一个人留在了家里。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　由于每天要接送和辅导孩子，再加上工作又很繁忙，应酬又多，因此他便很少回自己原本的家，母亲的日常生活也全靠她自理。但这样的日子持续了半年多后，他突然覺得要做出改变。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“妈，我今晚要去你那儿吃饭，你给我弄点好吃的吧！买点虾和牛肉。”他将电话打给母亲。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　晚上回去后，母亲果然给他准备了一顿丰盛的晚餐，他吃得很香，母亲也吃得很香。他还告诉母亲，以后每周自己都会回来吃一顿，解解馋。“你儿媳做的菜不好吃，而且没啥好吃的荤菜，饭店里的菜又不太卫生。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　此后，他真的每周在规定的时间里回来吃饭，有时明知去不了，他也不提前说，而是在快到饭点时，才在电话里说：“妈，我临时有个饭局，去不了你那儿了，做的饭菜你自己吃吧。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　每回碰到这种情况，母亲就在电话里抱怨：“下次来不来，你得搞准了，做了这么多好菜，我一个人哪能吃完，真是太浪费了，糟蹋钱。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“我也没办法提前搞准，很多饭局都是临时接到参加通知的。”他有些无奈地回应。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　等他挂上电话，一旁的妻子便埋怨道：“真是睁眼说瞎话，明明晚上要在家辅导孩子学习，却非说外面有应酬，实话实说就是！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他说，她不懂，如果他实话实说，今晚的晚餐，妈妈又会糊弄掉了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　看着妻子满脸的迷惑，他开始解释。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他说，自从他们搬走后，妈妈每天都不好好吃饭了，早上吃的是咸菜加稀饭，中午还吃早上剩下的稀饭，晚上至多只会炒一盘蔬菜，很少吃鱼虾等荤菜。“可我在健康类报纸上看到说，老人要保持健康，除了坚持锻炼外，还必须要适当地吃点好的，有营养的。摄入足够的营养对老人健康长寿非常关键，可她舍不得去买菜，每月给她的生活费都剩余许多。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他喝了口水，继续说道：“可我一说要回去吃饭，情况就不一样了，她肯定会买些好吃的。我故意说临时有饭局，是逼她不得不吃下那些已经做好的好菜！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“按你这么说，你回去吃不是为解馋，而是为让妈能吃上些好的？”妻子问。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“是的，我都重度脂肪肝了，外面饭局什么好菜没有，还要解什么馋，我每次回去也只吃一点，只为留给妈吃。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他还告诉妻子，母亲一辈子生活在农村，一辈子节俭，她深知挣钱不容易，更深知他们培养孩子要花费很多钱。现在她觉得占着他们的房，让他们没了房租收入，心中很是愧疚，于是便处处替他们节省——买菜时要跑好几个超市，只为买到最便宜的，特别喜欢挑选那些不新鲜、有破损的促销菜。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　妻子听后也有些动容，她说：“那以后我们周末都去妈那儿‘蹭饭’吧，让她多买些新鲜蔬菜，就说她孙子爱吃新鲜的。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“那太好了，做菜不好吃的‘黑锅’还得委屈你继续背呀，”他有些动情地说道，“今后无论我们多忙，都要常回去吃饭，不为别的，只为含辛茹苦把我养大的老母亲。”</span><br></p>', 0, 0, 0, 0, 1678076090902, 0);
INSERT INTO `t_blog` VALUES (86, 1, 41, '老同学，你还欠我一顿饭', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　记得那年，我上大一。东北的夏天，早晚凉爽，可白天一点儿也不输给南方的火炉，我们这些穷酸学生，只能靠满脑子的冷饮来消暑。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　临近期末，我着急赶一篇论文，碰巧图书馆停电，找资料的计划泡汤，作业若交不上，挂科加补考，丢人现眼不说，还得交补考费。我急得像热锅上的蚂蚁团团转。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　遇到困难，自然想到同城上大学的老同学。我飞奔着去找他，他和我穿得幾乎一模一样，大裤衩，无袖圆领T恤，外加一双“叭哒叭哒”响的拖鞋。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　到了图书馆，不知道他使了什么诡计，竟然让“冷面”美女管理员把我也给放了进去。我们一起查资料，还在嗡嗡作响的586电脑上，用1。44MB的软盘拷贝了几篇论文。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　到了午饭点，我想请他吃饭。他用力搂了下我脖子，说：“让你请客？回头，不知道你跑同学BBS论坛里怎么数落我呢？”我哈哈一笑，丢给他一句：“算你识相！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“中午就在学校的西餐厅吃！”他很干脆地敲定了地方。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我心里直犯嘀咕：“西餐厅？两人吃一顿怎么也得二三百吧。”当时，我们每月200块生活费就够小康了啊。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“你小子捡到宝啦？”我疑惑着。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他笑着岔开话：“西餐厅品种多，口味全，最爽的是，这大夏天的，还有冷饮赠送！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　对我们这些穷学生来说，以前只是隔着电视屏幕见过西餐厅，到城里上大学后，才在街边近距离邂逅过西餐厅，但从来都没敢进去，更别说吃了。听他这么一说，我直流口水。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我连忙紧跟着他，一路小跑，贪吃的欲望就像流火直窜。不一会儿，他指着旁边的一栋楼说：“老同学。西餐厅到了。有请！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我抬头一看，差点笑岔气，楼上大牌子上赫然写着——“校园西餐厅”。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我们四目相对，哈哈大笑起来。我想，这小子也太鬼啦！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我们边吃边聊，吹着相互的糗事，也聊点儿新近读的书、交的友和看的电影。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他起身，说是去拿冷饮。我瞪大眼睛，目光紧紧粘着他，看他如何变戏法。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　不一会儿，他端着两个小碗，得意扬扬地喊着：“清凉冷饮绿豆汤来啦。”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我深深地吸了口气，接过碗，就着西餐厅里循环播放的刘德华的《忘情水》，一饮而尽。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我憋着一肚子气，一本正经地说：“我要到同学BBS论坛里去，揭露你欺骗忽悠我这个善良老同学的‘罪行’！”</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“别啊！求你了，老同学！和你开玩笑呢。”他忙求饶。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　“那可不行！怎么求我？光说不练嘴把式！得拿出点儿实际行动。我可不愿和你在这儿天高云扯淡的！”我不依不饶。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他赶紧说，某个周末，请我吃西餐和冷饮，正宗的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　后来，我们一起等了三年，都毕业了，也没兑现这个承诺。不是不想兑现，只是因为，我们实在穷得连基本的伙食费还得靠勤工俭学来维持，那有闲钱吃这等奢侈品啊！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一转眼，20年过去了，如今炎炎夏日，冷气空调随处可见，西餐冷饮想吃就吃。可我却怎么也忘不了那个夏天的“西餐厅”和那碗清凉的绿豆冷饮。它们很卑微，价格很低廉，却浸透着那段清苦的岁月，饱含着淡淡的校园回忆和清纯透亮的同学友情。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　近年来，我常和老同学碰面，每次他要请我吃饭，我都毫不犹豫地答应，但前提是不允许吃西餐和冷饮。老同学一直很无奈，为无法兑现当年的诺言耿耿于怀。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　我告诉老同学，你就永远欠着吧。我们要永远留着这个念想，用来回忆。不是有句话叫“青春是用来回忆的”嘛，不回忆无青春啊！也许这顿饭，这诺言，像一根长长的线，牵连着我和老同学，延续着真诚而单纯的情谊。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　老同学，你还欠我一顿饭！</span><br></p>', 0, 0, 0, 0, 1678076111914, 0);
INSERT INTO `t_blog` VALUES (87, 1, 41, '和你一起慢慢变老', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他今年六十三了，老伴儿整六十，他俩是典型的“焦不离孟，孟不离焦”。若哪一位一会儿不在身边，另一位必定心惶不定，满世界寻找。在一起时却又喜欢拌嘴，你来我往唇枪舌剑，谁也不服谁，真正的公说公有理，婆说婆有理。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　那一回他和老伴儿使劲儿吵了一架，最后，老伴儿赌气去了省城的女儿家，发誓再也不回来了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　倔强的他就这样被撂下了，孤家寡人独守沙家浜。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　第一天他还硬撑着，第二天就满屋子转圈，饭也吃不香，觉也睡不实了，第三天天刚蒙蒙亮，就往女儿家打电话，说自己常吃的药忘放哪儿了，这两天没吃药，心脏突突地跳，感觉不太好，看来要出大事儿了！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　老伴儿其实早就归心似箭了，却又不好意思跟女儿提，正心焦神烦呢，他的电话来了，可不是瞌睡时送来了枕头？她便急慌慌收拾了行李，一刻不停地往家赶。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　这边的他喜得眉开眼笑，撂了电话拉开架势高门大嗓地唱了一段《智取威虎山》。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　回来就回来，不记仇，日子还按部就班地往前过，吵吵好好，好好恼恼，两口子嘛，没有隔夜仇，热了冷了饥了饱了，吵过后还得互相惦记着。可是他越来越觉得老伴儿不对劲儿，说过的话扭头就忘，吵架时常常忘词，做的饭不是咸了就是淡了，总是一个人灵魂出窍般地发呆，后来竟然在去菜市场时迷路了。他想那可是天天都去的啊，就算闭着眼睛都能摸得着，还能迷路，咋回事啊这老婆子？糊涂了？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他心里没底，越琢磨越怕，便不敢耽搁，赶紧带着她去了医院。检查结果竟然真是，好在是早期，不严重，也就是一点点的苗头，有时清醒有时糊涂。医生给开了药，建议多带她去外边散散心，多交流，多关心。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他心想，咋交流？那就是多吵架呗，吵架锻炼大脑！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　可她都这样了，咋忍心跟她吵啊，自己的老伴儿自己宠，可舍不得刺激。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　最终，他决定带她去山里住几天，山里空气好，对她的病有好处。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　用两天的时间准备行装，衣服裤子小毛毯，牙膏牙刷擦脸油，林林总总一大包，对了，还要带她去买双鞋，要走山路哩，鞋不跟脚可不行。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　俩人就去了卖运动鞋的专卖店，他让她挑，她就挑了自己喜歡的穿上试，浅灰色，上边是浅蓝的条纹，清爽干净，大小刚合适。她很满意，在镜子前走来走去，笑得眼睛都眯了起来。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　她高兴他心里就舒畅，就决定买这双，可是她一看价钱那笑容就凝固在脸上了，五百三十元！？？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　太贵了呀，她嘟囔。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他俯下身子，柔声问，穿上舒服不？她回答说舒服！他又问，那，喜欢不？她有点不好意思地看看鞋又看看他，想笑又皱起了眉，又欢喜又嫌弃的样子，低声说：“可是太贵呀！”他笑笑，宠溺地摸摸她的头，说：“在这儿等我，我去交钱！”她乖乖地点头，眼睛里溢出笑来。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　付了款，他拎着鞋牵着她的手慢慢地往回返。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　小区门口，有山里汉子挑着箩筐在卖山楂，老伴儿兴奋起来，叫着山里红山里红，边叫嘴里边还使劲儿吸溜以阻止快要淌下来的口水。他不由得就笑出声来，拍拍她的手说别急别急，给你买给你买！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　买了五块钱的山里红，个个圆润红艳，她急不可待地要吃，他便耐心地说回家洗洗，不卫生吃了肚子会疼！她不依，开始发脾气，站住不走，拽也不走，他却不急，好声好语地劝。她不听，拧着身子闹脾气，伸出双手使劲儿扭他的两腮，这边扭，那边扭，他的脸像是橡皮的，在她的手里急速地变换着形状。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他拍拍她的头，暖暖地笑，得空赶紧哄她，以前那么爆的脾气，这会儿却一点也不恼。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　固执的老伴最后还是投降了，虽然还是不太满意，但总算是跟着走了，那嘴却高高地噘着，翻着白眼瞪他，一副受了委屈的孩子模样，很可爱。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　风里有了凉意，他给她系好围巾，捧起她的手轻轻地搓揉几下，问：“暖了没？”她嘿嘿嘿地笑，忘掉了刚才的不愉快。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　一手拎着新买的鞋和红艳艳的山里红，一手牵着不再赌气耍性子的她，俩人慢慢地往家走。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　这一幕，看呆了小区门口的闲人们，直到他们拐过弯再也看不见了，人们才收回目光，啧啧声四起，都是满脸的羡慕。就有戴着眼镜的姑娘文绉绉地说：“执子之手与子偕老，幸福多简单呀，不过就是有人愿意牵着你的手，和你一起慢慢变老！”</span><br></p>', 0, 0, 0, 0, 1678076131840, 0);
INSERT INTO `t_blog` VALUES (88, 1, 41, '放空一天，只为想您', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　今天是我的生日，母亲在时看望母亲，母亲走后就只剩下虚无的感念了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　母亲曾说：“妈想我娃，我娃就来了，只怪妈没把我娃照顾好……”而后母亲就泪水涟涟地说起往事，言语里尽是悔恨，但我从来没有怪怨过她。四十八年前，巷子里三个婴儿出天花，唯一挺过来的就是我。如今我快五十岁了，不应该满心感激吗？</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　不知为什么，我固执地只想感谢我的母亲，但明明是我的父亲解决了家里的温饱。我的父亲从未打骂过我，但我的母亲脾性不好，又苛求完美，对做错事的我非打即骂。可静下心来回望每个阶段的自己，都有被母亲改造过的深深的痕迹。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　小学时我手脚极不协调，不会翻跟头不会跳绳不会踢毽子。可母亲一直教我，直教到我进了中学不再需要幼稚的游戏来陪伴。我虽然一直没学会，却不曾疏离游戏的快乐。童年的我不曾被童年拒绝在门外，源于母亲一直帮我死扛着童年的大门，我才不至于在寂寞里形成孤僻的性格。也因了母亲是老师，各方面都不优秀的我，才有了可怜的小骄傲垫底，倒也不至于堕进无药可救的差生行列。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　中学时，我开始自己带干粮，食宿在小镇，距离家五里，而母亲去了距家更远的村子教学。同学们每周三下午都会回家带下半周的干粮，母亲则会骑着自行车给我送到学校，使我少了往返奔波的辛苦，多了好好学习的时间。假期回到家里，别的孩子都在地里帮父母忙活，我只是被母亲要求在家里复习功课就行。每个假期，都是我强大自己的加油站——笨鸟有了大量的苦练时间，飞起来也就有模有样了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　大学时曾給一个个体户的孩子做过一段家教，我骄傲地写信告知家里，母亲就让我将辅导时发生的事情随便写给她。三十年前，只有书信，没有电话。随后我收到了她的回信——让停止家教，理由很简单：那家长从不和我交流，只让我在柜台里辅导孩子，不尊重我。“感觉有伤自尊的事，绝对不能做”，母亲是以这句话结束那封信的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　直到现在，我还不知道是该欢喜还是该悲哀：尊严被我呵护得无比大，大到可以为了保护它而舍弃很多。当然，好处也是充分的，我可以问心无愧地挺直腰板，可以安安心心睡个好觉。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　工作了，我不怕领导怕母亲。面对同样教师出身的她，我总感觉自己摆脱不了要努力成为好学生的心理——见她时她每次都要问我所带班级的考试名次，班级情况。问得我总不踏实，总怕辜负，李老师的女儿张老师应该努力成为最好的老师啊，便越发认真越发努力，为了给母亲响亮的作答。多年后，我在教师岗位上获得了一些小荣小誉，真得感谢身后那根督促我的无形鞭子。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　尊严，努力，这是从青春期到工作后母亲教给我的。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　细想起来，我没有母亲为我梳头的记忆，从小到大为了不用打理头发，她都给我留着难看的瓜瓢头；没有母亲给我暖手或做精致饭菜的记忆，母亲是有大格局没有小细节的粗线条……但为什么我还老想起母亲，为什么对母亲近而离父亲远？后来，我说服了自己：生日时自然得感念母亲，一个孩子的降生可能有多种原因，但有两个是不可改变的：一是怀胎十月；二是人生人，吓死人。我更爱我母亲就是情理之中了，也就减少了对父亲的愧疚。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　生日里，没有母亲来行孝，只好虚无地感念了。</span><br></p>', 0, 0, 0, 0, 1678076156889, 0);
INSERT INTO `t_blog` VALUES (89, 1, 41, '曾经的你，如今成了隔岸的风景', '<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他和她是大学同学，新生报到的第一天，他从熙熙攘攘的人群中第一眼就看到了她。她穿着一条翠绿色的雪纺连衣裙，一头瀑布似的直发，清秀的脸庞，一看就知道是个安静的女子。那一刻，仿佛整个世界都为她而转动。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　他知道自己懵懂的初恋即将开始了，很巧，他们的座位在前后桌，她坐在他的前排，他以为有可以跟她亲近的机会，关注着她的一颦一笑，可惜他更多的只是看着她的背影和一头漂亮的头发。她的头发很好，简直可以去做洗发水广告，每天还会散发着很好闻的清香。他是个腼腆的男孩，不善言辞，而她也是个文静的女生，所以，一学期结束了，他们说过的话不过十句。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　直到第一学期的期末，参加社团，他擅长小提琴，而她擅长钢琴，老师要求他俩合作一曲。他心里很激动，刚开始排练的时候，两人没有默契，总配合不好，排练老师叫他们多交流，于是他们就互留了QQ号。他加了她的QQ，发现她的空间里写满了忧伤，有一天她的QQ签名写着：何处为家？身心流浪。他猛然地心疼，就大胆地与她聊天。原来她的父母离异，她随母亲再嫁，继父家开了一家小公司，有一个哥哥，她尊重哥哥，但并不喜欢，母亲和继父却一直都希望她将来嫁给哥哥，继承家业，一想到大学毕业就要回家结婚，是件多么悲催的事情，她感到前途一片渺茫。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　这激起了他的保护欲，他想要拯救她，并开始处处关心她，终于博得她的好感，他俩暗生情愫，琴瑟相依，合作得很精彩。大学的后三年生活，是他们彼此最幸福的时光，他无微不至地照顾她，许她一个美好的未来。毕业时，他决定去她家拜见她的父母，继父知道后，只是默默地走开，没想到母亲态度却很强硬，不同意！</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　母亲禁止她出门，不让她去见他，她想偷偷地溜走，没想到母亲说，如果敢再见他，就喝农药，死在她面前，母亲辛苦把她拉扯大，她不能辜负母亲。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　于是，她放弃了，决定结婚，而他远走他乡，肆意流浪，似乎远离那个没有她的城市，他才会忘掉曾经那段情感的伤痛。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　多年以后，他们再一次相遇，是在一家商场，她早已挽起了长发，高高盘起的发簪，少了当年的青涩，显出着女人的韵味，老公体贴地抱着孩子，她一脸幸福地看着他们，而他也已经有自己的公司，身边带着漂亮的妻子和可爱的儿子。他们相视一笑，擦肩而过的那一刻，他发现自己曾经的伤口虽然还在，但已不再那么痛了。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　愛了并不一定就要得到，看着她过得幸福，他还有什么理由不祝福她。多年的情感和遗憾，在那一刻释怀了，原来他们只是携手走过了一段青春，但有缘无分。有些爱情注定没有结果，虽然当初那么坚持，但是仍然输给了现实。当时间冲淡了心中的那份执念，回到柴米油盐的生活中，才发现我们已成为彼此最熟悉的陌生人。</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　</span><br style=\"padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 16px; background-color: rgb(254, 255, 251);\">　　偶尔触动心底的那根弦，会泛起涟漪，还会忆起与青春有关的回忆，但平静之后，仍是好好地生活。尽管曾经付出了真爱，爱得轰轰烈烈，但最终陪伴你身边的是千年修得共枕眠的人。尘缘如梦，梦醒无踪，曾经的一切都已成为过眼云烟，就在念与不念间，莞尔一笑，身后已学会了云淡风轻。曾经的你，如今已成了隔岸的风景。</span><br></p>', 1, 0, 0, 0, 1678076173960, 0);

-- ----------------------------
-- Table structure for t_comment
-- ----------------------------
DROP TABLE IF EXISTS `t_comment`;
CREATE TABLE `t_comment`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键，唯一标识',
  `active` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '评论是否存在，1：存在，0：已删除',
  `blog_id` int(10) UNSIGNED NOT NULL COMMENT '博文ID，在哪篇博文下的评论',
  `user_id` int(10) UNSIGNED NOT NULL COMMENT '评论发送者ID',
  `reply_id` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '被回复的评论ID',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '回复的内容',
  `create_timestamp` bigint(20) UNSIGNED NOT NULL COMMENT '回复时间',
  `update_timestamp` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 160 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of t_comment
-- ----------------------------
INSERT INTO `t_comment` VALUES (6, 1, 9, 20, 0, '范进中举后的命运如何了？', 1677165395220, 0);
INSERT INTO `t_comment` VALUES (22, 1, 35, 20, 0, '脱下鞋子跳舞，赤着脚太空漫步', 1677169610417, 0);
INSERT INTO `t_comment` VALUES (23, 1, 35, 20, 0, '我笑了你还装酷，阳光晒过的路', 1677169615957, 0);
INSERT INTO `t_comment` VALUES (24, 1, 35, 20, 0, '正好是年轻的温度，温暖舒服', 1677169621422, 0);
INSERT INTO `t_comment` VALUES (25, 1, 35, 20, 0, '吵醒了闹区的树木，吸一口纯氧就漂浮', 1677169628462, 0);
INSERT INTO `t_comment` VALUES (26, 1, 35, 20, 0, '蓝色背景下我练习飞行的角度，保持我的态度', 1677169633883, 0);
INSERT INTO `t_comment` VALUES (27, 1, 35, 20, 0, '我的未来式由我做主，跳整天的舞玩耍整片屏幕', 1677169639227, 0);
INSERT INTO `t_comment` VALUES (28, 1, 35, 20, 0, '不断电的梦直线加速，奔跑在我画的地图', 1677169644535, 0);
INSERT INTO `t_comment` VALUES (29, 1, 35, 20, 0, '翻开了五线谱，是我涂鸦的音符', 1677169650860, 0);
INSERT INTO `t_comment` VALUES (30, 1, 35, 20, 0, '我找到我的幸福，自由平等博爱', 1677169662067, 0);
INSERT INTO `t_comment` VALUES (31, 1, 35, 20, 0, '我复古创新演出，我的天赋', 1677169677541, 0);
INSERT INTO `t_comment` VALUES (32, 1, 35, 20, 0, '吵醒了闹区的树木，吸一口纯氧就漂浮', 1677169684474, 0);
INSERT INTO `t_comment` VALUES (33, 1, 35, 20, 0, '蓝色背景下我练习飞行的角度，保持我的态度', 1677169747156, 0);
INSERT INTO `t_comment` VALUES (34, 1, 35, 20, 0, '我的未来式由我做主，每一个动作我都完整投入', 1677169799220, 0);
INSERT INTO `t_comment` VALUES (35, 1, 35, 20, 0, '不断电的你陪我加速，奔跑在我们的领土', 1677169865653, 0);
INSERT INTO `t_comment` VALUES (36, 1, 34, 20, 0, '从一个高的地方去远方', 1677170104810, 0);
INSERT INTO `t_comment` VALUES (37, 1, 34, 20, 0, '从低处回家稍纵即逝的快乐', 1677170120167, 0);
INSERT INTO `t_comment` VALUES (38, 1, 34, 20, 0, '转动的车轮它载着我', 1677170201708, 0);
INSERT INTO `t_comment` VALUES (39, 1, 34, 20, 0, '偶然遇见月光倾泻的苍白色', 1677170207582, 0);
INSERT INTO `t_comment` VALUES (40, 1, 34, 20, 0, '彩色的路标禁止通行的警告', 1677170212874, 0);
INSERT INTO `t_comment` VALUES (41, 1, 34, 20, 0, '天空之下我们轻得像羽毛', 1677170218218, 0);
INSERT INTO `t_comment` VALUES (42, 1, 34, 20, 0, '双眼是盲目的最佳玩伴\r\n', 1677170223741, 0);
INSERT INTO `t_comment` VALUES (43, 1, 34, 20, 0, '还是选择了不选择的旅途', 1677170228495, 0);
INSERT INTO `t_comment` VALUES (44, 1, 34, 20, 0, '观看了一颗流星坠毁了', 1677170233242, 0);
INSERT INTO `t_comment` VALUES (45, 1, 34, 20, 0, '所有的人会为此而难过', 1677170237911, 0);
INSERT INTO `t_comment` VALUES (46, 1, 34, 20, 0, '抱怨这城市日光太曲折', 1677170243225, 0);
INSERT INTO `t_comment` VALUES (47, 1, 34, 20, 0, '只有日光还唱歌', 1677170248590, 0);
INSERT INTO `t_comment` VALUES (48, 1, 34, 20, 0, '明媚的角落反射着光芒', 1677170253517, 0);
INSERT INTO `t_comment` VALUES (49, 1, 34, 20, 0, '蝴蝶飞过城市高楼开出了花', 1677170258161, 0);
INSERT INTO `t_comment` VALUES (50, 1, 34, 20, 0, '被它唤醒的生命短暂一瞬', 1677170263262, 0);
INSERT INTO `t_comment` VALUES (51, 1, 34, 20, 0, '偶然丢失的彩色化作了粉末', 1677170270666, 0);
INSERT INTO `t_comment` VALUES (55, 1, 45, 20, 0, '向着那阳光！', 1677170346859, 0);
INSERT INTO `t_comment` VALUES (56, 1, 45, 20, 0, '因为我已动身准备去远方，在花绽放的风中，向着那阳光。', 1677170352560, 0);
INSERT INTO `t_comment` VALUES (57, 1, 45, 20, 0, '也许你也会嘲笑我，那愚蠢的模样。', 1677170357969, 0);
INSERT INTO `t_comment` VALUES (58, 1, 45, 20, 0, '不顾及那世俗的眼光。', 1677170363382, 0);
INSERT INTO `t_comment` VALUES (59, 1, 45, 20, 0, '不会再胆怯，不会再慌张。', 1677170368655, 0);
INSERT INTO `t_comment` VALUES (60, 1, 45, 20, 0, '我乘着风破浪。', 1677170374012, 0);
INSERT INTO `t_comment` VALUES (61, 1, 45, 20, 0, '在那无垠的晴空下，', 1677170379485, 0);
INSERT INTO `t_comment` VALUES (62, 1, 45, 20, 0, '因为我已动身准备去远方，在花绽放的风中。', 1677170387926, 0);
INSERT INTO `t_comment` VALUES (63, 1, 45, 20, 0, '也许你也会嘲笑我，那愚蠢的模样。', 1677170393513, 0);
INSERT INTO `t_comment` VALUES (64, 1, 45, 20, 0, '不顾及那世俗的眼光。', 1677170399338, 0);
INSERT INTO `t_comment` VALUES (65, 1, 45, 20, 0, '不会再胆怯，不会再慌张。', 1677170404550, 0);
INSERT INTO `t_comment` VALUES (66, 1, 45, 20, 0, '我乘着风破浪。', 1677170410375, 0);
INSERT INTO `t_comment` VALUES (67, 1, 45, 20, 0, '在那无垠的晴空下，', 1677170415917, 0);
INSERT INTO `t_comment` VALUES (68, 1, 45, 20, 0, '向着那阳光！', 1677170423750, 0);
INSERT INTO `t_comment` VALUES (69, 1, 45, 20, 0, '因为我已动身准备去远方，在花绽放的风中，向着那阳光。', 1677170429101, 0);
INSERT INTO `t_comment` VALUES (70, 1, 45, 20, 0, '也许你也会嘲笑我，那愚蠢的模样。', 1677170434505, 0);
INSERT INTO `t_comment` VALUES (71, 1, 45, 20, 0, '不顾及那世俗的眼光。', 1677170439808, 0);
INSERT INTO `t_comment` VALUES (72, 1, 45, 20, 0, '不会再胆怯，不会再慌张。', 1677170445121, 0);
INSERT INTO `t_comment` VALUES (73, 1, 45, 20, 0, '我乘着风破浪。', 1677170450513, 0);
INSERT INTO `t_comment` VALUES (74, 1, 45, 20, 0, '在那无垠的晴空下，', 1677170455981, 0);
INSERT INTO `t_comment` VALUES (75, 1, 45, 20, 0, '就是能追逐着太阳。', 1677170461497, 0);
INSERT INTO `t_comment` VALUES (76, 1, 45, 20, 0, '我许过，那唯一微小的愿望。', 1677170467162, 0);
INSERT INTO `t_comment` VALUES (77, 1, 45, 20, 0, '却胆怯，只敢被低调地伪装。', 1677170472403, 0);
INSERT INTO `t_comment` VALUES (78, 1, 45, 20, 0, '我想过，像花朵一样地绽放。', 1677170479093, 0);
INSERT INTO `t_comment` VALUES (79, 1, 45, 20, 0, '因为我已动身准备去远方，在花绽放的风中，向着那阳光。', 1677170484432, 0);
INSERT INTO `t_comment` VALUES (80, 1, 45, 20, 0, '也许你也会嘲笑我，那愚蠢的模样。', 1677170489805, 0);
INSERT INTO `t_comment` VALUES (81, 1, 45, 20, 0, '不顾及那世俗的眼光。', 1677170495508, 0);
INSERT INTO `t_comment` VALUES (82, 1, 45, 20, 0, '不会再胆怯，不会再慌张。', 1677170500847, 0);
INSERT INTO `t_comment` VALUES (83, 1, 45, 20, 0, '我乘着风破浪。', 1677170506071, 0);
INSERT INTO `t_comment` VALUES (84, 1, 45, 20, 0, '在那无垠的晴空下，', 1677170511427, 0);
INSERT INTO `t_comment` VALUES (85, 1, 45, 20, 0, '就是能追逐着太阳。', 1677170517329, 0);
INSERT INTO `t_comment` VALUES (86, 1, 45, 20, 0, '我许过，那唯一微小的愿望。', 1677170522638, 0);
INSERT INTO `t_comment` VALUES (87, 1, 45, 20, 0, '却忘了，那零星赞美的眼光。', 1677170528065, 0);
INSERT INTO `t_comment` VALUES (88, 1, 45, 20, 0, '我听过，无数的蜚语与诽谤。', 1677170533691, 0);
INSERT INTO `t_comment` VALUES (89, 1, 45, 20, 0, '却被现实击退埋藏。', 1677170539523, 0);
INSERT INTO `t_comment` VALUES (90, 1, 45, 20, 0, '我有过，那美好的小小梦想。', 1677170544790, 0);
INSERT INTO `t_comment` VALUES (91, 1, 45, 20, 0, '却胆怯，只敢被低调地伪装。', 1677170550097, 0);
INSERT INTO `t_comment` VALUES (92, 1, 45, 20, 0, '我想过，像花朵一样地绽放。', 1677170556661, 0);
INSERT INTO `t_comment` VALUES (116, 1, 59, 25, 0, '这是ChatGPT写的文章？', 1677637774292, 0);
INSERT INTO `t_comment` VALUES (117, 1, 16, 32, 0, '小时候喜欢躺在谷塘里看星星，现在看不到了', 1677857909874, 0);
INSERT INTO `t_comment` VALUES (118, 1, 16, 20, 117, '我也喜欢，哈哈', 1677858160790, 0);
INSERT INTO `t_comment` VALUES (119, 1, 22, 32, 0, '人民万岁', 1677858216470, 0);
INSERT INTO `t_comment` VALUES (120, 1, 16, 31, 117, '现在看到的夜晚的天空都是灰蒙蒙的', 1677858295861, 0);
INSERT INTO `t_comment` VALUES (121, 1, 62, 31, 0, '喜欢秋天的稻谷，金灿灿的 哈哈 ^_^', 1677858453196, 0);
INSERT INTO `t_comment` VALUES (122, 1, 35, 30, 27, '赞', 1677858515834, 0);
INSERT INTO `t_comment` VALUES (123, 1, 62, 30, 121, '味道也好好闻', 1677858539511, 0);
INSERT INTO `t_comment` VALUES (124, 1, 61, 30, 0, '真厉害 ', 1677858575390, 0);
INSERT INTO `t_comment` VALUES (125, 1, 66, 31, 0, '看到最后，甜甜的，哈哈哈', 1677859745672, 0);
INSERT INTO `t_comment` VALUES (126, 1, 66, 30, 0, '论两人如何互相暗恋还能保持单身……', 1677859880291, 0);
INSERT INTO `t_comment` VALUES (127, 1, 66, 35, 125, '嘻嘻', 1677859885311, 0);
INSERT INTO `t_comment` VALUES (128, 1, 66, 32, 126, '真实 qwq', 1677859963939, 0);
INSERT INTO `t_comment` VALUES (129, 1, 61, 27, 124, '谢谢 ♪(･ω･)ﾉ   哈哈', 1677860016826, 0);
INSERT INTO `t_comment` VALUES (130, 1, 48, 27, 0, '人生苦短，我用Python', 1677860056449, 0);
INSERT INTO `t_comment` VALUES (131, 1, 48, 31, 0, 'PHP是世界上最好的语言', 1677860186564, 0);
INSERT INTO `t_comment` VALUES (132, 1, 12, 31, 0, '丞相！！！', 1677860229912, 0);
INSERT INTO `t_comment` VALUES (133, 1, 59, 31, 116, '看起来是的', 1677860260990, 0);
INSERT INTO `t_comment` VALUES (134, 1, 16, 35, 120, '彩虹色的 @_@', 1677860456623, 0);
INSERT INTO `t_comment` VALUES (135, 1, 16, 31, 134, '૮₍ ｡•.•｡₎ა', 1677860479942, 0);
INSERT INTO `t_comment` VALUES (136, 1, 48, 30, 0, 'HTML + JavaScript 最方便，哈哈', 1677860597004, 0);
INSERT INTO `t_comment` VALUES (137, 1, 48, 20, 130, '我也是用的Python', 1677860774631, 0);
INSERT INTO `t_comment` VALUES (138, 1, 48, 27, 137, 'haha ~', 1677861058227, 0);
INSERT INTO `t_comment` VALUES (139, 1, 45, 32, 0, '以前的好多好朋友都没有再联系了', 1677862067483, 0);
INSERT INTO `t_comment` VALUES (140, 1, 45, 31, 139, '哈哈，之前天真的以为就是一辈子的好朋友，没想到还是被时间磨平了棱角', 1677862120148, 0);
INSERT INTO `t_comment` VALUES (141, 1, 17, 32, 0, '故乡是一个让人难忘的地方', 1677862216028, 0);
INSERT INTO `t_comment` VALUES (142, 1, 17, 39, 141, '哈哈哈，明天回家一下', 1677863037517, 0);
INSERT INTO `t_comment` VALUES (143, 1, 34, 39, 0, '像我，一个腼腆害羞而又内向的女孩，哈哈哈', 1677863106746, 0);
INSERT INTO `t_comment` VALUES (144, 1, 48, 39, 0, '我C语言快学完了～', 1677863147670, 0);
INSERT INTO `t_comment` VALUES (145, 1, 45, 39, 140, '难怪最近变圆了 ○', 1677863232689, 0);
INSERT INTO `t_comment` VALUES (146, 1, 61, 39, 0, '我C语言都还没学完 (⊙o⊙)', 1677863408041, 0);
INSERT INTO `t_comment` VALUES (147, 1, 19, 39, 0, '时光如流水', 1677863635118, 0);
INSERT INTO `t_comment` VALUES (148, 1, 59, 29, 116, '是的，NewBing', 1677899543716, 0);
INSERT INTO `t_comment` VALUES (149, 1, 34, 29, 143, '是的', 1677899679041, 0);
INSERT INTO `t_comment` VALUES (150, 1, 48, 29, 144, '学完请你吃烧烤大餐！', 1677899712846, 0);
INSERT INTO `t_comment` VALUES (151, 1, 45, 29, 0, '能点个赞也不错', 1677899783847, 0);
INSERT INTO `t_comment` VALUES (152, 1, 21, 29, 0, '睡前喝牛奶 *v*', 1677899831955, 0);
INSERT INTO `t_comment` VALUES (153, 1, 16, 40, 117, '躺在谷堆上，嘿嘿', 1677900946983, 0);
INSERT INTO `t_comment` VALUES (154, 1, 34, 40, 0, '这种感觉怪怪的', 1677901000010, 0);
INSERT INTO `t_comment` VALUES (155, 1, 16, 36, 0, '真不错', 1677902235707, 0);
INSERT INTO `t_comment` VALUES (156, 1, 34, 41, 0, '加油~', 1677902508149, 0);
INSERT INTO `t_comment` VALUES (157, 1, 17, 29, 0, '希望是本无所谓有，无所谓无的。这正如地上的路；其实地上本没有路，走的人多了，也便成了路。', 1678032963009, 0);
INSERT INTO `t_comment` VALUES (158, 1, 17, 41, 157, '只空有希望而不去奋斗、追求，希望便“无所谓有”；\n有了希望并始终不渝地斗争、实践，希望便“无所谓无”。\n人们都向着希望之路快跑，就会迎来新生活！', 1678033841373, 0);
INSERT INTO `t_comment` VALUES (159, 1, 66, 27, 0, '有美人兮志在山野居  ヾ(^▽^*)))', 1678628662247, 0);

-- ----------------------------
-- Table structure for t_like
-- ----------------------------
DROP TABLE IF EXISTS `t_like`;
CREATE TABLE `t_like`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态：1点赞，-1反对，0取消',
  `user_id` int(10) UNSIGNED NOT NULL COMMENT '点赞的用户',
  `blog_id` int(10) UNSIGNED NOT NULL COMMENT '被点赞的文章',
  `create_timestamp` bigint(20) UNSIGNED NOT NULL COMMENT '点赞的时间',
  `update_timestamp` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最后一次修改的时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 122 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of t_like
-- ----------------------------
INSERT INTO `t_like` VALUES (3, 1, 27, 51, 1676647855799, 0);
INSERT INTO `t_like` VALUES (33, 1, 27, 22, 1676953183645, 0);
INSERT INTO `t_like` VALUES (34, 1, 20, 17, 1677857500302, 0);
INSERT INTO `t_like` VALUES (35, 1, 31, 17, 1677857705543, 0);
INSERT INTO `t_like` VALUES (36, -1, 27, 15, 1677857757594, 0);
INSERT INTO `t_like` VALUES (37, 1, 32, 16, 1677857852858, 0);
INSERT INTO `t_like` VALUES (38, 1, 32, 17, 1677858193133, 0);
INSERT INTO `t_like` VALUES (39, 1, 32, 22, 1677858200942, 0);
INSERT INTO `t_like` VALUES (40, 1, 32, 45, 1677858244761, 0);
INSERT INTO `t_like` VALUES (41, 1, 31, 16, 1677858255119, 0);
INSERT INTO `t_like` VALUES (42, 1, 31, 51, 1677858348786, 0);
INSERT INTO `t_like` VALUES (43, 1, 31, 24, 1677858359285, 0);
INSERT INTO `t_like` VALUES (44, 1, 31, 62, 1677858365220, 0);
INSERT INTO `t_like` VALUES (45, 1, 30, 35, 1677858475089, 0);
INSERT INTO `t_like` VALUES (46, 1, 30, 62, 1677858552337, 0);
INSERT INTO `t_like` VALUES (47, 1, 30, 61, 1677858574528, 0);
INSERT INTO `t_like` VALUES (48, 1, 35, 66, 1677859704263, 0);
INSERT INTO `t_like` VALUES (49, 1, 31, 66, 1677859745111, 0);
INSERT INTO `t_like` VALUES (50, 1, 27, 35, 1677860036095, 0);
INSERT INTO `t_like` VALUES (51, 1, 27, 48, 1677860046361, 0);
INSERT INTO `t_like` VALUES (52, 1, 31, 6, 1677860079845, 0);
INSERT INTO `t_like` VALUES (53, 1, 31, 8, 1677860112757, 0);
INSERT INTO `t_like` VALUES (54, 1, 31, 22, 1677860125961, 0);
INSERT INTO `t_like` VALUES (55, 1, 31, 48, 1677860164004, 0);
INSERT INTO `t_like` VALUES (56, 1, 31, 12, 1677860209641, 0);
INSERT INTO `t_like` VALUES (57, 1, 27, 17, 1677860299684, 0);
INSERT INTO `t_like` VALUES (58, 1, 35, 16, 1677860395772, 0);
INSERT INTO `t_like` VALUES (59, 1, 30, 16, 1677860515927, 0);
INSERT INTO `t_like` VALUES (60, 1, 30, 22, 1677860519438, 0);
INSERT INTO `t_like` VALUES (61, 1, 30, 17, 1677860525507, 0);
INSERT INTO `t_like` VALUES (62, 1, 30, 48, 1677860535786, 0);
INSERT INTO `t_like` VALUES (63, 1, 30, 45, 1677860606270, 0);
INSERT INTO `t_like` VALUES (64, 1, 32, 6, 1677860648738, 0);
INSERT INTO `t_like` VALUES (65, -1, 32, 66, 1677860806052, 0);
INSERT INTO `t_like` VALUES (66, 1, 20, 16, 1677861004366, 0);
INSERT INTO `t_like` VALUES (67, 1, 27, 16, 1677861039838, 0);
INSERT INTO `t_like` VALUES (68, 1, 32, 11, 1677861110543, 0);
INSERT INTO `t_like` VALUES (69, 1, 32, 18, 1677861118102, 0);
INSERT INTO `t_like` VALUES (70, 1, 20, 22, 1677861636394, 0);
INSERT INTO `t_like` VALUES (71, 1, 20, 51, 1677861651338, 0);
INSERT INTO `t_like` VALUES (72, 1, 20, 62, 1677861655986, 0);
INSERT INTO `t_like` VALUES (73, 1, 20, 12, 1677861662433, 0);
INSERT INTO `t_like` VALUES (74, 1, 20, 34, 1677861674852, 0);
INSERT INTO `t_like` VALUES (75, 1, 32, 34, 1677861692968, 0);
INSERT INTO `t_like` VALUES (76, 1, 31, 34, 1677861712613, 0);
INSERT INTO `t_like` VALUES (77, 1, 32, 44, 1677861739032, 0);
INSERT INTO `t_like` VALUES (78, 1, 39, 16, 1677862999017, 0);
INSERT INTO `t_like` VALUES (79, 1, 39, 34, 1677863053771, 0);
INSERT INTO `t_like` VALUES (80, 1, 39, 48, 1677863146727, 0);
INSERT INTO `t_like` VALUES (81, 1, 39, 6, 1677863250896, 0);
INSERT INTO `t_like` VALUES (82, 1, 39, 11, 1677863367938, 0);
INSERT INTO `t_like` VALUES (83, 1, 39, 61, 1677863379673, 0);
INSERT INTO `t_like` VALUES (84, 1, 39, 9, 1677863448373, 0);
INSERT INTO `t_like` VALUES (85, 1, 39, 50, 1677863480575, 0);
INSERT INTO `t_like` VALUES (86, 1, 39, 27, 1677863489989, 0);
INSERT INTO `t_like` VALUES (87, 1, 39, 59, 1677863500806, 0);
INSERT INTO `t_like` VALUES (88, 1, 39, 10, 1677863525215, 0);
INSERT INTO `t_like` VALUES (89, 1, 39, 18, 1677863577998, 0);
INSERT INTO `t_like` VALUES (90, 1, 39, 19, 1677863616498, 0);
INSERT INTO `t_like` VALUES (91, 1, 39, 29, 1677863656142, 0);
INSERT INTO `t_like` VALUES (92, 1, 29, 34, 1677899661231, 0);
INSERT INTO `t_like` VALUES (93, 1, 29, 48, 1677899690759, 0);
INSERT INTO `t_like` VALUES (94, 1, 29, 6, 1677899728365, 0);
INSERT INTO `t_like` VALUES (95, 1, 29, 45, 1677899739861, 0);
INSERT INTO `t_like` VALUES (96, 1, 29, 21, 1677899799832, 0);
INSERT INTO `t_like` VALUES (97, 1, 29, 16, 1677899849652, 0);
INSERT INTO `t_like` VALUES (98, 1, 29, 17, 1677899875672, 0);
INSERT INTO `t_like` VALUES (99, 1, 36, 17, 1677900000426, 0);
INSERT INTO `t_like` VALUES (100, 1, 36, 16, 1677900054798, 0);
INSERT INTO `t_like` VALUES (101, 1, 36, 34, 1677900323317, 0);
INSERT INTO `t_like` VALUES (102, 1, 36, 6, 1677900386165, 0);
INSERT INTO `t_like` VALUES (103, 1, 40, 16, 1677900920765, 0);
INSERT INTO `t_like` VALUES (104, 1, 40, 34, 1677900967045, 0);
INSERT INTO `t_like` VALUES (105, 1, 40, 6, 1677901007261, 0);
INSERT INTO `t_like` VALUES (106, 1, 40, 45, 1677901021827, 0);
INSERT INTO `t_like` VALUES (107, 1, 41, 16, 1677901200365, 0);
INSERT INTO `t_like` VALUES (108, 1, 36, 39, 1677902129445, 0);
INSERT INTO `t_like` VALUES (109, 1, 36, 45, 1677902146182, 0);
INSERT INTO `t_like` VALUES (110, 1, 36, 35, 1677902183552, 0);
INSERT INTO `t_like` VALUES (111, 1, 41, 10, 1677902425343, 0);
INSERT INTO `t_like` VALUES (112, 1, 39, 17, 1677947928866, 0);
INSERT INTO `t_like` VALUES (113, 1, 41, 17, 1678033566085, 0);
INSERT INTO `t_like` VALUES (114, 1, 40, 17, 1678071423167, 0);
INSERT INTO `t_like` VALUES (115, 1, 40, 70, 1678071456847, 0);
INSERT INTO `t_like` VALUES (116, 1, 39, 70, 1678071466409, 0);
INSERT INTO `t_like` VALUES (117, 1, 36, 71, 1678072312224, 0);
INSERT INTO `t_like` VALUES (118, 1, 36, 72, 1678072808832, 0);
INSERT INTO `t_like` VALUES (119, 1, 36, 78, 1678075410926, 0);
INSERT INTO `t_like` VALUES (120, 1, 27, 66, 1678628671683, 0);
INSERT INTO `t_like` VALUES (121, -1, 27, 34, 1678628782407, 0);

-- ----------------------------
-- Table structure for t_message
-- ----------------------------
DROP TABLE IF EXISTS `t_message`;
CREATE TABLE `t_message`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键，唯一',
  `sender_id` int(10) UNSIGNED NOT NULL COMMENT '发送者ID，0 为 系统发送',
  `receiver_id` int(10) UNSIGNED NOT NULL COMMENT '接收者ID',
  `state` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看状态：1已查看，0未查看',
  `target_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '目标链接',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '消息标题',
  `content` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '消息内容',
  `msg_type` tinyint(3) UNSIGNED NOT NULL COMMENT '消息类型：1回复，2提到，3点赞，4系统消息',
  `create_timestamp` bigint(20) UNSIGNED NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 382 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of t_message
-- ----------------------------
INSERT INTO `t_message` VALUES (274, 27, 20, 1, '/read.jsp?i=22', '你的文章《开国大典》收到了第一个赞', '你在博客上发表的文章《开国大典》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1676953183646);
INSERT INTO `t_message` VALUES (312, 31, 20, 1, '/read.jsp?i=17', '你的文章《故乡》收到了第一个赞', '你在博客上发表的文章《故乡》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677857705557);
INSERT INTO `t_message` VALUES (313, 32, 20, 1, '/read.jsp?i=16', '你的文章《繁星》收到了第一个赞', '你在博客上发表的文章《繁星》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677857852870);
INSERT INTO `t_message` VALUES (314, 32, 20, 1, '/read.jsp?i=16#commentItem117', '<strong>初夏</strong> 对我的博文发表了评论', '在<strong>《繁星》</strong>中说：小时候喜欢躺在谷塘里看星星，现在看不到了', 1, 1677857909880);
INSERT INTO `t_message` VALUES (315, 20, 32, 1, '/read.jsp?i=16#commentItem118', '<strong>敏Ymm</strong> 回复了我的评论', '在<strong>《繁星》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@半夏琉璃 ：</a>我也喜欢，哈哈<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">半夏琉璃：小时候喜欢躺在谷塘里看星星，现在看不到了</p>', 2, 1677858160801);
INSERT INTO `t_message` VALUES (316, 32, 20, 1, '/read.jsp?i=22#commentItem119', '<strong>半夏琉璃</strong> 对我的博文发表了评论', '在<strong>《开国大典》</strong>中说：人民万岁', 1, 1677858216475);
INSERT INTO `t_message` VALUES (317, 32, 20, 1, '/read.jsp?i=45', '你的文章《Ta恋爱了，我只能点个赞……》收到了第一个赞', '你在博客上发表的文章《Ta恋爱了，我只能点个赞……》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858244771);
INSERT INTO `t_message` VALUES (318, 31, 32, 1, '/read.jsp?i=16#commentItem120', '<strong>_清风来叙</strong> 回复了我的评论', '在<strong>《繁星》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@半夏琉璃 ：</a>现在看到的夜晚的天空都是灰蒙蒙的<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">半夏琉璃：小时候喜欢躺在谷塘里看星星，现在看不到了</p>', 2, 1677858295875);
INSERT INTO `t_message` VALUES (319, 31, 27, 1, '/read.jsp?i=51', '你的文章《草船借箭》收到了第一个赞', '你在博客上发表的文章《草船借箭》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858348804);
INSERT INTO `t_message` VALUES (320, 31, 20, 1, '/read.jsp?i=24', '你的文章《少女时代》收到了第一个赞', '你在博客上发表的文章《少女时代》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858359304);
INSERT INTO `t_message` VALUES (321, 31, 30, 1, '/read.jsp?i=62', '你的文章《秋天的雨》收到了第一个赞', '你在博客上发表的文章《秋天的雨》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858365238);
INSERT INTO `t_message` VALUES (322, 31, 30, 1, '/read.jsp?i=62#commentItem121', '<strong>_清风来叙</strong> 对我的博文发表了评论', '在<strong>《秋天的雨》</strong>中说：喜欢秋天的稻谷，金灿灿的 哈哈 ^_^', 1, 1677858453203);
INSERT INTO `t_message` VALUES (323, 30, 20, 1, '/read.jsp?i=35', '你的文章《“留言式”聊天：我…回，你回我是轮回》收到了第一个赞', '你在博客上发表的文章《“留言式”聊天：我回你是秒回，你回我是轮回》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858475106);
INSERT INTO `t_message` VALUES (324, 30, 20, 1, '/read.jsp?i=35#commentItem122', '<strong>脆脆鱼</strong> 回复了我的评论', '在<strong>《“留言式”聊天：我回你是秒回，你回我是…》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@敏Ymm ：</a>赞<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">敏Ymm：我的未来式由我做主，跳整天的舞玩耍整片屏幕</p>', 2, 1677858515849);
INSERT INTO `t_message` VALUES (325, 30, 31, 1, '/read.jsp?i=62#commentItem123', '<strong>脆脆鱼</strong> 回复了我的评论', '在<strong>《秋天的雨》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@_清风来叙 ：</a>味道也好好闻<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">_清风来叙：喜欢秋天的稻谷，金灿灿的 哈哈 ^_^</p>', 2, 1677858539525);
INSERT INTO `t_message` VALUES (326, 30, 27, 1, '/read.jsp?i=61', '你的文章《Java提取${.…位符并组装对应值》收到了第一个赞', '你在博客上发表的文章《Java提取${...}占位符并组装对应值》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677858574535);
INSERT INTO `t_message` VALUES (327, 30, 27, 1, '/read.jsp?i=61#commentItem124', '<strong>脆脆鱼</strong> 对我的博文发表了评论', '在<strong>《Java提取${..…占位符并组装对应值》</strong>中说：真厉害 ', 1, 1677858575405);
INSERT INTO `t_message` VALUES (328, 31, 35, 0, '/read.jsp?i=66', '你的文章《染琪不绣花》收到了第一个赞', '你在博客上发表的文章《染琪不绣花》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677859745126);
INSERT INTO `t_message` VALUES (329, 31, 35, 0, '/read.jsp?i=66#commentItem125', '<strong>_清风来叙</strong> 对我的博文发表了评论', '在<strong>《染琪不绣花》</strong>中说：看到最后，甜甜的，哈哈哈', 1, 1677859745686);
INSERT INTO `t_message` VALUES (330, 30, 35, 0, '/read.jsp?i=66#commentItem126', '<strong>脆脆鱼</strong> 对我的博文发表了评论', '在<strong>《染琪不绣花》</strong>中说：论两人如何互相暗恋还能保持单身……', 1, 1677859880305);
INSERT INTO `t_message` VALUES (331, 35, 31, 1, '/read.jsp?i=66#commentItem127', '<strong>苏绣姑娘</strong> 回复了我的评论', '在<strong>《染琪不绣花》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@_清风来叙 ：</a>嘻嘻<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">_清风来叙：看到最后，甜甜的，哈哈哈</p>', 2, 1677859885315);
INSERT INTO `t_message` VALUES (332, 32, 30, 0, '/read.jsp?i=66#commentItem128', '<strong>半夏琉璃</strong> 回复了我的评论', '在<strong>《染琪不绣花》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@脆脆鱼 ：</a>真实 qwq<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">脆脆鱼：论两人如何互相暗恋还能保持单身……</p>', 2, 1677859963952);
INSERT INTO `t_message` VALUES (333, 27, 30, 0, '/read.jsp?i=61#commentItem129', '<strong>玉米子</strong> 回复了我的评论', '在<strong>《Java提取${...}占位符并组装对…》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@脆脆鱼 ：</a>谢谢 ♪(･ω･)ﾉ   哈哈<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">脆脆鱼：真厉害 </p>', 2, 1677860016830);
INSERT INTO `t_message` VALUES (334, 27, 20, 1, '/read.jsp?i=48', '你的文章《那些意欲取代 C+…语言，成功了吗？》收到了第一个赞', '你在博客上发表的文章《那些意欲取代 C++ 的编程语言，成功了吗？》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677860046368);
INSERT INTO `t_message` VALUES (335, 27, 20, 1, '/read.jsp?i=48#commentItem130', '<strong>玉米子</strong> 对我的博文发表了评论', '在<strong>《那些意欲取代 C++…程语言，成功了吗？》</strong>中说：人生苦短，我用Python', 1, 1677860056466);
INSERT INTO `t_message` VALUES (336, 31, 20, 1, '/read.jsp?i=6', '你的文章《沁园春 · 雪》收到了第一个赞', '你在博客上发表的文章《沁园春 · 雪》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677860079860);
INSERT INTO `t_message` VALUES (337, 31, 20, 1, '/read.jsp?i=8', '你的文章《祖国啊，我亲爱的祖国》收到了第一个赞', '你在博客上发表的文章《祖国啊，我亲爱的祖国》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677860112779);
INSERT INTO `t_message` VALUES (338, 31, 20, 1, '/read.jsp?i=48#commentItem131', '<strong>_清风来叙</strong> 对我的博文发表了评论', '在<strong>《那些意欲取代 C++…程语言，成功了吗？》</strong>中说：PHP是世界上最好的语言', 1, 1677860186577);
INSERT INTO `t_message` VALUES (339, 31, 20, 1, '/read.jsp?i=12', '你的文章《出师表》收到了第一个赞', '你在博客上发表的文章《出师表》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677860209655);
INSERT INTO `t_message` VALUES (340, 31, 20, 1, '/read.jsp?i=12#commentItem132', '<strong>_清风来叙</strong> 对我的博文发表了评论', '在<strong>《出师表》</strong>中说：丞相！！！', 1, 1677860229927);
INSERT INTO `t_message` VALUES (341, 35, 31, 1, '/read.jsp?i=16#commentItem134', '<strong>苏绣姑娘</strong> 回复了我的评论', '在<strong>《繁星》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@_清风来叙 ：</a>彩虹色的 @_@<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">_清风来叙：现在看到的夜晚的天空都是灰蒙蒙的</p>', 2, 1677860456638);
INSERT INTO `t_message` VALUES (342, 31, 35, 0, '/read.jsp?i=16#commentItem135', '<strong>_清风来叙</strong> 回复了我的评论', '在<strong>《繁星》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@苏绣姑娘 ：</a>૮₍ ｡•.•｡₎ა<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">苏绣姑娘：彩虹色的 @_@</p>', 2, 1677860479957);
INSERT INTO `t_message` VALUES (343, 30, 20, 1, '/read.jsp?i=48#commentItem136', '<strong>脆脆鱼</strong> 对我的博文发表了评论', '在<strong>《那些意欲取代 C++…程语言，成功了吗？》</strong>中说：HTML + JavaScript 最方便，哈哈', 1, 1677860597018);
INSERT INTO `t_message` VALUES (344, 20, 27, 1, '/read.jsp?i=48#commentItem137', '<strong>敏Ymm</strong> 回复了我的评论', '在<strong>《那些意欲取代 C++ 的编程语言，成功…》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@玉米子 ：</a>我也是用的Python<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">玉米子：人生苦短，我用Python</p>', 2, 1677860774645);
INSERT INTO `t_message` VALUES (345, 27, 20, 0, '/read.jsp?i=48#commentItem138', '<strong>玉米子</strong> 回复了我的评论', '在<strong>《那些意欲取代 C++ 的编程语言，成功…》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@敏Ymm ：</a>haha ~<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">敏Ymm：我也是用的Python</p>', 2, 1677861058234);
INSERT INTO `t_message` VALUES (346, 32, 20, 0, '/read.jsp?i=11', '你的文章《苏州园林》收到了第一个赞', '你在博客上发表的文章《苏州园林》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677861110553);
INSERT INTO `t_message` VALUES (347, 32, 20, 0, '/read.jsp?i=18', '你的文章《春》收到了第一个赞', '你在博客上发表的文章《春》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677861118122);
INSERT INTO `t_message` VALUES (348, 32, 20, 0, '/read.jsp?i=34', '你的文章《我好喜欢你呀》收到了第一个赞', '你在博客上发表的文章《我好喜欢你呀》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677861692984);
INSERT INTO `t_message` VALUES (349, 32, 20, 0, '/read.jsp?i=44', '你的文章《我结婚那天你可一定要来啊》收到了第一个赞', '你在博客上发表的文章《我结婚那天你可一定要来啊》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677861739047);
INSERT INTO `t_message` VALUES (350, 32, 20, 0, '/read.jsp?i=45#commentItem139', '<strong>半夏琉璃</strong> 对我的博文发表了评论', '在<strong>《Ta恋爱了，我只能点个赞……》</strong>中说：以前的好多好朋友都没有再联系了', 1, 1677862067502);
INSERT INTO `t_message` VALUES (351, 31, 32, 0, '/read.jsp?i=45#commentItem140', '<strong>_清风来叙</strong> 回复了我的评论', '在<strong>《Ta恋爱了，我只能点个赞……》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@半夏琉璃 ：</a>哈哈，之前天真的以为就是一辈子的好朋友，没想到还是被时间磨平了棱角<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">半夏琉璃：以前的好多好朋友都没有再联系了</p>', 2, 1677862120165);
INSERT INTO `t_message` VALUES (352, 32, 20, 0, '/read.jsp?i=17#commentItem141', '<strong>半夏琉璃</strong> 对我的博文发表了评论', '在<strong>《故乡》</strong>中说：故乡是一个让人难忘的地方', 1, 1677862216041);
INSERT INTO `t_message` VALUES (353, 39, 32, 0, '/read.jsp?i=17#commentItem142', '<strong>大可</strong> 回复了我的评论', '在<strong>《故乡》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@半夏琉璃 ：</a>哈哈哈，明天回家一下<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">半夏琉璃：故乡是一个让人难忘的地方</p>', 2, 1677863037539);
INSERT INTO `t_message` VALUES (354, 39, 20, 0, '/read.jsp?i=34#commentItem143', '<strong>大可</strong> 对我的博文发表了评论', '在<strong>《我好喜欢你呀》</strong>中说：像我，一个腼腆害羞而又内向的女孩，哈哈哈', 1, 1677863106754);
INSERT INTO `t_message` VALUES (355, 39, 20, 0, '/read.jsp?i=48#commentItem144', '<strong>大可</strong> 对我的博文发表了评论', '在<strong>《那些意欲取代 C++…程语言，成功了吗？》</strong>中说：我C语言快学完了～', 1, 1677863147677);
INSERT INTO `t_message` VALUES (356, 39, 31, 0, '/read.jsp?i=45#commentItem145', '<strong>大可</strong> 回复了我的评论', '在<strong>《Ta恋爱了，我只能点个赞……》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@_清风来叙 ：</a>难怪最近变圆了 ○<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">_清风来叙：哈哈，之前天真的以为就是一辈子的好朋友，没想到还是被时间磨平了棱角</p>', 2, 1677863232707);
INSERT INTO `t_message` VALUES (357, 39, 27, 0, '/read.jsp?i=61#commentItem146', '<strong>大可</strong> 对我的博文发表了评论', '在<strong>《Java提取${..…占位符并组装对应值》</strong>中说：我C语言都还没学完 (⊙o⊙)', 1, 1677863408059);
INSERT INTO `t_message` VALUES (358, 39, 20, 0, '/read.jsp?i=9', '你的文章《范进中举》收到了第一个赞', '你在博客上发表的文章《范进中举》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863448396);
INSERT INTO `t_message` VALUES (359, 39, 20, 0, '/read.jsp?i=50', '你的文章《程序？进程？傻傻分不清楚》收到了第一个赞', '你在博客上发表的文章《程序？进程？傻傻分不清楚》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863480595);
INSERT INTO `t_message` VALUES (360, 39, 20, 0, '/read.jsp?i=27', '你的文章《草原》收到了第一个赞', '你在博客上发表的文章《草原》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863490026);
INSERT INTO `t_message` VALUES (361, 39, 29, 1, '/read.jsp?i=59', '你的文章《Write a s…the moon》收到了第一个赞', '你在博客上发表的文章《Write a story for children about a dog who lives on the moon》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863500825);
INSERT INTO `t_message` VALUES (362, 39, 20, 0, '/read.jsp?i=10', '你的文章《从百草园到三味书屋》收到了第一个赞', '你在博客上发表的文章《从百草园到三味书屋》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863525226);
INSERT INTO `t_message` VALUES (363, 39, 20, 0, '/read.jsp?i=19', '你的文章《匆匆》收到了第一个赞', '你在博客上发表的文章《匆匆》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863616519);
INSERT INTO `t_message` VALUES (364, 39, 20, 0, '/read.jsp?i=19#commentItem147', '<strong>大可</strong> 对我的博文发表了评论', '在<strong>《匆匆》</strong>中说：时光如流水', 1, 1677863635135);
INSERT INTO `t_message` VALUES (365, 39, 20, 0, '/read.jsp?i=29', '你的文章《如何高效地学习技术》收到了第一个赞', '你在博客上发表的文章《如何高效地学习技术》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677863656161);
INSERT INTO `t_message` VALUES (366, 29, 39, 1, '/read.jsp?i=34#commentItem149', '<strong>酸炒小鱼干</strong> 回复了我的评论', '在<strong>《我好喜欢你呀》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@大可 ：</a>是的<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">大可：像我，一个腼腆害羞而又内向的女孩，哈哈哈</p>', 2, 1677899679111);
INSERT INTO `t_message` VALUES (367, 29, 39, 1, '/read.jsp?i=48#commentItem150', '<strong>酸炒小鱼干</strong> 回复了我的评论', '在<strong>《那些意欲取代 C++ 的编程语言，成功…》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@大可 ：</a>学完请你吃烧烤大餐！<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">大可：我C语言快学完了～</p>', 2, 1677899712899);
INSERT INTO `t_message` VALUES (368, 29, 20, 0, '/read.jsp?i=45#commentItem151', '<strong>酸炒小鱼干</strong> 对我的博文发表了评论', '在<strong>《Ta恋爱了，我只能点个赞……》</strong>中说：能点个赞也不错', 1, 1677899783911);
INSERT INTO `t_message` VALUES (369, 29, 20, 0, '/read.jsp?i=21', '你的文章《为什么不要空腹喝牛奶》收到了第一个赞', '你在博客上发表的文章《为什么不要空腹喝牛奶》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677899799912);
INSERT INTO `t_message` VALUES (370, 29, 20, 0, '/read.jsp?i=21#commentItem152', '<strong>酸炒小鱼干</strong> 对我的博文发表了评论', '在<strong>《为什么不要空腹喝牛奶》</strong>中说：睡前喝牛奶 *v*', 1, 1677899832019);
INSERT INTO `t_message` VALUES (371, 40, 20, 0, '/read.jsp?i=16', '你的文章《繁星》收到了十个赞', '你在博客上发表的文章《繁星》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677900920908);
INSERT INTO `t_message` VALUES (372, 40, 32, 0, '/read.jsp?i=16#commentItem153', '<strong>尘烟染暮雪</strong> 回复了我的评论', '在<strong>《繁星》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@半夏琉璃 ：</a>躺在谷堆上，嘿嘿<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">半夏琉璃：小时候喜欢躺在谷塘里看星星，现在看不到了</p>', 2, 1677900947049);
INSERT INTO `t_message` VALUES (373, 40, 20, 0, '/read.jsp?i=34#commentItem154', '<strong>尘烟染暮雪</strong> 对我的博文发表了评论', '在<strong>《我好喜欢你呀》</strong>中说：这种感觉怪怪的', 1, 1677901000061);
INSERT INTO `t_message` VALUES (374, 36, 20, 0, '/read.jsp?i=39', '你的文章《一开学就生病？做好…点摆脱开学综合征》收到了第一个赞', '你在博客上发表的文章《一开学就生病？做好这几点摆脱开学综合征》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1677902129532);
INSERT INTO `t_message` VALUES (375, 36, 20, 0, '/read.jsp?i=16#commentItem155', '<strong>一只长颈鹿</strong> 对我的博文发表了评论', '在<strong>《繁星》</strong>中说：真不错', 1, 1677902235759);
INSERT INTO `t_message` VALUES (376, 41, 20, 0, '/read.jsp?i=34#commentItem156', '<strong>静候佳音</strong> 对我的博文发表了评论', '在<strong>《我好喜欢你呀》</strong>中说：加油~', 1, 1677902508204);
INSERT INTO `t_message` VALUES (377, 29, 20, 0, '/read.jsp?i=17#commentItem157', '<strong>酸炒小鱼干</strong> 对我的博文发表了评论', '在<strong>《故乡》</strong>中说：希望是本无所谓有，无所谓无的。这正如地上的路；其实地上本没有路，走的人多了，也便成了路。', 1, 1678032963016);
INSERT INTO `t_message` VALUES (378, 41, 29, 0, '/read.jsp?i=17#commentItem158', '<strong>静候佳音</strong> 回复了我的评论', '在<strong>《故乡》</strong>中<br/>回复 <a href=\"/XiaoXiangBlog/people.jsp\">@酸炒小鱼干 ：</a>只空有希望而不去奋斗、追求，希望便“无所谓有”；\n有了希望并始终不渝地斗争、实践，希望便“无所谓无”。\n人们都向着希望之路快跑，就会迎来新生活！<p style=\"color: #aaa;border-left: #888 2px solid;padding-left: 10px;\">酸炒小鱼干：希望是本无所谓有，无所谓无的。这正如地上的路；其实地上本没有路，走的人多了，也便成了路。</p>', 2, 1678033841393);
INSERT INTO `t_message` VALUES (379, 40, 20, 0, '/read.jsp?i=17', '你的文章《故乡》收到了十个赞', '你在博客上发表的文章《故乡》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1678071423189);
INSERT INTO `t_message` VALUES (380, 40, 39, 1, '/read.jsp?i=70', '你的文章《“其实真遇上了，是…想那么多的……”》收到了第一个赞', '你在博客上发表的文章《“其实真遇上了，是不会想那么多的……”》受到了其他用户的欢迎，特此通知！希望你能再接再厉，为广大网友创作更有价值的文章！', 3, 1678071456864);
INSERT INTO `t_message` VALUES (381, 27, 35, 0, '/read.jsp?i=66#commentItem159', '<strong>玉米子</strong> 对我的博文发表了评论', '在<strong>《染琪不绣花》</strong>中说：有美人兮志在山野居  ヾ(^▽^*)))', 1, 1678628662262);

-- ----------------------------
-- Table structure for t_user
-- ----------------------------
DROP TABLE IF EXISTS `t_user`;
CREATE TABLE `t_user`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID，自动生成，唯一',
  `active` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '账号是否激活：1激活，0禁用',
  `account` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号，登录用，不可修改',
  `passwd` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '密码，登录用，MD5加密',
  `role` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '角色，0：普通，1：管理员',
  `nick` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '昵称',
  `signature` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '签名',
  `sex` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '性别，0：未设置，1：男，2：女',
  `hometown` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '家乡',
  `link` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '联系方式',
  `avatar` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '头像ID',
  `avatar_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '头像URL',
  `has_new_msg` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '新消息计数',
  `blog_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '博客数量计数',
  `blog_read_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '博客阅读计数',
  `blog_like_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '博客被点赞计数',
  `create_timestamp` bigint(20) UNSIGNED NOT NULL COMMENT '创建时间',
  `update_timestamp` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最后修改时间',
  `last_login_timestamp` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最后登录时间',
  `last_login_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '最后登录IP',
  PRIMARY KEY (`id`, `account`) USING BTREE,
  INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 42 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of t_user
-- ----------------------------
INSERT INTO `t_user` VALUES (20, 1, 'admin', '1vcu5ej743uf0h0prhgor2f19u', 1, '敏Ymm', '吾生也有涯，而知也无涯。', 1, '湖南江华', '', 99, NULL, 26, 37, 383, 71, 1677512059632, 1677849859347, 1678070481405, '127.0.0.1');
INSERT INTO `t_user` VALUES (27, 1, '13243648888', '18636p0uq0gabghr9n1s66dblt', 0, '玉米子', '吾生也有涯，而知也无涯。', 1, '瑶都', '', 101, NULL, 1, 3, 11, 5, 1676359871271, 1677856477896, 1678628594109, '192.168.30.48');
INSERT INTO `t_user` VALUES (29, 1, '18178460000', '6c53569augcutme1kepi4bnhti', 0, '酸炒小鱼干', '要知道伤心总是难免的', 0, '贺郡', '', 57, NULL, 1, 1, 8, 1, 1676647427969, 1677899588883, 1678076298777, '192.168.100.21');
INSERT INTO `t_user` VALUES (30, 1, '17674250000', '6qoq0h7kutqj7ao813c2p53jnm', 0, '脆脆鱼', '仿若太阳般耀眼的你～', 2, '零陵', '', 76, NULL, 2, 1, 4, 3, 1677597378064, 1677856648617, 1677857632913, '192.168.30.41');
INSERT INTO `t_user` VALUES (31, 1, '19900658888', '1tv2bu481r7j0t549pbbd9hg3c', 0, '_清风来叙', '不经意间，我们错过了许多……', 1, '八步', '', 85, NULL, 1, 0, 0, 0, 1677852926278, 1677856421153, 1678070595769, '127.0.0.1');
INSERT INTO `t_user` VALUES (32, 1, '17232700000', '787p13511jgo219g1fkdrppujk', 0, '半夏琉璃', '心动像风来得不知不觉', 2, '羊城', '', 30, NULL, 3, 0, 0, 0, 1677853013660, 1677858113324, 1677857842956, '192.168.30.77');
INSERT INTO `t_user` VALUES (35, 1, '17211746666', '1fs8mc6te4j9ons3qfegde6ksn', 0, '苏绣姑娘', '春风来，青纱起绿窗', 0, '金陵', '', 12, NULL, 5, 1, 11, 3, 1677853066275, 1677858777705, 1677858637194, '192.168.30.15');
INSERT INTO `t_user` VALUES (36, 1, '17301910000', 'eb1rejp29i2hmdqo0busdg141', 0, '一只长颈鹿', '少年不惧岁月长，彼方尚有荣光在', 2, '渔村', '', 20, NULL, 0, 10, 12, 3, 1677853180915, 1677900291848, 1678071537698, '192.168.30.44');
INSERT INTO `t_user` VALUES (39, 1, '19974119217', '1s4jtssk57mil34v8t2nladiqe', 0, '大可', '允许一切发生', 2, '娄星', '', 83, NULL, 0, 2, 5, 2, 1677853381170, 1677862975078, 1678070794219, '192.168.30.66');
INSERT INTO `t_user` VALUES (40, 1, '16602700100', '3pck0lobpkepcgiu81buf261uq', 0, '尘烟染暮雪', '我有在努力了......', 2, '汉城', '', 4, NULL, 0, 0, 0, 0, 1677900754000, 1677900913356, 1678071400529, '192.168.100.67');
INSERT INTO `t_user` VALUES (41, 1, '19960109910', '3hr4ra1cuekelt6846f3lsoikl', 0, '静候佳音', '保持和创造快乐的情绪 ^_^', 2, '乐山', '', 51, NULL, 0, 11, 5, 0, 1677901107834, 1677901196563, 1678075885582, '192.168.30.4');

SET FOREIGN_KEY_CHECKS = 1;
