package minuhy.xiaoxiang.blog.util;

import com.alibaba.fastjson.JSONObject;
/**
 * Jsonģ幤ߣ淶ظʽ
 * ʱ:2023-2-15 1:37:17
 */
public class ResultUtil {
	public static final int SUCCESS = 200; // ɹ
    public static final int FAIL = 400; // ʧ
    public static final int ERROR = 500; // Ҫת

    int code;
    String msg;
    Object data;

    public ResultUtil(int code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    /**
     * ɹ 
     */
    public static ResultUtil success(){
        return success(null);
    }

    /**
     * ɹһϢ
     * @param msg Ϣ
     */
    public static ResultUtil success(String msg){
        return success(msg,null);
    }

    /**
     * ɹһ
     * @param data 
     */
    public static ResultUtil success(Object data){
        return success(null,data);
    }

    /**
     * ɹһݺһϢ
     * @param msg Ϣ
     * @param data Ϣ
     */
    public static ResultUtil success(String msg, Object data){
        return result(SUCCESS,msg,data);
    }

    /**
     * ʧ 
     */
    public static ResultUtil fail(){
        return fail(null);
    }

    /**
     * ʧܣһϢ
     * @param msg Ϣ
     */
    public static ResultUtil fail(String msg){
        return fail(msg,null);
    }

    /**
     * ʧܣһ
     * @param data 
     */
    public static ResultUtil fail(Object data){
        return fail(null,data);
    }

    /**
     * ʧܣһݺһϢ
     * @param msg Ϣ
     * @param data Ϣ
     */
    public static ResultUtil fail(String msg, Object data){
        return result(FAIL,msg,data);
    }


    /**
     *  
     */
    public static ResultUtil error(){
        return error(null);
    }

    /**
     * 󣬴һϢ
     * @param msg Ϣ
     */
    public static ResultUtil error(String msg){
        return error(msg,null);
    }

    /**
     * 󣬴һ
     * @param data 
     */
    public static ResultUtil error(Object data){
        return error(null,data);
    }

    /**
     * 󣬴һݺһϢ
     * @param msg Ϣ
     * @param data Ϣ
     */
    public static ResultUtil error(String msg, Object data){
        return result(ERROR,msg,data);
    }

    /**
     * һϢ
     * @param code ״̬
     * @param msg Ϣ
     * @param data 
     * @return Ϣ
     */
    public static ResultUtil result(int code,String msg, Object data){
        return new ResultUtil(code,msg,data);
    }


    @Override
    public String toString() {
        JSONObject json = new JSONObject();
        json.put("code",this.code);
        json.put("msg",this.msg);
        json.put("data",this.data);
        return json.toJSONString();
    }
}
