package minuhy.xiaoxiang.blog.servlet.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase.SizeLimitExceededException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

import minuhy.xiaoxiang.blog.config.DebugConfig;
import minuhy.xiaoxiang.blog.util.ResultUtil;

/**
 * ļϴ
 * @author xxxy1116
 * ʱ:2023-02-27 01:49
 */
public class FileUploadServlet extends FileBaseServlet{

	/**
	 * UID
	 */
	private static final long serialVersionUID = 5342015741115399047L;
	private static final Logger log = LoggerFactory.getLogger(FileUploadServlet.class);

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	    
		if(!init) {
			String jsonStr = ResultUtil.fail("ϵͳʼδ").toString();
			backJson(jsonStr,response);
			return;
		}
		
		if(getLoginUserBean(request) == null) {
			String jsonStr = ResultUtil.fail("ȵ¼").toString();
			backJson(jsonStr,response);
			return;
		}
		
		String contentType = request.getContentType();
	    if ((contentType.indexOf("multipart/form-data") >= 0)) {
	    	
	        DiskFileItemFactory factory = new DiskFileItemFactory();
	        
	        // 洢ڴеС
	        factory.setSizeThreshold(maxMemorySize);
	        
	        // ڴСݵλ
	        factory.setRepository(new File(cacheFilePath));
	        
	        // µļϴ
	        ServletFileUpload upload = new ServletFileUpload(factory);
	        
	        // ҪϴļС
	        upload.setSizeMax(maxFileSize);
	        
	        try {
	            // Իȡļ
	            List<FileItem> fileItems = upload.parseRequest(request);
	            
	            // ϴļ
	            ArrayList<String> names = new ArrayList<>();
	            Iterator<FileItem> i = fileItems.iterator();
	            while (i.hasNext()) {
	                FileItem fi = i.next();
	                if (!fi.isFormField()) {
	                	
	                    // ȡϴļ
	                    String fileName = fi.getName();
	                    
	                    if(DebugConfig.isDebug) {
		                    String fieldName = fi.getFieldName();
		                    boolean isInMemory = fi.isInMemory();
		                    long sizeInBytes = fi.getSize();
		                    log.debug("{}",fieldName);
		                    log.debug("ļ{}",fileName);
		                    log.debug("Ƿڴ棺{}",isInMemory);
		                    log.debug("ֽڴС{}",sizeInBytes);
	                    }
	                    // ļ
	                    String suffixName = fileName.substring(fileName.lastIndexOf('.'));
	                    if(isOnlyPicture) {
	                    	if(!suffixName.equals(".jpg") 
	                    			&& !suffixName.equals(".png")
	                    			&& !suffixName.equals(".gif")
	                    			&& !suffixName.equals(".webp")
	                    			&& !suffixName.equals(".ico")
	                    			) {
	                    		// ļͲ֧
	                    		String jsonStr = ResultUtil.fail("ļͲ֧").toString();
	                			backJson(jsonStr,response);
	                			return;
	                    	}
	                    }
	                    fileName = getMd5(fi)+suffixName;

	                    // дļ
	                    File file;
	                    if (fileName.lastIndexOf("\\") >= 0) {
	                        file = new File(uploadFilePath + fileName.substring(fileName.lastIndexOf("\\")));
	                    } else {
	                        file = new File(uploadFilePath + fileName.substring(fileName.lastIndexOf("\\") + 1));
	                    }
	                    
	                    fi.write(file);
	                    
	                    if(DebugConfig.isDebug) {
	                    	log.debug("ļϴ"+ uploadFilePath + fileName);
	                    }
	                    names.add(fileName);
	                }
	            }

                // ϴ
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("filenames", names);
                String jsonStr = ResultUtil.success(jsonObject).toString();
    			backJson(jsonStr,response);
    			return;
	        }catch(SizeLimitExceededException ex) {
	        	if(DebugConfig.isDebug) {
		        	log.error("ļС");
	        	}
	            // ļ̫
				String jsonStr = ResultUtil.fail("ļ̫").toString();
				backJson(jsonStr,response);
				return;
	        } catch (Exception ex) {
	        	log.error("ļϴ{}",ex);
	            // 
				String jsonStr = ResultUtil.fail("").toString();
				backJson(jsonStr,response);
				return;
	        }
	    } else {
	        // 
			String jsonStr = ResultUtil.fail("֧").toString();
			backJson(jsonStr,response);
			return;
	    }

	}
	
}
