package minuhy.xiaoxiang.blog.servlet.comment;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

import minuhy.xiaoxiang.blog.bean.user.UserBean;
import minuhy.xiaoxiang.blog.config.DebugConfig;
import minuhy.xiaoxiang.blog.database.CommentDb;
import minuhy.xiaoxiang.blog.servlet.BaseHttpServlet;
import minuhy.xiaoxiang.blog.util.RequestUtil;
import minuhy.xiaoxiang.blog.util.ResultUtil;
import minuhy.xiaoxiang.blog.util.TimeUtil;

@WebServlet("/comment/delete")
public class DeleteServlet extends BaseHttpServlet{
	/**
	 * 
	 */
	private static final long serialVersionUID = -1585231955724729886L;
	private static final Logger log = LoggerFactory.getLogger(DeleteServlet.class);
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		resp.sendRedirect(req.getContextPath()+"/index.jsp");
	}
	
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		currentPath = req.getContextPath();
		
		UserBean userBean = getLoginUserBean(req);
		if(userBean == null) {
			// ûе¼
			if (DebugConfig.isDebug) {
				log.debug("û¼ɾ");
			}

			JSONObject jsonObject = new JSONObject();
			jsonObject.put("url", currentPath+"/login.jsp");
			String jsonStr = ResultUtil.error("ȵ¼",jsonObject).toString();
			backJson(jsonStr,resp);
			return;
		}
		
		if (DebugConfig.isDebug) {
			log.debug("ɾ");
		}
		
		// 1. ȡ
		String commetIdStr = RequestUtil.getReqParam(req, "commetId", "");
		int commetId;
		
		// 2. ʽǷȷ
		if (DebugConfig.isDebug) {
			log.debug("{}",  commetIdStr);
		}
		
		try {
			commetId = Integer.parseInt(commetIdStr);// valueOf(commetIdStr);
			if(commetId<1) {
				throw new NumberFormatException("IDΧȷ");
			}
		}catch (NumberFormatException e) {
			if (DebugConfig.isDebug) {
				log.debug("IDʽ", commetIdStr);
			}

			String jsonStr = ResultUtil.fail("۱Ŵ").toString();
			backJson(jsonStr,resp);
			return;
		}
		
		// 3. ҵ߼
		CommentDb commentDb = new CommentDb();
		
		try {
			// ѯǷȨ
			int[] id = commentDb.getCommentAuthorIdAndBlogIdAndBlogAuthorIdByCommentId(commetId);
			int CommentAuthorId = id[0];
			int blogId = id[1];
			int BlogAuthorId = id[2];
			if((CommentAuthorId != userBean.getId()) // ߱
					&& userBean.getRole()!=1 // ǹԱ
					&& BlogAuthorId != userBean.getId() // 
					) {
				String jsonStr = ResultUtil.fail("Ȩ").toString();
				backJson(jsonStr,resp);
				return;
			}
			
			// ɾ
			if(commentDb.deleteComment(blogId,commetId,TimeUtil.getTimestampMs())) {
				// ؽ
				String jsonStr = ResultUtil.success("ɾɹ").toString();
				backJson(jsonStr,resp);
				return;
			}else {
				String jsonStr = ResultUtil.fail("ɾʧ").toString();
				backJson(jsonStr,resp);
				return;
			}
		} catch (Exception e) {
			e.printStackTrace();
			log.error("ݿ{}", e);
			
			String jsonStr = ResultUtil.error("ݿ").toString();
			backJson(jsonStr,resp);
			return;
		}
		
	}
}
