package minuhy.xiaoxiang.blog.database;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import minuhy.xiaoxiang.blog.config.DatabaseConfig;
import minuhy.xiaoxiang.blog.config.DebugConfig;
import minuhy.xiaoxiang.blog.database.common.Executant;
import minuhy.xiaoxiang.blog.entity.MessageEntity;
/**
 * Ϣݿ
 * @author y17mm
 * ʱ:2023-02-21 12:11
 */
public class MessageDb extends Executant {
	private static final Logger log = LoggerFactory.getLogger(MessageDb.class);
	
	/**
	 * Ϣдݿ
	 * 
	 * @param messageEntity ϢϢ
	 * @return ɹ/
	 * @throws SQLException ݿ
	 */
	public boolean writeMessage(MessageEntity messageEntity) throws SQLException {
		String sql = "INSERT INTO `t_message` " + 
				"(`sender_id`, `receiver_id`, `target_url`, `title`, `content`, `msg_type`, `create_timestamp`) " + 
				"VALUES (?, ?, ?, ?, ?, ?, ?)";

		if (DebugConfig.isDebug) {
			log.debug("Ϣ{} - {}", sql, messageEntity.toString());
		}

		int result1 = 0;
		int result2 = 0;
		try {
			result1 = insert(sql, 
							String.valueOf(messageEntity.getSenderId()),
							String.valueOf(messageEntity.getReceiverId()),
							messageEntity.getTargetUrl()==null?"":messageEntity.getTargetUrl(),
							messageEntity.getTitle()==null?"":messageEntity.getTitle(),
							messageEntity.getContent()==null?"":messageEntity.getContent(),
							String.valueOf(messageEntity.getMsgType()),
							String.valueOf(messageEntity.getCreateTimestamp())
				);

			if (DebugConfig.isDebug) {
				log.debug("ݣ{}", result1);
			}
			
			// ûǱϢһ -------------------------------------------------------
			sql = "UPDATE `t_user` "
					+ "SET `has_new_msg` = `has_new_msg` + 1 "
					+ "WHERE `id` = ?";
			result2 = update(sql, 
					String.valueOf(messageEntity.getReceiverId())
				);
			
			if(result2 == 0) {
				log.debug("ûϢ־ʧ");
			}

			if (DebugConfig.isDebug) {
				log.debug("ΪûһδϢ{}", messageEntity.getReceiverId());
			}
		} finally {
			close();
		}
		return result1 > 0;
	}

	
	/**
	 * ȡϢ
	 * @param userId
	 * @return
	 */
	public int getNewMessageCountByUserId(int userId) {
		String sql = "SELECT `has_new_msg` " + 
				"FROM `t_user` " + 
				"WHERE `id` = ?" 
				+ "LIMIT 0,1;";

		if (DebugConfig.isDebug) {
			log.debug("Ϣݣ{} - {}", sql, userId);
		}

		int newMsgCount = 0;
		try {
			ResultSet resultSet = query(sql, 
					String.valueOf(userId)
				);
			if (resultSet.next()) {
				newMsgCount = resultSet.getInt("has_new_msg");
			}
		}catch (SQLException e) {
			e.printStackTrace();
			if (DebugConfig.isDebug) {
				log.error("Ϣݿ{}", e);
			}
		} finally {
			close();
		}
		return newMsgCount;
	}
	
	/**
	 * ȡĳûϢ
	 * @param receiverId ûID
	 * @return Ϣ
	 */
	public int getMessageTotalByReceiverId(int receiverId) {
		String sql = "SELECT COUNT(`id`) as `count` " + 
				"FROM `t_message` " + 
				"WHERE `receiver_id` = ?";

		if (DebugConfig.isDebug) {
			log.debug("Ϣ{} - {}", sql, receiverId);
		}

		int msgTotal = 0;
		try {
			ResultSet resultSet = query(sql, 
					String.valueOf(receiverId)
				);
			if (resultSet.next()) {
				msgTotal = resultSet.getInt("count");
			}
		}catch (SQLException e) {
			e.printStackTrace();
			if (DebugConfig.isDebug) {
				log.error("Ϣݿ{}", e);
			}
		} finally {
			close();
		}
		return msgTotal;
	}
	
	/**
	 * ȡϢ
	 * @param receiverId
	 * @param pagination
	 * @return
	 * @throws SQLException
	 */
	public MessageEntity[] getMessagesByReceiverIdAndPagination(int receiverId,int pagination) throws SQLException {
		MessageEntity[] messageEntitys = new MessageEntity[DatabaseConfig.PAGE_ITEM_COUNT];
		try {
			////  ------------------------------
			String sql = "SELECT * " + 
					"FROM `t_message` " + 
					"WHERE `receiver_id` = ? " + 
					"ORDER BY `create_timestamp` DESC " + 
					"LIMIT "+pagination*DatabaseConfig.PAGE_ITEM_COUNT+","+DatabaseConfig.PAGE_ITEM_COUNT;
			
			if (DebugConfig.isDebug) {
				log.debug("Ϣݣ{} - {},{}", sql, receiverId,pagination);
			}
			
			ResultSet resultSet = query(sql,
					String.valueOf(receiverId)
					);
			for(int i=0;i<messageEntitys.length;i++) {
				MessageEntity messageEntity = createMessageEntity(resultSet);
				if(messageEntity == null) {
					// ģ½滻һ
					MessageEntity[] MessageEntitysTemp = new MessageEntity[i];
					for(int j=0;j<i;j++) {
						MessageEntitysTemp[j] = messageEntitys[j];
					}
					messageEntitys = MessageEntitysTemp;
					// 
					break;
				}else {
					messageEntitys[i] = messageEntity;
				}
			}
			//// ΪѶ ------------------------------
			sql = "UPDATE `t_message` "
					+ "SET `state` = 1 "
					+ "WHERE `id` = ?";
			
			int resultSum = 0;
			for(int i=0;i<messageEntitys.length;i++) {
				if(messageEntitys[i].getState() == 0) { // Ϣδ״̬
					int result = update(sql, 
							String.valueOf(messageEntitys[i].getId())
						);
					resultSum+=result;
					if(DebugConfig.isDebug) {
						if(result == 0) {
							log.warn("ϢΪѶʱʧܣ{} - {},{}", sql, result,messageEntitys[i].getId());
						}
					}
				}
			}
			// ûϢǱߵδ===============================
			sql = "UPDATE `t_user` " + 
					"SET `has_new_msg` = if(`has_new_msg`- ?<0,0,`has_new_msg`- ?) " + 
					"WHERE `id` = ?";
			if(resultSum != 0) { // ϢΪѶ
				int result = update(sql, 
						String.valueOf(resultSum),
						String.valueOf(resultSum),
						String.valueOf(receiverId)
					);
				if(DebugConfig.isDebug) {
					if(result == 0) {
						log.warn("ûδʱʧܣ{} - {},{}", sql, receiverId,resultSum);
					}
				}
			}
		} finally {
			close();
		}
		
		return messageEntitys;
	}

	private MessageEntity createMessageEntity(ResultSet resultSet) throws SQLException {
		MessageEntity messageEntity = null;
		if (resultSet.next()) {

			int id = resultSet.getInt("id"); // Ψһʶ
		    int senderId= resultSet.getInt("sender_id"); // ID
		    int receiverId= resultSet.getInt("receiver_id"); // ID
		    int state= resultSet.getInt("state"); // 鿴״̬1Ѳ鿴0δ鿴
		    String targetUrl= resultSet.getString("target_url"); // Ŀ
		    String title= resultSet.getString("title"); // Ϣ
		    String content= resultSet.getString("content"); // Ϣ
		    int msgType= resultSet.getInt("msg_type"); // Ϣͣ1ۣ2ޣ3ظۣ4ϵͳϢ
		    long createTimestamp= resultSet.getLong("create_timestamp"); // ʱ
			
			
		    messageEntity = new MessageEntity( 
		    		id,  
		    		senderId,  
		    		receiverId, 
		    		state,  
		    		targetUrl,  
		    		title,  
		    		content,  
		    		msgType,  
		    		createTimestamp
				);

			if (DebugConfig.isDebug) {
				log.debug("鵽ݣ{}", messageEntity);
			}
		} else {
			if (DebugConfig.isDebug) {
				log.debug("ûв鵽");
			}
		}
		return messageEntity;
	}
	
}
