---
title: Triggers
author: dotMorten
description: A collection of custom visual State Triggers
keywords: CompareStateTrigger, ControlSizeTrigger, FullScreenModeStateTrigger, IsEqualStateTrigger, IsNotEqualStateTrigger, IsNullOrEmptyStateTriggers, NetworkConnectionStateTrigger, RegexStateTrigger, UserHandPreferenceStateTrigger, UserInteractionModeStateTrigger
dev_langs:
  - csharp
category: Xaml
subcategory: Miscellaneous
discussion-id: 0
issue-id: 0
icon: Assets/Triggers.png
---

# Triggers

## CompareStateTrigger

Enables a state if the value is equal to, greater than, or less than another value.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/CompareStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/CompareStateTriggerSample.xaml.cs":::

## ControlStateTrigger

Enables a state if the target control meets the specified size

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/ControlSizeTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/ControlSizeTriggerSample.xaml.cs":::

## IsEqualStateTrigger

Enables a state if the value is equal to another value.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/IsEqualStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/IsEqualStateTriggerSample.xaml.cs":::

## IsNotEqualStateTrigger

Enables a state if the value is not equal to another value.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/IsNotEqualStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/IsNotEqualStateTriggerSample.xaml.cs":::

## IsNullOrEmptyStateTrigger

Enables a state if an Object is null or a String/IEnumerable is empty.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/IsNullOrEmptyStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/IsNullOrEmptyStateTriggerSample.xaml.cs":::

## NetworkConnectionStateTrigger

Trigger for switching when the network availability changes.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/NetworkConnectionStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/NetworkConnectionStateTriggerSample.xaml.cs":::

## RegexStateTrigger

Enables a state if the regex expression is true for a given string value.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/RegexStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/RegexStateTriggerSample.xaml.cs":::

## UserHandPreferenceStateTrigger

Trigger for switching UI based on whether the user favors their left or right hand.

:::code language="xaml" source="~/../code-windows/components/Triggers/samples/UserHandPreferenceStateTriggerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/Triggers/samples/UserHandPreferenceStateTriggerSample.xaml.cs":::


