---
title: EffectAnimations
author: arlodotexe  
description: Animate a Win2D effect using XAML.
keywords: Media, effects, animations, pipeline
dev_langs:
  - csharp
category: Animations
subcategory: Media
discussion-id: 0
issue-id: 0
icon: Assets/EffectAnimations.png
---

# EffectAnimations

EffectAnimations are used to animate the Win2D effects in `CommunityToolkit.WinUI.Media.Effects` without code-behind. Combined with an `AnimationSet`, you can string together complex animated effects that run sequentially or simultaneously.

> [!SAMPLE EffectAnimationsSample]

## BlurEffectAnimation

Apply and animate a Win2D BlurEffect

> [!SAMPLE BlurEffectAnimationSample]

## ColorEffectAnimation

Animate an overlaid color with a Win2D ColorEffect.

> [!SAMPLE ColorEffectAnimationSample]

## CrossFadeEffectAnimation

Blends and animates any PipelineBuilder source with any Win2D effect. This sample blends an image with a `BlurEffect` and effect from `CommunityToolkit.WinUI.Media.Effects`.

> [!SAMPLE CrossFadeEffectAnimationSample]

## ExposureEffectAnimation

Animate the exposure with a Win2D ExposureEffect.

> [!SAMPLE ExposureEffectAnimationSample]

## HueRotationEffectAnimation

Animate Hue to a specific angle using a Win2D HueRotationEffect.

> [!SAMPLE HueRotationEffectAnimationSample]

## SaturationEffectAnimation

> [!SAMPLE SaturationEffectAnimationSample]

## SepiaEffectAnimation

> [!SAMPLE SepiaEffectAnimationSample]

