---
title: LayoutTransformControl
author: odonno
description: The LayoutTransformControl is a control that supports transformations on FrameworkElement as if applied by LayoutTransform.
keywords: LayoutTransformControl, Control, Layout, RenderTransform, RotateTransform, ScaleTransform, SkewTransform, Transform
dev_langs:
  - csharp
category: Controls
subcategory: Layout
discussion-id: 0
issue-id: 0
icon: Assets/LayoutTransformControl.png
---

# LayoutTransformControl

The `LayoutTransformControl` is a control that applies Matrix transformations on any `FrameworkElement` of your application.

The transformations that can be applied are one of the following:

* [RotateTransform](/uwp/api/windows.ui.xaml.media.rotatetransform)
* [ScaleTransform](/uwp/api/windows.ui.xaml.media.scaletransform)
* [SkewTransform](/uwp/api/windows.ui.xaml.media.skewtransform)
* [MatrixTransform](/uwp/api/windows.ui.xaml.media.matrixtransform)
* [TransformGroup](/uwp/api/windows.ui.xaml.media.transformgroup)

:::code language="xaml" source="~/../code-windows/components/LayoutTransformControl/samples/LayoutTransformControlSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/LayoutTransformControl/samples/LayoutTransformControlSample.xaml.cs":::

## Syntax

```xaml
<controls:LayoutTransformControl Background="Black" 
                                 HorizontalAlignment="Center" 
                                 VerticalAlignment="Center"
                                 RenderTransformOrigin="0.5,0.5">
    <controls:LayoutTransformControl.Transform>
        <RotateTransform Angle="90" />
    </controls:LayoutTransformControl.Transform>

    <Border HorizontalAlignment="Center" 
            VerticalAlignment="Center"
            BorderBrush="Red"
            BorderThickness="5">
        <Grid>
            <TextBlock Padding="10" Foreground="White" Text="This is a test message." />
        </Grid>
    </Border>
</controls:LayoutTransformControl>
```

