---
title: ColorPicker
author: michael-hawker
description: An extended color picker control that lets a user pick a color using a color spectrum, sliders, or text input.
keywords: ColorPicker, Control, Layout
dev_langs:
  - csharp
category: Controls
subcategory: Input
discussion-id: 0
issue-id: 0
icon: Assets/ColorPicker.png
---

# ColorPicker

The [ColorPicker](/dotnet/api/microsoft.toolkit.uwp.ui.controls.colorpicker) control lets a user pick a color using a color spectrum, palette, sliders, or text input.

:::code language="xaml" source="~/../code-windows/components/ColorPicker/samples/ColorPickerSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/ColorPicker/samples/ColorPickerSample.xaml.cs":::

## ColorPickerButton
The `ColorPickerButton` variant represents a `DropDownButton` variant which provides a preview of the selected color and allows a user to expand the drop-down to select a new color.

:::code language="xaml" source="~/../code-windows/components/ColorPicker/samples/ColorPickerButtonSample.xaml":::

:::code language="csharp" source="~/../code-windows/components/ColorPicker/samples/ColorPickerButtonSample.xaml.cs":::


