---
title: Migrating from MVVM Basic
author: mrlacey
description: This article describes how to migrate MvvmLight solutions to the Windows Community Toolkit MVVM framework.
keywords: dotnet, csharp, windows 10, uwp, windows community toolkit, uwp community toolkit, uwp toolkit, mvvm, mvvmbasic, MVVM Basic, net core, net standard, Windows Template Studio, WinTS
dev_langs:
  - csharp
  - vb
---

# Migrating from MVVM Basic

This article explains how to migrate apps built with the [MVVM](https://github.com/microsoft/WindowsTemplateStudio/blob/dev/docs/UWP/frameworks/mvvmbasic.md) Basic option in [Windows Template Studio](https://marketplace.visualstudio.com/items?itemName=WASTeamAccount.WindowsTemplateStudio) to use the MVVM Toolkit library instead. It applies to both UWP and WPF apps created with Windows Template Studio.

> **Platform APIs:** [`ObservableObject`](/dotnet/api/microsoft.toolkit.mvvm.componentmodel.ObservableObject), [`RelayCommand`](/dotnet/api/microsoft.toolkit.mvvm.input.RelayCommand)

This article focuses exclusively on migration and does not cover how to use the additional functionality that the library provides.

## Installing the MVVM Toolkit

To use the MVVM Toolkit, you must install the NuGet package into your existing application.

### Install via .NET CLI

```
dotnet add package CommunityToolkit.Mvvm --version 8.1.0
```

### Install via PackageReference

```xml
<PackageReference Include="CommunityToolkit.Mvvm" Version="8.1.0" />
```

## Updating a project

There are four steps to migrate the code generated by Windows Template Studio.

1. Delete old files.
2. Replace use of `Observable`.
3. Add new namespace references.
4. Update methods with different names.

### 1. Delete old files

MVVM Basic is comprised of two files

```csharp
\Helpers\Observable.cs
\Helpers\RelayCommand.cs
```

```vb
\Helpers\Observable.vb
\Helpers\RelayCommand.vb
```

Delete both of these files.

If you try and build the project at this point you will see lots of errors. These can be useful for identifying files that require changes.

### 2. Replace use of `Observable`

The `Observable` class was used as a base class for ViewModels. The MVVM Toolkit contains a similar class with additional functionality that is called [`ObservableObject`](ObservableObject.md).

Change all classes that previously inherited from `Observable` to inherit from `ObservableObject`.

For example

```csharp
    public class MainViewModel : Observable
```

```vb
    Public Class MainViewModel
        Inherits Observable
```

will become

```csharp
    public class MainViewModel : ObservableObject
```

```vb
    Public Class MainViewModel
        Inherits ObservableObject
```

### 3. Add new namespace references

Add a reference to the `CommunityToolkit.Mvvm.ComponentModel` namespace in all files where there is a reference to `ObservableObject`.

You can either add the appropriate directive manually, of move the cursor to the `ObservableObject` and press `Ctrl+.` to access the Quick Action menu to add this for you.

```csharp
using CommunityToolkit.Mvvm.ComponentModel;
```

```vb
Imports CommunityToolkit.Mvvm.ComponentModel
```

Add a reference to the `CommunityToolkit.Mvvm.Input` namespace in all files where there is a reference to [`RelayCommand`](RelayCommand.md).

You can either add the appropriate directive manually, of move the cursor to the `RelayCommand` and press `Ctrl+.` to access the Quick Action menu to add this for you.

```csharp
using CommunityToolkit.Mvvm.Input;
```

```vb
Imports CommunityToolkit.Mvvm.Input
```

### 4. Update methods with different names

There are two methods that must be updated to allow for different names for the same functionality.

All calls to `Observable.Set` must be replaced with calls to `ObservableObject.SetProperty`.

So,

```csharp
    set { Set(ref _elementTheme, value); }
```

```vb
    Set
        [Set](_elementTheme, Value)
    End Set
```

will become

```csharp
    set { SetProperty(ref _elementTheme, value); }
```

```vb
    Set
        SetProperty(_elementTheme, Value)
    End Set
```

All calls to `RelayCommand.OnCanExecuteChanged` must be replaced with calls to `RelayCommand.NotifyCanExecuteChanged`.

So,

```csharp
    (UndoCommand as RelayCommand)?.OnCanExecuteChanged();
```

```vb
    Dim undo = TryCast(UndoCommand, RelayCommand)
    undo?.OnCanExecuteChanged()
```

will become

```csharp
    (UndoCommand as RelayCommand)?.NotifyCanExecuteChanged();
```

```vb
    Dim undo = TryCast(UndoCommand, RelayCommand)
    undo?.NotifyCanExecuteChanged()
```

The app should now work with the same functionality as before.
