---
title: .NET MAUI Community Toolkit documentation
author: bijington
description: The .NET MAUI Community Toolkit is a collection of reusable elements for application development with .NET MAUI, including animations, behaviors, converters, effects, and helpers.
ms.date: 01/14/2022
---

# .NET Multi-platform App UI (.NET MAUI) Community Toolkit documentation

The .NET MAUI Community Toolkit is a collection of reusable elements for application development with [.NET MAUI][maui-url], including animations, behaviors, converters, effects, and helpers. It simplifies and demonstrates common developer tasks when building iOS, Android, macOS and WinUI applications using [.NET MAUI][maui-url].

The MAUI Community Toolkit is available as a set of NuGet Packages for new or existing [.NET MAUI][maui-url] projects.

You can also preview the capabilities of the toolkit by running the sample app available in the MAUI Community Toolkit repo.

Feel free to browse the documentation using the table of contents on the left side of this page.

[maui-url]: /dotnet/maui/ "Microsoft .NET MAUI documentation"

## Supported versions

The .NET MAUI Community Toolkit supports the platforms officially supported by [Microsoft](/dotnet/maui/supported-platforms):

* Android 5.0 (API 21) or higher.
* iOS 10 or higher.
* macOS 10.15 or higher, using Mac Catalyst.
* Windows 11 and Windows 10 version 1809 or higher, using [Windows UI Library (WinUI) 3](/windows/apps/winui/winui3/).
* Tizen 7.0 or higher.

## [Get started][get-started]

Follow the [Getting started guide][get-started] to install the **CommunityToolkit.Maui** NuGet packages into your existing or new [.NET MAUI][maui-url] projects.

[get-started]: get-started.md "Getting started guide"

## Open source

The .NET MAUI Community Toolkit is built as a set of open source projects hosted on GitHub by the community. Please feel free to join the team in contributing in any possible way that you can:

### CommunityToolkit.Maui

* [GitHub repository](https://github.com/CommunityToolkit/Maui)
* [Report an issue](https://github.com/CommunityToolkit/Maui/issues/new/choose)
* [Documentation repository](https://github.com/MicrosoftDocs/CommunityToolkit)
* [Report an issue with the documentation](https://github.com/MicrosoftDocs/CommunityToolkit/issues/new)

### CommunityToolkit.Maui.Markup

* [GitHub repository](https://github.com/CommunityToolkit/Maui.Markup)
* [Report an issue](https://github.com/CommunityToolkit/Maui.Markup/issues/new/choose)
* [Documentation repository](https://github.com/MicrosoftDocs/CommunityToolkit)
* [Report an issue with the documentation](https://github.com/MicrosoftDocs/CommunityToolkit/issues/new)