---
title: Getting Started with the .NET Multi-platform App UI (.NET MAUI) Community Toolkit
author: bijington
description: The toolkit is available as a set of NuGet packages that can be added to any existing or new .NET MAUI project.
ms.date: 01/23/2023
---

# Getting Started with the .NET Multi-platform App UI (.NET MAUI) Community Toolkit

This article covers how to get started using the packages provided as part of the .NET MAUI Community Toolkit project.

## Adding the NuGet package(s)

The toolkit is available as a set of NuGet packages that can be added to any existing or new project using Visual Studio.

1. Open an existing project, or create a new project as per the [.NET MAUI setup documentation](/dotnet/maui/get-started/first-app)

2. In the Solution Explorer panel, right click on your project name and select **Manage NuGet Packages**. Search for **CommunityToolkit.Maui**, and choose the desired NuGet Package from the list.

    ![Manage NuGet Packages...](images/get-started/manage-nuget.png "Right click on the solution and select 'Manage NuGet Packages...'")

3. Choose the toolkit(s) that are most appropriate for your needs from the options below:

### [CommunityToolkit.Maui](#tab/CommunityToolkitMaui)

This package is a collection of Animations, Behaviors, Converters, and Custom Views for development with .NET MAUI. It simplifies and demonstrates common developer tasks building iOS, Android, macOS and Windows apps with .NET MAUI.

**Package name:** `CommunityToolkit.Maui`

**Package url:** https://www.nuget.org/packages/CommunityToolkit.Maui

#### Initializing the package

First the using statement needs to be added to the top of your *MauiProgram.cs* file

```csharp
using CommunityToolkit.Maui;
```

In order to use the toolkit correctly the `UseMauiCommunityToolkit` method must be called on the `MauiAppBuilder` class when bootstrapping an application the *MauiProgram.cs* file. The following example shows how to perform this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
    .UseMauiCommunityToolkit()
```

To use the features of the toolkit please refer to the documentation pages for each specific feature.

### [CommunityToolkit.Maui.Markup](#tab/CommunityToolkitMauiMarkup)

This package is a set of fluent helper methods and classes to simplify building declarative .NET MAUI user interfaces in C#.

**Package name:** `CommunityToolkit.Maui.Markup`

**Package url:** https://www.nuget.org/packages/CommunityToolkit.Maui.Markup

#### Initializing the package

First the using statement needs to be added to the top of your *MauiProgram.cs* file

```csharp
using CommunityToolkit.Maui.Markup;
```

In order to use the toolkit correctly the `UseMauiCommunityToolkitMarkup` method must be called on the `MauiAppBuilder` class when bootstrapping an application the *MauiProgram.cs* file. The following example shows how to perform this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
    .UseMauiCommunityToolkitMarkup()
```

To use the features of the toolkit please refer to the documentation pages for each specific feature.

### [CommunityToolkit.Maui.Maps](#tab/CommunityToolkitMauiMaps)

This package enables you to display a map in your .NET MAUI Windows application.

> [!IMPORTANT]
> Bing Maps has stopped giving out new API keys that are needed for this control to work. We are currently deciding if we should update this control to use the WinUI control that uses Azure Maps or that we will wait for the official .NET MAUI first-party implementation for this.
> For the time being that means you cannot use this control if you do not already have a Bing Maps API key. Bing Maps as a whole will be discontinued entirely on June 30th, 2025.

**Package name:** `CommunityToolkit.Maui.Maps`

**Package url:** https://www.nuget.org/packages/CommunityToolkit.Maui.Maps

#### Initializing the package

First the using statement needs to be added to the top of your *MauiProgram.cs* file

```csharp
using CommunityToolkit.Maui.Maps;
```

In order to use the `Map` correctly the `.UseMauiCommunityToolkitMaps` method must be called on the `MauiAppBuilder` class when bootstrapping an application the *MauiProgram.cs* file. This method expects a valid Bing Maps API key which you can obtain through the [Bing Maps Portal](https://www.bingmapsportal.com/).

The following example shows how to perform this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
    .UseMauiCommunityToolkitMaps("YOUR_API_KEY")
```

When using the .NET MAUI Community Toolkit Map for Windows and the regular .NET MAUI Maps together, you will need to make sure that each initialization call is only made for the relevant platform. The following example shows how to do this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
#if ANDROID || IOS
    .UseMauiMaps()
#elif WINDOWS
    .UseMauiCommunityToolkitMaps("YOUR_API_KEY")
#endif
```

For more information on how to initialize the map on iOS and Android, as well as how to work with the map control API, see the [.NET MAUI Maps documentation](/dotnet/maui/user-interface/controls/map).

### [CommunityToolkit.Maui.MediaElement](#tab/CommunityToolkitMauiMediaElement)

This package enables you to play audio and video in your .NET MAUI application.

**Package name:** `CommunityToolkit.Maui.MediaElement`

**Package url:** https://www.nuget.org/packages/CommunityToolkit.Maui.MediaElement

#### Initializing the package

First the using statement needs to be added to the top of your *MauiProgram.cs* file

```csharp
using CommunityToolkit.Maui;
```

In order to use the `MediaElement` correctly the `UseMauiCommunityToolkitMediaElement` method must be called on the `MauiAppBuilder` class when bootstrapping an application the *MauiProgram.cs* file. The following example shows how to perform this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
    .UseMauiCommunityToolkitMediaElement()
```

To use the features of the toolkit please refer to the documentation pages for each specific feature.

### [CommunityToolkit.Maui.Camera](#tab/CommunityToolkitMauiCamera)

This package enables you to connect to a camera, display a preview from the camera and take photos.

**Package name:** `CommunityToolkit.Maui.Camera`

**Package url:** https://www.nuget.org/packages/CommunityToolkit.Maui.Camera

#### Initializing the package

First the using statement needs to be added to the top of your *MauiProgram.cs* file

```csharp
using CommunityToolkit.Maui;
```

In order to use the `CameraView` correctly, the `UseMauiCommunityToolkitCamera` method must be called on the `MauiAppBuilder` class when bootstrapping an application the *MauiProgram.cs* file. The following example shows how to perform this.

```csharp
var builder = MauiApp.CreateBuilder();
builder
    .UseMauiApp<App>()
    .UseMauiCommunityToolkitCamera()
```

To use the features of the toolkit please refer to the documentation pages for each specific feature.

----

## Using the NuGet package(s)

4. Enable Toolkit in `MauiProgram.cs`:

```csharp
var builder = MauiApp.CreateBuilder();
builder.UseMauiApp<App>();
builder.UseMauiCommunityToolkit();
```

4.1. For advanced settings set [CommunityToolkit.Maui.Options](./options.md):

```csharp
builder.UseMauiCommunityToolkit(options =>
{
    options.SetShouldSuppressExceptionsInConverters(false);
    options.SetShouldSuppressExceptionsInBehaviors(false);
    options.SetShouldSuppressExceptionsInAnimations(false);
});
```

5. Check out the rest of the documentation to learn more about implementing specific features.

## Other resources

The [.NET MAUI Community Toolkit GitHub Repository](https://github.com/CommunityToolkit/Maui/tree/main/samples) contains the source code for a sample application that is designed to show how you can use the toolkit to build a .NET MAUI application. **Please note that you will be required to clone or download the repository and compile the source code in order to run the sample application.**

We recommend developers who are new to .NET MAUI to visit the [.NET MAUI](/dotnet/maui/) documentation.

Visit the [.NET MAUI Community Toolkit GitHub Repository](https://github.com/CommunityToolkit/Maui) to see the current source code, what is coming next, and clone the repository.  Community contributions are welcome!
