---
title: Extensions - .NET MAUI Community Toolkit
author: bijington
description: The .NET MAUI Community Toolkit provides a set of extension methods to simplify common tasks.
ms.date: 04/22/2022
---

# Extensions

The .NET MAUI Community Toolkit provides a set of extension methods to simplify common tasks such as animating the `BackgroundColor` change of a `VisualElement`. 

## .NET MAUI Community Toolkit Extensions

The .NET MAUI Community Toolkit provides a collection of extension methods to make developers lives easier. Here are the extension methods provided by the toolkit:

| Extension | Description |
| --------- | ----------- |
| [`ColorAnimationExtensions`](color-animation-extensions.md) | The `ColorAnimationExtensions` provide a series of extension methods that support animating the `Color` related properties of a `VisualElement`. |
| [`ColorConversionExtensions`](color-conversion-extensions.md) | The `ColorConversionExtensions` provide a series of extension methods that support converting, modifying or inspecting `Color`s. |
| [`KeyboardExtensions`](keyboard-extensions.md) | The `KeyboardExtensions` provide a series of extension methods that support interacting with the Keyboard on controls that support text input. |
| [`ServiceCollectionExtensions`](servicecollection-extensions.md) | The `ServiceCollectionExtensions` provide a series of extension methods that simplify registering Views and their associated ViewModels within the .NET MAUI `IServiceCollection`. |
