---
title: Essentials - .NET MAUI Community Toolkit
author: jfversluis
description: The .NET MAUI Community Toolkit Essentials provides developers with cross-platform APIs for their applications.
ms.date: 08/09/2023
---

# Essentials

Android, iOS, MacCatalyst, Windows, and Tizen offer unique operating system and platform APIs that developers have access to all in C# leveraging .NET. Essentials provides a single cross-platform API that works with any .NET MAUI application that can be accessed from shared code no matter how the user interface is created.

## .NET MAUI Community Toolkit Essentials

The .NET MAUI Community Toolkit provides a collection of cross-platform APIs for their applications. Here are the APIs provided by the toolkit:

| Essential | Description |
| --------- | ----------- |
| [`AppTheme Resources`](../essentials/apptheme-resources.md) | With `AppThemeObject` and `AppThemeColor` you can create theme aware resources for your application that automatically update when the device theme updates. |
| [`Badge`](../essentials/badge.md) | The `Badge` allows developers to set the app icon badge number on the homescreen. |
| [`FolderPicker`](../essentials/folder-picker.md) | The `FolderPicker` allows picking a folder from the file system. |
| [`FileSaver`](../essentials/file-saver.md) | The `FileSaver` provides the ability to select target folder and save files to the file system. |
| [`SpeechToText`](../essentials/speech-to-text.md) | The `SpeechToText` provides the ability to convert speech to text. |
