/**

  Company:
    Microchip Technology Inc.

  File Name:
    delay.c

  Summary:
    This is delay.c file

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  MPLAB Code Configurator - v2.25
        Device            :  PIC18LF25K50
        Driver Version    :  2.00
    The generated drivers are tested against the following:
        Compiler          :  XC8 v1.34
        MPLAB             :  MPLAB X v2.35 or v3.00
 */

/*
Copyright (c) 2013 - 2015 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
 */

#include "mcc_generated_files/mcc.h"

void Delay (uint16_t ms)
{
    while (ms > 0)
    {
        __delay_ms (1);
        ms--;
    }
}

void ConfigureBaudRate (void)
{
    //printf ("\x55");  // 'U' character for auto baud detection
    Delay(200);
    
    TXSTA1bits.TXEN = 0;
    TRISCbits.TRISC6 = 0;
    LATCbits.LATC6 = 0;
    Delay(300);
    LATCbits.LATC6 = 1;
    TRISCbits.TRISC6 = 1;
    TXSTA1bits.TXEN = 1;
    
    printf ("\x55");  // 'U' character for auto baud detection

    Delay(200); 
}

void ClearReceptionBuffer (void)
{
    while (EUSART1_Read() != '\n'); 
}
