/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using MPLAB Code Configurator

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  MPLAB Code Configurator - v2.25
        Device            :  PIC18LF25K50
        Driver Version    :  2.00
    The generated drivers are tested against the following:
        Compiler          :  XC8 v1.34
        MPLAB             :  MPLAB X v2.35 or v3.00
 */

/*
Copyright (c) 2013 - 2015 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
 */

#include "mcc_generated_files/mcc.h"
#include <string.h>
#include <stdlib.h>
#include "delay.h"


/*
                         Main application
 */

#define TEST_PORT_NB       224 // TODO: update port to 224
#define DEACTIVATE_MODE    0
#define ACTIVATE_MODE      1
#define CNF_MODE           2
#define UNCNF_MODE         3
#define CRYPTO_MODE        4
#define LINK_CHECK_MODE    5
#define OTAA_TRIGGER_MODE  6
#define LINK_CHECK_ANS_CID 2
#define UPLINK_NO_RESPONSE_NB 128
#define MAX_JOINREQUEST_RETRIES    3

//Default join mode
//Comment this out if default activation mode is ABP (ACTIVATION BY PERSONALIZATION)
#define OVER_THE_AIR_ACTIVATION 

static uint8_t join = NOT_JOINED;
static uint8_t testMode = OFF;
static uint8_t sendData[100];
uint16_t sendDataLen;
static char receiveData[100];
static char rx[50];
static uint8_t portNb;
static uint16_t downlinkCtr = 0;
static bool bTxUncnf = true;
static uint8_t mrgn = 255;
static uint8_t gwnb = 0;
static uint8_t uplinkTestNoResp = 0;

static uint8_t MacRxData(void);
static uint8_t unhex(uint8_t c);
static bool CheckTestMode(uint8_t iCtr);
static void EnterTestMode(void);
static uint8_t ReadUartConvertToUint8(char nextChar);

volatile uint8_t fiveSecFlag = 0;

#define DELAY_BETWEEN_TR 1000 //3000

// ### L4S8a Declare here a lightSensor variable of type adc_result_t

uint8_t sendMACCommand(const char *command) {
    printf(command);
    printf("\r\n");
    uint8_t uartRxByte = EUSART1_Read();
    ClearReceptionBuffer();
    if (uartRxByte == 'o') {
        return 1;
    }
    return 0;
}

void InitMACSettings() {
    //OTAA
    sendMACCommand("mac set deveui 7777777777777777");
    sendMACCommand("mac set appeui 7777777777777777");
    sendMACCommand("mac set appkey 12345678901234567890123456789012");
    //ABP
    sendMACCommand("mac set devaddr 77777777");
    sendMACCommand("mac set nwkskey 12345678901234567890123456789012");
    sendMACCommand("mac set appskey 12345678901234567890123456789012");
    sendMACCommand("mac set adr on");
    //868 sushma 07/07/17 - uncomment for 868
//    sendMACCommand("mac set ch dcycle 0 0");
//    sendMACCommand("mac set ch dcycle 1 0");
//    sendMACCommand("mac set ch dcycle 2 0");
    
    
    //    sendMACCommand("mac set dr 2");
    //    sendMACCommand("mac set dr 0");
    //868 sushma 07/07/17 - uncomment for 868
//    sendMACCommand("mac set ch freq 3 868850000");
//    sendMACCommand("mac set ch dcycle 3 0");
//    sendMACCommand("mac set ch drrange 3 0 5");
//    sendMACCommand("mac set ch status 3 off");
    
    
    sendMACCommand("mac save");
    Reset();
}

void ToggleLED(void) {
    RED_LED = ON;
    TMR1_StartTimer();
    //Delay(500);
    //RED_LED = OFF;
}

void SendPacket(bool bTxUncnf, uint8_t portNb, uint8_t *data, uint16_t dataLen) {
    uint8_t temp[64];
    uint8_t i;

    if (TEST_PORT_NB == portNb) {
        if (bTxUncnf) {
            printf("mac tx uncnf ");
        } else {
            printf("mac tx cnf ");
        }
    } else {
        printf("mac tx uncnf ");
    }
    printf("%d", portNb);
    printf(" ");

    for (i = 0; i < dataLen; i++) {
        temp[i << 1] = data[i] >> 4;
        printf("%0X", (uint8_t) temp[i << 1]);
        temp[(i << 1) + 1] = data[i] % 16;
        printf("%0X", (uint8_t) temp[(i << 1) + 1]);
    }

    printf("\r\n");
}

void main(void) {
    uint8_t uartRxByte;
    uint8_t iCtr;
    uint8_t i;
    bool bLinkCheckEnabled = false;

    SYSTEM_Initialize();

    TMR0_StopTimer();

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    ConfigureBaudRate();
    
    printf("sys reset\r\n");
    Delay(2000);
    ClearReceptionBuffer();

    // Try to join the network until an 'accepted' answer is received, the join flag will indicate the status of the join procedure
    while (join == NOT_JOINED) {
        
#if defined OVER_THE_AIR_ACTIVATION
        printf("mac join otaa\r\n");
#else
        printf("mac join abp\r\n");
#endif
        uartRxByte = EUSART1_Read();
        ClearReceptionBuffer();

        if ((uartRxByte != 'b') && (uartRxByte != 'i')){
            if (uartRxByte == 'k') // if keys are not init, retry with otaa
            {
                printf("mac join otaa\r\n");

                uartRxByte = EUSART1_Read();
                ClearReceptionBuffer();
                if (uartRxByte == 'k') // if keys are not init
                {
                    // init every settings
                    InitMACSettings();

                }

                if ((uartRxByte != 'n') && (uartRxByte != 'b')) // no free channels
                {
                    uartRxByte = EUSART1_Read();
                    ClearReceptionBuffer();
                    if (uartRxByte == 'a') // if an 'ok' answer is received back from the sensor
                    {
                        join = JOINED; // set the join flag to indicate join was accomplished
                    }
                }
            } else {
                uartRxByte = EUSART1_Read();
                ClearReceptionBuffer();
                if (uartRxByte == 'o') // if an 'accepted' answer is received back from the sensor
                {
                    uartRxByte = EUSART1_Read();
                    ClearReceptionBuffer();
                }


                if (uartRxByte == 'a') // if an 'accepted' answer is received back from the sensor
                {
                    join = JOINED; // set the join flag to indicate join was accomplished
                }
            }
        }
        Delay(500);
    }

    Delay(3000);

    TMR0_Initialize();

    while (1) {
        while (testMode == OFF) {
            GREEN_LED = ON; //the D6 LED ON indicates TEST MODE is off 
            printf("mac tx uncnf 1 1\r\n");
            ToggleLED(); // toggle an LED to indicate transmission is occurring

            //wait for 
            iCtr = MacRxData();

            if ((TEST_PORT_NB == portNb) && (CheckTestMode(iCtr))) {
                //Activated test mode
                EnterTestMode();
            }

            while (!fiveSecFlag) {
            }
            fiveSecFlag = 0;
            //Delay(DELAY_BETWEEN_TR);
        }

        while (testMode == ON) {

            if (uplinkTestNoResp < UPLINK_NO_RESPONSE_NB) {
                // Test mode main loop; test mode entered

                GREEN_LED = OFF; //the D6 LED OFF indicates TEST MODE is on 

                SendPacket(bTxUncnf, TEST_PORT_NB, &sendData, sendDataLen);

                //prepare the next data
                sendData[0] = (uint8_t) (downlinkCtr >> 8);
                sendData[1] = (uint8_t) (downlinkCtr);
                sendDataLen = 2;

                iCtr = MacRxData();

                if (iCtr != 0xFF) {
                    while (!fiveSecFlag) {
                    }
                    fiveSecFlag = 0;

                    if (bLinkCheckEnabled) {
                        bLinkCheckEnabled = false;

                        printf("mac set linkchk 0\r\n");
                        uartRxByte = EUSART1_Read();
                        ClearReceptionBuffer();

                        printf("mac get mrgn\r\n");
                        mrgn = ReadUartConvertToUint8('\r');
                        ClearReceptionBuffer();

                        printf("mac get gwnb\r\n");
                        gwnb = ReadUartConvertToUint8('\r');
                        ClearReceptionBuffer();

                        sendData[0] = LINK_CHECK_MODE;
                        sendData[1] = LINK_CHECK_ANS_CID;
                        sendData[2] = mrgn;
                        sendData[3] = gwnb;
                        sendDataLen = 4;
                    } else {
                        if (iCtr > 0) {
                            if (TEST_PORT_NB == portNb) {
                                downlinkCtr++;

                                //prepare the next data
                                sendData[0] = (uint8_t) (downlinkCtr >> 8);
                                sendData[1] = (uint8_t) (downlinkCtr);
                                sendDataLen = 2;

                                uplinkTestNoResp = 0;

                                switch (rx[0]) {
                                    case DEACTIVATE_MODE:
                                        if (iCtr == 1) {
                                            //Deactivated test mode
                                            testMode = OFF;
                                        }
                                        break;

                                    case ACTIVATE_MODE:
                                        if (CheckTestMode(iCtr)) {
                                            //Activated test mode
                                            EnterTestMode();
                                        }
                                        break;

                                    case CNF_MODE:
                                        if (iCtr == 1) {
                                            //Confirmed frames
                                            bTxUncnf = false;
                                        }
                                        break;

                                    case UNCNF_MODE:
                                        if (iCtr == 1) {
                                            //Unconfirmed frames
                                            bTxUncnf = true;
                                        }
                                        break;

                                    case CRYPTO_MODE:
                                        if (iCtr <= 33) {
                                            //Cryptography tests
                                            sendData[0] = 0x04;

                                            for (i = 1; i < iCtr; i++) {
                                                //TODO: take care of this
                                                sendData[i] = (((uint16_t) rx[i]) + 1) % 256;
                                            }
                                            sendDataLen = iCtr;
                                        }

                                        break;

                                    case LINK_CHECK_MODE:
                                        if (iCtr == 1) {
                                            //Generate LinkCheckReq
                                            //TODO
                                            printf("mac set linkchk 1\r\n");
                                            bLinkCheckEnabled = true;
                                            uartRxByte = EUSART1_Read();
                                            ClearReceptionBuffer();
                                        }
                                        break;
                                    case OTAA_TRIGGER_MODE:
                                    {
                                        uint8_t jointrials = 0;
                                        join = NOT_JOINED;
                                        testMode = OFF;
                                        
                                        while(join == NOT_JOINED)
                                        {
                                            jointrials++;
                                            if(jointrials > MAX_JOINREQUEST_RETRIES)
                                            {
                                                break;
                                            }
                                            printf("mac join otaa\r\n");
                                            uartRxByte = EUSART1_Read();
                                            ClearReceptionBuffer();
                                            if (uartRxByte == 'k') // if keys are not init
                                            {
                                                // init every settings
                                                InitMACSettings();

                                            }

                                            if ((uartRxByte != 'n') && (uartRxByte != 'b')) // no free channels
                                            {
                                                uartRxByte = EUSART1_Read();
                                                ClearReceptionBuffer();
                                                if (uartRxByte == 'a') // if an 'ok' answer is received back from the sensor
                                                {
                                                    join = JOINED; // set the join flag to indicate join was accomplished
                                                    break;
                                                }
                                            }
                                            Delay(500);
                                        }
                                    }
                                    break;

                                    default:
                                        break;
                                }
                            }
                        } else {
                            // No answer received from the server side
                            // Increment no response counter
                            uplinkTestNoResp++;
                        }
                    }

                    ToggleLED(); // toggle an LED to indicate transmission is occurring
                    //Delay (DELAY_BETWEEN_TR);                
                } else {
                    Delay(500);
                }
            } else {
                //Deactivated test mode after 
                testMode = OFF;
            }
        }
    }
}

static uint8_t MacRxData(void) {
    uint8_t uartRxByte;
    uint8_t iCtr = 0;
    char nextChar;
    uint8_t retValue = 0xFF; // Error

    //wait for 
    uartRxByte = EUSART1_Read();
    if (uartRxByte == 'o') // if an 'mac_tx_ok or mac_err or mac_rx 1 data' answer is received back from the sensor
    {
        ClearReceptionBuffer();
        uartRxByte = EUSART1_Read();
        if (uartRxByte == 'm') // if an 'mac_tx_ok or mac_err or mac_rx 1 data' answer is received back from the sensor
        {
            uartRxByte = EUSART1_Read(); //read the "a"
            uartRxByte = EUSART1_Read(); //read the "c"
            uartRxByte = EUSART1_Read(); // read the "_"
            uartRxByte = EUSART1_Read();
            if (uartRxByte == 'r') {
                EUSART1_Read(); // read the "x"
                EUSART1_Read(); // read the " "

                //Read port number
                nextChar = ' ';
                portNb = ReadUartConvertToUint8(nextChar);

                //Skip ' '
                uartRxByte = EUSART1_Read();

                iCtr = 0;
                while ((receiveData[iCtr] = EUSART1_Read()) != '\r') {
                    if ((iCtr % 2) == 0) {
                        rx[iCtr >> 1] = (receiveData[iCtr] < 0x3A) ? (receiveData[iCtr] - 48) : (receiveData[iCtr] - 55);
                        rx[iCtr >> 1] <<= 4;
                    } else {
                        rx[iCtr >> 1] += (receiveData[iCtr] < 0x3A) ? (receiveData[iCtr] - 48) : (receiveData[iCtr] - 55);
                    }

                    iCtr++;

                }

                retValue = iCtr >> 1;
            } else if (uartRxByte == 't') {
                retValue = 0;
            }
        }
    }

    ClearReceptionBuffer();

    return retValue;
}

static uint8_t unhex(uint8_t c) {
    if (c >= '0' && c <= '9')
        return c - '0';
    if (c >= 'A' && c <= 'F')
        return c - 'A' + 10;
    return '-';
}

static bool CheckTestMode(uint8_t iCtr) {
    bool bPayloadValid = false;

    if (iCtr == 4) {
        for (iCtr = 0; iCtr < 4; iCtr++) {
            if (rx[iCtr] == 1) {
                bPayloadValid = true;
            } else {
                bPayloadValid = false;
                break;
            }
        }
    }

    return bPayloadValid;
}

static void EnterTestMode(void) {
    testMode = ON;
    downlinkCtr = 0;
    uplinkTestNoResp = 0;

    //prepare the first data
    sendData[0] = (uint8_t) (downlinkCtr >> 8);
    sendData[1] = (uint8_t) (downlinkCtr);
    sendDataLen = 2;
}

static uint8_t ReadUartConvertToUint8(char nextChar) {
    uint8_t retCompValue = 0;
    char inBuffer[4];

    //Read port number
    inBuffer[0] = EUSART1_Read();
    inBuffer[1] = EUSART1_Read();
    if ((inBuffer[1] != nextChar) && (inBuffer[1] != 0)) {
        inBuffer[2] = EUSART1_Read();
        if ((inBuffer[2] != nextChar) && (inBuffer[2] != 0)) {
            retCompValue = unhex(inBuffer[1]) * 10;
            retCompValue += ((unhex(inBuffer[0])) * 100);
            retCompValue += (unhex(inBuffer[2]));
        } else {
            retCompValue = unhex(inBuffer[1]);
            retCompValue += ((unhex(inBuffer[0])) * 10);
        }
    } else {
        retCompValue = unhex(inBuffer[0]);
    }

    return retCompValue;
}
/**
 End of File
 */