/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommChangeInfo;
import com.microchip.mplab.comm.MPLABCommUSBAccessInterface;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MPLABCommUSBAccess
implements MPLABCommUSBAccessInterface {
    int cSessionID = -1;
    int DeviceListCount = 0;
    String[] DeviceNameList;
    private Lock cReadPipeLock = new ReentrantLock();

    private native int usbInitialize();

    private native int usbRelease(int var1);

    private native int usbCreateDeviceList(int var1, int var2);

    private native int usbUpdateDeviceList(int var1, int var2);

    private native int usbReleaseDeviceList(int var1);

    private native int usbGetDeviceListCount(int var1);

    private native String usbGetDeviceInfo(int var1, int var2);

    private native String usbGetChangeInfo(int var1, int var2);

    private native int usbOpenDevice(int var1, int var2);

    private native int usbCloseDevice(int var1, int var2);

    private native int usbResetDevice(int var1, int var2);

    private native int usbWriteControlPipe(int var1, int var2, int var3, int var4, byte[] var5);

    private native int usbReadControlPipe(int var1, int var2, int var3, int var4, byte[] var5);

    private native int usbWriteBulkPipe(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    private native int usbReadBulkPipe(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    private native int usbWriteInterruptPipe(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    private native int usbReadInterruptPipe(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    private native int usbCancelPipeTransfer(int var1, int var2, int var3);

    private native int usbGetDeviceDescriptor(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    public int USB_Initialize(String usbAccessLibName) {
        int result;
        if (this.cSessionID == -1) {
            try {
                System.loadLibrary(usbAccessLibName);
                result = this.usbInitialize();
                if (result >= 0) {
                    this.cSessionID = result;
                }
            }
            catch (UnsatisfiedLinkError e) {
                result = -137;
            }
        } else {
            result = -115;
        }
        return result;
    }

    public int USB_Release(int sessionId) {
        int result;
        if (this.cSessionID >= 0 && sessionId == this.cSessionID) {
            result = this.usbRelease(this.cSessionID);
            this.cSessionID = -1;
        } else {
            result = -116;
        }
        return result;
    }

    public synchronized int USB_CreateDeviceList(int sessionId, int vendorId) {
        int listHandle = sessionId == this.cSessionID ? this.usbCreateDeviceList(sessionId, vendorId) : -116;
        return listHandle;
    }

    public synchronized int USB_UpdateDeviceList(int listHandle, int vendorId) {
        int result = this.usbUpdateDeviceList(listHandle, vendorId);
        return result;
    }

    public synchronized int USB_ReleaseDeviceList(int listHandle) {
        int result = this.usbReleaseDeviceList(listHandle);
        return result;
    }

    public synchronized String[] USB_GetDeviceList(int listHandle) {
        int count = this.usbGetDeviceListCount(listHandle);
        String[] deviceList = new String[count];
        for (int i = 0; i < count; ++i) {
            deviceList[i] = this.usbGetDeviceInfo(listHandle, i);
        }
        return deviceList;
    }

    @Deprecated
    public synchronized MPLABCommChangeInfo[] USB_GetChangeList(int listHandle) {
        String change;
        int count = 0;
        boolean changeFlag = true;
        while (changeFlag) {
            change = this.usbGetChangeInfo(listHandle, count);
            if (change.length() > 0) {
                ++count;
                continue;
            }
            changeFlag = false;
        }
        MPLABCommChangeInfo[] changeList = new MPLABCommChangeInfo[count];
        for (int i = 0; i < count; ++i) {
            change = this.usbGetChangeInfo(listHandle, i);
            int state = change.startsWith("1") ? 1 : 0;
            changeList[i] = new MPLABCommChangeInfo(listHandle, i, change.substring(1), state);
        }
        return changeList;
    }

    public synchronized int USB_GetDeviceCount(int listHandle) {
        int count = this.usbGetDeviceListCount(listHandle);
        return count;
    }

    public synchronized int USB_OpenDevice(int listHandle, int deviceIndex) {
        int result = this.usbOpenDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int USB_CloseDevice(int listHandle, int deviceIndex) {
        int result = this.usbCloseDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int USB_ResetDevice(int listHandle, int deviceIndex) {
        int result = this.usbResetDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int USB_MonitorDevice(int listHandle, int deviceIndex) {
        int state = 1;
        return state;
    }

    public synchronized int USB_WriteControlPipe(int listHandle, int deviceIndex, int byteCount, int timeout, byte[] data) {
        int result = this.usbWriteControlPipe(listHandle, deviceIndex, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_ReadControlPipe(int listHandle, int deviceIndex, int byteCount, int timeout, byte[] data) {
        int result = this.usbReadControlPipe(listHandle, deviceIndex, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_WriteBulkPipe(int listHandle, int deviceIndex, int endpointNumber, int byteCount, int timeout, byte[] data) {
        int result = this.usbWriteBulkPipe(listHandle, deviceIndex, endpointNumber, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_ReadBulkPipe(int listHandle, int deviceIndex, int endpointNumber, int byteCount, int timeout, byte[] data) {
        int result = this.usbReadBulkPipe(listHandle, deviceIndex, endpointNumber, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_WriteInterruptPipe(int listHandle, int deviceIndex, int endpointNumber, int byteCount, int timeout, byte[] data) {
        int result = this.usbWriteInterruptPipe(listHandle, deviceIndex, endpointNumber, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_ReadInterruptPipe(int listHandle, int deviceIndex, int endpointNumber, int byteCount, int timeout, byte[] data) {
        int result = this.usbReadInterruptPipe(listHandle, deviceIndex, endpointNumber, byteCount, timeout, data);
        return result;
    }

    public synchronized int USB_CancelPipeTransfer(int listHandle, int deviceIndex, int endpointAddress) {
        int result = this.usbCancelPipeTransfer(listHandle, deviceIndex, endpointAddress);
        return result;
    }

    public String USB_GetSerialNumberString(int listHandle, int deviceIndex) {
        String sn = null;
        return sn;
    }

    public String USB_GetManufacturerString(int listHandle, int deviceIndex) {
        String man = null;
        return man;
    }

    public String USB_GetProductString(int listHandle, int deviceIndex) {
        String prod = null;
        return prod;
    }

    public synchronized int USB_GetDeviceDescriptor(int listHandle, int deviceIndex, byte[] buffer) {
        int result = this.usbGetDeviceDescriptor(listHandle, deviceIndex, 1, 0, 0, buffer);
        return result;
    }

    public int USB_GetEndpointDescriptor(int listHandle, int deviceIndex, int endpointAddress, byte[] buffer) {
        int result = this.usbGetDeviceDescriptor(listHandle, deviceIndex, 5, endpointAddress, 0, buffer);
        return result;
    }

    public int USB_GetStringDescriptor(int listHandle, int deviceIndex, int stringIndex, int maxLength, byte[] buffer) {
        int result = this.usbGetDeviceDescriptor(listHandle, deviceIndex, 3, stringIndex, maxLength, buffer);
        return result;
    }

    public static void DumpBuffer(byte[] data, int count) {
        String s = "";
        int k = 16;
        for (int i = 0; i < count; ++i) {
            k = i;
            System.out.printf("%02X ", data[i]);
            if ((k + 1) % 8 == 0) {
                System.out.print(" ");
            }
            if (data[i] >= 32 && data[i] <= 126) {
                byte[] b = new byte[]{data[i]};
                String ts = new String(b);
                s = s.concat(ts);
            } else {
                s = s.concat(".");
            }
            if ((i + 1) % 16 != 0) continue;
            System.out.printf(" %s\n", s);
            s = "";
        }
        if (s.length() > 0) {
            while ((k + 1) % 16 != 0) {
                if ((k + 1) % 8 == 0) {
                    System.out.print(" ");
                }
                System.out.print("-- ");
                s = s.concat(".");
                ++k;
            }
            System.out.printf("  %s\n", s);
        }
    }
}

