/*
 * Decompiled with CFR 0.152.
 */
package BootloaderView.gui;

import BootloaderView.AppContext.AppContext;
import BootloaderView.applicationthread.SwingWorkerThread;
import BootloaderView.applicationthread.SwingWorkerThreadFromWrite;
import BootloaderView.gui.TextFieldEditor;
import BootloaderView.state.CommState;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import protocol.protocolclasses.CommandReadVersionProtocol;
import protocol.write.nextchunkgetter.MemoryRecordTypes;
import readhexfile.classes.ReadHexFile;
import serialport.classes.MyToolObject;
import serialport.classes.SerialPort;

public class BootloaderView
extends JFrame {
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JDialog jDialog1;
    private JDialog jDialog2;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private BindingGroup bindingGroup;

    public BootloaderView() {
        this.initComponents();
        AppContext.swingEditorObj = new TextFieldEditor(this);
        AppContext.setCommState(CommState.IDLE);
        if (AppContext.debugEnable) {
            System.out.println("STATE: " + (Object)((Object)AppContext.getCommState()));
        }
        this.comPortListUpdate();
        System.out.println("User Program Running");
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jDialog1 = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jDialog2 = new JDialog();
        this.jFileChooser1 = new JFileChooser();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jButton1 = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jDialog1.setTitle("Console Window");
        this.jDialog1.setAlwaysOnTop(true);
        this.jDialog1.setMinimumSize(new Dimension(700, 400));
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 707, Short.MAX_VALUE)));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 441, Short.MAX_VALUE).addContainerGap()));
        this.jDialog2.setTitle("Please Select A File");
        this.jDialog2.setMinimumSize(new Dimension(660, 460));
        this.jFileChooser1.setCurrentDirectory(new File("C:\\Users\\c16188\\Desktop\\SVNOneButton"));
        this.jFileChooser1.setDoubleBuffered(true);
        this.jFileChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jFileChooser1ActionPerformed(evt);
            }
        });
        GroupLayout jDialog2Layout = new GroupLayout(this.jDialog2.getContentPane());
        this.jDialog2.getContentPane().setLayout(jDialog2Layout);
        jDialog2Layout.setHorizontalGroup(jDialog2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog2Layout.createSequentialGroup().addContainerGap().addComponent(this.jFileChooser1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jDialog2Layout.setVerticalGroup(jDialog2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog2Layout.createSequentialGroup().addContainerGap().addComponent(this.jFileChooser1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.setDefaultCloseOperation(3);
        this.setTitle("Bootloader Application v1.0");
        this.setMinimumSize(new Dimension(659, 205));
        this.jLabel1.setFont(new Font("Verdana", 1, 12));
        this.jLabel1.setText("Serial Port/Device Configuration:");
        this.jLabel1.setToolTipText("");
        this.jComboBox1.setToolTipText("");
        this.jComboBox1.setName("");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Program Device");
        this.jButton1.setName("ProgramDeviceButton");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText(" ");
        this.jLabel4.setText("Status: ");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jFileChooser1, (Property)ELProperty.create((String)"${selectedFile.name}"), (Object)this.jLabel5, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"PIC16", "PIC18"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("300");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jTextField2.setText("4000");
        this.jTextField2.setName("");
        this.jLabel2.setText("Bootloader Offset (Address):");
        this.jLabel6.setText("Program Memory Size:");
        this.jMenu3.setText("File");
        this.jMenuItem4.setText("Open/Load File");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu1.setText("COMM Settings");
        this.jMenuItem2.setText("Connect");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("Diisconnect");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Tools");
        this.jMenuItem1.setText("Refresh");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem1);
        this.jMenuItem5.setText("Show Console");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BootloaderView.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 232, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 203, -2)).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 65, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 133, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox2, 0, -1, Short.MAX_VALUE).addGap(34, 34, 34).addComponent(this.jComboBox1, -2, 129, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 106, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jComboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)));
        this.jComboBox1.getAccessibleContext().setAccessibleName("");
        this.bindingGroup.bind();
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        switch (AppContext.getCommState()) {
            default: 
        }
        AppContext.setIndexSlectedByUser(this.jComboBox1.getSelectedIndex());
        if (AppContext.getIndexSlectedByUser() != -1 && AppContext.debugEnable) {
            System.out.println("The index selected is: " + AppContext.getIndexSlectedByUser());
        }
        AppContext.swingEditorObj.print(1, "COM Port Selected\nEvent: COM PORT SELECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        switch (AppContext.getCommState()) {
            case IDLE: {
                this.jProgressBar1.setMinimum(0);
                this.jProgressBar1.setStringPainted(true);
                AppContext.pic18DeviceWhenCaptured = AppContext.pic18Device;
                AppContext.dataManager.programMemorySize = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField2.getText(), 16) * 2 : Integer.parseInt(this.jTextField2.getText(), 16);
                AppContext.dataManager.conmMemorySize = 14;
                AppContext.dataManager.eepromMemorySize = 256;
                AppContext.dataManager.eepromOffset = !AppContext.pic18DeviceWhenCaptured ? 122880 : 0xF00000;
                AppContext.dataManager.configBitsOffset = 0x300000;
                AppContext.dataManager.cursorStart = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField1.getText(), 16) * 2 : Integer.parseInt(this.jTextField1.getText(), 16);
                if (AppContext.dataManager.programMemorySize < AppContext.dataManager.cursorStart) {
                    this.updateGUI(4, "Please enter a valid program memory size for the device. Programming failed.");
                    break;
                }
                AppContext.thread1 = new SwingWorkerThread();
                AppContext.thread1.execute();
                AppContext.setCommState(CommState.BUSY);
                AppContext.swingEditorObj.print(1, "Program Thread Start Succeeded\nEvent: PROGRAM THREAD. STATE: " + (Object)((Object)AppContext.getCommState()));
                break;
            }
            case CONNECT: {
                this.jProgressBar1.setMinimum(0);
                this.jProgressBar1.setStringPainted(true);
                AppContext.pic18DeviceWhenCaptured = AppContext.pic18Device;
                AppContext.dataManager.programMemorySize = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField2.getText(), 16) * 2 : Integer.parseInt(this.jTextField2.getText(), 16);
                AppContext.dataManager.eepromMemorySize = 256;
                AppContext.dataManager.conmMemorySize = 14;
                AppContext.dataManager.eepromOffset = !AppContext.pic18DeviceWhenCaptured ? 122880 : 0xF00000;
                AppContext.dataManager.configBitsOffset = 0x300000;
                AppContext.dataManager.cursorStart = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField1.getText(), 16) * 2 : Integer.parseInt(this.jTextField1.getText(), 16);
                if (AppContext.dataManager.programMemorySize < AppContext.dataManager.cursorStart) {
                    this.updateGUI(4, "Please enter a valid program memory size for the device. Programming failed.");
                    break;
                }
                AppContext.thread1 = new SwingWorkerThreadFromWrite();
                AppContext.thread1.execute();
                AppContext.setCommState(CommState.BUSY);
                AppContext.swingEditorObj.print(1, "Program Thread Start Succeeded\nEvent: PROGRAM THREAD. STATE: " + (Object)((Object)AppContext.getCommState()));
                break;
            }
            default: {
                AppContext.swingEditorObj.print(1, "Program Thread Not Started\nEvent: PROGRAM THREAD. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                System.out.println("Event: PROGRAM THREAD. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
            }
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        switch (AppContext.getCommState()) {
            default: 
        }
        this.jComboBox1.removeAllItems();
        this.comPortListUpdate();
        AppContext.swingEditorObj.print(1, "Connections refreshed\nEvent: REFRESH. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        switch (AppContext.getCommState()) {
            case IDLE: {
                AppContext.setIndexWhenConnected(AppContext.getIndexSlectedByUser());
                int tRes = SerialPort.connectToSerialPort(AppContext.getIndexWhenConnected());
                if (tRes == 0) {
                    AppContext.setCommState(CommState.CONNECT);
                    AppContext.swingEditorObj.print(1, "Connection Successful\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                    CommandReadVersionProtocol protocol = new CommandReadVersionProtocol();
                    AppContext.swingEditorObj.print(1, "Reading Version ...\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                    protocol.sendReceiveDataProtocol();
                    break;
                }
                AppContext.setCommState(CommState.IDLE);
                AppContext.swingEditorObj.print(1, "Connection Failed\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                break;
            }
            default: {
                AppContext.swingEditorObj.print(1, "Not Connected\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
            }
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        switch (AppContext.getCommState()) {
            case IDLE: 
            case CONNECT: 
            case BUSY: {
                int tRes = SerialPort.disconnectSerialPort(AppContext.getIndexWhenConnected());
                if (tRes == 0) {
                    AppContext.swingEditorObj.print(2, "Status: Disconnected");
                    AppContext.swingEditorObj.disp(0);
                    AppContext.setCommState(CommState.IDLE);
                    AppContext.swingEditorObj.print(1, "Device Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                    AppContext.setCommState(CommState.IDLE);
                    break;
                }
                AppContext.swingEditorObj.print(1, "Device Disconnection Failed\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                break;
            }
            default: {
                AppContext.swingEditorObj.print(1, "Device Not Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
            }
        }
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.jDialog2.setVisible(true);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.jDialog1.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jFileChooser1ActionPerformed(ActionEvent evt) {
        String str = evt.getActionCommand();
        ReadHexFile file1 = new ReadHexFile();
        if (str.compareTo("ApproveSelection") == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppContext.swingEditorObj.print(1, "Reading HEX File ...");
                }
            });
            AppContext.pic18DeviceWhenCaptured = AppContext.pic18Device;
            AppContext.dataManager.programMemorySize = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField2.getText(), 16) * 2 : Integer.parseInt(this.jTextField2.getText(), 16);
            AppContext.dataManager.eepromMemorySize = 256;
            AppContext.dataManager.conmMemorySize = 14;
            AppContext.dataManager.eepromOffset = !AppContext.pic18DeviceWhenCaptured ? 122880 : 0x200000;
            AppContext.dataManager.configBitsOffset = 0x300000;
            AppContext.dataManager.cursorStart = !AppContext.pic18DeviceWhenCaptured ? Integer.parseInt(this.jTextField1.getText(), 16) * 2 : Integer.parseInt(this.jTextField1.getText(), 16);
            if (AppContext.debugEnable) {
                System.out.println(String.format("pROGRAM: %02X", AppContext.dataManager.programMemorySize));
                System.out.println(String.format("CURSOR: %02X", AppContext.dataManager.cursorStart));
            }
            AppContext.fileDelay = AppContext.dataManager.programMemorySize + AppContext.dataManager.eepromMemorySize;
            MemoryRecordTypes memoryType = MemoryRecordTypes.EEPROM_MEMORY;
            file1.getFileData(this.jFileChooser1.getSelectedFile().getAbsolutePath(), memoryType);
            memoryType = MemoryRecordTypes.PROGRAM_MEMORY;
            file1.getFileData(this.jFileChooser1.getSelectedFile().getAbsolutePath(), memoryType);
            if (AppContext.pic18DeviceWhenCaptured) {
                memoryType = MemoryRecordTypes.CONFIGURATION_WORDS;
                file1.getFileData(this.jFileChooser1.getSelectedFile().getAbsolutePath(), memoryType);
            }
            if (AppContext.dataManager.eepromMemory != null || AppContext.dataManager.programMemory != null) {
                AppContext.dataManager.init();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppContext.swingEditorObj.print(1, "Hex File Read Successful");
                }
            });
            this.jProgressBar1.setMaximum(AppContext.fileDelay);
            this.jLabel5.setText("\"" + this.jFileChooser1.getName(this.jFileChooser1.getSelectedFile()) + "\"" + "  loaded");
        }
        if (AppContext.thread1 != null) {
            SwingWorker<Void, Void> swingWorker = AppContext.thread1;
            synchronized (swingWorker) {
                AppContext.thread1.notify();
            }
        }
        this.jDialog2.setVisible(false);
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        String str = (String)this.jComboBox2.getSelectedItem();
        AppContext.pic18Device = str.compareTo("PIC18") == 0;
        if (AppContext.debugEnable) {
            System.out.println("Is PIC18 the Selected Device ? " + AppContext.pic18Device);
        }
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void comPortListUpdate() {
        Map<Integer, MyToolObject> serialToolMapDup = SerialPort.getPortListInit();
        int firstIndex = 0;
        int lastIndex = 0;
        for (Map.Entry<Integer, MyToolObject> mto : serialToolMapDup.entrySet()) {
            firstIndex = mto.getValue().cToolDescription.indexOf("COM");
            lastIndex = mto.getValue().cToolDescription.lastIndexOf(58);
            String subComString = mto.getValue().cToolDescription.substring(firstIndex, lastIndex);
            this.jComboBox1.addItem(subComString);
        }
    }

    public static void main(String[] args) {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Test");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BootloaderView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BootloaderView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BootloaderView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BootloaderView.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BootloaderView().setVisible(true);
            }
        });
    }

    public void updateGUI(int textFieldNumber, String data_string) {
        switch (textFieldNumber) {
            case 1: {
                this.jTextArea1.append(data_string);
                this.jTextArea1.append("\n");
                break;
            }
            case 2: {
                this.jLabel4.setText(data_string);
                break;
            }
            case 3: {
                this.jLabel3.setText(data_string);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, data_string, "Error", 0);
                break;
            }
            case 5: {
                JOptionPane.showMessageDialog(null, data_string, "Details", 1);
                break;
            }
            default: {
                System.out.println("Error. Incorrect text field number entered !!");
            }
        }
    }

    public void disp(int count) {
        this.jProgressBar1.setValue(count);
    }

    public void dispplayFileChooser() {
        this.jDialog2.setVisible(true);
    }
}

