/*
 * Decompiled with CFR 0.152.
 */
package packetprocessor;

import BootloaderView.AppContext.AppContext;
import com.microchip.mplab.comm.MPLABCommCompletionInterface;
import protocol.state.InnerCommState;
import serialport.classes.SerialPort;

public class PacketProcessor {
    private static byte command;
    private static byte[] lengthProcess;
    private static byte[] addressProcess;
    private static byte[] dataPayloadProcess;
    private static int length;
    private static int address;
    private static int addressDivider;
    private static byte[] packed_data;

    private static int CalLength() {
        if (dataPayloadProcess == null) {
            return 2 + lengthProcess.length + addressProcess.length;
        }
        return 2 + lengthProcess.length + addressProcess.length + dataPayloadProcess.length;
    }

    private static byte[] pack() {
        int i;
        packed_data = new byte[PacketProcessor.CalLength()];
        PacketProcessor.packed_data[0] = 85;
        PacketProcessor.packed_data[1] = command;
        for (i = 2; i < 6; ++i) {
            PacketProcessor.packed_data[i] = lengthProcess[i - 2];
        }
        for (i = 6; i < 10; ++i) {
            PacketProcessor.packed_data[i] = addressProcess[i - 6];
        }
        if (dataPayloadProcess != null) {
            for (i = 10; i < 10 + dataPayloadProcess.length; ++i) {
                PacketProcessor.packed_data[i] = dataPayloadProcess[i - 10];
            }
        }
        return packed_data;
    }

    public static int sendBeforePacket(byte commandArg, int lengthArg, int addressArg, byte[] data_payloadArg, MPLABCommCompletionInterface completionHandler) {
        int i;
        if (data_payloadArg != null && lengthArg != data_payloadArg.length) {
            System.out.println("Error. Number of bytes to be sent do not match the dataPayload length !!");
            return 1;
        }
        for (i = 0; i < 4; ++i) {
            PacketProcessor.lengthProcess[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            PacketProcessor.addressProcess[i] = 0;
        }
        command = commandArg;
        length = lengthArg;
        address = addressArg;
        dataPayloadProcess = data_payloadArg;
        addressDivider = !AppContext.pic18DeviceWhenCaptured ? address / 2 : address;
        for (i = 0; i < 2 && length != 0; length >>= 8, ++i) {
            PacketProcessor.lengthProcess[i] = (byte)length;
        }
        if (command == 2 || command == 5 || command == 3) {
            PacketProcessor.lengthProcess[2] = 85;
            PacketProcessor.lengthProcess[3] = -86;
        }
        for (i = 0; i < 4 && address != 0; ++i) {
            PacketProcessor.addressProcess[i] = (byte)addressDivider;
            addressDivider >>= 8;
        }
        byte[] packedData = PacketProcessor.pack();
        SerialPort serialWrite = new SerialPort();
        int byte_count = serialWrite.write(packedData, completionHandler, 500);
        return byte_count;
    }

    public static int readBeforePacket(int length, MPLABCommCompletionInterface completionHandler) {
        byte[] data1 = new byte[length + 1];
        SerialPort serialRead = new SerialPort();
        int byte_count = serialRead.read(data1, completionHandler, 500);
        data1[data1.length - 1] = (byte)byte_count;
        if (byte_count == 0) {
            AppContext.data = data1;
        }
        return byte_count;
    }

    public static void validatePacket() {
        AppContext.STX_READ = AppContext.data[0] & 0xFF;
        AppContext.command_READ = AppContext.data[1] & 0xFF;
        AppContext.successBit = AppContext.data[AppContext.data.length - 2] & 0xFF;
        AppContext.innerCommState = InnerCommState.DATA_READY;
    }

    static {
        lengthProcess = new byte[4];
        addressProcess = new byte[4];
    }
}

